/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.tools.deployment.main.ApplicationManager;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIFileChooser;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.help.CSH;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;

public class NewAppDialog
extends UIDialog {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$NewAppDialog == null ? (class$com$sun$enterprise$tools$deployment$ui$NewAppDialog = NewAppDialog.class$("com.sun.enterprise.tools.deployment.ui.NewAppDialog")) : class$com$sun$enterprise$tools$deployment$ui$NewAppDialog);
    private static final String DIALOG_TITLE;
    private static final String BROWSER_TITLE;
    private static final String FILE_NAME;
    private static final String DISPLAY_NAME;
    private static final String helpSetMapID = "NewApp";
    private static final String DOT_EAR = ".ear";
    private boolean frameSizeAdjusted = false;
    private UITitledTextField appDisplayName = null;
    private UITitledTextField appArchiveFileName = null;
    private JButton okButton = new JButton();
    private JButton cancelButton = new JButton();
    private JFrame parent;
    private ApplicationManager applicationManager;
    private JFileChooser openFileDialog = null;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$NewAppDialog;

    private static String DIR_NOT_ALLOWED(String v0) {
        return localStrings.getLocalString("ui.newappdialog.directory_not_allowed", "Filename may not be a directory: {0}", new Object[]{v0});
    }

    private static String INVALID_DIR(String v0) {
        return localStrings.getLocalString("ui.newappdialog.invalid_directory", "{0} does not exist or is read only.", new Object[]{v0});
    }

    private static String ALREADY_EXISTS(String v0) {
        return localStrings.getLocalString("ui.newappdialog.already_exists", "{0} already exists.\nDo you wish to overwrite?", new Object[]{v0});
    }

    private static String ERROR_CREATING(String v0) {
        return localStrings.getLocalString("ui.newappdialog.error_creating_new_app", "Error creating new application: {0}", new Object[]{v0});
    }

    public NewAppDialog(JFrame p2, ApplicationManager cMgr) {
        super((Frame)p2, true);
        CSH.setHelpIDString((Component)this, (String)helpSetMapID);
        this.parent = p2;
        this.applicationManager = cMgr;
        this.initLayout();
    }

    private void initLayout() {
        this.setTitle(DIALOG_TITLE);
        UITitledControlButtonBox content = new UITitledControlButtonBox(null, false);
        content.setControlButtonLocation(101);
        this.setContentPane(content);
        UITitledBox textFields = new UITitledBox(null, false);
        content.setView(textFields);
        textFields.getGBConstraints().insets = new Insets(3, 5, 3, 5);
        this.appArchiveFileName = new UITitledTextField(FILE_NAME, false);
        this.appArchiveFileName.setBrowserActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                NewAppDialog.this.browseApplicationName();
            }
        });
        textFields.addWithGBConstraints(this.appArchiveFileName);
        String dir = UIConfig.getStartingDirectory().getPath();
        if (!dir.endsWith(File.separator)) {
            dir = dir + File.separator;
        }
        this.appArchiveFileName.setText(dir);
        this.appDisplayName = new UITitledTextField(DISPLAY_NAME, false);
        textFields.addWithGBConstraints(this.appDisplayName);
        UIButton okBtn = UIButton.createOkButton(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                NewAppDialog.this.okAction();
            }
        });
        content.addControlButton(okBtn);
        okBtn.makeDefaultButton(true);
        UIButton canBtn = UIButton.createCancelButton(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                NewAppDialog.this.hide();
            }
        });
        content.addControlButton(canBtn);
        UIHelpButton help_btn = new UIHelpButton(helpSetMapID);
        content.addControlButton(help_btn);
        this.openFileDialog = UIFileChooser.getFileChooser();
        this.openFileDialog.setFileSelectionMode(0);
        ((Component)this).setBounds(this.parent.getBounds().x + 20, this.parent.getBounds().y + 20, 420, 180);
    }

    private void browseApplicationName() {
        File entry = new File(this.appArchiveFileName.getText());
        File dir = entry.isDirectory() ? entry : entry.getParentFile();
        this.openFileDialog.setCurrentDirectory(dir);
        int rtn = this.openFileDialog.showDialog(this, BROWSER_TITLE);
        if (rtn == 0) {
            File selFile = this.openFileDialog.getSelectedFile();
            String archName = selFile.getAbsolutePath();
            this.appArchiveFileName.setText(archName.toLowerCase().endsWith(DOT_EAR) ? archName : archName + DOT_EAR);
            this.getDisplayName(true);
        }
    }

    private String getDisplayName(boolean reset) {
        String dn2;
        String string = dn2 = reset ? "" : this.appDisplayName.getText();
        if (dn2.equals("")) {
            String fn;
            String fp = this.appArchiveFileName.getText();
            int fs = fp.lastIndexOf(File.separator);
            String string2 = fs >= 0 ? (fs >= fp.length() - 1 ? "" : fp.substring(fs + 1)) : (fn = fp);
            dn2 = fn.length() <= 1 ? fn : (fn.toLowerCase().endsWith(DOT_EAR) ? fn.substring(0, fn.length() - DOT_EAR.length()) : (fn.lastIndexOf(".") > 0 ? fn.substring(0, fn.lastIndexOf(".")) : fn));
            this.appDisplayName.setText(dn2);
        }
        return dn2;
    }

    private void okAction() {
        File archFile;
        if (!this.isVisible()) {
            UIUtils.debugImplementationError("Dialog is not visible!");
            return;
        }
        if (this.appArchiveFileName.getText().equals("")) {
            UIOptionPane.showErrorDialog(this.parent, localStrings.getLocalString("ui.newappdialog.no_app_location", "You must fill in the location to add an application."));
            return;
        }
        String archName = this.appArchiveFileName.getText();
        if (new File(archName).isDirectory()) {
            UIOptionPane.showErrorDialog(this, NewAppDialog.DIR_NOT_ALLOWED(archName));
            return;
        }
        if (!archName.toLowerCase().endsWith(DOT_EAR)) {
            archName = archName + DOT_EAR;
        }
        if ((archFile = new File(archName)).isDirectory()) {
            UIOptionPane.showErrorDialog(this, NewAppDialog.DIR_NOT_ALLOWED(archName));
            return;
        }
        File parentDir = new File(archFile.getAbsolutePath()).getParentFile();
        if (!(parentDir == null || parentDir.exists() && parentDir.canWrite())) {
            UIOptionPane.showErrorDialog(this, NewAppDialog.INVALID_DIR(parentDir.getPath()));
            return;
        }
        if (archFile.exists()) {
            boolean overwrite = UIOptionPane.showConfirmDialog(this, NewAppDialog.ALREADY_EXISTS(archName));
            if (!overwrite) {
                return;
            }
            if (this.applicationManager.getApplicationWithJar(archFile) != null) {
                this.applicationManager.closeApplication(this.applicationManager.getApplicationWithJar(archFile));
            }
            archFile.delete();
        }
        try {
            String dispName = this.getDisplayName(false);
            Application app = this.applicationManager.newApplication(dispName, new File(archName).getCanonicalPath());
        }
        catch (IOException ioe) {
            UIOptionPane.showErrorDialog(this, NewAppDialog.ERROR_CREATING(ioe.getMessage()));
            return;
        }
        UIConfig.addStartingDirectory(parentDir);
        UIConfig.saveConfig();
        this.hide();
    }

    public Dimension getPreferredSize() {
        return new Dimension(300, 180);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        BROWSER_TITLE = DIALOG_TITLE = localStrings.getLocalString("ui.newappdialog.title", "New Application");
        FILE_NAME = localStrings.getLocalString("ui.newappdialog.location", "Application File Name:");
        DISPLAY_NAME = localStrings.getLocalString("ui.newappdialog.appname", "Application Display Name:");
    }
}

