/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui;

import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.FileContentsDescriptor;
import com.sun.enterprise.deployment.xml.ApplicationClientNode;
import com.sun.enterprise.deployment.xml.XMLUtils;
import com.sun.enterprise.tools.deployment.ui.DescriptorInspector;
import com.sun.enterprise.tools.deployment.ui.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.Wizard;
import com.sun.enterprise.tools.deployment.ui.descriptor.AppClientGeneralInspector;
import com.sun.enterprise.tools.deployment.ui.descriptor.AppClientJarFileInspector;
import com.sun.enterprise.tools.deployment.ui.descriptor.EjbRefsInspector;
import com.sun.enterprise.tools.deployment.ui.descriptor.EnvironmentInspector;
import com.sun.enterprise.tools.deployment.ui.descriptor.JmsDestinationRefsInspector;
import com.sun.enterprise.tools.deployment.ui.descriptor.ResourceRefsInspector;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.io.FileWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.help.CSH;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.crimson.tree.XmlDocument;

public class NewAppClientWizard
extends Wizard {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$NewAppClientWizard == null ? (class$com$sun$enterprise$tools$deployment$ui$NewAppClientWizard = NewAppClientWizard.class$("com.sun.enterprise.tools.deployment.ui.NewAppClientWizard")) : class$com$sun$enterprise$tools$deployment$ui$NewAppClientWizard);
    private static String WIZARD_TITLE = localStrings.getLocalString("ui.newappclientwizard.wizard_title", "New Application Client Wizard");
    private static String DEFAULT_NAME = localStrings.getLocalString("ui.newappclientwizard.client", "client");
    private static String HELP_TEXT = localStrings.getLocalString("ui.newappclientwizard.help", "");
    private ApplicationClientDescriptor applicationClientDescriptor;
    private AppClientJarFileInspector appClientJarFileInspector;
    private AppClientGeneralInspector appClientGeneralInspector;
    private EnvironmentInspector environmentInspector;
    private EjbRefsInspector ejbRefsInspector;
    private JmsDestinationRefsInspector jmsDestRefsInspector;
    private ResourceRefsInspector resourceRefsInspector;
    private JTextArea xmlTextArea = new JTextArea();
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$NewAppClientWizard;

    public String getHelpGroup() {
        return "CW";
    }

    public NewAppClientWizard(Frame owner, JComponent targetChooser) {
        super(owner);
        this.createWands(targetChooser);
        super.setBounds(100, 100, 700, 580);
        super.setTitle(WIZARD_TITLE);
        super.show();
    }

    private void createWands(JComponent targetChooser) {
        String mode = "WizardMode";
        Vector inspectors = new Vector();
        super.addIntroPanel(HELP_TEXT);
        this.appClientJarFileInspector = (AppClientJarFileInspector)AppClientJarFileInspector.newInspectorPane(mode, targetChooser);
        this.addInspectorPane(this.appClientJarFileInspector, localStrings.getLocalString("appclientjarfileinspector.wizardsubtitle", "JAR File Contents"), localStrings.getLocalString("ui.newappclientwizard.set_jar_file_contents", "Set Application Client JAR File Contents"));
        this.appClientGeneralInspector = (AppClientGeneralInspector)AppClientGeneralInspector.newInspectorPane(mode, null);
        this.addInspectorPane(this.appClientGeneralInspector, localStrings.getLocalString("appclientgeneralinspector.wizardsubtitle", "General"), localStrings.getLocalString("ui.newappclientwizard.set_app_client_properties", "Set Application Client General Properties"));
        this.environmentInspector = (EnvironmentInspector)EnvironmentInspector.newInspectorPane(mode, null);
        this.addInspectorPane(this.environmentInspector, localStrings.getLocalString("environmentinspector.wizardsubtitle", "Environment Entries"), localStrings.getLocalString("ui.newappclientwizard.set_env_entries", "Set Environment Entries"));
        this.ejbRefsInspector = (EjbRefsInspector)EjbRefsInspector.newInspectorPane(mode, null);
        this.addInspectorPane(this.ejbRefsInspector, localStrings.getLocalString("ui.newappclientwizard.ejb_refs", "Enterprise Bean References"), localStrings.getLocalString("ui.newappclientwizard.set_ejb_refs", "Set EJB References Entries."));
        this.resourceRefsInspector = (ResourceRefsInspector)ResourceRefsInspector.newInspectorPane(mode, null);
        this.addInspectorPane(this.resourceRefsInspector, localStrings.getLocalString("ui.newappclientwizard.res_refs", "Resource References"), localStrings.getLocalString("ui.newappclientwizard.set_res_refs", "Set Resource References"));
        this.jmsDestRefsInspector = (JmsDestinationRefsInspector)JmsDestinationRefsInspector.newInspectorPane(mode, null);
        this.addInspectorPane(this.jmsDestRefsInspector, localStrings.getLocalString("ui.newappclientwizard.jmsdest_refs", "JMS Destination References"), localStrings.getLocalString("ui.newappclientwizard.set_jmsdest_refs", "Set Resource Environment References."));
        XMLDisplay xmlDisp = new XMLDisplay(this.xmlTextArea);
        super.addComponent(xmlDisp, localStrings.getLocalString("ui.newappclientwizard.review_settings", "Review Settings"), localStrings.getLocalString("ui.newappclientwizard.inspect_xml", "Inspect XML descriptor"));
    }

    protected void descriptorChanged() {
        this.delegateNotification(this.getCurrentComponent());
    }

    void delegateNotification(Object insp) {
        if (insp instanceof DescriptorInspector) {
            ((DescriptorInspector)insp).setDescriptor(this.getApplicationClientDescriptor());
            if (insp instanceof InspectorPane) {
                ((InspectorPane)insp).invokeRefresh();
            }
        }
    }

    public Set getLibraryJars() {
        return this.getFileContentsDescriptor().getLibraryJars();
    }

    public ApplicationClientDescriptor getApplicationClientDescriptor() {
        if (this.applicationClientDescriptor == null) {
            this.applicationClientDescriptor = new ApplicationClientDescriptor();
            this.applicationClientDescriptor.setDescription("");
            this.addDescriptorListener(this.applicationClientDescriptor, new NotificationListener(){

                public void notification(NotificationEvent ae2) {
                    NewAppClientWizard.this.descriptorChanged();
                }
            });
        }
        return this.applicationClientDescriptor;
    }

    public FileContentsDescriptor getFileContentsDescriptor() {
        return this.appClientJarFileInspector.getFileContentsDescriptor();
    }

    private String getMainClass() {
        return this.appClientGeneralInspector.getMainClass();
    }

    private String getJarFile() {
        return this.appClientJarFileInspector.getJarFile();
    }

    private File writeDescriptorAction() throws Exception {
        XmlDocument document = ApplicationClientNode.getDocument(this.getApplicationClientDescriptor());
        File descriptorFile = File.createTempFile("application-client", ".xml");
        FileWriter fw = new FileWriter(descriptorFile);
        XMLUtils.writeDocument(document, fw);
        fw.close();
        UIUtils.println(localStrings.getLocalString("ui.newappclientwizard.done", "Done {0}", new Object[]{descriptorFile.getAbsolutePath()}));
        return descriptorFile;
    }

    private String convertToFilename(String classname) {
        return classname.replace('.', '/') + ".class";
    }

    private void badClassAction(Throwable ex2) {
        StringBuffer dirList = new StringBuffer("");
        Iterator itr = this.getFileContentsDescriptor().getDirectories();
        while (itr.hasNext()) {
            dirList.append("\n").append(itr.next().toString());
        }
        if (UIUtils.debugMode()) {
            UIUtils.printImplementationError("NewAppClientWizard.badClassAction", "Unable to load class: " + this.getMainClass(), ex2);
        }
        JOptionPane.showMessageDialog(this, localStrings.getLocalString("ui.newappclientwizard.cant_load_class", "The class ({0}) could not be loaded from {1}\n{2}", new Object[]{this.getMainClass(), dirList.toString(), ex2.toString()}));
    }

    public void goForward() {
        JComponent currentComponent = super.getCurrentComponent();
        if (currentComponent instanceof AppClientJarFileInspector) {
            String jarFileName = this.getJarFile();
            if (jarFileName == null || jarFileName.equals("")) {
                JOptionPane.showMessageDialog(this, localStrings.getLocalString("ui.newappclientwizard.supply_jar_file_name", "Please supply the name of the JAR file of your application client."));
                return;
            }
            if (!this.getFileContentsDescriptor().getFiles().hasMoreElements()) {
                JOptionPane.showMessageDialog(this, localStrings.getLocalString("ui.newappclientwizard.choose_content", "Please choose the content files for your application client."));
                return;
            }
            this.appClientGeneralInspector.setFileContentsDescriptor(this.getFileContentsDescriptor());
        }
        if (currentComponent instanceof AppClientGeneralInspector) {
            String mainClassName = this.getMainClass();
            if (mainClassName == null || mainClassName.equals("")) {
                JOptionPane.showMessageDialog(this, localStrings.getLocalString("ui.newappclientwizard.add_main_class", "Please add the name of the Main class for your application client."));
                return;
            }
            try {
                this.getFileContentsDescriptor().getClassLoader().loadClass(mainClassName);
            }
            catch (Throwable t2) {
                this.badClassAction(t2);
                return;
            }
            if (this.getApplicationClientDescriptor().getName().equals("")) {
                this.getApplicationClientDescriptor().setName(DEFAULT_NAME);
            }
            super.okToEnableFinish(currentComponent, true);
        }
        super.goForward();
        currentComponent = super.getCurrentComponent();
        this.helpButton.setHelpID(currentComponent);
        if (currentComponent instanceof XMLDisplay) {
            this.refreshXmlDisplay();
        }
        this.delegateNotification(currentComponent);
    }

    public void goBackward() {
        super.goBackward();
        this.helpButton.setHelpID(super.getCurrentComponent());
    }

    public void finishAction() {
        super.finishAction();
    }

    private void refreshXmlDisplay() {
        try {
            XmlDocument document = ApplicationClientNode.getDocument(this.getApplicationClientDescriptor());
            StringWriter sw = new StringWriter();
            XMLUtils.writeDocument(document, sw);
            this.xmlTextArea.setText(sw.toString());
        }
        catch (Throwable t2) {
            UIUtils.println(localStrings.getLocalString("ui.newappclientwizard.xml_forming_error", "Warning: error forming XML"));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class XMLDisplay
    extends JPanel {
        public XMLDisplay(JTextArea ta) {
            CSH.setHelpIDString((Component)this, (String)(NewAppClientWizard.this.getHelpGroup() + "Review"));
            this.setLayout(new BorderLayout());
            ta.setEnabled(false);
            this.add(new JScrollPane(ta));
        }
    }
}

