/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledList;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Iterator;
import javax.help.CSH;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ManifestClasspathInspector {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$ManifestClasspathInspector == null ? (class$com$sun$enterprise$tools$deployment$ui$ManifestClasspathInspector = ManifestClasspathInspector.class$("com.sun.enterprise.tools.deployment.ui.ManifestClasspathInspector")) : class$com$sun$enterprise$tools$deployment$ui$ManifestClasspathInspector);
    private static String MFC_BOXTITLE = localStrings.getLocalString("ui.manifestclasspathinspector.boxtitle", "JARs in Manifest Classpath:");
    private static String INSPECTOR_BUTTON = localStrings.getLocalString("ui.manifestclasspathinspector.inspector_button", "Manifest Classpath...");
    private static String ADD_BUTTON = localStrings.getLocalString("ui.manifestclasspathinspector.add_button", "Add>");
    private static String REMOVE_BUTTON = localStrings.getLocalString("ui.manifestclasspathinspector.remove_button", "<Remove");
    private static String helpSetMapID = "ManifestClasspath";
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$ManifestClasspathInspector;

    private static String DIALOG_TITLE_FOR(String v0) {
        return localStrings.getLocalString("ui.manifestclasspathinspector.dialogtitle_for", "Manifest Classpath for {0}", new Object[]{v0});
    }

    private static String JARLIST_TITLE_FOR(String v0) {
        return localStrings.getLocalString("ui.manifestclasspathinspector.jarlisttitle_for", "Library JARs in {0}", new Object[]{v0});
    }

    private ManifestClasspathInspector() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class DialogDisplayButton
    extends JButton
    implements ActionListener {
        private UpdateListener target = null;
        private Application appDescriptor = null;
        private String archName = null;
        private ListModel listModel = null;
        private ManifestClasspathDialog dialog = null;

        public DialogDisplayButton(UpdateListener target) {
            super(INSPECTOR_BUTTON);
            this.target = target;
            super.setActionCommand("show");
            super.addActionListener(this);
        }

        public void setApplication(Application app) {
            this.appDescriptor = app;
            if (this.dialog != null) {
                this.dialog.setApplication(this.appDescriptor);
            }
        }

        public void setUpdateListener(UpdateListener target) {
            this.target = target;
            if (this.dialog != null) {
                this.dialog.setUpdateListener(this.target);
            }
        }

        public void setManifestClasspathInspector(ListModel listModel, String archName, Descriptor descriptor) {
            this.archName = archName;
            this.listModel = listModel;
            if (descriptor == null) {
                this.appDescriptor = null;
            } else if (descriptor instanceof Application) {
                this.appDescriptor = (Application)descriptor;
            } else if (descriptor instanceof EjbDescriptor) {
                this.appDescriptor = ((EjbDescriptor)descriptor).getApplication();
            } else if (descriptor instanceof BundleDescriptor) {
                this.appDescriptor = ((BundleDescriptor)descriptor).getApplication();
            } else {
                this.appDescriptor = null;
                UIUtils.debugPrintln("Unable to obtain Application descriptor from class " + descriptor.getClass().getName());
            }
            if (this.dialog != null) {
                this.dialog.setApplication(this.appDescriptor);
                this.dialog.setListModel(this.listModel, this.archName);
            }
        }

        public void actionPerformed(ActionEvent ae2) {
            if (this.dialog == null) {
                Window window = UIUtils.getAncestorWindow(this);
                this.dialog = window instanceof Dialog ? new ManifestClasspathDialog((Dialog)window) : new ManifestClasspathDialog((Frame)window);
                this.dialog.setUpdateListener(this.target);
                this.dialog.setApplication(this.appDescriptor);
            }
            this.dialog.setListModel(this.listModel, this.archName);
            this.dialog.show();
        }
    }

    private static class ManifestClasspathDialog
    extends UIDialog
    implements ActionListener {
        private UpdateListener target = null;
        private Application appDescriptor = null;
        private UITitledList jarListPanel = null;
        private UITitledList classpathPanel = null;
        private JButton addLibJarButton = null;
        private JButton delLibJarButton = null;

        public ManifestClasspathDialog(Frame owner) {
            super(owner, true);
            this.initDialog(owner);
        }

        public ManifestClasspathDialog(Dialog owner) {
            super(owner, true);
            this.initDialog(owner);
        }

        private void initDialog(Window window) {
            CSH.setHelpIDString((Component)this, (String)helpSetMapID);
            this.doNothingOnClose();
            UITitledControlButtonBox windowPanel = new UITitledControlButtonBox(null, false);
            windowPanel.setControlButtonLocation(15);
            windowPanel.setControlButtonAnchor(13);
            this.setContentPane(windowPanel);
            UITitledBox box = new UITitledBox(null, false);
            windowPanel.setView(box);
            GridBagConstraints gbc = box.getGBConstraints();
            gbc.gridx = -1;
            gbc.gridy = 0;
            gbc.insets = new Insets(5, 5, 3, 5);
            this.jarListPanel = new UITitledList("<updated-later>", false);
            this.jarListPanel.setListView(new JList());
            box.addWithGBConstraints(this.jarListPanel);
            this.jarListPanel.getListView().addListSelectionListener(new ListSelectionListener(this){
                private final /* synthetic */ ManifestClasspathDialog this$0;
                {
                    this.this$0 = this$0;
                }

                public void valueChanged(ListSelectionEvent lse) {
                    if (!lse.getValueIsAdjusting()) {
                        ManifestClasspathDialog.access$200(this.this$0).setEnabled(!ManifestClasspathDialog.access$100(this.this$0).isSelectionEmpty());
                    }
                }
            });
            JPanel buttons = new JPanel();
            buttons.setLayout(new GridBagLayout());
            GridBagConstraints bc2 = new GridBagConstraints();
            bc2.weightx = 0.0;
            bc2.weighty = 0.0;
            bc2.gridx = 0;
            bc2.gridy = -1;
            bc2.insets = new Insets(5, 0, 0, 0);
            bc2.fill = 2;
            bc2.anchor = 10;
            Insets margin = new Insets(3, 5, 3, 5);
            this.addLibJarButton = new UIButton(ADD_BUTTON, "add", this);
            this.addLibJarButton.setMargin(margin);
            buttons.add((Component)this.addLibJarButton, bc2);
            this.delLibJarButton = new UIButton(REMOVE_BUTTON, "del", this);
            this.delLibJarButton.setMargin(margin);
            buttons.add((Component)this.delLibJarButton, bc2);
            gbc = box.getGBConstraintsCopy();
            gbc.weightx = 0.0;
            gbc.insets = new Insets(0, 0, 0, 0);
            gbc.fill = 0;
            box.add((Component)buttons, gbc);
            this.classpathPanel = new UITitledList(MFC_BOXTITLE, false);
            this.classpathPanel.setListView(new JList());
            box.addWithGBConstraints(this.classpathPanel);
            this.classpathPanel.getListView().addListSelectionListener(new ListSelectionListener(this){
                private final /* synthetic */ ManifestClasspathDialog this$0;
                {
                    this.this$0 = this$0;
                }

                public void valueChanged(ListSelectionEvent lse) {
                    if (!lse.getValueIsAdjusting()) {
                        ManifestClasspathDialog.access$700(this.this$0).setEnabled(!ManifestClasspathDialog.access$600(this.this$0).isSelectionEmpty());
                    }
                }
            });
            UIButton okBtn = UIButton.createOkButton(this);
            windowPanel.addControlButton(okBtn);
            UIButton cancelBtn = UIButton.createCancelButton(this);
            windowPanel.addControlButton(cancelBtn);
            UIHelpButton helpBtn = new UIHelpButton(helpSetMapID);
            windowPanel.addControlButton(helpBtn);
            Rectangle b10 = window.getBounds();
            b10.x += 20;
            b10.y += 20;
            b10.width = 525;
            b10.height = 250;
            ((Component)this).setBounds(b10);
        }

        public void setApplication(Application app) {
            this.appDescriptor = app;
        }

        public void setUpdateListener(UpdateListener target) {
            this.target = target;
        }

        public void setListModel(ListModel listModel, String archName) {
            this.setTitle(ManifestClasspathInspector.DIALOG_TITLE_FOR(archName));
            String appName = this.appDescriptor == null ? "<?>" : this.appDescriptor.getName();
            this.jarListPanel.setTitle(ManifestClasspathInspector.JARLIST_TITLE_FOR(appName));
            this.classpathPanel.getListView().setModel(listModel);
            this.delLibJarButton.setEnabled(false);
            DefaultListModel<String> appJarsListModel = new DefaultListModel<String>();
            if (this.appDescriptor != null) {
                try {
                    Iterator itr = this.appDescriptor.getApplicationArchivist().getLibraryJarUris().iterator();
                    while (itr.hasNext()) {
                        String next = (String)itr.next();
                        appJarsListModel.addElement(next);
                    }
                }
                catch (IOException ioe) {
                    UIUtils.debugPrintln("Error getting LibraryJarURIs:" + ioe.toString());
                }
            } else {
                UIUtils.debugPrintln("'appDescriptor' is null");
            }
            this.jarListPanel.getListView().setModel(appJarsListModel);
            this.addLibJarButton.setEnabled(false);
        }

        public void actionPerformed(ActionEvent ae2) {
            String cmd = ((JButton)ae2.getSource()).getActionCommand();
            if (cmd.equals("add")) {
                this.addAction();
            } else if (cmd.equals("del")) {
                this.removeAction();
            } else if (cmd.equals("ok")) {
                if (this.target != null) {
                    this.target.manifestClasspathUpdated(this.classpathPanel.getListView().getModel());
                    this.hide();
                }
            } else if (cmd.equals("cancel")) {
                this.hide();
            } else if (cmd.equals("help")) {
                // empty if block
            }
        }

        private void addAction() {
            Object[] list = this.jarListPanel.getSelectedValues();
            DefaultListModel mfcModel = (DefaultListModel)this.classpathPanel.getModel();
            int i2 = 0;
            while (i2 < list.length) {
                if (!mfcModel.contains(list[i2])) {
                    mfcModel.addElement(list[i2]);
                }
                ++i2;
            }
        }

        private void removeAction() {
            Object[] list = this.classpathPanel.getSelectedValues();
            DefaultListModel mfcModel = (DefaultListModel)this.classpathPanel.getModel();
            int i2 = 0;
            while (i2 < list.length) {
                mfcModel.removeElement(list[i2]);
                ++i2;
            }
        }

        static /* synthetic */ UITitledList access$100(ManifestClasspathDialog x0) {
            return x0.jarListPanel;
        }

        static /* synthetic */ JButton access$200(ManifestClasspathDialog x0) {
            return x0.addLibJarButton;
        }

        static /* synthetic */ UITitledList access$600(ManifestClasspathDialog x0) {
            return x0.classpathPanel;
        }

        static /* synthetic */ JButton access$700(ManifestClasspathDialog x0) {
            return x0.delLibJarButton;
        }
    }

    public static interface UpdateListener {
        public void manifestClasspathUpdated(ListModel var1);
    }
}

