/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleArchivist;
import com.sun.enterprise.tools.deployment.main.ApplicationManager;
import com.sun.enterprise.tools.deployment.main.ServerManager;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.DescriptorInspector;
import com.sun.enterprise.tools.deployment.ui.InspectorManager;
import com.sun.enterprise.tools.deployment.ui.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.util.JarClassLoader;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.help.CSH;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class InspectorEventDelegator
extends JTabbedPane
implements DescriptorInspector,
InspectorPane.InspectorPaneOwner {
    private static boolean removeDisabledTabs = true;
    private int addingInspectorPane = 0;
    private int lastRefreshedInspector = -1;
    private int refreshInspectorAt_recursion = 0;
    private boolean refreshInspectorAt_recursionCheck = false;
    private boolean cacheClassList = false;
    private Vector archiveClassList = null;
    private static Descriptor lastInspectedDescriptor = null;
    private InspectorManager.ProxyDescriptor proxyDescriptor = null;
    private int initialDescriptorUpdate = 0;
    private DeferredNotification deferredNotification = new DeferredNotification();

    public InspectorEventDelegator() {
        this.setRequestFocusEnabled(true);
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent e10) {
                InspectorEventDelegator.this.requestFocus();
            }
        });
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e10) {
                InspectorEventDelegator.this.requestFocus();
            }
        });
    }

    public InspectorEventDelegator makeCopy() {
        InspectorManager inspectorManager = DT.getInspectorManager();
        InspectorEventDelegator copy = inspectorManager.createNewInspector(this.getClass(), "DeploymentMode");
        copy.proxyDescriptor = this.proxyDescriptor;
        copy.setDescriptor(this.getDescriptor());
        int selNdx = this.getSelectedIndex();
        copy._setSelectedIndex(selNdx);
        return copy;
    }

    public int addInspectorPane(InspectorPane insp) {
        return this.addInspectorPane(insp, -1);
    }

    public int addInspectorPane(InspectorPane insp, int index) {
        int rtnIndex = this.indexOfComponent(insp);
        if (rtnIndex >= 0) {
            return rtnIndex;
        }
        insp.setOwner(this);
        ++this.addingInspectorPane;
        if (index < 0) {
            this.add(insp.getTabName(), insp);
            rtnIndex = this.indexOfComponent(insp);
        } else {
            this.insertTab(insp.getTabName(), null, insp, null, index);
            rtnIndex = index;
        }
        --this.addingInspectorPane;
        String helpId = insp.getHelpID();
        if (helpId != null && helpId.length() > 0) {
            CSH.setHelpIDString((Component)insp, (String)(this.getHelpGroup() + helpId));
        }
        return rtnIndex;
    }

    public InspectorPane getCurrentInspectorPane() {
        int index = this.getSelectedIndex();
        return index < 0 ? null : (InspectorPane)this.getComponentAt(index);
    }

    public abstract String getHelpGroup();

    public void addNotify() {
        super.addNotify();
        this.requestFocus();
    }

    public synchronized void refreshInspectorAt(int index) {
        if (!this.isCurrentInspector()) {
            return;
        }
        if (this.refreshInspectorAt_recursion > 0) {
            if (UIUtils.debugMode()) {
                UIUtils.printImplementationError("**RECURSION CHECK** (" + this.refreshInspectorAt_recursion + ")");
            }
            this.refreshInspectorAt_recursionCheck = true;
            return;
        }
        ++this.refreshInspectorAt_recursion;
        if (this.refreshInspectorAt_recursionCheck) {
            this.refreshInspectorAt_recursionCheck = false;
            UIUtils.debugImplementationError("Unexpected 'true' recursion check ...");
        }
        if (index != this.lastRefreshedInspector) {
            DescriptionInspector din = DescriptionInspector.findDescriptionInspector(this);
            if (din != null) {
                din.clearDescription();
            }
            this.lastRefreshedInspector = index;
        }
        if (this.getDescriptor() != null) {
            DescriptorInspector inspector = (DescriptorInspector)((Object)this.getComponentAt(index));
            boolean isInspPane = inspector instanceof InspectorPane;
            Descriptor d10 = this.getDescriptor();
            if (d10 != inspector.getDescriptor() || !isInspPane) {
                inspector.setDescriptor(d10);
                if (inspector instanceof InspectorPane) {
                    ((InspectorPane)inspector).resetRefresh();
                }
            }
            if (isInspPane) {
                ((InspectorPane)inspector).invokeRefresh();
            } else {
                UIUtils.debugImplementationError("Not an InspectorPane");
            }
        }
        if (this.refreshInspectorAt_recursionCheck) {
            if (UIUtils.debugMode()) {
                UIUtils.printImplementationError("**RECURSION CHECK** - prior invocation stack");
            }
            this.refreshInspectorAt_recursionCheck = false;
        }
        --this.refreshInspectorAt_recursion;
    }

    public int disableInspector(InspectorPane insp) {
        int index = this.indexOfComponent(insp);
        if (index >= 0) {
            if (removeDisabledTabs) {
                this.remove(insp);
            } else {
                this.setEnabledAt(index, false);
            }
        }
        return index;
    }

    public int enableInspector(InspectorPane insp, int index) {
        int n2 = this.indexOfComponent(insp);
        if (n2 >= 0) {
            this.setEnabledAt(n2, true);
        } else {
            this.addInspectorPane(insp, index);
        }
        return index;
    }

    public boolean isValidInspector() {
        return true;
    }

    public int getSelectedIndex() {
        return super.getSelectedIndex();
    }

    public void setSelectedIndex(int index) {
        this._setSelectedIndex(index);
    }

    private void _setSelectedIndex(int index) {
        super.setSelectedIndex(index);
        if (this.addingInspectorPane == 0) {
            this.refreshInspectorAt(index);
        }
    }

    public void setEnabledAt(int index, boolean enabled) {
        if (index >= 0) {
            super.setEnabledAt(index, enabled);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Vector getArchiveContents() {
        Descriptor d10 = this.getDescriptor();
        if (d10 instanceof BundleDescriptor) {
            BundleDescriptor bd2 = (BundleDescriptor)d10;
            try {
                void t2;
                Vector<File> contents = new Vector<File>();
                Vector items = bd2.getArchivist().getEntryNames();
                int i2 = 0;
                while (i2 < items.size()) {
                    contents.addElement(new File((String)items.elementAt(i2)));
                    ++i2;
                }
                return t2;
            }
            catch (Throwable t2) {
                UIUtils.debugPrintln("Contents exception: " + t2.toString());
            }
        }
        return null;
    }

    public Vector getArchiveClasses() {
        if (this.cacheClassList && this.archiveClassList != null) {
            return this.archiveClassList;
        }
        Descriptor d10 = this.getDescriptor();
        if (!(d10 instanceof BundleDescriptor)) {
            UIUtils.debugPrintln("Descriptor does not subclass BundleDescriptor");
            return null;
        }
        BundleDescriptor bd2 = (BundleDescriptor)d10;
        Archivist arch = bd2.getArchivist();
        ClassLoader classLoader = null;
        if (arch instanceof EjbBundleArchivist) {
            UIUtils.debugPrintln("Using EjbBundleArchivist classLoader");
            EjbBundleArchivist ejbArch = (EjbBundleArchivist)arch;
            classLoader = ejbArch.getClassLoader();
        } else if (arch instanceof ApplicationArchivist) {
            UIUtils.debugPrintln("Using ApplicationArchivist classLoader");
            ApplicationArchivist appArch = (ApplicationArchivist)arch;
            classLoader = appArch.getClassLoader();
        } else {
            Application app = bd2.getApplication();
            if (app != null) {
                UIUtils.debugPrintln("Using Applications classLoader");
                ApplicationArchivist appArch = app.getApplicationArchivist();
                classLoader = appArch.getClassLoader();
            } else {
                UIUtils.debugPrintln("Creating a default classLoader");
                try {
                    classLoader = new JarClassLoader();
                    ((JarClassLoader)classLoader).addJar(new File(arch.getArchiveUri()).getAbsolutePath());
                }
                catch (IOException ioe) {
                    UIUtils.debugPrintln("Unable to create JarClassLoader - " + ioe.toString());
                }
            }
        }
        Vector classNames = null;
        try {
            classNames = arch.getClassNames();
        }
        catch (IOException ioe) {
            UIUtils.debugPrintln("Unable to obtain list of class names - " + ioe.toString());
            return null;
        }
        this.archiveClassList = new Vector();
        Enumeration e10 = classNames.elements();
        while (e10.hasMoreElements()) {
            String className = (String)e10.nextElement();
            try {
                this.archiveClassList.add(classLoader.loadClass(className));
            }
            catch (Throwable t2) {
                UIUtils.debugPrintln(t2.toString());
            }
        }
        return this.archiveClassList;
    }

    public void resetArchiveClasses() {
        this.archiveClassList = null;
    }

    public abstract Descriptor getDescriptor();

    public abstract void setDescriptor(Descriptor var1);

    public Class getDescriptorClass() {
        Descriptor d10 = this.getDescriptor();
        return d10 != null ? d10.getClass() : null;
    }

    public static InspectorEventDelegator getInspectorFor(Descriptor obj) {
        InspectorManager inspectorManager = DT.getInspectorManager();
        lastInspectedDescriptor = null;
        return inspectorManager._getInspectorFor(obj, false);
    }

    public void setInspectorDescriptor(Descriptor d10) {
        ++this.initialDescriptorUpdate;
        if (d10 instanceof InspectorManager.ProxyDescriptor) {
            this.proxyDescriptor = (InspectorManager.ProxyDescriptor)d10;
            d10 = this.proxyDescriptor.getDescriptor();
        }
        lastInspectedDescriptor = d10;
        if (d10 != null) {
            this.setDescriptor(d10);
        }
        --this.initialDescriptorUpdate;
    }

    private boolean isCurrentInspector() {
        return lastInspectedDescriptor == this.getDescriptor();
    }

    public boolean isCurrentInspectorPane(InspectorPane pane) {
        return this.isCurrentInspector() && this.getCurrentInspectorPane() == pane;
    }

    public String getLargeIconUri() {
        Descriptor desc = this.getDescriptor();
        return desc != null ? desc.getLargeIconUri() : "";
    }

    public String getSmallIconUri() {
        Descriptor desc = this.getDescriptor();
        return desc != null ? desc.getSmallIconUri() : "";
    }

    protected static ServerManager getServerManager() {
        return DT.getServerManager();
    }

    protected static ApplicationManager getApplicationManager() {
        return DT.getApplicationManager();
    }

    public void addApplicationManagerNotification() {
        if (this instanceof NotificationListener) {
            ApplicationManager am2 = DT.getApplicationManager();
            if (this.deferredNotification != null) {
                am2.addNotificationListener(this.deferredNotification);
            } else {
                am2.addNotificationListener((NotificationListener)((Object)this));
            }
        } else {
            UIUtils.printImplementationError("This class does not implement NotificationListener");
        }
    }

    public void addServerManagerNotification() {
        if (this instanceof NotificationListener) {
            ServerManager sm = DT.getServerManager();
            if (this.deferredNotification != null) {
                sm.addNotificationListener(this.deferredNotification);
            } else {
                sm.addNotificationListener((NotificationListener)((Object)this));
            }
        } else {
            UIUtils.printImplementationError("This class does not implement NotificationListener");
        }
    }

    class DeferredNotification
    implements NotificationListener,
    Runnable {
        private Hashtable notifyHash = null;
        private int hitCount = 0;

        DeferredNotification() {
        }

        public void notification(NotificationEvent ne) {
            String type = ne.getType();
            if (type == null) {
                return;
            }
            if (type.equals(Descriptor.DESCRIPTOR_CHANGED)) {
                if (this.notifyHash == null) {
                    this.notifyHash = new Hashtable();
                    this.hitCount = 0;
                }
                ++this.hitCount;
                if (this.notifyHash.containsKey(type)) {
                    this.notifyHash.put(type, ne);
                } else {
                    this.notifyHash.put(type, ne);
                    EventQueue.invokeLater(this);
                }
            } else {
                InspectorEventDelegator target = InspectorEventDelegator.this;
                ((NotificationListener)((Object)target)).notification(ne);
            }
        }

        public void run() {
            if (this.notifyHash == null) {
                UIUtils.printImplementationError("Somehow we got here with an empty notification list");
                return;
            }
            InspectorEventDelegator target = InspectorEventDelegator.this;
            Enumeration keys = this.notifyHash.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                NotificationEvent ne = (NotificationEvent)this.notifyHash.get(key);
                ((NotificationListener)((Object)target)).notification(ne);
            }
            this.notifyHash = null;
        }
    }
}

