/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.security.PrincipalImpl;
import com.sun.enterprise.security.acl.Group;
import com.sun.enterprise.security.acl.Role;
import com.sun.enterprise.security.acl.RoleMapper;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.UsersDialog;
import com.sun.enterprise.tools.deployment.ui.descriptor.RolesDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.help.CSH;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AppSecurityInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$AppSecurityInspector == null ? (class$com$sun$enterprise$tools$deployment$ui$AppSecurityInspector = AppSecurityInspector.class$("com.sun.enterprise.tools.deployment.ui.AppSecurityInspector")) : class$com$sun$enterprise$tools$deployment$ui$AppSecurityInspector);
    private static String TABNAME = localStrings.getLocalString("appsecurityinspector.tabname", "Security");
    private static String wizardHelpID = "Security";
    private static String deployHelpID = "Security";
    Application application;
    RoleNamesTableModel roleNamesTableModel;
    RoleNamesTable roleNamesTable;
    RoleUsersTableModel usersTableModel;
    RoleUsersTable usersTable;
    RoleUsersTableModel userGroupsTableModel;
    RoleUsersTable userGroupsTable;
    UsersDialog usersDialog;
    JButton delSecConstPB;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$AppSecurityInspector;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$Application;
    static /* synthetic */ Class class$javax$swing$JFrame;

    public static InspectorPane newInspectorPane(String mode, Object obj) {
        return new AppSecurityInspector();
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return class$com$sun$enterprise$deployment$Application == null ? (class$com$sun$enterprise$deployment$Application = AppSecurityInspector.class$("com.sun.enterprise.deployment.Application")) : class$com$sun$enterprise$deployment$Application;
    }

    public Descriptor getDescriptor() {
        return this.application;
    }

    public void setDescriptor(Descriptor object) {
        if (object instanceof Application) {
            this.application = (Application)object;
            this.invokeRefresh();
        } else {
            this.application = null;
        }
    }

    private AppSecurityInspector() {
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        GridBagConstraints c10 = new GridBagConstraints();
        UITitledControlButtonBox tablesBox = new UITitledControlButtonBox(null, false);
        tablesBox.setControlButtonLocation(15);
        c10.weightx = 0.5;
        c10.weighty = 0.5;
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 1;
        this.add((Component)tablesBox, c10);
        JPanel tabledPanel = new JPanel();
        GridBagLayout tgb = new GridBagLayout();
        tabledPanel.setLayout(tgb);
        tablesBox.setView(tabledPanel, false);
        UITitledTable roleNamesView = new UITitledTable(localStrings.getLocalString("appsecurityinspector.role_names_label", "Role names referenced:"), false);
        c10.weightx = 0.5;
        c10.weighty = 0.5;
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(2, 0, 0, 5);
        c10.fill = 1;
        tabledPanel.add((Component)roleNamesView, c10);
        this.roleNamesTableModel = new RoleNamesTableModel();
        this.roleNamesTable = new RoleNamesTable(this.roleNamesTableModel);
        roleNamesView.setTableView(this.roleNamesTable);
        this.roleNamesTable.setSelectionMode(0);
        this.roleNamesTable.setAutoResizeMode(4);
        this.roleNamesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e10) {
                if (e10.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel sm = (ListSelectionModel)e10.getSource();
                if (sm.isSelectionEmpty()) {
                    AppSecurityInspector.this.usersTable.clearSelection();
                    AppSecurityInspector.this.userGroupsTable.clearSelection();
                } else {
                    AppSecurityInspector.this.showUsersInSelectedRole();
                }
            }
        });
        UITitledTable roleUsersView = new UITitledTable(localStrings.getLocalString("appsecurityinspector.users_label", "Users in role:"), false);
        c10.weightx = 0.5;
        c10.weighty = 0.5;
        c10.gridx = 1;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(2, 0, 0, 0);
        c10.fill = 1;
        tabledPanel.add((Component)roleUsersView, c10);
        this.usersTableModel = new RoleUsersTableModel(true);
        this.usersTable = new RoleUsersTable(this.usersTableModel);
        roleUsersView.setTableView(this.usersTable);
        this.usersTable.setSelectionMode(0);
        this.usersTable.setAutoResizeMode(4);
        ListSelectionModel usersSelectionModel = this.usersTable.getSelectionModel();
        usersSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e10) {
                if (e10.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel sm = (ListSelectionModel)e10.getSource();
                if (!sm.isSelectionEmpty()) {
                    AppSecurityInspector.this.userGroupsTable.clearSelection();
                    AppSecurityInspector.this.delSecConstPB.setEnabled(true);
                } else if (AppSecurityInspector.this.userGroupsTable.getSelectedRow() < 0) {
                    AppSecurityInspector.this.delSecConstPB.setEnabled(false);
                }
            }
        });
        UITitledTable userGroupsView = new UITitledTable(null, false);
        c10.weightx = 0.5;
        c10.weighty = 0.5;
        c10.gridx = 1;
        c10.gridy = 1;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 0, 2, 0);
        c10.fill = 1;
        tabledPanel.add((Component)userGroupsView, c10);
        this.userGroupsTableModel = new RoleUsersTableModel(false);
        this.userGroupsTable = new RoleUsersTable(this.userGroupsTableModel);
        userGroupsView.setTableView(this.userGroupsTable);
        this.userGroupsTable.setSelectionMode(0);
        this.userGroupsTable.setAutoResizeMode(4);
        ListSelectionModel userGroupsSelectionModel = this.userGroupsTable.getSelectionModel();
        userGroupsSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e10) {
                if (e10.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel sm = (ListSelectionModel)e10.getSource();
                if (!sm.isSelectionEmpty()) {
                    AppSecurityInspector.this.usersTable.clearSelection();
                    AppSecurityInspector.this.delSecConstPB.setEnabled(true);
                } else if (AppSecurityInspector.this.usersTable.getSelectedRow() < 0) {
                    AppSecurityInspector.this.delSecConstPB.setEnabled(false);
                }
            }
        });
        String addSecConstPBText = localStrings.getLocalString("appsecurityinspector.add_sec_const_pb", "Add");
        JButton addSecConstPB = new JButton(addSecConstPBText);
        addSecConstPB.setMnemonic('A');
        addSecConstPB.setActionCommand("Add");
        addSecConstPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                AppSecurityInspector.this.addUserAction();
            }
        });
        tablesBox.addControlButton(addSecConstPB);
        String delSecConstPBString = localStrings.getLocalString("appsecurityinspector.del_sec_const_pb", "Delete");
        this.delSecConstPB = new JButton(delSecConstPBString);
        this.delSecConstPB.setMnemonic('D');
        this.delSecConstPB.setActionCommand("Delete");
        this.delSecConstPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                AppSecurityInspector.this.deleteUserAction();
            }
        });
        tablesBox.addControlButton(this.delSecConstPB);
        this.delSecConstPB.setEnabled(false);
        String editRolesPBText = localStrings.getLocalString("appsecurityinspector.edit_roles_pb", "Edit Roles...");
        JButton editRolesPB = new JButton(editRolesPBText);
        editRolesPB.setMnemonic('E');
        editRolesPB.setActionCommand("Edit Roles");
        editRolesPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                AppSecurityInspector.this.editRolesAction();
            }
        });
        tablesBox.addControlButton(editRolesPB);
    }

    private void showUsersInSelectedRole() {
        this.usersTable.clearTableData();
        this.userGroupsTable.clearTableData();
        if (this.application == null) {
            return;
        }
        String role = this.roleNamesTable.getSelectedRole();
        if (role == null) {
            return;
        }
        RoleMapper roleMapper = this.application.getRoleMapper();
        ArrayList associatedPrincipals = new ArrayList();
        Enumeration e10 = null;
        e10 = roleMapper.getUsersAssignedTo(new Role(role));
        while (e10.hasMoreElements()) {
            associatedPrincipals.add(e10.nextElement());
        }
        ArrayList associatedGroups = new ArrayList();
        e10 = roleMapper.getGroupsAssignedTo(new Role(role));
        while (e10.hasMoreElements()) {
            associatedGroups.add(e10.nextElement());
        }
        Vector<StringBuffer> userNames = new Vector<StringBuffer>();
        Iterator iter = ((AbstractList)associatedPrincipals).iterator();
        while (iter.hasNext()) {
            PrincipalImpl principal = (PrincipalImpl)iter.next();
            String n2 = principal.getName();
            userNames.add(new StringBuffer(n2));
        }
        this.usersTable.updateTableData(userNames);
        Vector<StringBuffer> groupNames = new Vector<StringBuffer>();
        iter = ((AbstractList)associatedGroups).iterator();
        while (iter.hasNext()) {
            PrincipalImpl principal = (PrincipalImpl)iter.next();
            String n3 = principal.getName();
            groupNames.add(new StringBuffer(n3));
        }
        this.userGroupsTable.updateTableData(groupNames);
    }

    private void addUserToRoleMapper(String selectedUser) {
        Role role = new Role(this.roleNamesTable.getSelectedRole());
        RoleMapper roleMapper = this.application.getRoleMapper();
        roleMapper.assignRole(new PrincipalImpl(selectedUser), role);
    }

    private void addGroupToRoleMapper(String selectedUser) {
        Role role = new Role(this.roleNamesTable.getSelectedRole());
        RoleMapper roleMapper = this.application.getRoleMapper();
        roleMapper.assignRole(new Group(selectedUser), role);
    }

    private void addUserAction() {
        if (DT.getServerManager().getCurrentServer() == null) {
            JOptionPane.showMessageDialog(this, localStrings.getLocalString("appsecurityinspector.must_connect", "You must connect to the J2EE server before mapping users."));
            return;
        }
        if (this.roleNamesTable.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog(this, localStrings.getLocalString("appsecurityinspector.must_select_role", "You must select a role before attempting to add users."));
            return;
        }
        if (this.usersDialog == null) {
            Frame frame = this.getMyParentFrame();
            this.usersDialog = new UsersDialog(frame, true);
            CSH.setHelpIDString((Component)this.usersDialog, (String)"AIAddUser");
            this.usersDialog.setServerManager(DT.getServerManager());
            this.usersDialog.addComponentListener(new ComponentAdapter(){

                public void componentHidden(ComponentEvent we) {
                    if (AppSecurityInspector.this.usersDialog.isFinished()) {
                        String selectedGroup;
                        String selectedUser = AppSecurityInspector.this.usersDialog.getSelectedUser();
                        if (selectedUser != null) {
                            AppSecurityInspector.this.addUserToRoleMapper(selectedUser);
                        }
                        if ((selectedGroup = AppSecurityInspector.this.usersDialog.getSelectedGroup()) != null) {
                            AppSecurityInspector.this.addGroupToRoleMapper(selectedGroup);
                        }
                        AppSecurityInspector.this.showUsersInSelectedRole();
                    }
                }
            });
            this.usersDialog.pack();
        }
        this.usersDialog.setLocationRelativeTo(this.usersDialog.getOwner());
        this.usersDialog.setVisible(true);
    }

    private void deleteUserAction() {
        JFrame frame = (JFrame)SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame == null ? (class$javax$swing$JFrame = AppSecurityInspector.class$("javax.swing.JFrame")) : class$javax$swing$JFrame, this);
        RoleMapper roleMapper = this.application.getRoleMapper();
        Role role = new Role(this.roleNamesTable.getSelectedRole());
        String selUserName = this.usersTable.getSelectedUser();
        String selGroupName = this.userGroupsTable.getSelectedUser();
        if (selUserName != null) {
            int n2 = JOptionPane.showConfirmDialog(frame, localStrings.getLocalString("appsecurityinspector.sure_delete_user", "Are you sure you want to delete selected user?"), localStrings.getLocalString("appsecurityinspector.delete_user", "Delete user"), 0);
            if (n2 == 0) {
                roleMapper.unassignPrincipalFromRole(role, new PrincipalImpl(selUserName));
                this.showUsersInSelectedRole();
            }
        } else if (selGroupName != null) {
            int n3 = JOptionPane.showConfirmDialog(frame, localStrings.getLocalString("appsecurityinspector.sure_delete_group", "Are you sure you want to delete selected group?"), localStrings.getLocalString("appsecurityinspector.delete_group", "Delete Group"), 0);
            if (n3 == 0) {
                roleMapper.unassignPrincipalFromRole(role, new Group(selGroupName));
                this.showUsersInSelectedRole();
            }
        } else {
            JOptionPane.showMessageDialog(frame, localStrings.getLocalString("appsecurityinspector.must_select_user_or_group", "You must first select a user or group from the list"));
        }
    }

    private void editRolesAction() {
        RolesDialog rolesDialog = RolesDialog.newRolesDialog(this, true);
        rolesDialog.showDialog(this.application);
    }

    public void refresh() {
        if (this.application == null) {
            return;
        }
        Vector<StringBuffer> roleNames = new Vector<StringBuffer>();
        Iterator itr = this.application.getRoles().iterator();
        while (itr.hasNext()) {
            Role nextRole = (Role)itr.next();
            String n2 = nextRole.getName();
            roleNames.add(new StringBuffer(n2));
        }
        this.roleNamesTable.updateTableData(roleNames);
        this.showUsersInSelectedRole();
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        AppSecurityInspector myPanel = new AppSecurityInspector();
        frame.getContentPane().add((Component)myPanel, "Center");
        ((Component)frame).setSize(myPanel.getPreferredSize());
        ((Component)frame).setVisible(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class RoleUsersTableModel
    extends InspectorTableModel {
        public RoleUsersTableModel(boolean isUserTable) {
            super(new String[]{isUserTable ? localStrings.getLocalString("userstablemodel.user_name", "User name") : localStrings.getLocalString("userstablemodel.group_name", "Group name")});
            this.columnNames = this.columnNames;
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public Object getObjectValue(Object obj, int col) {
            return obj.toString();
        }

        public void setObjectValue(Object obj, int col, Object value) {
            StringBuffer sb = (StringBuffer)obj;
            sb.setLength(0);
            sb.append(value.toString());
        }
    }

    private class RoleUsersTable
    extends InspectorTable {
        public RoleUsersTable(RoleUsersTableModel model) {
            super(model);
            this.setSelectionMode(0);
        }

        public String getSelectedUser() {
            Object ref = this.getSelectedRowObject();
            return ref != null ? ref.toString() : null;
        }
    }

    private class RoleNamesTableModel
    extends InspectorTableModel {
        public RoleNamesTableModel() {
            super(new String[]{localStrings.getLocalString("appsecurityinspector.role_names_table_col_name", "Role Name")});
        }

        public Object getObjectValue(Object obj, int col) {
            return obj.toString();
        }

        public void setObjectValue(Object obj, int col, Object value) {
            StringBuffer sb = (StringBuffer)obj;
            sb.setLength(0);
            sb.append(value.toString());
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    private class RoleNamesTable
    extends InspectorTable {
        public RoleNamesTable(RoleNamesTableModel model) {
            super(model);
            this.setToolTipText(localStrings.getLocalString("appsecurityinspector.role_names_tool_tip", "Table of role names"));
            this.setSelectionMode(0);
        }

        public String getSelectedRole() {
            Object ref = this.getSelectedRowObject();
            return ref != null ? ref.toString() : null;
        }
    }
}

