/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.main;

import com.sun.ejb.sqlgen.DBInfo;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.resource.ConnectorInfo;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.tools.deployment.backend.BufferedRemoteByteArray;
import com.sun.enterprise.tools.deployment.backend.BufferedRemoteByteArrayImpl;
import com.sun.enterprise.tools.deployment.backend.DeploymentSession;
import com.sun.enterprise.tools.deployment.backend.DeploymentSessionImpl;
import com.sun.enterprise.tools.deployment.backend.JarInstaller;
import com.sun.enterprise.tools.deployment.main.ServerException;
import com.sun.enterprise.tools.deployment.main.ServerListener;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import com.sun.enterprise.util.ORBManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.Util;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.ORB;

public class ServerManager {
    private static final String OMG_ORB_INIT_PORT_PROPERTY = "org.omg.CORBA.ORBInitialPort";
    private static final String OMG_ORB_INIT_HOST_PROPERTY = "org.omg.CORBA.ORBInitialHost";
    private static final String DEFAULT_ORB_INIT_HOST = "localhost";
    private static final String DEFAULT_ORB_INIT_PORT = "1050";
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$main$ServerManager == null ? (class$com$sun$enterprise$tools$deployment$main$ServerManager = ServerManager.class$("com.sun.enterprise.tools.deployment.main.ServerManager")) : class$com$sun$enterprise$tools$deployment$main$ServerManager);
    public static String NOTIFICATION_TYPE = "ServerManager";
    public static String SERVER_LISTENER_ADDED = "serverListenerAdded";
    public static String SERVER_LISTENER_REMOVED = "serverListenerRemoved";
    public static String SERVER_ADDED = "addServer";
    public static String SERVER_REMOVED = "removeServer";
    public static String SERVER_SELECTED = "setCurrentServer";
    public static String APP_DEPLOYED = "deployedApplication";
    public static String APP_UNDEPLOYED = "undeployedApplication";
    public static String SA_DEPLOYED = "deployedApplication";
    public static String SA_UNDEPLOYED = "undeployedStandAlone";
    private static String LOCAL_SERVER = "local";
    public static String SERVER_PROPERTY = "name";
    public static String LOCAL_HOST = "localhost";
    private static String SERVERS_FILENAME = "servers";
    private File preferencesDirectory;
    private Vector listeners = new Vector();
    private Hashtable serverNameToListenerMap = new Hashtable();
    private String currentServer;
    private Context initialContext;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$main$ServerManager;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$backend$JarInstaller;
    static /* synthetic */ Class class$com$sun$ejb$sqlgen$DBInfo;

    public ServerManager(File preferencesDirectory) {
        this.preferencesDirectory = preferencesDirectory;
    }

    public void undeployApplication(String applicationName, String serverName) throws ServerException {
        JarInstaller installer = this.getJarInstaller(serverName);
        try {
            installer.undeployApplication(applicationName);
            this.changed(APP_UNDEPLOYED, applicationName);
        }
        catch (Throwable t2) {
            throw new ServerException(localStrings.getLocalString("enterprise.tools.deployment.main.erroruninstallingapplicationfromserver", "Error uninstalling {0} from {1}", new Object[]{applicationName, serverName}));
        }
    }

    public void undeployApplication(Object[] appList, String serverName) throws ServerException {
        int i2 = 0;
        while (i2 < appList.length) {
            if (appList[i2] instanceof String) {
                this.undeployApplication((String)appList[i2], serverName);
            }
            ++i2;
        }
    }

    public void deployedApplication(Application app) {
        this.changed(APP_DEPLOYED, app.getName());
    }

    public void undeployConnector(String rarName, String serverName) throws ServerException {
        JarInstaller installer = this.getJarInstaller(serverName);
        try {
            installer.undeployConnector(rarName);
            this.changed(SA_UNDEPLOYED, rarName);
        }
        catch (Throwable t2) {
            throw new ServerException(localStrings.getLocalString("enterprise.tools.deployment.main.erroruninstallingapplicationfromserver", "Error uninstalling {0} from {1}", new Object[]{rarName, serverName}));
        }
    }

    public void undeployConnector(Object[] rarList, String serverName) throws ServerException {
        int i2 = 0;
        while (i2 < rarList.length) {
            if (rarList[i2] instanceof String) {
                this.undeployConnector((String)rarList[i2], serverName);
            }
            ++i2;
        }
    }

    public void deployedStandAlone(Descriptor desc) {
        this.changed(SA_DEPLOYED, desc.getName());
    }

    public void addServer(String serverName) throws ServerException {
        JarInstaller jarInstaller = this.getJarInstaller(serverName);
        if (this.serverNameToListenerMap.containsKey(serverName)) {
            this.setCurrentServer(serverName);
            this.changed(SERVER_SELECTED, serverName);
        } else {
            ServerListener serverListener = null;
            try {
                serverListener = this.createServerListener(serverName);
                jarInstaller.addRemoteNotificationListener(serverListener);
            }
            catch (Exception e10) {
                System.out.println(localStrings.getLocalString("enterprise.tools.deployment.main.errorgettingserverlistener", "Error getting server listener"));
            }
            this.serverNameToListenerMap.put(serverName, serverListener);
            this.setCurrentServer(serverName);
            this.changed(SERVER_ADDED, serverName);
        }
    }

    public void removeServer(String hostName) {
        if (this.serverNameToListenerMap.containsKey(hostName)) {
            ServerListener serverListener = (ServerListener)this.serverNameToListenerMap.get(hostName);
            try {
                this.serverNameToListenerMap.remove(hostName);
                if (this.getCurrentServer() != null && this.getCurrentServer().equals(hostName)) {
                    this.currentServer = null;
                }
                this.changed(SERVER_REMOVED, hostName);
                JarInstaller jarInstaller = this.getJarInstaller(hostName);
                jarInstaller.removeRemoteNotificationListener(serverListener);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getCurrentServer() {
        if (this.currentServer != null && this.serverNameToListenerMap.containsKey(this.currentServer)) {
            return this.currentServer;
        }
        return null;
    }

    public void setCurrentServer(String serverName) {
        this.currentServer = serverName;
        String notificationString = "";
        if (serverName != null) {
            notificationString = serverName;
        }
        this.changed(SERVER_SELECTED, notificationString);
    }

    public Vector getServerNames() {
        Vector v2 = new Vector();
        Enumeration e10 = this.serverNameToListenerMap.keys();
        while (e10.hasMoreElements()) {
            v2.addElement(e10.nextElement());
        }
        return v2;
    }

    public void addNotificationListener(NotificationListener nl) {
        this.listeners.addElement(nl);
        this.changed(SERVER_LISTENER_ADDED, "");
    }

    public void removeNotificationListener(NotificationListener nl) {
        this.listeners.removeElement(nl);
        this.changed(SERVER_LISTENER_REMOVED, "");
    }

    protected void changed() {
        Vector listenersClone = null;
        Vector vector = this.listeners;
        synchronized (vector) {
            listenersClone = (Vector)this.listeners.clone();
        }
        Enumeration e10 = listenersClone.elements();
        while (e10.hasMoreElements()) {
            NotificationListener nl = (NotificationListener)e10.nextElement();
            nl.notification(new NotificationEvent(this, NOTIFICATION_TYPE));
        }
    }

    protected void changed(String type, String name) {
        Vector listenersClone = null;
        Vector vector = this.listeners;
        synchronized (vector) {
            listenersClone = (Vector)this.listeners.clone();
        }
        NotificationEvent event = new NotificationEvent(this, type, SERVER_PROPERTY, name);
        Enumeration e10 = listenersClone.elements();
        while (e10.hasMoreElements()) {
            NotificationListener nl = (NotificationListener)e10.nextElement();
            nl.notification(event);
        }
    }

    /*
     * WARNING - void declaration
     */
    public DeploymentSession createDeploymentSession(String serverName) throws Exception {
        try {
            void t2;
            DeploymentSessionImpl ds2 = new DeploymentSessionImpl();
            PortableRemoteObject.exportObject((Remote)ds2);
            Tie servantsTie = Util.getTie((Remote)ds2);
            servantsTie.orb(ORBManager.getORB());
            return t2;
        }
        catch (Throwable t2) {
            throw new ServerException(localStrings.getLocalString("enterprise.tools.deployment.main.couldnotgetorbforserver", "Couldn't get orb for ({0}) {1}", new Object[]{"createDeploymentSession", serverName}));
        }
    }

    /*
     * WARNING - void declaration
     */
    private ServerListener createServerListener(String serverName) throws Exception {
        try {
            void t2;
            ServerListener listener = new ServerListener(this);
            PortableRemoteObject.exportObject((Remote)listener);
            Tie servantsTie = Util.getTie((Remote)listener);
            servantsTie.orb(ORBManager.getORB());
            return t2;
        }
        catch (Throwable t2) {
            throw new ServerException(localStrings.getLocalString("enterprise.tools.deployment.main.couldnotgetorbforserver", "Couldn't get orb for ({0}) {1}", new Object[]{"createCallBack", serverName}));
        }
    }

    /*
     * WARNING - void declaration
     */
    public BufferedRemoteByteArray createBufferedByteArray(String serverName, byte[] bytes) throws ServerException {
        try {
            void t2;
            BufferedRemoteByteArrayImpl buffer = new BufferedRemoteByteArrayImpl(bytes);
            PortableRemoteObject.exportObject((Remote)buffer);
            Tie servantsTie = Util.getTie((Remote)buffer);
            servantsTie.orb(ORBManager.getORB());
            return t2;
        }
        catch (Throwable t2) {
            throw new ServerException(localStrings.getLocalString("enterprise.tools.deployment.main.couldnotgetorbforserver", "Couldn't get orb for ({0}) {1}", new Object[]{"createBufferedByteArray", serverName}));
        }
    }

    public boolean isInstalled(String applicationName, String serverName) throws ServerException {
        JarInstaller installer = this.getJarInstaller(serverName);
        if (installer != null) {
            try {
                Vector applicationNames = installer.getApplicationNames();
                int i2 = 0;
                while (i2 < applicationNames.size()) {
                    if (applicationName.equals(applicationNames.elementAt(i2))) {
                        return true;
                    }
                    ++i2;
                }
            }
            catch (Throwable t2) {
                throw new ServerException(localStrings.getLocalString("enterprise.tools.deployment.main.couldnotapplicationlistfromserver", "Couldn't get application list from {0}", new Object[]{serverName}));
            }
        }
        return false;
    }

    public Vector getApplicationNamesForServer(String serverName) throws ServerException {
        Vector v2 = null;
        if (serverName == null) {
            return v2;
        }
        JarInstaller installer = this.getJarInstaller(serverName);
        if (installer != null) {
            try {
                v2 = installer.getApplicationNames();
            }
            catch (RemoteException re) {
                throw new ServerException(localStrings.getLocalString("enterprise.tools.deployment.main.errorgettingappnamefromserverwithreason", "Error obtaining application names from {0} \n reason {1}", new Object[]{serverName, re.getMessage()}));
            }
        }
        return v2;
    }

    public Vector getApplicationNames() throws ServerException {
        return this.getApplicationNamesForServer(this.getCurrentServer());
    }

    public Vector getConnectorNamesForServer(String serverName) throws ServerException {
        JarInstaller installer;
        Vector<String> v2 = null;
        if (serverName != null && (installer = this.getJarInstaller(serverName)) != null) {
            try {
                v2 = new Vector<String>();
                ConnectorInfo ci2 = installer.listConnectors();
                int i2 = 0;
                while (i2 < ci2.connectors.length) {
                    v2.add(ci2.connectors[i2].toString());
                    ++i2;
                }
            }
            catch (Exception re) {
                throw new ServerException(localStrings.getLocalString("enterprise.tools.deployment.main.errorgettingappnamefromserverwithreason", "Error obtaining application names from {0} \n reason {1}", new Object[]{serverName, re.toString()}));
            }
        }
        return v2;
    }

    public Vector getConnectorNames() throws ServerException {
        return this.getConnectorNamesForServer(this.getCurrentServer());
    }

    public Vector getConnectionFactoriesForServer(String serverName) throws ServerException {
        JarInstaller installer;
        Vector<String> v2 = null;
        if (serverName != null && (installer = this.getJarInstaller(serverName)) != null) {
            try {
                v2 = new Vector<String>();
                ConnectorInfo ci2 = installer.listConnectors();
                int i2 = 0;
                while (i2 < ci2.connectionFactories.length) {
                    v2.add(ci2.connectionFactories[i2].toString());
                    ++i2;
                }
            }
            catch (Exception re) {
                throw new ServerException(localStrings.getLocalString("enterprise.tools.deployment.main.errorgettingappnamefromserverwithreason", "Error obtaining application names from {0} \n reason {1}", new Object[]{serverName, re.toString()}));
            }
        }
        return v2;
    }

    public Vector getConnectionFactories() throws ServerException {
        return this.getConnectionFactoriesForServer(this.getCurrentServer());
    }

    public Set getConnectionFactoryPropertyTemplate(String appName, String connectorName) throws RemoteException, PoolingException, ServerException {
        String serverName = this.getCurrentServer();
        JarInstaller installer = this.getJarInstaller(serverName);
        return installer.getConnectionFactoryPropertyTemplate(appName, connectorName);
    }

    public void addConnectionFactory(String appName, String connectorName, String jndiName, String xaRecoveryUser, String xaRecoveryPassword, Properties props) throws RemoteException, PoolingException, ServerException {
        String serverName = this.getCurrentServer();
        JarInstaller installer = this.getJarInstaller(serverName);
        installer.addConnectionFactory(appName, connectorName, jndiName, xaRecoveryUser, xaRecoveryPassword, props);
    }

    public void removeConnectionFactory(String jndiName) throws RemoteException, PoolingException, ServerException {
        String serverName = this.getCurrentServer();
        JarInstaller installer = this.getJarInstaller(serverName);
        installer.removeConnectionFactory(jndiName);
    }

    public Set listConnectorResources() throws RemoteException, ServerException {
        String serverName = this.getCurrentServer();
        JarInstaller installer = this.getJarInstaller(serverName);
        Set res = installer.listConnectorResources();
        return res;
    }

    public JarInstaller getServerForName(String serverName) throws ServerException {
        return this.getJarInstaller(serverName);
    }

    private JarInstaller getJarInstaller(String serverName) throws ServerException {
        try {
            String initialPort;
            if (serverName.equalsIgnoreCase("local")) {
                serverName = DEFAULT_ORB_INIT_HOST;
            }
            if ((initialPort = System.getProperty(OMG_ORB_INIT_PORT_PROPERTY)) == null) {
                initialPort = String.valueOf(ORBManager.getORBInitialPort());
            }
            String corbaName = "corbaname:iiop:" + serverName + ":" + initialPort + "#" + "JarInstaller";
            Object objref = this.getIC().lookup(corbaName);
            Object o2 = PortableRemoteObject.narrow((Object)objref, (Class)(class$com$sun$enterprise$tools$deployment$backend$JarInstaller == null ? (class$com$sun$enterprise$tools$deployment$backend$JarInstaller = ServerManager.class$("com.sun.enterprise.tools.deployment.backend.JarInstaller")) : class$com$sun$enterprise$tools$deployment$backend$JarInstaller));
            JarInstaller installer = (JarInstaller)o2;
            return installer;
        }
        catch (Throwable t2) {
            throw new ServerException(localStrings.getLocalString("enterprise.tools.deployment.main.couldnotconnecttoserver", "Couldn't connect to {0}", new Object[]{serverName}));
        }
    }

    private Context getIC() {
        if (this.initialContext == null) {
            Hashtable<String, ORB> env = new Hashtable<String, ORB>();
            env.put("java.naming.corba.orb", ORBManager.getORB());
            try {
                this.initialContext = new InitialContext(env);
            }
            catch (Exception ex2) {
                ex2.printStackTrace();
            }
        }
        return this.initialContext;
    }

    public DBInfo getDBInfo(String serverName) throws ServerException {
        try {
            String initialPort;
            if (serverName.equalsIgnoreCase("local")) {
                serverName = DEFAULT_ORB_INIT_HOST;
            }
            if ((initialPort = System.getProperty(OMG_ORB_INIT_PORT_PROPERTY)) == null) {
                initialPort = String.valueOf(ORBManager.getORBInitialPort());
            }
            String corbaName = "corbaname:iiop:" + serverName + ":" + initialPort + "#" + "DatabaseInformation";
            Object objref = this.getIC().lookup(corbaName);
            Object o2 = PortableRemoteObject.narrow((Object)objref, (Class)(class$com$sun$ejb$sqlgen$DBInfo == null ? (class$com$sun$ejb$sqlgen$DBInfo = ServerManager.class$("com.sun.ejb.sqlgen.DBInfo")) : class$com$sun$ejb$sqlgen$DBInfo));
            DBInfo info = (DBInfo)o2;
            return info;
        }
        catch (Throwable t2) {
            throw new ServerException(localStrings.getLocalString("enterprise.tools.deployment.main.couldnotgetdbinfofromserver", "Could not get db info from the J2EE server {0}", new Object[]{serverName}));
        }
    }

    public Hashtable restoreFromUserHome() throws IOException {
        Hashtable badServerNamesToExceptions = new Hashtable();
        File serversFile = new File(this.preferencesDirectory, SERVERS_FILENAME);
        if (serversFile.exists()) {
            FileInputStream fis = new FileInputStream(serversFile);
            Properties servers = new Properties();
            servers.load(fis);
            fis.close();
            Enumeration<?> e10 = servers.propertyNames();
            while (e10.hasMoreElements()) {
                String serverName = (String)e10.nextElement();
                try {
                    this.addServer(serverName);
                }
                catch (Throwable ex2) {
                    badServerNamesToExceptions.put(badServerNamesToExceptions, ex2);
                }
            }
        }
        return badServerNamesToExceptions;
    }

    public void saveToUserHome() throws IOException {
        File serversFile = new File(this.preferencesDirectory, SERVERS_FILENAME);
        FileOutputStream fos = new FileOutputStream(serversFile);
        Properties serversP = new Properties();
        Enumeration e10 = this.getServerNames().elements();
        while (e10.hasMoreElements()) {
            String nextServer = (String)e10.nextElement();
            ((Hashtable)serversP).put(nextServer, nextServer);
        }
        serversP.store(fos, "J2EE Servers");
        if (fos != null) {
            fos.close();
        }
    }

    private String printList() {
        String s2 = "Server Manager ";
        Enumeration e10 = this.getServerNames().elements();
        while (e10.hasMoreElements()) {
            s2 = s2 + "\n\t" + e10.nextElement();
        }
        return s2;
    }

    public String toString() {
        return "ServerManager";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

