/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.realm;

import com.sun.enterprise.ServerConfiguration;
import com.sun.enterprise.security.auth.realm.AuthenticationHandler;
import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.InvalidOperationException;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchUserException;
import com.sun.enterprise.security.auth.realm.User;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.TypeUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public abstract class Realm
implements Comparable {
    private static final String REALM_PREFIX = "auth.realm.";
    private static final String REALMS_LIST = "auth.realms";
    private static final boolean debug = false;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$security$auth$realm$Realm == null ? (class$com$sun$enterprise$security$auth$realm$Realm = Realm.class$("com.sun.enterprise.security.auth.realm.Realm")) : class$com$sun$enterprise$security$auth$realm$Realm);
    private static Hashtable loadedRealms = new Hashtable();
    private String myName;
    static /* synthetic */ Class class$com$sun$enterprise$security$auth$realm$Realm;

    public final String getName() {
        return this.myName;
    }

    protected final void setName(String name) {
        if (this.myName != null) {
            return;
        }
        this.myName = name;
    }

    public String toString() {
        return this.myName;
    }

    public int compareTo(Object realm) {
        if (!(realm instanceof Realm)) {
            return 1;
        }
        Realm r2 = (Realm)realm;
        String str = r2.getAuthType();
        int temp = this.getAuthType().compareTo(str);
        if (temp != 0) {
            return temp;
        }
        str = r2.getName();
        return this.getName().compareTo(str);
    }

    public static String[] getSupported() {
        ServerConfiguration config = ServerConfiguration.getConfiguration();
        return TypeUtil.stringToArray(config.getProperty(REALMS_LIST), ",");
    }

    public static void initialize() {
        ServerConfiguration config = ServerConfiguration.getConfiguration();
        String[] realms = Realm.getSupported();
        int i2 = 0;
        while (i2 < realms.length) {
            String realmName = REALM_PREFIX + realms[i2];
            String realmFile = config.getProperty(realmName);
            try {
                File rfile = new File(FileUtil.getAbsolutePath(realmFile));
                Realm.instantiate(realms[i2], rfile);
            }
            catch (Exception e10) {
                e10.printStackTrace(System.err);
            }
            ++i2;
        }
    }

    public static Realm instantiate(String realmName, File f2) throws NoSuchRealmException, BadRealmException, FileNotFoundException {
        if (!f2.exists() || !f2.isFile()) {
            throw new FileNotFoundException();
        }
        if (Realm.getInstance(realmName) != null) {
            throw new BadRealmException(localStrings.getLocalString("realm.already_exists", "This Realm already exists."));
        }
        FileInputStream in = new FileInputStream(f2);
        Properties props = new Properties();
        try {
            props.load(in);
            String classname = props.getProperty("classname");
            Class<?> realmClass = Class.forName(classname);
            Object obj = realmClass.newInstance();
            Realm r2 = (Realm)obj;
            r2.setName(realmName);
            loadedRealms.put(realmName, r2);
            r2.init(props);
            return r2;
        }
        catch (Exception e10) {
            e10.printStackTrace(System.out);
            throw new BadRealmException(e10.getMessage());
        }
    }

    public static Realm getInstance(String name) throws NoSuchRealmException, BadRealmException {
        Realm retval = null;
        retval = (Realm)loadedRealms.get(name);
        return retval;
    }

    public static Enumeration getRealmNames() {
        return loadedRealms.keys();
    }

    protected Realm() {
    }

    protected void init(Properties props) throws BadRealmException, NoSuchRealmException {
    }

    public abstract String getAuthType();

    public abstract AuthenticationHandler getAuthenticationHandler();

    public abstract Enumeration getUserNames() throws BadRealmException;

    public abstract User getUser(String var1) throws NoSuchUserException, BadRealmException;

    public abstract Enumeration getGroupNames() throws BadRealmException;

    public abstract Enumeration getGroupNames(String var1) throws InvalidOperationException, NoSuchUserException;

    public abstract void refresh() throws BadRealmException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

