/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.acl;

import com.sun.enterprise.ServerConfiguration;
import com.sun.enterprise.security.PrincipalImpl;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.acl.Group;
import com.sun.enterprise.security.acl.Role;
import com.sun.enterprise.security.auth.AuthenticationInfo;
import com.sun.enterprise.security.auth.Credentials;
import com.sun.enterprise.security.auth.Privilege;
import com.sun.enterprise.security.auth.realm.sharedpassword.SharedPasswordRealm;
import com.sun.enterprise.tools.admin.RealmTool;
import java.io.Serializable;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class RoleMapper
implements Serializable {
    private static boolean debug = false;
    private static Hashtable roleMaps = new Hashtable();
    private static final String DEFAULT_ROLE_NAME = "auth.anyone.role.name";
    private static Role defaultRole = null;
    private Hashtable prinTable = new Hashtable();
    private Hashtable roleTable = new Hashtable();
    private String appName;
    static /* synthetic */ Class class$com$sun$enterprise$security$acl$RoleMapper;

    private RoleMapper(String appName) {
        this.appName = appName;
    }

    private static synchronized void initDefaultRole() {
        if (defaultRole == null) {
            ServerConfiguration config = ServerConfiguration.getConfiguration();
            String drole = config.getProperty(DEFAULT_ROLE_NAME, "ANYONE");
            defaultRole = new Role(drole);
        }
    }

    public static RoleMapper getRoleMapper(String appName) {
        if (!roleMaps.containsKey(appName)) {
            Class clazz = class$com$sun$enterprise$security$acl$RoleMapper == null ? (class$com$sun$enterprise$security$acl$RoleMapper = RoleMapper.class$("com.sun.enterprise.security.acl.RoleMapper")) : class$com$sun$enterprise$security$acl$RoleMapper;
            synchronized (clazz) {
                roleMaps.put(appName, new RoleMapper(appName));
            }
        }
        return (RoleMapper)roleMaps.get(appName);
    }

    public static void setRoleMapper(String appName, RoleMapper rmap) {
        if (!roleMaps.containsKey(appName)) {
            Class clazz = class$com$sun$enterprise$security$acl$RoleMapper == null ? (class$com$sun$enterprise$security$acl$RoleMapper = RoleMapper.class$("com.sun.enterprise.security.acl.RoleMapper")) : class$com$sun$enterprise$security$acl$RoleMapper;
            synchronized (clazz) {
                roleMaps.put(appName, rmap);
            }
        }
    }

    public static void removeRoleMapper(String appName) {
        if (roleMaps.containsKey(appName)) {
            Class clazz = class$com$sun$enterprise$security$acl$RoleMapper == null ? (class$com$sun$enterprise$security$acl$RoleMapper = RoleMapper.class$("com.sun.enterprise.security.acl.RoleMapper")) : class$com$sun$enterprise$security$acl$RoleMapper;
            synchronized (clazz) {
                roleMaps.remove(appName);
            }
        }
    }

    public String getName() {
        return this.appName;
    }

    public void setName(String name) {
        if (roleMaps.containsKey(this.appName)) {
            Class clazz = class$com$sun$enterprise$security$acl$RoleMapper == null ? (class$com$sun$enterprise$security$acl$RoleMapper = RoleMapper.class$("com.sun.enterprise.security.acl.RoleMapper")) : class$com$sun$enterprise$security$acl$RoleMapper;
            synchronized (clazz) {
                roleMaps.remove(this.appName);
                this.appName = name;
                roleMaps.remove(name);
                roleMaps.put(this.appName, this);
            }
        }
    }

    public static Role getDefaultRole() {
        if (defaultRole == null) {
            RoleMapper.initDefaultRole();
        }
        return defaultRole;
    }

    public void assignRole(Principal p2, Role r2) {
        this.createMapping(this.prinTable, p2, r2);
        this.createMapping(this.roleTable, r2, p2);
    }

    private void createMapping(Hashtable table, Principal key, Principal value) {
        HashSet aSet;
        if (!table.containsKey(key)) {
            Hashtable hashtable = table;
            synchronized (hashtable) {
                table.put(key, new HashSet());
            }
        }
        HashSet hashSet = aSet = (HashSet)table.get(key);
        synchronized (hashSet) {
            aSet.add(value);
        }
    }

    private void removeKey(Hashtable table, Principal key) {
        table.remove(key);
    }

    private void removeValue(Hashtable table, Principal value) {
        Enumeration e10 = table.elements();
        while (e10.hasMoreElements()) {
            HashSet aSet;
            HashSet hashSet = aSet = (HashSet)e10.nextElement();
            synchronized (hashSet) {
                aSet.remove(value);
            }
        }
    }

    private void removeValueFromSetWithKey(Hashtable ht, Object key, Object value) {
        Set set = (Set)ht.get(key);
        if (set != null) {
            set.remove(value);
            if (set.isEmpty()) {
                ht.remove(key);
            }
        }
    }

    public void unassignRole(Role r2) {
        this.removeKey(this.roleTable, r2);
        this.removeValue(this.prinTable, r2);
    }

    public void unassignPrincipalFromRole(Role r2, Principal p2) {
        this.removeValueFromSetWithKey(this.prinTable, p2, r2);
        this.removeValueFromSetWithKey(this.roleTable, r2, p2);
    }

    private void unassignPrincipalFromRole(Hashtable map, Role r2, Principal p2) {
    }

    protected Iterator getRoles(Principal p2) {
        if (debug) {
            System.out.println(this);
            System.out.println("In roleMapper.getRoles(" + p2 + ")");
        }
        HashSet aSet = (HashSet)this.prinTable.get(p2);
        if (debug) {
            System.out.println("Set of roles = " + aSet);
        }
        if (aSet != null) {
            return aSet.iterator();
        }
        return null;
    }

    public boolean hasRole(Principal principal, String role) {
        if (debug) {
            System.out.println("PRINCIPAL : " + principal);
            System.out.println("PRINCIPAL TABLE: " + this.prinTable);
        }
        HashSet aSet = (HashSet)this.prinTable.get(principal);
        if (debug) {
            System.out.println("For principal: " + principal + " , set of roles= " + aSet);
        }
        Role r2 = new Role(role);
        if (aSet != null && aSet.contains(r2)) {
            return true;
        }
        return this.arePrincipalsGroupsInRole(principal.getName(), r2);
    }

    /*
     * WARNING - void declaration
     */
    private Enumeration getGroupsForPrincipal(String principal) {
        SharedPasswordRealm rlm = (SharedPasswordRealm)RealmTool.getDefaultRealm();
        try {
            void e10;
            Enumeration en2 = rlm.getGroupNames(principal);
            return e10;
        }
        catch (Exception e10) {
            Vector v2 = new Vector();
            return v2.elements();
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean arePrincipalsGroupsInRole(String principal, Role role) {
        en = this.getGroupsForPrincipal(principal);
        aset = (HashSet)this.roleTable.get(role);
        if (aset != null) ** GOTO lbl9
        return false;
lbl-1000:
        // 1 sources

        {
            gname = (String)en.nextElement();
            g = new PrincipalImpl(gname);
            if (!aset.contains(g)) continue;
            return true;
lbl9:
            // 2 sources

            ** while (en.hasMoreElements())
        }
lbl10:
        // 1 sources

        return false;
    }

    public Enumeration getRoles() {
        return this.roleTable.keys();
    }

    public Enumeration getGroupsAssignedTo(Role r2) {
        Vector vec = new Vector();
        HashSet aSet = (HashSet)this.roleTable.get(r2);
        if (aSet != null) {
            Iterator iter = aSet.iterator();
            while (iter.hasNext()) {
                Object o2 = iter.next();
                if (!(o2 instanceof Group)) continue;
                vec.add(o2);
            }
        }
        return vec.elements();
    }

    public Enumeration getUsersAssignedTo(Role r2) {
        Vector vec = new Vector();
        HashSet aSet = (HashSet)this.roleTable.get(r2);
        if (aSet != null) {
            Iterator iter = aSet.iterator();
            while (iter.hasNext()) {
                Object o2 = iter.next();
                if (o2 instanceof Group) continue;
                vec.add(o2);
            }
        }
        return vec.elements();
    }

    public Enumeration getCurrentRoles() {
        if (debug) {
            System.out.println("within roleMapper.getCurrentRoles()");
        }
        Vector<Role> rlist = new Vector<Role>();
        SecurityContext sc = SecurityContext.getCurrent();
        if (debug) {
            System.out.println("roleMapper.SecurityContext=" + sc);
        }
        if (RoleMapper.getDefaultRole() != null) {
            if (debug) {
                System.out.println("roleMapper.adding the default role=" + RoleMapper.getDefaultRole());
            }
            rlist.add(RoleMapper.getDefaultRole());
        }
        if (sc == null) {
            return rlist.elements();
        }
        try {
            try {
                Credentials c10 = sc.getCredentials();
                if (debug) {
                    System.out.println("roleMapper.credential = " + c10);
                }
                if (debug) {
                    // empty if block
                }
                AuthenticationInfo[] alist = c10.getAuthenticationInfo();
                if (debug) {
                    System.out.println("AuthInfoList = " + alist.length);
                }
                int i2 = 0;
                while (i2 < alist.length) {
                    AuthenticationInfo ainfo = alist[i2];
                    if (debug) {
                        System.out.println("AuthInfo = " + ainfo);
                    }
                    if (ainfo.isAuthenticated()) {
                        PrincipalImpl p2 = new PrincipalImpl(ainfo.getPrincipalName());
                        Iterator itr = this.getRoles(p2);
                        if (itr != null) {
                            while (itr.hasNext()) {
                                rlist.add((Role)itr.next());
                            }
                        }
                        Privilege[] groups = ainfo.getAttribute("Groups");
                        int j2 = 0;
                        while (j2 < groups.length) {
                            Group g2 = new Group(groups[j2].getName());
                            itr = this.getRoles(g2);
                            if (itr != null) {
                                while (itr.hasNext()) {
                                    rlist.add((Role)itr.next());
                                }
                            }
                            ++j2;
                        }
                    }
                    ++i2;
                }
            }
            catch (Exception e10) {
                e10.printStackTrace();
                Object var13_14 = null;
                return rlist.elements();
            }
            Object var13_13 = null;
            return rlist.elements();
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            return rlist.elements();
        }
    }

    public String toString() {
        String s2 = "RoleMapper";
        Enumeration e10 = this.getRoles();
        while (e10.hasMoreElements()) {
            Role r2 = (Role)e10.nextElement();
            Enumeration ee2 = null;
            s2 = s2 + "\n\t" + r2 + "(";
            ee2 = this.getGroupsAssignedTo(r2);
            while (ee2.hasMoreElements()) {
                s2 = s2 + ee2.nextElement();
                if (!ee2.hasMoreElements()) continue;
                s2 = s2 + ",";
            }
            s2 = s2 + ")(";
            ee2 = this.getUsersAssignedTo(r2);
            while (ee2.hasMoreElements()) {
                s2 = s2 + ee2.nextElement();
                if (!ee2.hasMoreElements()) continue;
                s2 = s2 + ",";
            }
            s2 = s2 + ")";
        }
        return s2;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

