/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.PoolManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.resource.ClientSecurityInfo;
import com.sun.enterprise.resource.Jdbc10XaAllocator;
import com.sun.enterprise.resource.Jdbc20XaAllocator;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceAllocator;
import com.sun.enterprise.resource.ResourcePrincipal;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.DataSource;

public class JdbcDataSource
implements DataSource,
Serializable {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$resource$JdbcDataSource == null ? (class$com$sun$enterprise$resource$JdbcDataSource = JdbcDataSource.class$("com.sun.enterprise.resource.JdbcDataSource")) : class$com$sun$enterprise$resource$JdbcDataSource);
    private transient PoolManager poolMgr;
    private static final boolean debug = false;
    private String dataSourceName;
    private String desc;
    private String jndiName;
    private int jdbcMajorVersion;
    static /* synthetic */ Class class$com$sun$enterprise$resource$JdbcDataSource;

    public Connection getConnection() throws SQLException {
        String auth;
        InvocationManager i2 = Switch.getSwitch().getInvocationManager();
        if (i2 == null) {
            String msg = localStrings.getLocalString("datasource.wrongclient", "");
            throw new SQLException(msg);
        }
        this.initPoolManager();
        ResourceReferenceDescriptor ref = this.poolMgr.getResourceReference(this.jndiName);
        boolean resourceShareable = true;
        if (ref == null) {
            String msg = localStrings.getLocalString("no.resource.reference", "", new Object[]{this.jndiName});
            Log.err.println(msg);
            return this.internalGetConnection("", "", resourceShareable);
        }
        String shareableStr = ref.getSharingScope();
        if (shareableStr.equals(ResourceReferenceDescriptor.RESOURCE_UNSHAREABLE)) {
            resourceShareable = false;
        }
        if ((auth = ref.getAuthorization()).equals(ResourceReferenceDescriptor.APPLICATION_AUTHORIZATION)) {
            String msg = localStrings.getLocalString("password.parameter.warning", "", new Object[]{this.jndiName});
            Log.err.println(msg);
            return this.internalGetConnection("", "", resourceShareable);
        }
        ResourcePrincipal prin = ref.getResourcePrincipal();
        if (prin == null) {
            String msg = localStrings.getLocalString("password.info.warning", "", new Object[]{this.jndiName});
            Log.err.println(msg);
            return this.internalGetConnection("", "", resourceShareable);
        }
        return this.internalGetConnection(prin.getName(), prin.getPassword(), resourceShareable);
    }

    public Connection getConnection(String username, String password) throws SQLException {
        String auth;
        InvocationManager i2 = Switch.getSwitch().getInvocationManager();
        if (i2 == null) {
            String msg = localStrings.getLocalString("datasource.wrongclient", "");
            throw new SQLException(msg);
        }
        this.initPoolManager();
        ResourceReferenceDescriptor ref = this.poolMgr.getResourceReference(this.jndiName);
        boolean resourceShareable = true;
        if (ref == null) {
            String msg = localStrings.getLocalString("no.resource.reference", "", new Object[]{this.jndiName});
            Log.err.println(msg);
            return this.internalGetConnection(username, password, resourceShareable);
        }
        String shareableStr = ref.getSharingScope();
        if (shareableStr.equals(ResourceReferenceDescriptor.RESOURCE_UNSHAREABLE)) {
            resourceShareable = false;
        }
        if ((auth = ref.getAuthorization()).equals(ResourceReferenceDescriptor.CONTAINER_AUTHORIZATION)) {
            String msg = localStrings.getLocalString("redundant.password", "", new Object[]{this.jndiName});
            throw new SQLException(msg);
        }
        return this.internalGetConnection(username, password, resourceShareable);
    }

    private Connection internalGetConnection(String username, String password, boolean shareable) throws SQLException {
        ResourceAllocator alloc = null;
        ResourceSpec spec = new ResourceSpec(this.jndiName, 1);
        ResourcePrincipal prin = new ResourcePrincipal(username, password);
        ClientSecurityInfo info = new ClientSecurityInfo(prin);
        if (this.jdbcMajorVersion == 1) {
            if (!shareable) {
                throw new SQLException("Cannot use resource in unshareable scope: " + this.jndiName);
            }
            alloc = new Jdbc10XaAllocator(this.poolMgr, this.dataSourceName, spec, info);
        } else {
            alloc = new Jdbc20XaAllocator(this.poolMgr, this.dataSourceName, spec, info, shareable);
        }
        try {
            return (Connection)this.poolMgr.getResource(spec, alloc, new ClientSecurityInfo(prin));
        }
        catch (PoolingException ex2) {
            Exception nex = ex2.getNestedException();
            if (nex instanceof SQLException) {
                throw (SQLException)nex;
            }
            if (nex instanceof RuntimeException) {
                throw (RuntimeException)nex;
            }
            nex.printStackTrace();
            nex.printStackTrace(Log.err);
            throw new SQLException(nex.toString());
        }
    }

    public int getJdbcMajorVersion() {
        return this.jdbcMajorVersion;
    }

    public void setJdbcMajorVersion(int version) {
        this.jdbcMajorVersion = version;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public int getLoginTimeout() throws SQLException {
        return DriverManager.getLoginTimeout();
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        DriverManager.setLoginTimeout(seconds);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return DriverManager.getLogWriter();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        DriverManager.setLogWriter(out);
    }

    public String getDescription() {
        return this.desc;
    }

    public void setDescription(String desc) {
        this.desc = desc;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    private void initPoolManager() {
        if (this.poolMgr == null) {
            this.poolMgr = Switch.getSwitch().getPoolManager();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

