/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.naming;

import com.sun.enterprise.Switch;
import com.sun.enterprise.naming.SerialContextProvider;
import com.sun.enterprise.naming.SerialNameParser;
import com.sun.enterprise.util.ORBManager;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.CommunicationException;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.spi.NamingManager;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;

public class SerialContext
implements Context {
    private static final String ORB_STRING = "ORB";
    private static final String HANDLE_DELEGATE = "HandleDelegate";
    private static final String TRANSACTION_MGR = "TransactionManager";
    private static final boolean debug = false;
    private static Hashtable providerCache = new Hashtable();
    private static NameParser myParser = new SerialNameParser();
    private Hashtable myEnv;
    private SerialContextProvider provider;
    private String componentId;
    static /* synthetic */ Class class$com$sun$enterprise$naming$SerialContextProvider;

    private SerialContextProvider getProvider() throws NamingException {
        ORB orb = (ORB)this.myEnv.get("java.naming.corba.orb");
        if (orb == null) {
            orb = ORBManager.getORB();
        }
        this.provider = (SerialContextProvider)providerCache.get(orb);
        if (this.provider == null) {
            try {
                NamingContext nctx = NamingContextHelper.narrow((Object)orb.resolve_initial_references("NameService"));
                NameComponent[] path = new NameComponent[]{new NameComponent("SerialContextProvider", "")};
                this.provider = (SerialContextProvider)PortableRemoteObject.narrow((java.lang.Object)nctx.resolve(path), (Class)(class$com$sun$enterprise$naming$SerialContextProvider == null ? (class$com$sun$enterprise$naming$SerialContextProvider = SerialContext.class$("com.sun.enterprise.naming.SerialContextProvider")) : class$com$sun$enterprise$naming$SerialContextProvider));
            }
            catch (Exception ex2) {
                throw new CommunicationException("Can't find SerialContextProvider");
            }
            providerCache.put(orb, this.provider);
        }
        return this.provider;
    }

    public SerialContext(Hashtable environment) throws NamingException {
        this.myEnv = environment != null ? (Hashtable)environment.clone() : null;
        this.componentId = "";
    }

    public SerialContext(String compId, Hashtable env) throws NamingException {
        this(env);
        this.componentId = compId;
    }

    public String getNameInNamespace() throws NamingException {
        return this.componentId;
    }

    public java.lang.Object lookup(String name) throws NamingException {
        if (name.equals("")) {
            return new SerialContext(this.componentId, this.myEnv);
        }
        if ((name = this.getRelativeName(name)).equals(ORB_STRING)) {
            return ORBManager.getORB();
        }
        if (name.equals(HANDLE_DELEGATE)) {
            return Switch.getSwitch().getHandleDelegate();
        }
        if (name.equals(TRANSACTION_MGR)) {
            return Switch.getSwitch().getContainerFactory().getTransactionMgr();
        }
        try {
            java.lang.Object obj = this.getProvider().lookup(name);
            if (obj instanceof Context) {
                return new SerialContext(name, this.myEnv);
            }
            java.lang.Object retObj = NamingManager.getObjectInstance(obj, null, null, this.myEnv);
            return retObj;
        }
        catch (NamingException nnfe) {
            throw nnfe;
        }
        catch (Exception ex2) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            ex2.printStackTrace(printWriter);
            throw new CommunicationException(stringWriter.toString());
        }
    }

    public java.lang.Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    public void bind(String name, java.lang.Object obj) throws NamingException {
        name = this.getRelativeName(name);
        try {
            this.getProvider().bind(name, obj);
        }
        catch (RemoteException ex2) {
            throw new CommunicationException(ex2.toString());
        }
    }

    public void bind(Name name, java.lang.Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    public void rebind(String name, java.lang.Object obj) throws NamingException {
        name = this.getRelativeName(name);
        try {
            this.getProvider().rebind(name, obj);
        }
        catch (RemoteException ex2) {
            throw new CommunicationException(ex2.toString());
        }
    }

    public void rebind(Name name, java.lang.Object obj) throws NamingException {
        this.rebind(name.toString(), obj);
    }

    public void unbind(String name) throws NamingException {
        name = this.getRelativeName(name);
        try {
            this.getProvider().unbind(name);
        }
        catch (RemoteException ex2) {
            throw new CommunicationException(ex2.toString());
        }
    }

    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    public void rename(String oldname, String newname) throws NamingException {
        oldname = this.getRelativeName(oldname);
        newname = this.getRelativeName(newname);
        try {
            this.getProvider().rename(oldname, newname);
        }
        catch (RemoteException ex2) {
            throw new CommunicationException(ex2.toString());
        }
    }

    public void rename(Name oldname, Name newname) throws NamingException {
        this.rename(oldname.toString(), newname.toString());
    }

    public NamingEnumeration list(String name) throws NamingException {
        if (name.equals("")) {
            try {
                Hashtable bindings = this.getProvider().list(this.componentId);
                return new RepNames(bindings);
            }
            catch (RemoteException ex2) {
                throw new CommunicationException(ex2.toString());
            }
        }
        java.lang.Object target = this.lookup(name = this.getRelativeName(name));
        if (target instanceof Context) {
            return ((Context)target).list("");
        }
        throw new NotContextException(name + " cannot be listed");
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        if (name.equals("")) {
            try {
                Hashtable bindings = this.getProvider().list(this.componentId);
                return new RepBindings(bindings);
            }
            catch (RemoteException ex2) {
                throw new CommunicationException(ex2.toString());
            }
        }
        java.lang.Object target = this.lookup(name = this.getRelativeName(name));
        if (target instanceof Context) {
            return ((Context)target).listBindings("");
        }
        throw new NotContextException(name + " cannot be listed");
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    public void destroySubcontext(String name) throws NamingException {
        name = this.getRelativeName(name);
        try {
            this.getProvider().destroySubcontext(name);
        }
        catch (RemoteException e10) {
            throw new CommunicationException(e10.toString());
        }
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    public Context createSubcontext(String name) throws NamingException {
        Context c10 = null;
        name = this.getRelativeName(name);
        try {
            c10 = this.getProvider().createSubcontext(name);
            if (c10 instanceof Context) {
                c10 = new SerialContext(name, this.myEnv);
            }
        }
        catch (RemoteException e10) {
            throw new CommunicationException(e10.toString());
        }
        return c10;
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }

    public java.lang.Object lookupLink(String name) throws NamingException {
        name = this.getRelativeName(name);
        return this.lookup(name);
    }

    public java.lang.Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    public NameParser getNameParser(String name) throws NamingException {
        return myParser;
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(name.toString());
    }

    public String composeName(String name, String prefix) throws NamingException {
        Name result = this.composeName(new CompositeName(name), new CompositeName(prefix));
        return result.toString();
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    public java.lang.Object addToEnvironment(String propName, java.lang.Object propVal) throws NamingException {
        if (this.myEnv == null) {
            this.myEnv = new Hashtable(5, 0.75f);
        }
        return this.myEnv.put(propName, propVal);
    }

    public java.lang.Object removeFromEnvironment(String propName) throws NamingException {
        if (this.myEnv == null) {
            return null;
        }
        return this.myEnv.remove(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this.myEnv == null) {
            this.myEnv = new Hashtable(3, 0.75f);
        }
        return this.myEnv;
    }

    public void close() throws NamingException {
        this.myEnv = null;
    }

    private String getRelativeName(String name) {
        if (!this.componentId.equals("")) {
            name = this.componentId + "/" + name;
        }
        return name;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class RepBindings
    implements NamingEnumeration {
        Enumeration names;
        Hashtable bindings;

        RepBindings(Hashtable bindings) {
            this.bindings = bindings;
            this.names = bindings.keys();
        }

        public boolean hasMoreElements() {
            return this.names.hasMoreElements();
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public java.lang.Object nextElement() {
            if (this.hasMoreElements()) {
                String name = (String)this.names.nextElement();
                return new Binding(name, this.bindings.get(name));
            }
            return null;
        }

        public java.lang.Object next() throws NamingException {
            return this.nextElement();
        }

        public void close() throws NamingException {
            throw new OperationNotSupportedException("close() not implemented");
        }
    }

    class RepNames
    implements NamingEnumeration {
        Hashtable bindings;
        Enumeration names;

        RepNames(Hashtable bindings) {
            this.bindings = bindings;
            this.names = bindings.keys();
        }

        public boolean hasMoreElements() {
            return this.names.hasMoreElements();
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public java.lang.Object nextElement() {
            if (this.names.hasMoreElements()) {
                String name = (String)this.names.nextElement();
                String className = this.bindings.get(name).getClass().getName();
                return new NameClassPair(name, className);
            }
            return null;
        }

        public java.lang.Object next() throws NamingException {
            return this.nextElement();
        }

        public void close() throws NamingException {
            throw new OperationNotSupportedException("close() not implemented");
        }
    }
}

