/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.naming;

import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationException;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.NamingManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.JmsDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.jms.ConnectionFactoryWrapperStandalone;
import com.sun.enterprise.jms.JmsUtil;
import com.sun.enterprise.jms.JmsWrapperFactory;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.ORBManager;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Remote;
import java.util.Hashtable;
import java.util.Iterator;
import javax.jms.ConnectionFactory;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.jms.Topic;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.omg.CORBA.Object;

public class NamingManagerImpl
implements NamingManager {
    public static final String SERIALOBJECT_FACTORY = "com.sun.enterprise.naming.factory.SerialObjectFactory";
    public static final String IIOPOBJECT_FACTORY = "com.sun.enterprise.naming.factory.IIOPObjectFactory";
    public static final String MAIL_COMPONENT_FACTORY = "com.sun.enterprise.naming.factory.MailSessionObjectFactory";
    public static final String JMS_CONNECTION_FACTORY_FACTORY = "com.sun.enterprise.naming.factory.JmsConnectionFactoryFactory";
    public static final String LOCAL_HOME_FACTORY = "com.sun.enterprise.naming.factory.LocalHomeFactory";
    public static final String JAVA_COMP_STRING = "java:comp/env/";
    private static final String CONTEXT_SEPARATOR = "/";
    private static final String ID_SEPARATOR = "_";
    private static final String ROOT_ENV_CONTEXT_NAME = "environments";
    private static final String EJB_ENV_CONTEXT_NAME = "environments/ejbs";
    private static final String WEB_ENV_CONTEXT_NAME = "environments/web";
    private static final String APPCLIENT_ENV_CONTEXT_NAME = "environments/appclients";
    private static final int UNKNOWN_COMPONENT = 0;
    private static final int EJB_COMPONENT = 1;
    private static final int WEB_COMPONENT = 2;
    private static final int APP_CLIENT_COMPONENT = 3;
    private static final boolean debug = false;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$naming$NamingManagerImpl == null ? (class$com$sun$enterprise$naming$NamingManagerImpl = NamingManagerImpl.class$("com.sun.enterprise.naming.NamingManagerImpl")) : class$com$sun$enterprise$naming$NamingManagerImpl);
    private InitialContext initialContext;
    private InitialContext cosContext;
    private Context ejbEnvContext;
    private Context webEnvContext;
    private Context appClientEnvContext;
    private InvocationManager im = null;
    private Switch theSwitch = null;
    static /* synthetic */ Class class$com$sun$enterprise$naming$NamingManagerImpl;

    public NamingManagerImpl() throws NamingException {
        this(new InitialContext());
    }

    public NamingManagerImpl(InitialContext ic) throws NamingException {
        this.initialContext = ic;
        this.theSwitch = Switch.getSwitch();
        this.im = this.theSwitch.getInvocationManager();
        Hashtable<String, String> myEnv = new Hashtable<String, String>();
        myEnv.put("java.naming.factory.initial", "com.sun.jndi.cosnaming.CNCtxFactory");
        myEnv.put("java.naming.corba.orb", (String)ORBManager.getORB());
        this.cosContext = new InitialContext(myEnv);
        try {
            java.lang.Object rootContext = this.initialContext.lookup(ROOT_ENV_CONTEXT_NAME);
            this.appClientEnvContext = (Context)this.initialContext.lookup(APPCLIENT_ENV_CONTEXT_NAME);
            this.webEnvContext = (Context)this.initialContext.lookup(WEB_ENV_CONTEXT_NAME);
            this.ejbEnvContext = (Context)this.initialContext.lookup(EJB_ENV_CONTEXT_NAME);
        }
        catch (NameNotFoundException e10) {
            this.appClientEnvContext = this.initialContext.createSubcontext(APPCLIENT_ENV_CONTEXT_NAME);
            this.webEnvContext = this.initialContext.createSubcontext(WEB_ENV_CONTEXT_NAME);
            this.ejbEnvContext = this.initialContext.createSubcontext(EJB_ENV_CONTEXT_NAME);
        }
    }

    public Context getInitialContext() {
        return this.initialContext;
    }

    public void publishObject(String name, java.lang.Object obj, boolean rebind) throws NamingException {
        CompositeName nameobj = new CompositeName(name);
        this.publishObject(nameobj, obj, rebind);
    }

    public void publishObject(Name name, java.lang.Object obj, boolean rebind) throws NamingException {
        java.lang.Object serialObj = obj;
        if (this.isCOSNamingObj(obj)) {
            this.createSubContexts(name, this.cosContext);
            if (rebind) {
                this.cosContext.rebind(name, obj);
            } else {
                this.cosContext.bind(name, obj);
            }
            serialObj = new Reference("reference", new StringRefAddr("url", name.toString()), IIOPOBJECT_FACTORY, null);
        }
        if (rebind) {
            this.initialContext.rebind(name, serialObj);
        } else {
            this.initialContext.bind(name, serialObj);
        }
    }

    public void unpublishObject(String name) throws NamingException {
        java.lang.Object obj = this.initialContext.lookup(name);
        if (this.isCOSNamingObj(obj)) {
            this.cosContext.unbind(name);
        }
        this.initialContext.unbind(name);
    }

    public void unpublishObject(Name name) throws NamingException {
        this.unpublishObject(name.toString());
    }

    private void createSubContexts(Name name, Context rootCtx) throws NamingException {
        int numSubContexts = name.size() - 1;
        Context currentCtx = rootCtx;
        int subCtxIndex = 0;
        while (subCtxIndex < numSubContexts) {
            block5: {
                Context newCtx;
                String subCtxName = name.get(subCtxIndex);
                try {
                    java.lang.Object obj = currentCtx.lookup(subCtxName);
                    if (obj == null) {
                        currentCtx = newCtx = currentCtx.createSubcontext(subCtxName);
                        break block5;
                    }
                    if (obj instanceof Context) {
                        currentCtx = (Context)obj;
                        break block5;
                    }
                    throw new NameAlreadyBoundException(subCtxName);
                }
                catch (NameNotFoundException e10) {
                    currentCtx = newCtx = currentCtx.createSubcontext(subCtxName);
                }
            }
            ++subCtxIndex;
        }
    }

    public String getComponentId() throws NamingException {
        String id = null;
        try {
            ComponentInvocation ci2 = this.im.getCurrentInvocation();
            java.lang.Object containerContext = ci2.getContainerContext();
            if (containerContext == null) {
                throw new NamingException("No container context");
            }
            JndiNameEnvironment desc = (JndiNameEnvironment)this.theSwitch.getDescriptorFor(containerContext);
            id = this.getComponentIdInternal(desc);
        }
        catch (InvocationException e10) {
            throw new NamingException("invocation exception " + e10);
        }
        return id;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void bindObjects(JndiNameEnvironment env) throws NamingException {
        Context envContext = this.getEnvContext(env);
        String mangledIdName = this.getMangledIdName(env);
        try {
            envContext.createSubcontext(mangledIdName);
        }
        catch (NameAlreadyBoundException nabe) {
            Log.err.println(nabe);
        }
        Iterator itr = env.getEnvironmentProperties().iterator();
        while (itr.hasNext()) {
            EnvironmentProperty next = (EnvironmentProperty)itr.next();
            String logicalJndiName = this.descriptorToLogicalJndiName(next);
            String physicalJndiName = this.descriptorToPhysicalJndiName(env, next);
            java.lang.Object valueObject = next.getValueObject();
            System.out.println(localStrings.getLocalString("naming.bind", "Binding name:{0}", new java.lang.Object[]{logicalJndiName}));
            this.initialContext.rebind(physicalJndiName, valueObject);
        }
        Iterator itr2 = env.getJmsDestinationReferenceDescriptors().iterator();
        while (itr2.hasNext()) {
            JmsDestinationReferenceDescriptor next = (JmsDestinationReferenceDescriptor)itr2.next();
            String logicalJndiName = this.descriptorToLogicalJndiName(next);
            String physicalJndiName = this.descriptorToPhysicalJndiName(env, next);
            String destinationName = next.getJndiName();
            java.lang.Object destinationObject = null;
            try {
                destinationObject = this.initialContext.lookup(destinationName);
            }
            catch (NamingException ne) {
                throw new InvalidNameException(localStrings.getLocalString("naming.invalidDestination", "Invalid Destination:'{0}'", new java.lang.Object[]{destinationName}));
            }
            if (destinationObject instanceof Queue ? !next.getRefType().equals("javax.jms.Queue") : destinationObject instanceof Topic && !next.getRefType().equals("javax.jms.Topic")) {
                throw new InvalidNameException(localStrings.getLocalString("naming.destinationRefTypeMismatch", "", new java.lang.Object[]{next.getName(), next.getRefType()}));
            }
            System.out.println(localStrings.getLocalString("naming.bind", "Binding name:{0}", new java.lang.Object[]{logicalJndiName}));
            this.initialContext.rebind(physicalJndiName, destinationObject);
        }
        Iterator itr3 = env.getEjbReferenceDescriptors().iterator();
        while (itr3.hasNext()) {
            EjbReferenceDescriptor next = (EjbReferenceDescriptor)itr3.next();
            String logicalJndiName = this.descriptorToLogicalJndiName(next);
            String physicalJndiName = this.descriptorToPhysicalJndiName(env, next);
            System.out.println(localStrings.getLocalString("naming.bind", "Binding name:{0}", new java.lang.Object[]{logicalJndiName}));
            String otherBeanJndi = next.getValue();
            if (otherBeanJndi == null || otherBeanJndi.equals("")) {
                throw new InvalidNameException("Real JNDI name cannot be empty for " + next.getName());
            }
            Reference obj = next.isLocal() ? new Reference("reference", new StringRefAddr("url", otherBeanJndi), LOCAL_HOME_FACTORY, null) : new Reference("reference", new StringRefAddr("url", otherBeanJndi), IIOPOBJECT_FACTORY, null);
            this.initialContext.rebind(physicalJndiName, (java.lang.Object)obj);
        }
        Iterator itr4 = env.getResourceReferenceDescriptors().iterator();
        while (itr4.hasNext()) {
            ResourceReferenceDescriptor next = (ResourceReferenceDescriptor)itr4.next();
            String logicalResRef = next.getName();
            String logicalJndiName = this.descriptorToLogicalJndiName(next);
            String physicalJndiName = this.descriptorToPhysicalJndiName(env, next);
            System.out.println(localStrings.getLocalString("naming.bind", "Binding name:{0}", new java.lang.Object[]{logicalJndiName}));
            String resJndi = next.getValue();
            if (resJndi == null || resJndi.equals("")) {
                throw new InvalidNameException("Real JNDI name cannot be empty for " + logicalResRef);
            }
            java.lang.Object obj = null;
            if (next.isMailResource()) {
                obj = next.getMailConfiguration();
                String mailSessionInfoName = this.getEnvMailObjContextName(env) + CONTEXT_SEPARATOR + logicalResRef;
                this.initialContext.rebind(mailSessionInfoName, obj);
                obj = new Reference(obj.getClass().toString(), new StringRefAddr("url", mailSessionInfoName), MAIL_COMPONENT_FACTORY, null);
            } else {
                if (next.isURLResource()) {
                    String url = next.getJndiName();
                    try {
                        obj = new URL(url);
                    }
                    catch (MalformedURLException e10) {
                        throw new InvalidNameException(localStrings.getLocalString("naming.malformedURL", "Malformed URL:'{0}'", new java.lang.Object[]{url}));
                    }
                }
                if (next.isJMSConnectionFactory()) {
                    int componentType = this.getComponentType(env);
                    JmsWrapperFactory jmsWrapperFactory = null;
                    switch (componentType) {
                        case 1: {
                            jmsWrapperFactory = JmsWrapperFactory.getFactoryForEjb();
                            break;
                        }
                        case 2: {
                            jmsWrapperFactory = JmsWrapperFactory.getFactoryForWeb();
                            break;
                        }
                        case 3: {
                            jmsWrapperFactory = JmsWrapperFactory.getFactoryForAppClient();
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Invalid component type = " + componentType);
                        }
                    }
                    ConnectionFactoryWrapperStandalone wrapper = null;
                    ConnectionFactory factory = null;
                    try {
                        wrapper = (ConnectionFactoryWrapperStandalone)this.initialContext.lookup(resJndi);
                        factory = wrapper.getDelegate();
                    }
                    catch (NamingException ne) {
                        throw new InvalidNameException(localStrings.getLocalString("naming.invalidConnection", "Connection Factory Not Found:'{0}'", new java.lang.Object[]{resJndi}));
                    }
                    String xaCnxFactoryName = JmsUtil.getXAConnectionFactoryName(resJndi);
                    if (factory instanceof QueueConnectionFactory) {
                        if (!next.getType().equals("javax.jms.QueueConnectionFactory")) throw new InvalidNameException(localStrings.getLocalString("naming.jmsConnectionFactoryRefTypeMismatch", "", new java.lang.Object[]{logicalResRef, next.getType()}));
                        obj = jmsWrapperFactory.createQueueConnectionFactoryWrapper(xaCnxFactoryName, next);
                    } else {
                        if (!next.getType().equals("javax.jms.TopicConnectionFactory")) throw new InvalidNameException(localStrings.getLocalString("naming.jmsConnectionFactoryRefTypeMismatch", "", new java.lang.Object[]{logicalResRef, next.getType()}));
                        obj = jmsWrapperFactory.createTopicConnectionFactoryWrapper(xaCnxFactoryName, next);
                    }
                } else {
                    try {
                        obj = this.initialContext.lookup(resJndi);
                    }
                    catch (NamingException ne) {
                        String msg = localStrings.getLocalString("naming.unresolved.warning", "", new java.lang.Object[]{logicalJndiName, resJndi});
                        System.out.println(msg);
                    }
                    obj = new Reference(next.getType(), new StringRefAddr("url", resJndi), SERIALOBJECT_FACTORY, null);
                }
            }
            this.initialContext.rebind(physicalJndiName, obj);
        }
    }

    public void unbindObjects(JndiNameEnvironment env) throws NamingException {
        Iterator itr = env.getEnvironmentProperties().iterator();
        while (itr.hasNext()) {
            EnvironmentProperty next = (EnvironmentProperty)itr.next();
            String logicalJndiName = this.descriptorToLogicalJndiName(next);
            String physicalJndiName = this.descriptorToPhysicalJndiName(env, next);
            System.out.println(localStrings.getLocalString("naming.unbind", "Unbinding:{0}", new java.lang.Object[]{logicalJndiName}));
            this.initialContext.unbind(physicalJndiName);
        }
        Iterator itr2 = env.getJmsDestinationReferenceDescriptors().iterator();
        while (itr2.hasNext()) {
            JmsDestinationReferenceDescriptor next = (JmsDestinationReferenceDescriptor)itr2.next();
            String logicalJndiName = this.descriptorToLogicalJndiName(next);
            String physicalJndiName = this.descriptorToPhysicalJndiName(env, next);
            System.out.println(localStrings.getLocalString("naming.unbind", "Unbinding:{0}", new java.lang.Object[]{logicalJndiName}));
            this.initialContext.unbind(physicalJndiName);
        }
        Iterator itr3 = env.getEjbReferenceDescriptors().iterator();
        while (itr3.hasNext()) {
            EjbReferenceDescriptor next = (EjbReferenceDescriptor)itr3.next();
            String logicalJndiName = this.descriptorToLogicalJndiName(next);
            String physicalJndiName = this.descriptorToPhysicalJndiName(env, next);
            System.out.println(localStrings.getLocalString("naming.unbind", "Unbinding:{0}", new java.lang.Object[]{logicalJndiName}));
            this.initialContext.unbind(physicalJndiName);
        }
        Iterator itr4 = env.getResourceReferenceDescriptors().iterator();
        while (itr4.hasNext()) {
            ResourceReferenceDescriptor next = (ResourceReferenceDescriptor)itr4.next();
            String logicalJndiName = this.descriptorToLogicalJndiName(next);
            String physicalJndiName = this.descriptorToPhysicalJndiName(env, next);
            System.out.println(localStrings.getLocalString("naming.unbind", "Unbinding:{0}", new java.lang.Object[]{logicalJndiName}));
            this.initialContext.unbind(physicalJndiName);
            if (!next.isMailResource()) continue;
            String mailSessionInfoName = this.getEnvMailObjContextName(env) + CONTEXT_SEPARATOR + next.getName();
            this.initialContext.unbind(mailSessionInfoName);
        }
        Context envContext = this.getEnvContext(env);
        envContext.destroySubcontext(this.getMangledIdName(env));
    }

    private String descriptorToLogicalJndiName(Descriptor descriptor) {
        return JAVA_COMP_STRING + descriptor.getName();
    }

    private String descriptorToPhysicalJndiName(JndiNameEnvironment env, Descriptor descriptor) {
        return this.getComponentIdInternal(env) + CONTEXT_SEPARATOR + "env" + CONTEXT_SEPARATOR + descriptor.getName();
    }

    private String getEnvMailObjContextName(JndiNameEnvironment env) {
        return this.getComponentIdInternal(env) + CONTEXT_SEPARATOR + "mailsessions";
    }

    private int getComponentType(JndiNameEnvironment env) {
        int componentType = 0;
        if (env instanceof EjbDescriptor) {
            componentType = 1;
        } else if (env instanceof WebBundleDescriptor) {
            componentType = 2;
        } else if (env instanceof ApplicationClientDescriptor) {
            componentType = 3;
        } else {
            throw new IllegalArgumentException("Unknown component type");
        }
        return componentType;
    }

    private String getComponentIdInternal(JndiNameEnvironment env) {
        String id = this.getMangledIdName(env);
        String physicalJndiName = "none";
        int componentType = this.getComponentType(env);
        switch (componentType) {
            case 1: {
                physicalJndiName = "environments/ejbs/" + id;
                break;
            }
            case 2: {
                physicalJndiName = "environments/web/" + id;
                break;
            }
            case 3: {
                physicalJndiName = "environments/appclients/" + id;
            }
        }
        return physicalJndiName;
    }

    private String getMangledIdName(JndiNameEnvironment env) {
        String id = null;
        int componentType = this.getComponentType(env);
        switch (componentType) {
            case 1: {
                EjbDescriptor ejbEnv = (EjbDescriptor)env;
                String flattedJndiName = ejbEnv.getJndiName().replace('/', '.');
                EjbBundleDescriptor ejbBundle = ejbEnv.getEjbBundleDescriptor();
                Archivist archivist = ejbBundle.getArchivist();
                id = ejbEnv.getApplication().getName() + ID_SEPARATOR + archivist.getArchiveUri() + ID_SEPARATOR + ejbEnv.getName() + ID_SEPARATOR + flattedJndiName;
                break;
            }
            case 2: {
                WebBundleDescriptor webEnv = (WebBundleDescriptor)env;
                id = webEnv.getApplication().getName() + ID_SEPARATOR + webEnv.getContextRoot();
                break;
            }
            case 3: {
                ApplicationClientDescriptor appEnv = (ApplicationClientDescriptor)env;
                id = "client_" + appEnv.getName() + ID_SEPARATOR + appEnv.getMainClassName();
            }
        }
        return id;
    }

    private Context getEnvContext(JndiNameEnvironment env) throws NamingException {
        Context context;
        int componentType = this.getComponentType(env);
        switch (componentType) {
            case 1: {
                context = this.ejbEnvContext;
                break;
            }
            case 2: {
                context = this.webEnvContext;
                break;
            }
            case 3: {
                context = this.appClientEnvContext;
                break;
            }
            default: {
                throw new NamingException("Unknown component type");
            }
        }
        return context;
    }

    private boolean isCOSNamingObj(java.lang.Object obj) {
        return obj instanceof Remote || obj instanceof Object;
    }

    public static void main(String[] args) {
        try {
            String name = "";
            if (args.length > 0) {
                name = args[0];
            }
            InitialContext ic = new InitialContext();
            NamingEnumeration<NameClassPair> e10 = ic.list(name);
            while (e10.hasMoreElements()) {
                NameClassPair ncp = (NameClassPair)e10.nextElement();
                System.out.println(ncp.getName() + ": " + ncp.getClassName());
            }
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

