/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jms;

import com.sun.enterprise.ServerConfiguration;
import com.sun.enterprise.jms.ConnectionFactoryWrapperStandalone;
import com.sun.enterprise.jms.JmsUtil;
import com.sun.enterprise.repository.J2EEResource;
import com.sun.enterprise.repository.J2EEResourceCollection;
import com.sun.enterprise.repository.J2EEResourceFactory;
import com.sun.enterprise.repository.JmsCnxFactoryResource;
import com.sun.enterprise.repository.JmsDestinationResource;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.jms.spi.JMSAdmin;
import com.sun.jms.spi.JMSAdminFactory;
import com.sun.jms.spi.xa.JMSXAConnectionFactory;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class JmsConfig {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$jms$JmsConfig == null ? (class$com$sun$enterprise$jms$JmsConfig = JmsConfig.class$("com.sun.enterprise.jms.JmsConfig")) : class$com$sun$enterprise$jms$JmsConfig);
    private static final boolean debug = true;
    public static final int PERSIST_CHANGES_ONLY = 0;
    public static final int UPDATE_NAMESPACE_ONLY = 1;
    public static final int ALL = 2;
    private static final String CREATE_QUEUE = "-createQueue";
    private static final String CREATE_TOPIC = "-createTopic";
    private static final String DELETE_DESTINATION = "-deleteDestination";
    private static final String DELETE_ALL_DESTINATIONS = "-deleteAllDestinations";
    private static final String CREATE_QUEUE_CF = "-createQueueConnectionFactory";
    private static final String CREATE_TOPIC_CF = "-createTopicConnectionFactory";
    private static final String DELETE_CF = "-deleteConnectionFactory";
    private static final String LIST_DESTINATIONS = "-listDestinations";
    private static final String LIST_CONNECTION_FACTORIES = "-listConnectionFactories";
    private static final Properties EMPTY_PROPS = new Properties();
    private JMSAdmin jmsAdmin_;
    private boolean updateNamespace_;
    private Context namingContext_;
    private String adminHost_ = "localhost";
    private boolean persistChanges_;
    private J2EEResourceFactory resourceFactory_;
    private J2EEResourceCollection resources_;
    static /* synthetic */ Class class$com$sun$enterprise$jms$JmsConfig;

    public JmsConfig(int mode) throws Exception {
        boolean bl2 = this.updateNamespace_ = mode != 0;
        if (this.updateNamespace_) {
            this.namingContext_ = new InitialContext();
            this.getJmsAdmin();
        }
        boolean bl3 = this.persistChanges_ = mode != 1;
        if (this.persistChanges_) {
            this.resourceFactory_ = ServerConfiguration.getJ2EEResourceFactory();
            this.resources_ = this.resourceFactory_.loadDefaultResourceCollection();
        }
    }

    public void createDestination(String destinationName, boolean isQueue) throws Exception {
        if (this.updateNamespace_) {
            Destination destination = null;
            int type = JmsConfig.getStyleType(isQueue);
            try {
                destination = this.getJmsAdmin().createProviderDestination(destinationName, type, EMPTY_PROPS);
            }
            catch (InvalidDestinationException ide) {
                destination = this.handleInvalidDestination(ide, isQueue, destinationName);
            }
            this.namingContext_.rebind(destinationName, (Object)destination);
        }
        if (this.persistChanges_) {
            JmsDestinationResource dest = (JmsDestinationResource)this.resourceFactory_.createResource(1, destinationName);
            dest.setIsQueue(isQueue);
            this.resources_.addResource(dest);
            this.updatePersistentConfig();
        }
    }

    public void createConnectionFactory(String name, boolean isQueue) throws Exception {
        this.createConnectionFactory(name, isQueue, EMPTY_PROPS);
    }

    public void createConnectionFactory(String name, boolean isQueue, Map properties) throws Exception {
        if (this.updateNamespace_) {
            int type = JmsConfig.getStyleType(isQueue);
            ConnectionFactory factory = this.getJmsAdmin().createConnectionFactory(type, properties);
            ConnectionFactoryWrapperStandalone wrapper = new ConnectionFactoryWrapperStandalone(name, factory);
            this.namingContext_.rebind(name, (Object)wrapper);
            String xaName = JmsUtil.getXAConnectionFactoryName(name);
            this.createXAConnectionFactory(xaName, isQueue, properties);
        }
        if (this.persistChanges_) {
            JmsCnxFactoryResource cfr = (JmsCnxFactoryResource)this.resourceFactory_.createResource(2, name);
            cfr.setIsQueue(isQueue);
            this.resources_.addResource(cfr);
            this.updatePersistentConfig();
        }
    }

    public void createXAConnectionFactory(String name, boolean isQueue) throws Exception {
        this.createXAConnectionFactory(name, isQueue, EMPTY_PROPS);
    }

    public void createXAConnectionFactory(String name, boolean isQueue, Map properties) throws Exception {
        if (this.updateNamespace_) {
            int type = JmsConfig.getStyleType(isQueue);
            JMSXAConnectionFactory factory = (JMSXAConnectionFactory)this.getJmsAdmin().createXAConnectionFactory(type, properties);
            this.namingContext_.rebind(name, (Object)factory);
        }
    }

    public void deleteConnectionFactory(String name) throws Exception {
        Exception exception;
        block11: {
            block10: {
                exception = null;
                if (this.updateNamespace_) {
                    try {
                        this.namingContext_.unbind(name);
                    }
                    catch (NamingException ne) {
                        ne.printStackTrace();
                        exception = ne;
                    }
                    try {
                        String xaName = JmsUtil.getXAConnectionFactoryName(name);
                        this.deleteXAConnectionFactory(xaName);
                    }
                    catch (NamingException ne) {
                        ne.printStackTrace();
                        if (exception != null) break block10;
                        exception = ne;
                    }
                }
            }
            if (this.persistChanges_) {
                try {
                    J2EEResource resource = this.resources_.getResourceByName(2, name);
                    if (resource != null) {
                        this.resources_.removeResource(resource);
                    }
                    this.updatePersistentConfig();
                }
                catch (Exception e10) {
                    e10.printStackTrace();
                    if (exception != null) break block11;
                    exception = e10;
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public void deleteXAConnectionFactory(String name) throws Exception {
        if (this.updateNamespace_) {
            this.namingContext_.unbind(name);
        }
    }

    public void deleteDestination(String destinationName) throws Exception {
        Exception exception;
        block11: {
            block10: {
                exception = null;
                if (this.updateNamespace_) {
                    try {
                        this.getJmsAdmin().deleteProviderDestination(destinationName);
                    }
                    catch (JMSException jmse) {
                        jmse.printStackTrace();
                        exception = jmse;
                    }
                    try {
                        this.namingContext_.unbind(destinationName);
                    }
                    catch (NamingException ne) {
                        ne.printStackTrace();
                        if (exception != null) break block10;
                        exception = ne;
                    }
                }
            }
            if (this.persistChanges_) {
                try {
                    J2EEResource resource = this.resources_.getResourceByName(1, destinationName);
                    if (resource != null) {
                        this.resources_.removeResource(resource);
                    }
                    this.updatePersistentConfig();
                }
                catch (Exception e10) {
                    e10.printStackTrace();
                    if (exception != null) break block11;
                    exception = e10;
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public void deleteAllDestinations() throws Exception {
        if (this.updateNamespace_) {
            Set destinations = this.getDestinations(2);
            Iterator iter = destinations.iterator();
            while (iter.hasNext()) {
                JmsDestinationResource next = (JmsDestinationResource)iter.next();
                String name = next.getName();
                try {
                    this.deleteDestination(name);
                }
                catch (Exception e10) {
                    e10.printStackTrace();
                }
            }
        }
        if (this.persistChanges_) {
            try {
                this.resources_.removeAllResourcesByType(1);
                this.updatePersistentConfig();
            }
            catch (Exception e11) {
                e11.printStackTrace();
            }
        }
    }

    public void listDestinations() throws Exception {
        Set destinations = this.getDestinations(2);
        Iterator iter = destinations.iterator();
        while (iter.hasNext()) {
            System.out.println(iter.next());
        }
    }

    public void listConnectionFactories() throws Exception {
        Set cnxFactories = this.resources_.getResourcesByType(2);
        Iterator iter = cnxFactories.iterator();
        while (iter.hasNext()) {
            System.out.println(iter.next());
        }
    }

    private static int getStyleType(boolean isQueue) {
        return isQueue ? 0 : 1;
    }

    private JMSAdmin getJmsAdmin() throws Exception {
        if (this.jmsAdmin_ == null) {
            JMSAdminFactory jmsAdminFactory = JmsUtil.getJMSAdminFactory();
            this.jmsAdmin_ = jmsAdminFactory.getJMSAdmin(this.adminHost_);
        }
        return this.jmsAdmin_;
    }

    private Set getDestinations(int destinationType) throws Exception {
        HashSet<JmsDestinationResource> destinations = new HashSet<JmsDestinationResource>();
        Set allDestinations = this.resources_.getResourcesByType(1);
        Iterator iter = allDestinations.iterator();
        while (iter.hasNext()) {
            JmsDestinationResource next = (JmsDestinationResource)iter.next();
            if (destinationType == 0) {
                if (!next.getIsQueue()) continue;
                destinations.add(next);
                continue;
            }
            if (destinationType == 1) {
                if (next.getIsQueue()) continue;
                destinations.add(next);
                continue;
            }
            destinations.add(next);
        }
        return destinations;
    }

    private Set getJmsAdminDestinations(int destinationType) throws Exception {
        return this.getJmsAdmin().getDestinations(destinationType);
    }

    private void updatePersistentConfig() throws Exception {
        this.resourceFactory_.storeDefaultResourceCollection(this.resources_);
    }

    private Destination handleInvalidDestination(JMSException ide, boolean isQueue, String destName) throws Exception {
        Destination destination = null;
        String error = ide.getErrorCode();
        if (error.equals("destinationAlreadyExists")) {
            int type = JmsConfig.getStyleType(isQueue);
            Set destinations = this.getJmsAdminDestinations(type);
            destination = JmsUtil.getDestinationByName(destName, destinations);
            if (destination == null) {
                String realDestType;
                String requestedDestType;
                if (isQueue) {
                    requestedDestType = "Queue";
                    realDestType = "javax.jms.Topic";
                } else {
                    requestedDestType = "Topic";
                    realDestType = "javax.jms.Queue";
                }
                String errorMsg = localStrings.getLocalString("jms.destination.mismatch", "{0} {1} cannot be created because it already exists and is of type {2}.", new Object[]{requestedDestType, destName, realDestType});
                JMSException jmse = new JMSException(errorMsg);
                jmse.setLinkedException(ide);
                throw jmse;
            }
        } else {
            throw ide;
        }
        return destination;
    }

    public static void main(String[] args) {
        String currentArg = null;
        int i2 = 0;
        JmsConfig jmsConfig = null;
        try {
            if (args.length < 1) {
                JmsConfig.usage();
            } else {
                try {
                    jmsConfig = new JmsConfig(2);
                }
                catch (Exception e10) {
                    jmsConfig = new JmsConfig(0);
                }
                while (i2 < args.length) {
                    currentArg = args[i2];
                    ++i2;
                    if (currentArg.equals(CREATE_QUEUE)) {
                        jmsConfig.createDestination(args[i2], true);
                        ++i2;
                        continue;
                    }
                    if (currentArg.equals(CREATE_TOPIC)) {
                        jmsConfig.createDestination(args[i2], false);
                        ++i2;
                        continue;
                    }
                    if (currentArg.equals(DELETE_DESTINATION)) {
                        jmsConfig.deleteDestination(args[i2]);
                        ++i2;
                        continue;
                    }
                    if (currentArg.equals(DELETE_ALL_DESTINATIONS)) {
                        jmsConfig.deleteAllDestinations();
                        continue;
                    }
                    if (currentArg.equals(CREATE_QUEUE_CF)) {
                        jmsConfig.createConnectionFactory(args[i2], true);
                        ++i2;
                        continue;
                    }
                    if (currentArg.equals(CREATE_TOPIC_CF)) {
                        jmsConfig.createConnectionFactory(args[i2], false);
                        ++i2;
                        continue;
                    }
                    if (currentArg.equals(DELETE_CF)) {
                        jmsConfig.deleteConnectionFactory(args[i2]);
                        ++i2;
                        continue;
                    }
                    if (currentArg.equals(LIST_DESTINATIONS)) {
                        jmsConfig.listDestinations();
                        continue;
                    }
                    if (currentArg.equals(LIST_CONNECTION_FACTORIES)) {
                        jmsConfig.listConnectionFactories();
                        continue;
                    }
                    JmsConfig.usage();
                }
            }
        }
        catch (Exception e11) {
            e11.printStackTrace();
        }
        System.exit(0);
    }

    private static void usage() {
        System.out.println("Usage error");
        System.exit(1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

