/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jms;

import com.sun.enterprise.PoolManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.jms.ConnectionWrapper;
import com.sun.enterprise.jms.JmsWrapperFactory;
import com.sun.enterprise.jms.SessionWrapper;
import com.sun.enterprise.jms.SimpleAllocator;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.jms.spi.xa.JMSXAConnection;
import com.sun.jms.spi.xa.JMSXAQueueConnection;
import com.sun.jms.spi.xa.JMSXAQueueSession;
import com.sun.jms.spi.xa.JMSXATopicConnection;
import com.sun.jms.spi.xa.JMSXATopicSession;
import java.util.Enumeration;
import java.util.Vector;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;

public class ConnectionWrapperBase
implements ConnectionWrapper {
    private static final boolean debug = false;
    private boolean closed_ = false;
    private JMSXAConnection delegateXA_;
    private JmsWrapperFactory wrapperFactory_;
    private SimpleAllocator allocator_;
    private Vector sessionWrappers_;
    private boolean pointToPoint_;

    public ConnectionWrapperBase(JMSXAConnection delegate, JmsWrapperFactory wrapperFactory) {
        this.pointToPoint_ = delegate instanceof JMSXAQueueConnection;
        this.delegateXA_ = delegate;
        this.wrapperFactory_ = wrapperFactory;
        this.sessionWrappers_ = new Vector();
        this.allocator_ = new SimpleAllocator(this.pointToPoint_);
    }

    public String getClientID() throws JMSException {
        return this.getDelegate().getClientID();
    }

    public void setClientID(String clientID) throws JMSException {
        this.getDelegate().setClientID(clientID);
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        return this.getDelegate().getMetaData();
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        return this.getDelegate().getExceptionListener();
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        this.getDelegate().setExceptionListener(listener);
    }

    public void start() throws JMSException {
        this.getDelegate().start();
    }

    public void stop() throws JMSException {
        this.getDelegate().stop();
    }

    public void close() throws JMSException {
        ConnectionWrapperBase connectionWrapperBase = this;
        synchronized (connectionWrapperBase) {
            if (this.closed_) {
                return;
            }
            this.closed_ = true;
        }
        Vector sessionWrappersClone = (Vector)this.sessionWrappers_.clone();
        Enumeration e10 = sessionWrappersClone.elements();
        while (e10.hasMoreElements()) {
            SessionWrapper sessionWrapper = (SessionWrapper)e10.nextElement();
            try {
                sessionWrapper.close();
            }
            catch (JMSException ex2) {
                Log.err.println(ex2);
            }
        }
        this.getDelegateXA().close();
    }

    public void sessionClosed(SessionWrapper sessionWrapper) {
        this.sessionWrappers_.remove(sessionWrapper);
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.getQueueDelegate().createConnectionConsumer(queue, messageSelector, sessionPool, maxMessages);
    }

    public QueueSession createQueueSession(boolean transacted, int transactionMode) throws JMSException {
        JMSXAQueueSession queueSession = this.getQueueDelegateXA().createXAQueueSession(transacted, transactionMode);
        SessionWrapper sessionWrapper = (SessionWrapper)this.wrapperFactory_.createQueueSessionWrapper(queueSession, this);
        this.sessionWrappers_.add(sessionWrapper);
        return sessionWrapper;
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.getTopicDelegate().createConnectionConsumer(topic, messageSelector, sessionPool, maxMessages);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.getTopicDelegate().createDurableConnectionConsumer(topic, subscriptionName, messageSelector, sessionPool, maxMessages);
    }

    public TopicSession createTopicSession(boolean transacted, int transactionMode) throws JMSException {
        JMSXATopicSession topicSession = this.getTopicDelegateXA().createXATopicSession(transacted, transactionMode);
        SessionWrapper sessionWrapper = (SessionWrapper)this.wrapperFactory_.createTopicSessionWrapper(topicSession, this);
        this.sessionWrappers_.add(sessionWrapper);
        return sessionWrapper;
    }

    protected ResourceHandle createResourceHandle(SessionWrapper sessionWrapper) throws JMSException {
        ResourceHandle resourceHandle;
        try {
            resourceHandle = this.allocator_.createResource(sessionWrapper);
        }
        catch (Exception e10) {
            Log.err.println(e10);
            JMSException jmse = new JMSException(e10.getMessage());
            jmse.setLinkedException(e10);
            throw jmse;
        }
        return resourceHandle;
    }

    protected void registerResourceHandle(SessionWrapper sessionWrapper, ResourceHandle resourceHandle) throws JMSException {
        try {
            Switch theSwitch = Switch.getSwitch();
            PoolManager poolMgr = theSwitch.getPoolManager();
            poolMgr.registerResource(resourceHandle);
            sessionWrapper.setResourceHandle(resourceHandle);
        }
        catch (Exception e10) {
            Log.err.println(e10);
            JMSException jmse = new JMSException(e10.getMessage());
            jmse.setLinkedException(e10);
            throw jmse;
        }
    }

    protected void setupResourceHandle(SessionWrapper sessionWrapper) throws JMSException {
        ResourceHandle resourceHandle = this.createResourceHandle(sessionWrapper);
        this.registerResourceHandle(sessionWrapper, resourceHandle);
    }

    public Connection getDelegate() {
        JMSXAConnection delegateXA = this.getDelegateXA();
        return this.pointToPoint_ ? this.getQueueDelegate() : this.getTopicDelegate();
    }

    public QueueConnection getQueueDelegate() {
        return this.getQueueDelegateXA().getQueueConnection();
    }

    public TopicConnection getTopicDelegate() {
        return this.getTopicDelegateXA().getTopicConnection();
    }

    public JMSXAQueueConnection getQueueDelegateXA() {
        return (JMSXAQueueConnection)this.getDelegateXA();
    }

    public JMSXATopicConnection getTopicDelegateXA() {
        return (JMSXATopicConnection)this.getDelegateXA();
    }

    public JMSXAConnection getDelegateXA() {
        return this.delegateXA_;
    }
}

