/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop.security;

import com.sun.corba.ee.org.omg.CSI.CompleteEstablishContext;
import com.sun.corba.ee.org.omg.CSI.ContextError;
import com.sun.corba.ee.org.omg.CSI.EstablishContext;
import com.sun.corba.ee.org.omg.CSI.GSS_NT_ExportedNameHelper;
import com.sun.corba.ee.org.omg.CSI.IdentityToken;
import com.sun.corba.ee.org.omg.CSI.SASContextBody;
import com.sun.corba.ee.org.omg.CSI.SASContextBodyHelper;
import com.sun.corba.ee.org.omg.CSI.X501DistinguishedNameHelper;
import com.sun.corba.ee.org.omg.CSI.X509CertificateChainHelper;
import com.sun.enterprise.iiop.security.AnonCredential;
import com.sun.enterprise.iiop.security.Csiv2Manager;
import com.sun.enterprise.iiop.security.GSSUPName;
import com.sun.enterprise.iiop.security.GSSUPToken;
import com.sun.enterprise.iiop.security.Logger;
import com.sun.enterprise.iiop.security.SecurityContext;
import com.sun.enterprise.iiop.security.SecurityService;
import com.sun.enterprise.iiop.security.SvcContextUtils;
import com.sun.enterprise.security.auth.login.PasswordCredential;
import com.sun.enterprise.security.auth.login.X509CertificateCredential;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.ORBManager;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import javax.security.auth.Subject;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.ORB;
import org.omg.IOP.Codec;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;

public class SecServerRequestInterceptor
extends LocalObject
implements ServerRequestInterceptor {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$iiop$security$SecServerRequestInterceptor == null ? (class$com$sun$enterprise$iiop$security$SecServerRequestInterceptor = SecServerRequestInterceptor.class$("com.sun.enterprise.iiop.security.SecServerRequestInterceptor")) : class$com$sun$enterprise$iiop$security$SecServerRequestInterceptor);
    protected static final int SECURITY_ATTRIBUTE_SERVICE_ID = 15;
    private static final boolean NO_REPLACE = false;
    private String prname;
    private String name;
    private Codec codec;
    private ORB orb;
    SecurityService secsvc = null;
    static /* synthetic */ Class class$com$sun$enterprise$iiop$security$SecServerRequestInterceptor;
    static /* synthetic */ Class class$com$sun$enterprise$iiop$security$AnonCredential;
    static /* synthetic */ Class class$sun$security$x509$X500Name;
    static /* synthetic */ Class class$com$sun$enterprise$security$auth$login$X509CertificateCredential;
    static /* synthetic */ Class class$com$sun$enterprise$iiop$security$GSSUPName;
    static /* synthetic */ Class class$com$sun$enterprise$security$auth$login$PasswordCredential;

    public SecServerRequestInterceptor(String name, Codec codec) {
        this.name = name;
        this.codec = codec;
        this.prname = name + "::";
    }

    public String name() {
        return this.name;
    }

    private SASContextBody createContextError(int status) {
        Logger.fine("Creating ContextError message: minor code= " + status);
        byte[] error_token = new byte[]{};
        ContextError ce2 = new ContextError(0L, 1, status, error_token);
        SASContextBody sasctxtbody = new SASContextBody();
        sasctxtbody.error_msg(ce2);
        return sasctxtbody;
    }

    private SASContextBody createCompleteEstablishContext(int status) {
        Logger.fine("Creating CompleteEstablishContext message");
        byte[] final_context_token = new byte[]{};
        CompleteEstablishContext cec = new CompleteEstablishContext(0L, false, final_context_token);
        SASContextBody sasctxtbody = new SASContextBody();
        sasctxtbody.complete_msg(cec);
        return sasctxtbody;
    }

    private ServiceContext createSvcContext(SASContextBody sasctxtbody) {
        ServiceContext sc = null;
        Any a = this.orb.create_any();
        SASContextBodyHelper.insert(a, sasctxtbody);
        byte[] cdr_encoded_saselm = new byte[]{};
        try {
            cdr_encoded_saselm = this.codec.encode(a);
        }
        catch (Exception e10) {
            e10.printStackTrace();
        }
        sc = new ServiceContext();
        sc.context_id = 15;
        sc.context_data = cdr_encoded_saselm;
        return sc;
    }

    private void createIdCred(SecurityContext sc, IdentityToken idtok) throws Exception {
        switch (idtok.discriminator()) {
            case 0: {
                Logger.fine("Identity token type is Absent");
                sc.identcls = null;
                break;
            }
            case 1: {
                Logger.fine("Identity token type is Anonymous");
                Logger.fine("Adding AnonyCredential to subject's PublicCredentials");
                sc.subject.getPublicCredentials().add(new AnonCredential());
                sc.identcls = class$com$sun$enterprise$iiop$security$AnonCredential == null ? (class$com$sun$enterprise$iiop$security$AnonCredential = SecServerRequestInterceptor.class$("com.sun.enterprise.iiop.security.AnonCredential")) : class$com$sun$enterprise$iiop$security$AnonCredential;
                break;
            }
            case 4: {
                Logger.fine("Identity token type is X500 Distinguished Name");
                Any any = this.codec.decode(idtok.dn());
                byte[] derenc = X501DistinguishedNameHelper.extract(any);
                Logger.fine("Create an X500Name object from identity token");
                X500Name name = new X500Name(derenc);
                Logger.fine("Identity to be asserted is " + name.toString());
                Logger.fine("Adding X500Name to subject's PublicCredentials");
                sc.subject.getPublicCredentials().add(name);
                sc.identcls = class$sun$security$x509$X500Name == null ? (class$sun$security$x509$X500Name = SecServerRequestInterceptor.class$("sun.security.x509.X500Name")) : class$sun$security$x509$X500Name;
                break;
            }
            case 3: {
                Logger.fine("Identity token type is a X509 Certificate Chain");
                Any any = this.codec.decode(idtok.certificate_chain());
                byte[] derenc = X509CertificateChainHelper.extract(any);
                DerInputStream din = new DerInputStream(derenc);
                DerValue[] derval = din.getSequence(1);
                X509Certificate[] certchain = new X509CertImpl[derval.length];
                Logger.fine("Contents of X509 Certificate chain:");
                int i2 = 0;
                while (i2 < certchain.length) {
                    certchain[i2] = new X509CertImpl(derval[i2]);
                    Logger.fine("    " + certchain[i2].getSubjectDN().getName());
                    ++i2;
                }
                Logger.fine("Creating a X509CertificateCredential object from certchain");
                X509CertificateCredential cred = new X509CertificateCredential(certchain, "dummy", "certificate");
                Logger.fine("Adding X509CertificateCredential to subject's PublicCredentials");
                sc.subject.getPublicCredentials().add(certchain);
                sc.identcls = class$com$sun$enterprise$security$auth$login$X509CertificateCredential == null ? (class$com$sun$enterprise$security$auth$login$X509CertificateCredential = SecServerRequestInterceptor.class$("com.sun.enterprise.security.auth.login.X509CertificateCredential")) : class$com$sun$enterprise$security$auth$login$X509CertificateCredential;
                break;
            }
            case 2: {
                Logger.fine("Identity token type is GSS Exported Name");
                Any any = this.codec.decode(idtok.principal_name());
                byte[] expname = GSS_NT_ExportedNameHelper.extract(any);
                GSSUPName gssname = new GSSUPName(expname);
                sc.subject.getPublicCredentials().add(gssname);
                sc.identcls = class$com$sun$enterprise$iiop$security$GSSUPName == null ? (class$com$sun$enterprise$iiop$security$GSSUPName = SecServerRequestInterceptor.class$("com.sun.enterprise.iiop.security.GSSUPName")) : class$com$sun$enterprise$iiop$security$GSSUPName;
                Logger.fine("Adding GSSUPName credential to subject");
                break;
            }
            default: {
                Logger.severe("Unknown identity assertion type");
                throw new SecurityException(localStrings.getLocalString("secserverreqinterceptor.err_unknown_idassert_type", "Unknown identity assertion type."));
            }
        }
    }

    private void createAuthCred(SecurityContext sc, byte[] authtok) throws Exception {
        Logger.fine("Constructing a PasswordCredential from client authentication token");
        GSSUPToken tok = new GSSUPToken(this.orb, this.codec, authtok);
        final PasswordCredential pwdcred = tok.getPwdcred();
        final SecurityContext fsc = sc;
        Logger.fine("Password credential = " + pwdcred.toString());
        Logger.fine("Adding PasswordCredential to subject's PrivateCredentials");
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                fsc.subject.getPrivateCredentials().add(pwdcred);
                return null;
            }
        });
        sc = fsc;
        sc.authcls = class$com$sun$enterprise$security$auth$login$PasswordCredential == null ? (class$com$sun$enterprise$security$auth$login$PasswordCredential = SecServerRequestInterceptor.class$("com.sun.enterprise.security.auth.login.PasswordCredential")) : class$com$sun$enterprise$security$auth$login$PasswordCredential;
    }

    public void receive_request_service_contexts(ServerRequestInfo ri) throws ForwardRequest {
        SecurityContext seccontext = null;
        ServiceContext sc = null;
        int status = 0;
        boolean raise_no_perm = false;
        Logger.methodentry(this.prname + "receive_request_service_contexts");
        this.secsvc = Csiv2Manager.getSecurityService();
        this.orb = ORBManager.getORB();
        try {
            sc = ri.get_request_service_context(15);
        }
        catch (BAD_PARAM e10) {
            Logger.fine("No SAS context element found in service context list");
            this.secsvc.setSecurityContext(null);
            return;
        }
        Logger.fine("Received a non null SAS context element");
        Any SasAny = this.orb.create_any();
        try {
            SasAny = this.codec.decode(sc.context_data);
        }
        catch (Exception e11) {
            e11.printStackTrace();
            Logger.severe("CDR Decoding error for SAS context element.");
            throw new SecurityException(localStrings.getLocalString("secserverreqinterceptor.err_cdr_decode", "CDR Decoding error for SAS context element."));
        }
        Logger.fine("Successfully decoded CDR encoded SAS context element.");
        SASContextBody sasctxbody = SASContextBodyHelper.extract(SasAny);
        short sasdiscr = sasctxbody.discriminator();
        Logger.fine("SAS context element is a/an " + SvcContextUtils.getMsgname(sasdiscr) + " message");
        if (sasdiscr == 5) {
            sasctxbody = this.createContextError(4);
            sc = this.createSvcContext(sasctxbody);
            Logger.fine("Adding ContextError message to service context list");
            ri.add_reply_service_context(sc, false);
            this.secsvc.setSecurityContext(null);
            Logger.fine("SecurityContext set to null");
            throw new NO_PERMISSION();
        }
        if (sasdiscr != 0) {
            Logger.severe(this.prname + "Received Message not an EstablishContext message.");
            throw new SecurityException(localStrings.getLocalString("secserverreqinterceptor.err_not_ec_msg", "Received message not an EstablishContext message."));
        }
        EstablishContext ec2 = sasctxbody.establish_msg();
        seccontext = new SecurityContext();
        seccontext.subject = new Subject();
        try {
            if (ec2.client_authentication_token.length != 0) {
                Logger.fine("Message contains Client Authentication Token");
                this.createAuthCred(seccontext, ec2.client_authentication_token);
            }
            if (ec2.identity_token != null) {
                Logger.fine("Message contains an Identity Token");
                this.createIdCred(seccontext, ec2.identity_token);
            }
        }
        catch (Exception e12) {
            e12.printStackTrace();
            Logger.severe("Error while creating a JAAS subject credential.");
            throw new SecurityException(localStrings.getLocalString("secsercverreqinterceptor.err_cred_create", "Error while creating a JAAs subject credential."));
        }
        Logger.fine("Invoking setSecurityContext() to set security context");
        status = this.secsvc.setSecurityContext(seccontext);
        Logger.fine("setSecurityContext() returned status code " + status);
        if (status == 1) {
            Logger.fine("setSecurityContext() returned STATUS_FAILED");
            sasctxbody = this.createContextError(status);
            sc = this.createSvcContext(sasctxbody);
            Logger.fine("Adding ContextError message to service context list");
            ri.add_reply_service_context(sc, false);
            throw new NO_PERMISSION();
        }
        Logger.fine("setSecurityContext() returned SUCCESS");
        sasctxbody = this.createCompleteEstablishContext(status);
        sc = this.createSvcContext(sasctxbody);
        Logger.fine("Adding CompleteEstablisContext message to service context list");
        ri.add_reply_service_context(sc, false);
    }

    public void receive_request(ServerRequestInfo ri) throws ForwardRequest {
    }

    public void send_reply(ServerRequestInfo ri) {
    }

    public void send_exception(ServerRequestInfo ri) throws ForwardRequest {
    }

    public void send_other(ServerRequestInfo ri) throws ForwardRequest {
    }

    public void destroy() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

