/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.xml;

import com.sun.enterprise.deployment.ContainerTransaction;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbExternalDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.MethodPermission;
import com.sun.enterprise.deployment.RelationRoleDescriptor;
import com.sun.enterprise.deployment.RelationshipDescriptor;
import com.sun.enterprise.deployment.xml.ContentTransformationException;
import com.sun.enterprise.deployment.xml.DescriptorNodeUtils;
import com.sun.enterprise.deployment.xml.EjbNode;
import com.sun.enterprise.deployment.xml.MethodDescriptorNode;
import com.sun.enterprise.deployment.xml.ParseException;
import com.sun.enterprise.deployment.xml.XMLUtils;
import com.sun.enterprise.security.acl.Role;
import java.io.InputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.ejb.EJBException;
import org.apache.crimson.tree.ElementNode;
import org.apache.crimson.tree.XmlDocument;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class EjbBundleNode
extends ElementNode {
    public static String PUBLIC_DTD_ID_12 = "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN";
    public static String PUBLIC_DTD_ID = "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN";
    public static String SYSTEM_ID = "http://java.sun.com/dtd/ejb-jar_2_0.dtd";
    static /* synthetic */ Class class$com$sun$enterprise$deployment$xml$EjbBundleNode;

    public EjbBundleNode() {
        this.setTag("ejb-jar");
    }

    public void setDescriptor(EjbBundleDescriptor bundleDescriptor) {
        Document doc = this.getOwnerDocument();
        if (doc == null) {
            throw new IllegalArgumentException("Cannot set the descriptor unless this node has been added to a document");
        }
        XMLUtils factory = new XMLUtils(this.getOwnerDocument());
        DescriptorNodeUtils.appendDescriptorAttributes(factory, bundleDescriptor, this, DescriptorNodeUtils.EJB_STYLE);
        ElementNode ejbsNode = factory.getNode("enterprise-beans");
        this.appendChild(ejbsNode);
        Iterator itr = bundleDescriptor.getEjbs().iterator();
        while (itr.hasNext()) {
            EjbDescriptor nextEjbDescriptor = (EjbDescriptor)itr.next();
            EjbNode ejbNode = new EjbNode();
            ejbsNode.appendChild(ejbNode);
            ejbNode.setDescriptor(nextEjbDescriptor);
        }
        if (bundleDescriptor.hasRelationships()) {
            this.setRelationships(factory, bundleDescriptor);
        }
        if (bundleDescriptor.hasAssemblyInformation()) {
            Object e10;
            ElementNode assemblyDescriptorNode = factory.getNode("assembly-descriptor");
            this.appendChild(assemblyDescriptorNode);
            Iterator itr2 = bundleDescriptor.getRoles().iterator();
            while (itr2.hasNext()) {
                Role nextRole = (Role)itr2.next();
                ElementNode roleNode = factory.getNode("security-role");
                assemblyDescriptorNode.appendChild(roleNode);
                if (!nextRole.getDescription().equals("")) {
                    roleNode.appendChild(factory.getTextNode("description", nextRole.getDescription()));
                }
                roleNode.appendChild(factory.getTextNode("role-name", nextRole.getName()));
            }
            Iterator itr3 = bundleDescriptor.getEjbs().iterator();
            while (itr3.hasNext()) {
                EjbDescriptor ejbDescriptor = (EjbDescriptor)itr3.next();
                Map permissionedMethodsByPermission = ejbDescriptor.getPermissionedMethodsByPermission();
                ejbDescriptor.getExcludedMethodDescriptors();
                e10 = permissionedMethodsByPermission.keySet().iterator();
                while (e10.hasNext()) {
                    Set permissionedMethods;
                    MethodPermission permission = (MethodPermission)e10.next();
                    if (permission.isExcluded() || (permissionedMethods = (Set)permissionedMethodsByPermission.get(permission)).isEmpty()) continue;
                    ElementNode methodPermissionNode = factory.getNode("method-permission");
                    assemblyDescriptorNode.appendChild(methodPermissionNode);
                    if (permission.isRoleBased()) {
                        methodPermissionNode.appendChild(factory.getTextNode("role-name", permission.getRole().getName()));
                    } else {
                        methodPermissionNode.appendChild(factory.getNode("unchecked"));
                    }
                    this.addMethodsTags(methodPermissionNode, permissionedMethods, ejbDescriptor);
                }
            }
            Iterator ejbs = bundleDescriptor.getEjbs().iterator();
            while (ejbs.hasNext()) {
                EjbDescriptor ejbDescriptor = (EjbDescriptor)ejbs.next();
                if (ejbDescriptor.getMethodContainerTransactions().isEmpty()) continue;
                e10 = ejbDescriptor.getMethodContainerTransactions().keys();
                while (e10.hasMoreElements()) {
                    MethodDescriptor nextMethodDescriptor = (MethodDescriptor)e10.nextElement();
                    ContainerTransaction methodContainerTransaction = (ContainerTransaction)ejbDescriptor.getMethodContainerTransactions().get(nextMethodDescriptor);
                    ElementNode containerTransactionNode = factory.getNode("container-transaction");
                    assemblyDescriptorNode.appendChild(containerTransactionNode);
                    if (!methodContainerTransaction.getDescription().equals("")) {
                        containerTransactionNode.appendChild(factory.getTextNode("description", methodContainerTransaction.getDescription()));
                    }
                    MethodDescriptorNode methodDescriptorNode = new MethodDescriptorNode();
                    containerTransactionNode.appendChild(methodDescriptorNode);
                    methodDescriptorNode.setDescriptor(nextMethodDescriptor, ejbDescriptor);
                    containerTransactionNode.appendChild(factory.getTextNode("trans-attribute", methodContainerTransaction.getTransactionAttribute()));
                }
            }
            Iterator itr4 = bundleDescriptor.getEjbs().iterator();
            while (itr4.hasNext()) {
                EjbDescriptor ejbDescriptor = (EjbDescriptor)itr4.next();
                Map permissionedMethodsByPermission = ejbDescriptor.getPermissionedMethodsByPermission();
                Collection excludedMethodDescriptors = (Collection)permissionedMethodsByPermission.get(MethodPermission.getExcludedMethodPermission());
                if (excludedMethodDescriptors == null || excludedMethodDescriptors.isEmpty()) continue;
                ElementNode excludedMethodNode = factory.getNode("exclude-list");
                assemblyDescriptorNode.appendChild(excludedMethodNode);
                this.addMethodsTags(excludedMethodNode, excludedMethodDescriptors, ejbDescriptor);
            }
        }
        if (!"".equals(bundleDescriptor.getEjbClientJarUri())) {
            this.appendChild(factory.getTextNode("ejb-client-jar", bundleDescriptor.getEjbClientJarUri()));
        }
    }

    /*
     * WARNING - void declaration
     */
    public EjbBundleDescriptor getDescriptor() throws ContentTransformationException {
        ElementNode currentNode = this;
        try {
            void iae;
            Enumeration e10;
            EjbBundleDescriptor ejbBundleDescriptor = new EjbBundleDescriptor();
            Document doc = this.getOwnerDocument();
            if (doc == null) {
                throw new IllegalArgumentException("Cannot set the descriptor unless this node has been  added to a document");
            }
            DocumentType docType = doc.getDoctype();
            if (docType == null) {
                throw new RuntimeException("Invalid XML : No document type for " + doc);
            }
            String publicId = docType.getPublicId();
            if (publicId.equals(PUBLIC_DTD_ID)) {
                ejbBundleDescriptor.setEJBVersion("EJB 2.x");
            } else if (publicId.equals(PUBLIC_DTD_ID_12)) {
                ejbBundleDescriptor.setEJBVersion("EJB 1.x");
                System.out.println("Setting EJB version to EJB1.X...");
            } else {
                throw new RuntimeException("Invalid XML : Unknown document type : " + docType);
            }
            DescriptorNodeUtils.setDescriptorAttributes(this, ejbBundleDescriptor, DescriptorNodeUtils.EJB_STYLE);
            HashSet<EjbNode> ejbNodes = new HashSet<EjbNode>();
            Enumeration e11 = XMLUtils.getNodesUnder((Node)this, EjbNode.getTags());
            while (e11.hasMoreElements()) {
                EjbNode nextEjbNode = (EjbNode)e11.nextElement();
                ejbNodes.add(nextEjbNode);
                EjbDescriptor ejbDescriptor = nextEjbNode.getDescriptor();
                ejbBundleDescriptor.addEjb(ejbDescriptor);
            }
            if (XMLUtils.hasNodesUnder(this, "ejb-client-jar")) {
                ejbBundleDescriptor.setEjbClientJarUri(XMLUtils.getTextFor(this, "ejb-client-jar"));
            }
            this.getRelationships(ejbBundleDescriptor);
            if (XMLUtils.hasNodesUnder(this, "assembly-descriptor")) {
                ElementNode assemblyDescriptorNode = XMLUtils.getFirstNodeUnder(this, "assembly-descriptor");
                Enumeration e12 = XMLUtils.getNodesUnder((Node)assemblyDescriptorNode, "security-role");
                while (e12.hasMoreElements()) {
                    ElementNode nextRoleNode = (ElementNode)e12.nextElement();
                    currentNode = nextRoleNode;
                    String optionalDescription = "";
                    if (XMLUtils.hasNodesUnder(nextRoleNode, "description")) {
                        optionalDescription = XMLUtils.getTextFor(nextRoleNode, "description");
                    }
                    Role role = new Role(XMLUtils.getTextFor(nextRoleNode, "role-name"));
                    role.setDescription(optionalDescription);
                    ejbBundleDescriptor.addRole(role);
                }
                if (!ejbBundleDescriptor.areResourceReferencesValid()) {
                    throw new IllegalArgumentException("Incorrectly resolved role references");
                }
                if (XMLUtils.hasNodesUnder(assemblyDescriptorNode, "exclude-list")) {
                    ElementNode excludeMethodsListNode = XMLUtils.getFirstNodeUnder(assemblyDescriptorNode, "exclude-list");
                    Enumeration ee2 = XMLUtils.getNodesUnder((Node)excludeMethodsListNode, "method");
                    while (ee2.hasMoreElements()) {
                        MethodDescriptorNode methodDescriptorNode = (MethodDescriptorNode)ee2.nextElement();
                        String ejbName = methodDescriptorNode.getEjbName();
                        EjbDescriptor ejbDescriptor = ejbBundleDescriptor.getEjbByName(ejbName);
                        MethodDescriptor md = methodDescriptorNode.getDescriptor();
                        ejbDescriptor.addPermissionedMethod(MethodPermission.getExcludedMethodPermission(), md);
                    }
                }
                Enumeration e13 = XMLUtils.getNodesUnder((Node)assemblyDescriptorNode, "method-permission");
                while (e13.hasMoreElements()) {
                    MethodPermission mp;
                    ElementNode methodPermissionNode = (ElementNode)e13.nextElement();
                    currentNode = methodPermissionNode;
                    if (XMLUtils.hasNodesUnder(methodPermissionNode, "role-name")) {
                        Role role = new Role(XMLUtils.getTextFor(methodPermissionNode, "role-name"));
                        mp = new MethodPermission(role);
                    } else {
                        mp = MethodPermission.getUncheckedMethodPermission();
                    }
                    Enumeration ee3 = XMLUtils.getNodesUnder((Node)methodPermissionNode, "method");
                    while (ee3.hasMoreElements()) {
                        MethodDescriptorNode methodDescriptorNode = (MethodDescriptorNode)ee3.nextElement();
                        String ejbName = methodDescriptorNode.getEjbName();
                        EjbDescriptor ejbDescriptor = ejbBundleDescriptor.getEjbByName(ejbName);
                        MethodDescriptor md = methodDescriptorNode.getDescriptor();
                        ejbDescriptor.addPermissionedMethod(mp, md);
                    }
                }
                Hashtable methodContainerTransactions = new Hashtable();
                e10 = XMLUtils.getNodesUnder((Node)assemblyDescriptorNode, "container-transaction");
                while (e10.hasMoreElements()) {
                    ElementNode containerTransactionNode = (ElementNode)e10.nextElement();
                    currentNode = containerTransactionNode;
                    String optionalDescription = "";
                    if (XMLUtils.hasNodesUnder(containerTransactionNode, "description")) {
                        optionalDescription = XMLUtils.getTextFor(containerTransactionNode, "description");
                    }
                    Enumeration mdns = XMLUtils.getNodesUnder((Node)containerTransactionNode, "method");
                    while (mdns.hasMoreElements()) {
                        MethodDescriptorNode methodDescriptorNode = (MethodDescriptorNode)mdns.nextElement();
                        String methodNameSymbol = XMLUtils.getTextFor(methodDescriptorNode, "method-name");
                        String ejbName = methodDescriptorNode.getEjbName();
                        EjbDescriptor ejbDescriptor = ejbBundleDescriptor.getEjbByName(ejbName);
                        MethodDescriptor md = methodDescriptorNode.getDescriptor();
                        ContainerTransaction containerTransaction = new ContainerTransaction(XMLUtils.getTextFor(containerTransactionNode, "trans-attribute"), optionalDescription);
                        ejbDescriptor.getMethodContainerTransactions().put(md, containerTransaction);
                    }
                }
            }
            Iterator itr = ejbNodes.iterator();
            while (itr.hasNext()) {
                EjbNode nextEjbNode = (EjbNode)itr.next();
                String nameOfReferingBean = XMLUtils.getTextFor(nextEjbNode, "ejb-name");
                EjbDescriptor referingBean = ejbBundleDescriptor.getEjbByName(nameOfReferingBean);
                e10 = XMLUtils.getNodesUnder((Node)nextEjbNode, "ejb-ref");
                while (e10.hasMoreElements()) {
                    ElementNode ejbReferenceNode = (ElementNode)e10.nextElement();
                    currentNode = ejbReferenceNode;
                    this.addEJBReference(ejbBundleDescriptor, referingBean, ejbReferenceNode, false);
                }
                Enumeration e14 = XMLUtils.getNodesUnder((Node)nextEjbNode, "ejb-local-ref");
                while (e14.hasMoreElements()) {
                    ElementNode ejbReferenceNode = (ElementNode)e14.nextElement();
                    currentNode = ejbReferenceNode;
                    this.addEJBReference(ejbBundleDescriptor, referingBean, ejbReferenceNode, true);
                }
            }
            return iae;
        }
        catch (IllegalArgumentException iae) {
            iae.printStackTrace();
            throw new ContentTransformationException(iae.getMessage(), currentNode.toString());
        }
    }

    private void addMethodTag(ElementNode elementNode, MethodDescriptor md, EjbDescriptor ejbDescriptor) {
        MethodDescriptorNode methodDescriptorNode = new MethodDescriptorNode();
        elementNode.appendChild(methodDescriptorNode);
        methodDescriptorNode.setDescriptor(md, ejbDescriptor);
    }

    private void addMethodsTags(ElementNode elementNode, Collection mds, EjbDescriptor ejbDescriptor) {
        Iterator iterator = mds.iterator();
        while (iterator.hasNext()) {
            this.addMethodTag(elementNode, (MethodDescriptor)iterator.next(), ejbDescriptor);
        }
    }

    private void addEJBReference(EjbBundleDescriptor ejbBundleDescriptor, EjbDescriptor referingBean, ElementNode ejbReferenceNode, boolean isLocal) {
        String interfaceClassName;
        String homeClassName;
        String description = "";
        if (XMLUtils.getFirstNodeUnder(ejbReferenceNode, "description") != null) {
            description = XMLUtils.getTextFor(ejbReferenceNode, "description");
        }
        String ejbReferenceName = XMLUtils.getTextFor(ejbReferenceNode, "ejb-ref-name");
        if (isLocal) {
            homeClassName = XMLUtils.getTextFor(ejbReferenceNode, "local-home");
            interfaceClassName = XMLUtils.getTextFor(ejbReferenceNode, "local");
        } else {
            homeClassName = XMLUtils.getTextFor(ejbReferenceNode, "home");
            interfaceClassName = XMLUtils.getTextFor(ejbReferenceNode, "remote");
        }
        String referenceType = XMLUtils.getTextFor(ejbReferenceNode, "ejb-ref-type");
        if (XMLUtils.hasNodesUnder(ejbReferenceNode, "ejb-link")) {
            String ejbRefereeName = XMLUtils.getTextFor(ejbReferenceNode, "ejb-link");
            if (!ejbBundleDescriptor.hasEjbByName(ejbRefereeName)) {
                EjbExternalDescriptor ejbExternalDescriptor = new EjbExternalDescriptor();
                ejbExternalDescriptor.setName(ejbRefereeName);
                if (isLocal) {
                    ejbExternalDescriptor.setLocalHomeClassName(homeClassName);
                    ejbExternalDescriptor.setLocalClassName(interfaceClassName);
                } else {
                    ejbExternalDescriptor.setHomeClassName(homeClassName);
                    ejbExternalDescriptor.setRemoteClassName(interfaceClassName);
                }
                ejbExternalDescriptor.setType(referenceType);
                ejbExternalDescriptor.setLinkName(ejbRefereeName);
                EjbReferenceDescriptor ejbRef = new EjbReferenceDescriptor(ejbReferenceName, description, ejbExternalDescriptor, isLocal);
                referingBean.addEjbReferenceDescriptor(ejbRef);
            } else {
                EjbDescriptor refereeBean = ejbBundleDescriptor.getEjbByName(ejbRefereeName);
                if (isLocal) {
                    DescriptorNodeUtils.checkEjbLocalReference(refereeBean, referenceType, homeClassName, interfaceClassName, ejbRefereeName);
                } else {
                    DescriptorNodeUtils.checkEjbReference(refereeBean, referenceType, homeClassName, interfaceClassName, ejbRefereeName);
                }
                EjbReferenceDescriptor ejbRef = new EjbReferenceDescriptor(ejbReferenceName, description, refereeBean, isLocal);
                referingBean.addEjbReferenceDescriptor(ejbRef);
            }
        } else {
            String uniqueName = Descriptor.createUniqueNameAmongstNamedDescriptors("ExternalRef", referingBean.getEjbReferenceDescriptors());
            EjbExternalDescriptor ejbExternalDescriptor = new EjbExternalDescriptor();
            ejbExternalDescriptor.setName(uniqueName);
            if (isLocal) {
                ejbExternalDescriptor.setLocalHomeClassName(homeClassName);
                ejbExternalDescriptor.setLocalClassName(interfaceClassName);
            } else {
                ejbExternalDescriptor.setHomeClassName(homeClassName);
                ejbExternalDescriptor.setRemoteClassName(interfaceClassName);
            }
            ejbExternalDescriptor.setType(referenceType);
            EjbReferenceDescriptor ejbRef = new EjbReferenceDescriptor(ejbReferenceName, description, ejbExternalDescriptor, isLocal);
            referingBean.addEjbReferenceDescriptor(ejbRef);
        }
    }

    public void completeLoadingDescriptor(EjbBundleDescriptor ejbBundleDescriptor) {
        Enumeration e10 = XMLUtils.getNodesUnder((Node)this, "entity");
        while (e10.hasMoreElements()) {
            EjbNode nextEjbNode = (EjbNode)e10.nextElement();
            String ejbName = XMLUtils.getTextFor(nextEjbNode, "ejb-name");
            EjbDescriptor ejbDescriptor = ejbBundleDescriptor.getEjbByName(ejbName);
            nextEjbNode.completeLoadingDescriptor(ejbDescriptor);
        }
    }

    private void setRelationships(XMLUtils factory, EjbBundleDescriptor bundleDescriptor) {
        if (bundleDescriptor.getRelationships().size() == 0) {
            return;
        }
        ElementNode relsNode = factory.getNode("relationships");
        this.appendChild(relsNode);
        if (!bundleDescriptor.getRelationshipsDescription().equals("")) {
            relsNode.appendChild(factory.getTextNode("description", bundleDescriptor.getRelationshipsDescription()));
        }
        Iterator itr = bundleDescriptor.getRelationships().iterator();
        while (itr.hasNext()) {
            RelationshipDescriptor rd = (RelationshipDescriptor)itr.next();
            ElementNode rNode = factory.getNode("ejb-relation");
            relsNode.appendChild(rNode);
            if (!rd.getDescription().equals("")) {
                rNode.appendChild(factory.getTextNode("description", rd.getDescription()));
            }
            rNode.appendChild(factory.getTextNode("ejb-relation-name", rd.getName()));
            this.storeEjbRelationRole(rNode, rd.getSource(), factory);
            this.storeEjbRelationRole(rNode, rd.getSink(), factory);
        }
    }

    private void storeEjbRelationRole(ElementNode ejbRelationNode, RelationRoleDescriptor rrd, XMLUtils factory) {
        ElementNode roleNode = factory.getNode("ejb-relationship-role");
        String desc = rrd.getDescription();
        if (desc != null && !desc.equals("")) {
            roleNode.appendChild(factory.getTextNode("description", desc));
        }
        roleNode.appendChild(factory.getTextNode("ejb-relationship-role-name", rrd.getName()));
        roleNode.appendChild(factory.getTextNode("multiplicity", rrd.getIsMany() ? "many" : "one"));
        if (rrd.getCascadeDelete()) {
            roleNode.appendChild(factory.getNode("cascade-delete"));
        }
        ElementNode roleSourceNode = factory.getNode("relationship-role-source");
        if (!rrd.getRoleSourceDescription().equals("")) {
            roleNode.appendChild(factory.getTextNode("description", rrd.getRoleSourceDescription()));
        }
        roleSourceNode.appendChild(factory.getTextNode("ejb-name", rrd.getOwner().getName()));
        roleNode.appendChild(roleSourceNode);
        if (rrd.getCMRField() != null) {
            ElementNode cmrFieldNode = factory.getNode("cmr-field");
            if (!rrd.getCMRFieldDescription().equals("")) {
                cmrFieldNode.appendChild(factory.getTextNode("description", rrd.getCMRFieldDescription()));
            }
            cmrFieldNode.appendChild(factory.getTextNode("cmr-field-name", rrd.getCMRField()));
            String type = rrd.getCMRFieldType();
            if (type != null && !type.equals("")) {
                cmrFieldNode.appendChild(factory.getTextNode("cmr-field-type", type));
            }
            roleNode.appendChild(cmrFieldNode);
        }
        ejbRelationNode.appendChild(roleNode);
    }

    private void getRelationships(EjbBundleDescriptor bundleDescriptor) {
        ElementNode relnsNode = XMLUtils.getFirstNodeUnder(this, "relationships");
        if (relnsNode == null) {
            return;
        }
        if (XMLUtils.hasNodesUnder(relnsNode, "description")) {
            String d10 = XMLUtils.getTextFor(relnsNode, "description");
            bundleDescriptor.setRelationshipsDescription(d10);
        }
        Enumeration e22 = XMLUtils.getNodesUnder((Node)relnsNode, "ejb-relation");
        while (e22.hasMoreElements()) {
            ElementNode rNode = (ElementNode)e22.nextElement();
            RelationshipDescriptor relnDesc = new RelationshipDescriptor();
            if (XMLUtils.hasNodesUnder(rNode, "description")) {
                String d11 = XMLUtils.getTextFor(rNode, "description");
                relnDesc.setDescription(d11);
            }
            if (XMLUtils.hasNodesUnder(rNode, "ejb-relation-name")) {
                String rname = XMLUtils.getTextFor(rNode, "ejb-relation-name");
                relnDesc.setName(rname);
            }
            Enumeration roles = XMLUtils.getNodesUnder((Node)rNode, "ejb-relationship-role");
            ElementNode roleNode = (ElementNode)roles.nextElement();
            RelationRoleDescriptor source = this.loadEjbRelationRole(roleNode, bundleDescriptor);
            roleNode = (ElementNode)roles.nextElement();
            RelationRoleDescriptor sink = this.loadEjbRelationRole(roleNode, bundleDescriptor);
            source.setPartner(sink);
            sink.setPartner(source);
            relnDesc.setSource(source);
            source.setRelationshipDescriptor(relnDesc);
            relnDesc.setSink(sink);
            sink.setRelationshipDescriptor(relnDesc);
            if (source.getCMRField() != null && sink.getCMRField() != null) {
                relnDesc.setIsBidirectional(true);
            } else {
                relnDesc.setIsBidirectional(false);
            }
            String msg1 = "ERROR: Cascade-delete can only be specified if the other role has a multiplicity of ONE";
            if (source.getCascadeDelete() && sink.getIsMany()) {
                throw new EJBException(msg1);
            }
            if (sink.getCascadeDelete() && source.getIsMany()) {
                throw new EJBException(msg1);
            }
            bundleDescriptor.addRelationship(relnDesc);
        }
    }

    private RelationRoleDescriptor loadEjbRelationRole(ElementNode roleNode, EjbBundleDescriptor bundleDesc) {
        ElementNode fieldNode;
        RelationRoleDescriptor role = new RelationRoleDescriptor();
        if (XMLUtils.hasNodesUnder(roleNode, "description")) {
            String d10 = XMLUtils.getTextFor(roleNode, "description");
            role.setDescription(d10);
        }
        String rname = XMLUtils.getTextFor(roleNode, "ejb-relationship-role-name");
        role.setName(rname);
        String mul = XMLUtils.getTextFor(roleNode, "multiplicity");
        if (mul.equals("many")) {
            role.setIsMany(true);
        } else {
            role.setIsMany(false);
        }
        ElementNode sourceNode = XMLUtils.getFirstNodeUnder(roleNode, "relationship-role-source");
        if (XMLUtils.hasNodesUnder(sourceNode, "description")) {
            String d11 = XMLUtils.getTextFor(sourceNode, "description");
            role.setRoleSourceDescription(d11);
        }
        String ejbName = XMLUtils.getTextFor(sourceNode, "ejb-name");
        EjbCMPEntityDescriptor desc = (EjbCMPEntityDescriptor)bundleDesc.getEjbByName(ejbName);
        role.setPersistenceDescriptor(desc.getPersistenceDescriptor());
        if (XMLUtils.hasNodesUnder(roleNode, "cascade-delete")) {
            role.setCascadeDelete(true);
        }
        if ((fieldNode = XMLUtils.getFirstNodeUnder(roleNode, "cmr-field")) != null) {
            if (XMLUtils.hasNodesUnder(fieldNode, "description")) {
                String d12 = XMLUtils.getTextFor(fieldNode, "description");
                role.setCMRFieldDescription(d12);
            }
            role.setCMRField(XMLUtils.getTextFor(fieldNode, "cmr-field-name"));
            if (XMLUtils.hasNodesUnder(fieldNode, "cmr-field-type")) {
                role.setCMRFieldType(XMLUtils.getTextFor(fieldNode, "cmr-field-type"));
            }
        }
        return role;
    }

    public static Vector readEjbBundleNodes(InputStream is) throws ParseException {
        try {
            Hashtable<String, String> nodeToClass = new Hashtable<String, String>();
            nodeToClass.put("ejb-jar", "com.sun.enterprise.deployment.xml.EjbBundleNode");
            nodeToClass.put("session", "com.sun.enterprise.deployment.xml.EjbNode");
            nodeToClass.put("entity", "com.sun.enterprise.deployment.xml.EjbNode");
            nodeToClass.put("message-driven", "com.sun.enterprise.deployment.xml.EjbNode");
            nodeToClass.put(MethodDescriptorNode.METHOD_TAG, "com.sun.enterprise.deployment.xml.MethodDescriptorNode");
            return XMLUtils.getNodesByType(class$com$sun$enterprise$deployment$xml$EjbBundleNode == null ? (class$com$sun$enterprise$deployment$xml$EjbBundleNode = EjbBundleNode.class$("com.sun.enterprise.deployment.xml.EjbBundleNode")) : class$com$sun$enterprise$deployment$xml$EjbBundleNode, nodeToClass, is);
        }
        catch (SAXException se) {
            se.printStackTrace();
            throw new ParseException(se);
        }
        catch (Throwable t2) {
            throw new ParseException(t2.getMessage());
        }
    }

    public static XmlDocument getDocument(EjbBundleDescriptor ejbBundleDescriptor) {
        XmlDocument xmlDocument = new XmlDocument();
        xmlDocument.setDoctype(PUBLIC_DTD_ID, SYSTEM_ID, null);
        EjbBundleNode n2 = new EjbBundleNode();
        xmlDocument.appendChild(n2);
        n2.setDescriptor(ejbBundleDescriptor);
        return xmlDocument;
    }

    public static EjbBundleNode read(InputStream is) throws ParseException {
        Vector ejbBundleNodes = EjbBundleNode.readEjbBundleNodes(is);
        if (ejbBundleNodes.size() > 0) {
            return (EjbBundleNode)ejbBundleNodes.elementAt(0);
        }
        throw new ParseException("No Ejb bundle nodes could be found");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

