/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.ejb.sqlgen.SQLTypeMapper;
import com.sun.enterprise.deployment.CMRFieldInfo;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleArchivist;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.FieldDescriptor;
import com.sun.enterprise.deployment.JoinObjectDescriptor;
import com.sun.enterprise.deployment.PersistentFieldInfo;
import com.sun.enterprise.deployment.QueryDescriptor;
import com.sun.enterprise.deployment.RelationRoleDescriptor;
import com.sun.enterprise.deployment.RelationshipDescriptor;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.TypeUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.ejb.EJBException;

public final class PersistenceDescriptor
extends Descriptor {
    private static final boolean debug = true;
    public static final String DELETE_ROW = "deleteRow";
    public static final String CREATE_ROW = "createRow";
    public static final String LOAD_ROW = "loadRow";
    public static final String STORE_ROW = "storeRow";
    public static final String CREATE_TABLE = "createTable";
    public static final String DELETE_TABLE = "deleteTable";
    public static final String FINDBYPRIMARYKEY = "findByPrimaryKey";
    public static final String FINDBYSOURCEKEY = "findBySourceKey";
    public static final String FINDBYSINKKEY = "findBySinkKey";
    private Set cmpFields = new HashSet();
    private Set pkeyFields = new HashSet();
    private boolean pkeyIsOneField = false;
    private boolean pkeyFieldSpecified = true;
    private String primaryKeyClassName;
    private boolean pkeyStuffInitialized = false;
    private boolean pkeyFieldsAllPrimitive = false;
    private Set allSqlStatementedMethods;
    private Hashtable methodSqlMap = new Hashtable();
    private boolean createTableOnDeployment = true;
    private boolean deleteTableOnUndeployment = true;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$deployment$PersistenceDescriptor == null ? (class$com$sun$enterprise$deployment$PersistenceDescriptor = PersistenceDescriptor.class$("com.sun.enterprise.deployment.PersistenceDescriptor")) : class$com$sun$enterprise$deployment$PersistenceDescriptor);
    private Descriptor parentDesc;
    private EjbBundleDescriptor bundleDescriptor;
    private Class persistentClass;
    private Class stateClass;
    private Class primaryKeyClass;
    private PersistentFieldInfo[] persFieldInfo;
    private PersistentFieldInfo[] persNoPkeyFieldInfo;
    private PersistentFieldInfo[] pkeyFieldInfo;
    private boolean fieldInfoInitialized = false;
    private PersistentFieldInfo[] fkeyFields;
    private CMRFieldInfo[] cmrFieldInfo;
    private Field[] pkeyClassPkeyFields;
    private Hashtable queries = new Hashtable();
    private HashSet allQueriedMethods;
    private String tableName;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$PersistenceDescriptor;

    public PersistenceDescriptor() {
    }

    public PersistenceDescriptor(PersistenceDescriptor pers) {
        super(pers);
        this.getCMPFields().addAll(pers.getCMPFields());
        this.methodSqlMap = new Hashtable(pers.getMethodSqlMap());
        this.createTableOnDeployment = pers.createTableOnDeployment;
        this.deleteTableOnUndeployment = pers.deleteTableOnUndeployment;
    }

    public String getCMRFieldReturnType(String field) {
        String returnType = "java.util.Collection";
        try {
            if (!field.trim().equals("")) {
                Class persClass = this.getPersistentClass();
                String methodName = "get" + field.substring(0, 1).toUpperCase() + field.substring(1);
                Method method = TypeUtil.getMethod(persClass, persClass.getClassLoader(), methodName, new String[0]);
                returnType = method.getReturnType().getName();
            }
        }
        catch (Throwable t2) {
            t2.printStackTrace();
        }
        return returnType;
    }

    public boolean classesChanged() {
        FieldDescriptor primKeyFieldDesc;
        FieldDescriptor next;
        Iterator iter;
        this.persistentClass = null;
        this.stateClass = null;
        Class persClass = this.getPersistentClass();
        EjbCMPEntityDescriptor ejb = (EjbCMPEntityDescriptor)this.parentDesc;
        Vector fieldDescriptors = ejb.getFieldDescriptors();
        if (this.cmpFields != null) {
            iter = this.cmpFields.iterator();
            while (iter.hasNext()) {
                next = (FieldDescriptor)iter.next();
                if (fieldDescriptors.contains(next)) continue;
                iter.remove();
            }
        }
        if (this.pkeyFields != null) {
            iter = this.pkeyFields.iterator();
            while (iter.hasNext()) {
                next = (FieldDescriptor)iter.next();
                if (fieldDescriptors.contains(next)) continue;
                iter.remove();
            }
        }
        if ((primKeyFieldDesc = ejb.getPrimaryKeyFieldDesc()) != null && !fieldDescriptors.contains(primKeyFieldDesc)) {
            ejb.setPrimaryKeyFieldDesc(null);
        }
        Hashtable queriesClone = (Hashtable)this.queries.clone();
        this.queries = new Hashtable();
        this.initializeAllQueriedMethods();
        Iterator it = queriesClone.keySet().iterator();
        while (it.hasNext()) {
            Method oldMethod = (Method)it.next();
            Method newMethod = this.findEquivalentMethod(this.allQueriedMethods, oldMethod);
            if (newMethod == null) continue;
            QueryDescriptor oldQuery = (QueryDescriptor)queriesClone.get(oldMethod);
            QueryDescriptor newQuery = new QueryDescriptor(oldQuery, newMethod);
            this.queries.put(newMethod, newQuery);
        }
        this.invalidate();
        return false;
    }

    private Method findEquivalentMethod(Collection methods, Method methodToMatch) {
        Method matchedMethod = null;
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            Method next = (Method)iter.next();
            if (!this.methodsEqual(next, methodToMatch)) continue;
            matchedMethod = next;
            break;
        }
        return matchedMethod;
    }

    private boolean methodsEqual(Method m1, Method m2) {
        Class<?>[] m2ParamTypes;
        Class<?>[] m1ParamTypes;
        String m2ReturnType;
        String m1ReturnType;
        String m2DeclaringClass;
        String m1DeclaringClass;
        String m2Name;
        boolean equal = false;
        String m1Name = m1.getName();
        if (m1Name.equals(m2Name = m2.getName()) && (m1DeclaringClass = m1.getDeclaringClass().getName()).equals(m2DeclaringClass = m2.getDeclaringClass().getName()) && (m1ReturnType = m1.getReturnType().getName()).equals(m2ReturnType = m2.getReturnType().getName()) && (m1ParamTypes = m1.getParameterTypes()).length == (m2ParamTypes = m2.getParameterTypes()).length) {
            equal = true;
            int pIndex = 0;
            while (pIndex < m1ParamTypes.length) {
                String m2ParamClass;
                String m1ParamClass = m1ParamTypes[pIndex].getName();
                if (!m1ParamClass.equals(m2ParamClass = m2ParamTypes[pIndex].getName())) {
                    equal = false;
                    break;
                }
                ++pIndex;
            }
        }
        return equal;
    }

    public void setParentDescriptor(Descriptor parentDesc) {
        this.parentDesc = parentDesc;
    }

    public Descriptor getParentDescriptor() {
        return this.parentDesc;
    }

    public EjbBundleDescriptor getEjbBundleDescriptor() {
        if (this.bundleDescriptor == null) {
            if (this.parentDesc instanceof EjbCMPEntityDescriptor) {
                EjbCMPEntityDescriptor beanDesc = (EjbCMPEntityDescriptor)this.parentDesc;
                this.bundleDescriptor = beanDesc.getEjbBundleDescriptor();
            } else {
                JoinObjectDescriptor jDesc = (JoinObjectDescriptor)this.parentDesc;
                this.bundleDescriptor = jDesc.getEjbBundleDescriptor();
            }
        }
        return this.bundleDescriptor;
    }

    public Set getRelationships() {
        Set allRelationships = this.getEjbBundleDescriptor().getRelationships();
        HashSet<RelationshipDescriptor> myRelationships = new HashSet<RelationshipDescriptor>();
        Iterator iter = allRelationships.iterator();
        while (iter.hasNext()) {
            RelationshipDescriptor next = (RelationshipDescriptor)iter.next();
            if (!next.hasParticipant(this.parentDesc)) continue;
            myRelationships.add(next);
        }
        return myRelationships;
    }

    public CMRFieldInfo[] getCMRFieldInfo() {
        if (this.cmrFieldInfo == null) {
            try {
                this.initCMRFieldStuff();
            }
            catch (Exception ex2) {
                ex2.printStackTrace();
                Log.err.println(ex2);
                throw new EJBException(ex2);
            }
        }
        return this.cmrFieldInfo;
    }

    public CMRFieldInfo getCMRFieldInfoByName(String fieldName) {
        CMRFieldInfo[] cmrf = this.getCMRFieldInfo();
        int i2 = 0;
        while (i2 < cmrf.length) {
            if (cmrf[i2].name.equals(fieldName)) {
                return cmrf[i2];
            }
            ++i2;
        }
        throw new EJBException("CMRFieldInfo not found for field " + fieldName);
    }

    public void invalidate() {
        this.cmrFieldInfo = null;
        this.persFieldInfo = null;
        this.fieldInfoInitialized = false;
        this.pkeyStuffInitialized = false;
    }

    private void initCMRFieldStuff() throws Exception {
        if (this.parentDesc instanceof JoinObjectDescriptor) {
            this.cmrFieldInfo = new CMRFieldInfo[0];
            return;
        }
        if (!this.fieldInfoInitialized) {
            this.initializeFieldInfo();
        }
        boolean isRuntime = false;
        if (this.getPersistentClass() != null && !Modifier.isAbstract(this.getPersistentClass().getModifiers())) {
            isRuntime = true;
        }
        Set relationships = this.getRelationships();
        Iterator it = relationships.iterator();
        this.cmrFieldInfo = new CMRFieldInfo[relationships.size()];
        int count = 0;
        while (it.hasNext()) {
            String type;
            RelationshipDescriptor rd = (RelationshipDescriptor)it.next();
            RelationRoleDescriptor source = rd.getSource();
            RelationRoleDescriptor myrole = source.getPersistenceDescriptor() == this ? source : rd.getSink();
            CMRFieldInfo finfo = new CMRFieldInfo();
            this.cmrFieldInfo[count++] = finfo;
            PersistenceDescriptor partnerPers = myrole.getPartner().getPersistenceDescriptor();
            EjbCMPEntityDescriptor partner = myrole.getPartner().getOwner();
            if (!partner.isLocalInterfacesSupported() && myrole.getCMRField() != null) {
                throw new RuntimeException("No local interface for target bean of CMR field");
            }
            if (!myrole.getPartner().getIsMany()) {
                type = partner.isLocalInterfacesSupported() ? partner.getLocalClassName() : partner.getPrimaryKeyClassName();
            } else {
                type = myrole.getCMRFieldType();
                if (type == null) {
                    type = "java.util.Collection";
                }
            }
            finfo.type = this.getClass(type);
            finfo.name = myrole.getCMRField();
            if (finfo.name == null) {
                finfo.name = "_reverse_" + myrole.getPartner().getCMRField();
            }
            finfo.role = myrole;
            myrole.setCMRFieldInfo(finfo);
            if (isRuntime) {
                finfo.field = this.getStateClass().getField(finfo.name);
            }
            if (!rd.isOneOne() || this.fkeyFields == null) continue;
            PersistentFieldInfo[] partnerPkeyFields = partnerPers.getPkeyFieldInfo();
            PersistentFieldInfo[] cmrFkeyFields = new PersistentFieldInfo[partnerPkeyFields.length];
            int i2 = 0;
            while (i2 < partnerPkeyFields.length) {
                String fkeyName = "_" + finfo.name + "_" + partnerPkeyFields[i2].name;
                int j2 = 0;
                while (j2 < this.fkeyFields.length) {
                    if (this.fkeyFields[j2].name.equals(fkeyName)) {
                        cmrFkeyFields[i2] = this.fkeyFields[j2];
                    }
                    ++j2;
                }
                ++i2;
            }
            finfo.fkeyFields = cmrFkeyFields;
        }
        int i3 = this.cmrFieldInfo.length - 1;
        while (i3 > 0) {
            int j3 = 0;
            while (j3 < i3) {
                if (this.cmrFieldInfo[j3].name.compareTo(this.cmrFieldInfo[j3 + 1].name) > 0) {
                    CMRFieldInfo tmp = this.cmrFieldInfo[j3];
                    this.cmrFieldInfo[j3] = this.cmrFieldInfo[j3 + 1];
                    this.cmrFieldInfo[j3 + 1] = tmp;
                }
                ++j3;
            }
            --i3;
        }
    }

    public void clearCMPFields() {
        this.cmpFields.clear();
        this.setCMPFields(this.cmpFields);
    }

    public void addCMPField(String field) {
        this.addCMPField(new FieldDescriptor(field));
    }

    public void addCMPField(FieldDescriptor fieldDesc) {
        this.cmpFields.add(fieldDesc);
        this.setCMPFields(this.cmpFields);
    }

    public void removeCMPField(String field) {
        this.removeCMPField(new FieldDescriptor(field));
    }

    public void removeCMPField(FieldDescriptor fieldDesc) {
        this.cmpFields.remove(fieldDesc);
        this.setCMPFields(this.cmpFields);
    }

    public void setCMPFields(Set cmpFields) {
        this.cmpFields = cmpFields;
        this.persFieldInfo = null;
        this.fieldInfoInitialized = false;
        super.changed();
    }

    public boolean isCMPField(String field) {
        return this.getCMPFields().contains(new FieldDescriptor(field));
    }

    public Set getCMPFields() {
        return this.cmpFields;
    }

    public void setPkeyFields(Set pkeyFields) {
        this.pkeyFields = pkeyFields;
        this.fieldInfoInitialized = false;
        this.persFieldInfo = null;
        this.pkeyStuffInitialized = false;
        super.changed();
    }

    public Set getPkeyFields() {
        if (!this.pkeyStuffInitialized) {
            this.initPkeyInfo();
        }
        return this.pkeyFields;
    }

    public boolean isPkeyField(String field) {
        return this.isPkeyField(new FieldDescriptor(field));
    }

    public boolean isPkeyField(FieldDescriptor fieldDesc) {
        return this.getPkeyFields().contains(fieldDesc);
    }

    private void initPkeyInfo() {
        try {
            this.pkeyIsOneField = false;
            this.pkeyFieldSpecified = true;
            if (this.parentDesc instanceof EjbCMPEntityDescriptor) {
                EjbCMPEntityDescriptor dd2 = (EjbCMPEntityDescriptor)this.parentDesc;
                this.primaryKeyClassName = dd2.getPrimaryKeyClassName();
                FieldDescriptor fd2 = dd2.getPrimaryKeyFieldDesc();
                if (this.pkeyFields == null || this.pkeyFields.size() == 0) {
                    this.pkeyFields = new HashSet();
                    if (fd2 != null) {
                        this.pkeyFields.add(fd2);
                    } else if (!this.primaryKeyClassName.equals("java.lang.Object")) {
                        this.primaryKeyClass = this.getClass(this.primaryKeyClassName);
                        Field[] fields = this.primaryKeyClass.getFields();
                        this.pkeyFieldsAllPrimitive = true;
                        int i2 = 0;
                        while (i2 < fields.length) {
                            int m2 = fields[i2].getModifiers();
                            if (!Modifier.isStatic(m2) && !Modifier.isFinal(m2)) {
                                if (!fields[i2].getType().isPrimitive()) {
                                    this.pkeyFieldsAllPrimitive = false;
                                }
                                this.pkeyFields.add(new FieldDescriptor(fields[i2].getName()));
                            }
                            ++i2;
                        }
                    } else {
                        this.primaryKeyClassName = "java.lang.Long";
                        this.primaryKeyClass = this.getClass(this.primaryKeyClassName);
                        this.pkeyIsOneField = true;
                        this.pkeyFieldSpecified = false;
                    }
                }
                if (fd2 != null) {
                    this.pkeyIsOneField = true;
                }
            } else {
                JoinObjectDescriptor dd3 = (JoinObjectDescriptor)this.parentDesc;
                this.primaryKeyClassName = dd3.getJoinObjectClass();
                try {
                    this.primaryKeyClass = this.getClass(this.primaryKeyClassName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.pkeyStuffInitialized = true;
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
            Log.err.println(ex2);
            throw new EJBException(ex2);
        }
    }

    public boolean primaryKeyIsOneField() {
        if (!this.pkeyStuffInitialized) {
            this.initPkeyInfo();
        }
        return this.pkeyIsOneField;
    }

    public boolean primaryKeyIsSpecified() {
        if (!this.pkeyStuffInitialized) {
            this.initPkeyInfo();
        }
        return this.pkeyFieldSpecified;
    }

    public boolean primaryKeyFieldsAllPrimitive() {
        if (!this.pkeyStuffInitialized) {
            this.initPkeyInfo();
        }
        return this.pkeyFieldsAllPrimitive;
    }

    public Class getPrimaryKeyClass() {
        if (!this.pkeyStuffInitialized) {
            this.initPkeyInfo();
        }
        return this.primaryKeyClass;
    }

    public Class getPersistentClass() {
        if (this.persistentClass == null) {
            if (this.parentDesc instanceof EjbCMPEntityDescriptor) {
                EjbCMPEntityDescriptor entd = (EjbCMPEntityDescriptor)this.parentDesc;
                this.persistentClass = this.getClass(entd.getEjbClassName());
            } else {
                JoinObjectDescriptor dd2 = (JoinObjectDescriptor)this.parentDesc;
                this.persistentClass = this.getClass(dd2.getJoinObjectClass());
            }
        }
        return this.persistentClass;
    }

    public Class getStateClass() {
        if (this.stateClass == null) {
            EjbCMPEntityDescriptor entd;
            this.stateClass = this.getPersistentClass();
            if (this.parentDesc instanceof EjbCMPEntityDescriptor && (entd = (EjbCMPEntityDescriptor)this.parentDesc).isEJB20()) {
                String stateClassName = entd.getStateImplClassName();
                this.stateClass = this.getClass(stateClassName);
            }
        }
        return this.stateClass;
    }

    private Class getClass(String className) {
        try {
            EjbBundleArchivist arch = (EjbBundleArchivist)this.getEjbBundleDescriptor().getArchivist();
            return arch.getClassLoader().loadClass(className);
        }
        catch (Exception ex2) {
            throw new EJBException(ex2);
        }
    }

    public void setFkeyFields(PersistentFieldInfo[] fkeyFields) {
        this.fkeyFields = fkeyFields;
        this.fieldInfoInitialized = false;
        this.persFieldInfo = null;
        super.changed();
    }

    public PersistentFieldInfo[] getFkeyFields() {
        if (!this.fieldInfoInitialized) {
            this.initializeFieldInfo();
        }
        return this.fkeyFields;
    }

    public PersistentFieldInfo[] getPersistentFieldInfo() {
        if (!this.fieldInfoInitialized) {
            this.initializeFieldInfo();
        }
        return this.persFieldInfo;
    }

    public PersistentFieldInfo getPersistentFieldInfoByName(String fieldName) {
        if (!this.fieldInfoInitialized) {
            this.initializeFieldInfo();
        }
        int i2 = 0;
        while (i2 < this.persFieldInfo.length) {
            if (this.persFieldInfo[i2].name.equals(fieldName)) {
                return this.persFieldInfo[i2];
            }
            ++i2;
        }
        throw new EJBException("PersistentFieldInfo not found for field " + fieldName);
    }

    public PersistentFieldInfo[] getNonPkeyPersFieldInfo() {
        if (!this.fieldInfoInitialized) {
            this.initializeFieldInfo();
        }
        return this.persNoPkeyFieldInfo;
    }

    public PersistentFieldInfo[] getPkeyFieldInfo() {
        if (!this.fieldInfoInitialized) {
            this.initializeFieldInfo();
        }
        return this.pkeyFieldInfo;
    }

    public PersistentFieldInfo getPkeyFieldInfoByName(String fieldName) {
        if (!this.fieldInfoInitialized) {
            this.initializeFieldInfo();
        }
        int i2 = 0;
        while (i2 < this.pkeyFieldInfo.length) {
            if (this.pkeyFieldInfo[i2].name.equals(fieldName)) {
                return this.pkeyFieldInfo[i2];
            }
            ++i2;
        }
        throw new EJBException("PersistentFieldInfo not found for pkey field " + fieldName);
    }

    public Field[] getPkeyClassFields() {
        if (!this.fieldInfoInitialized) {
            this.initializeFieldInfo();
        }
        return this.pkeyClassPkeyFields;
    }

    private void initializeFieldInfo() {
        if (!this.pkeyStuffInitialized) {
            this.initPkeyInfo();
        }
        int cmpFieldCount = this.cmpFields.size();
        if (!this.pkeyFieldSpecified) {
            ++cmpFieldCount;
        }
        int fkeyCount = 0;
        if (this.fkeyFields != null) {
            fkeyCount = this.fkeyFields.length;
        }
        this.persFieldInfo = new PersistentFieldInfo[cmpFieldCount + fkeyCount];
        int fcount = 0;
        Iterator itr = this.cmpFields.iterator();
        while (itr.hasNext()) {
            this.persFieldInfo[fcount] = new PersistentFieldInfo();
            this.persFieldInfo[fcount].name = ((FieldDescriptor)itr.next()).getName();
            ++fcount;
        }
        if (this.fkeyFields != null) {
            int i2 = 0;
            while (i2 < this.fkeyFields.length) {
                this.persFieldInfo[fcount] = this.fkeyFields[i2];
                ++fcount;
                ++i2;
            }
        }
        if (!this.pkeyFieldSpecified) {
            PersistentFieldInfo pkField = new PersistentFieldInfo();
            pkField.name = "__PMPrimaryKey";
            this.persFieldInfo[fcount] = pkField;
        }
        int i3 = this.persFieldInfo.length - 1;
        while (i3 > 0) {
            int j2 = 0;
            while (j2 < i3) {
                if (this.persFieldInfo[j2].name.compareTo(this.persFieldInfo[j2 + 1].name) > 0) {
                    PersistentFieldInfo tmp = this.persFieldInfo[j2];
                    this.persFieldInfo[j2] = this.persFieldInfo[j2 + 1];
                    this.persFieldInfo[j2 + 1] = tmp;
                }
                ++j2;
            }
            --i3;
        }
        if (this.pkeyFieldSpecified) {
            this.pkeyFieldInfo = new PersistentFieldInfo[this.pkeyFields.size()];
            this.persNoPkeyFieldInfo = new PersistentFieldInfo[this.persFieldInfo.length - this.pkeyFieldInfo.length];
            int pkeyCount = 0;
            int noPkeyCount = 0;
            int i4 = 0;
            while (i4 < this.persFieldInfo.length) {
                boolean isPkey = false;
                Iterator it = this.pkeyFields.iterator();
                while (it.hasNext()) {
                    FieldDescriptor fd2 = (FieldDescriptor)it.next();
                    if (!fd2.getName().equals(this.persFieldInfo[i4].name)) continue;
                    isPkey = true;
                    break;
                }
                if (isPkey) {
                    this.pkeyFieldInfo[pkeyCount++] = this.persFieldInfo[i4];
                } else {
                    this.persNoPkeyFieldInfo[noPkeyCount++] = this.persFieldInfo[i4];
                }
                ++i4;
            }
        } else {
            this.pkeyFieldInfo = new PersistentFieldInfo[1];
            this.persNoPkeyFieldInfo = new PersistentFieldInfo[this.persFieldInfo.length - 1];
            int noPkeys = 0;
            int i5 = 0;
            while (i5 < this.persFieldInfo.length) {
                if (this.persFieldInfo[i5].name.equals("__PMPrimaryKey")) {
                    this.pkeyFieldInfo[0] = this.persFieldInfo[i5];
                } else {
                    this.persNoPkeyFieldInfo[noPkeys++] = this.persFieldInfo[i5];
                }
                ++i5;
            }
        }
        if (this.parentDesc instanceof JoinObjectDescriptor) {
            RelationshipDescriptor rd = ((JoinObjectDescriptor)this.parentDesc).getRelationshipDesc();
            RelationRoleDescriptor source = rd.getSource();
            RelationRoleDescriptor sink = rd.getSink();
            PersistenceDescriptor sourcePers = source.getPersistenceDescriptor();
            PersistentFieldInfo[] sourcePkeyFields = sourcePers.getPkeyFieldInfo();
            int i6 = 0;
            while (i6 < sourcePkeyFields.length) {
                String joinField = "_" + source.getOwner().getName() + "_" + sourcePkeyFields[i6].name;
                int j3 = 0;
                while (j3 < this.persFieldInfo.length) {
                    if (this.persFieldInfo[j3].name.equals(joinField)) {
                        this.persFieldInfo[j3].type = sourcePkeyFields[i6].type;
                        this.persFieldInfo[j3].relatedName = sourcePkeyFields[i6].name;
                        this.persFieldInfo[j3].relatedObj = source.getPersistenceDescriptor();
                    }
                    ++j3;
                }
                ++i6;
            }
            PersistenceDescriptor sinkPers = sink.getPersistenceDescriptor();
            PersistentFieldInfo[] sinkPkeyFields = sinkPers.getPkeyFieldInfo();
            int i7 = 0;
            while (i7 < sinkPkeyFields.length) {
                String joinField = "_" + sink.getOwner().getName() + "_" + sinkPkeyFields[i7].name;
                int j4 = 0;
                while (j4 < this.persFieldInfo.length) {
                    if (this.persFieldInfo[j4].name.equals(joinField)) {
                        this.persFieldInfo[j4].type = sinkPkeyFields[i7].type;
                        this.persFieldInfo[j4].relatedName = sinkPkeyFields[i7].name;
                        this.persFieldInfo[j4].relatedObj = sink.getPersistenceDescriptor();
                    }
                    ++j4;
                }
                ++i7;
            }
        } else {
            if (this.pkeyIsOneField) {
                this.pkeyFieldInfo[0].type = this.getPrimaryKeyClass();
            }
            int i8 = 0;
            while (i8 < this.persFieldInfo.length) {
                if (this.persFieldInfo[i8].type == null) {
                    this.persFieldInfo[i8].type = this.getCMPFieldType(this.persFieldInfo[i8].name);
                }
                ++i8;
            }
        }
        SQLTypeMapper typeMapper = new SQLTypeMapper();
        int i9 = 0;
        while (i9 < this.persFieldInfo.length) {
            this.persFieldInfo[i9].jdbcType = typeMapper.getJDBCTypeFor(this.persFieldInfo[i9].type);
            ++i9;
        }
        try {
            if (this.persistentClass != null && !Modifier.isAbstract(this.persistentClass.getModifiers())) {
                int i10 = 0;
                while (i10 < this.persFieldInfo.length) {
                    this.persFieldInfo[i10].field = this.getField(this.getStateClass(), this.persFieldInfo[i10].name);
                    ++i10;
                }
            }
            if (!this.pkeyIsOneField && this.primaryKeyClass != null && !Modifier.isAbstract(this.primaryKeyClass.getModifiers())) {
                this.pkeyClassPkeyFields = new Field[this.pkeyFieldInfo.length];
                int i11 = 0;
                while (i11 < this.pkeyFieldInfo.length) {
                    this.pkeyClassPkeyFields[i11] = this.primaryKeyClass.getField(this.pkeyFieldInfo[i11].name);
                    ++i11;
                }
            }
        }
        catch (NoSuchFieldException ex2) {
            ex2.printStackTrace();
            throw new EJBException(ex2);
        }
        this.fieldInfoInitialized = true;
    }

    private Field getField(final Class c10, final String name) throws NoSuchFieldException {
        Field field = (Field)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return c10.getDeclaredField(name);
                }
                catch (NoSuchFieldException ex2) {
                    return null;
                }
            }
        });
        if (field == null) {
            field = c10.getField(name);
        }
        return field;
    }

    private Hashtable getMethodSqlMap() {
        return this.methodSqlMap;
    }

    public boolean hasCMPData() {
        return this.methodSqlMap.size() == this.getAllSqlStatementedMethods().size();
    }

    public Set getAllSqlStatementedMethods() {
        if (this.allSqlStatementedMethods == null) {
            try {
                this.allSqlStatementedMethods = new HashSet();
                this.allSqlStatementedMethods.add(CREATE_ROW);
                this.allSqlStatementedMethods.add(DELETE_ROW);
                this.allSqlStatementedMethods.add(STORE_ROW);
                this.allSqlStatementedMethods.add(LOAD_ROW);
                this.allSqlStatementedMethods.add(CREATE_TABLE);
                this.allSqlStatementedMethods.add(DELETE_TABLE);
                this.allSqlStatementedMethods.add(FINDBYPRIMARYKEY);
                if (this.parentDesc instanceof JoinObjectDescriptor) {
                    this.allSqlStatementedMethods.add(FINDBYSOURCEKEY);
                    this.allSqlStatementedMethods.add(FINDBYSINKKEY);
                }
            }
            catch (Exception ex2) {
                throw new RuntimeException(localStrings.getLocalString("enterprise.deployment.exceptionbldngsqlstatementmthds", "Error building allSqlStatementedMethods {0}", new Object[]{ex2}));
            }
        }
        return this.allSqlStatementedMethods;
    }

    public Set getSqlStatementedMethods() {
        return this.getMethodSqlMap().keySet();
    }

    public void setSqlStatementFor(String method, String sqlStatement) {
        this.getMethodSqlMap().put(method, sqlStatement);
        this.changed();
    }

    public String getSqlStatementFor(String method) {
        Object statement = this.getMethodSqlMap().get(method);
        if (statement == null) {
            statement = "";
        }
        return (String)statement;
    }

    public String getSqlStatementFor(Method method) {
        return this.getSqlStatementFor(method.getName());
    }

    public boolean getCreateTableOnDeployment() {
        return this.createTableOnDeployment;
    }

    public void setCreateTableOnDeployment(boolean createTableOnDeployment) {
        this.createTableOnDeployment = createTableOnDeployment;
        this.changed();
    }

    public boolean getDeleteTableOnUndeployment() {
        return this.deleteTableOnUndeployment;
    }

    public void setDeleteTableOnUndeployment(boolean deleteTableOnUndeployment) {
        this.deleteTableOnUndeployment = deleteTableOnUndeployment;
        this.changed();
    }

    public Class getTypeFor(String field) {
        return this.getCMPFieldType(field);
    }

    private Class getCMPFieldType(String field) {
        Class pclass = this.getPersistentClass();
        if (Modifier.isAbstract(pclass.getModifiers())) {
            String javaBeanName = PersistenceDescriptor.capitalize(field);
            String getter = "get" + javaBeanName;
            try {
                Method method = pclass.getMethod(getter, null);
                return method.getReturnType();
            }
            catch (Exception ex2) {
                throw new RuntimeException("Cannot find accessor " + getter + " for CMP field " + field);
            }
        }
        try {
            Field f2 = this.getField(this.getStateClass(), field);
            return f2.getType();
        }
        catch (NoSuchFieldException ex3) {
            throw new RuntimeException("Cant find CMP field " + field + " in class " + this.getStateClass().getName());
        }
    }

    public static String capitalize(String name) {
        if (Character.isUpperCase(name.charAt(0))) {
            throw new EJBException("CMP/CMR field " + name + " must start with a lower case character.");
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public void setQueryFor(Method method, QueryDescriptor query) {
        Method queryMethod = this.findEquivalentMethod(this.queries.keySet(), method);
        if (queryMethod != null) {
            this.queries.put(queryMethod, query);
        } else {
            this.queries.put(method, query);
        }
    }

    public QueryDescriptor getQueryFor(Method method) {
        Method queryMethod = this.findEquivalentMethod(this.queries.keySet(), method);
        return queryMethod != null ? (QueryDescriptor)this.queries.get(queryMethod) : null;
    }

    public Set getQueriedMethods() {
        return this.queries.keySet();
    }

    public Set getAllPossibleQueriedMethods() {
        if (this.allQueriedMethods == null) {
            this.initializeAllQueriedMethods();
        }
        return this.allQueriedMethods;
    }

    private void initializeAllQueriedMethods() {
        this.allQueriedMethods = new HashSet();
        if (this.parentDesc instanceof JoinObjectDescriptor) {
            return;
        }
        Method[] beanMethods = this.getPersistentClass().getMethods();
        int i2 = 0;
        while (i2 < beanMethods.length) {
            if (beanMethods[i2].getName().startsWith("ejbSelect")) {
                this.allQueriedMethods.add(beanMethods[i2]);
            }
            ++i2;
        }
        if (this.parentDesc instanceof EjbCMPEntityDescriptor) {
            String name;
            int i3;
            Method[] homeMethods;
            Class homeIntf;
            EjbCMPEntityDescriptor entd = (EjbCMPEntityDescriptor)this.parentDesc;
            if (entd.isRemoteInterfacesSupported()) {
                homeIntf = this.getClass(entd.getHomeClassName());
                homeMethods = homeIntf.getMethods();
                i3 = 0;
                while (i3 < homeMethods.length) {
                    name = homeMethods[i3].getName();
                    if (name.startsWith("find") && !name.equals(FINDBYPRIMARYKEY)) {
                        this.allQueriedMethods.add(homeMethods[i3]);
                    }
                    ++i3;
                }
            }
            if (entd.isLocalInterfacesSupported()) {
                homeIntf = this.getClass(entd.getLocalHomeClassName());
                homeMethods = homeIntf.getMethods();
                i3 = 0;
                while (i3 < homeMethods.length) {
                    name = homeMethods[i3].getName();
                    if (name.startsWith("find") && !name.equals(FINDBYPRIMARYKEY)) {
                        this.allQueriedMethods.add(homeMethods[i3]);
                    }
                    ++i3;
                }
            }
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String toString() {
        String s2 = super.toString();
        s2 = s2 + "\n Entity descriptor";
        s2 = s2 + "\n cmpFields " + this.cmpFields;
        s2 = s2 + "\n methodSqlMap " + this.methodSqlMap;
        return s2;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

