/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class Descriptor
implements Serializable {
    public static String DESCRIPTOR_CHANGED = "Descriptor change";
    private static boolean boundsChecking = true;
    protected Vector listeners = new Vector();
    private String name = "";
    private String description = "";
    private String largeIconUri = null;
    private String smallIconUri = null;

    public Descriptor() {
        this.listeners = new Vector();
    }

    protected Descriptor(Descriptor other) {
        this.name = other.name;
        this.description = other.description;
        this.largeIconUri = other.largeIconUri;
        this.smallIconUri = other.smallIconUri;
    }

    public Descriptor(String name, String description) {
        this();
        this.name = name;
        this.description = description;
    }

    public static void setBoundsChecking(boolean b10) {
        boundsChecking = b10;
    }

    public static boolean isBoundsChecking() {
        return boundsChecking;
    }

    public void setName(String name) {
        if (name == null || !name.equals(this.name)) {
            this.name = name;
            this.changed();
        }
    }

    public String getName() {
        if (this.name == null) {
            this.name = "";
        }
        return this.name;
    }

    public void setDescription(String description) {
        if (description != null && !description.equals(this.description)) {
            this.description = description;
            this.changed();
        }
    }

    public String getDescription() {
        return this.description;
    }

    public String getLargeIconUri() {
        if (this.largeIconUri == null) {
            this.largeIconUri = "";
        }
        return this.largeIconUri;
    }

    public void setLargeIconUri(String largeIconUri) {
        this.largeIconUri = largeIconUri;
        this.changed();
    }

    public String getSmallIconUri() {
        if (this.smallIconUri == null) {
            this.smallIconUri = "";
        }
        return this.smallIconUri;
    }

    public void setSmallIconUri(String smallIconUri) {
        this.smallIconUri = smallIconUri;
        this.changed();
    }

    public void addNotificationListener(NotificationListener nl) {
        this.listeners.addElement(nl);
    }

    public void removeNotificationListener(NotificationListener nl) {
        this.listeners.removeElement(nl);
    }

    public void changed() {
        long l2 = System.currentTimeMillis();
        NotificationEvent ne = new NotificationEvent(this, DESCRIPTOR_CHANGED, this);
        Vector listenersClone = null;
        Vector vector = this.listeners;
        synchronized (vector) {
            listenersClone = (Vector)this.listeners.clone();
        }
        Enumeration e10 = listenersClone.elements();
        while (e10.hasMoreElements()) {
            NotificationListener nl = (NotificationListener)e10.nextElement();
            nl.notification(ne);
        }
        long ll = System.currentTimeMillis() - l2;
        if (ll > 20L) {
            // empty if block
        }
    }

    private static String stripIntegerEndingFrom(String s2) {
        return Descriptor.recursiveStripIntegerEndingFrom(s2);
    }

    private static String recursiveStripIntegerEndingFrom(String s2) {
        if (s2.length() > 1) {
            String shorterByOne = s2.substring(0, s2.length() - 1);
            String lastBit = s2.substring(s2.length() - 1, s2.length());
            try {
                Integer.parseInt(lastBit);
                return Descriptor.recursiveStripIntegerEndingFrom(shorterByOne);
            }
            catch (NumberFormatException nfe) {
                return s2;
            }
        }
        return s2;
    }

    private static String uniquifyString(String trialName, Vector v2, int index) {
        Enumeration e10 = v2.elements();
        while (e10.hasMoreElements()) {
            String next = (String)e10.nextElement();
            if (!next.equals(trialName)) continue;
            return Descriptor.uniquifyString(Descriptor.stripIntegerEndingFrom(trialName) + ++index, v2, index);
        }
        return trialName;
    }

    public static String createUniqueFilenameAmongst(String trialName, Vector otherNames) {
        int p2 = trialName.lastIndexOf(".");
        if (p2 < 0) {
            return Descriptor.uniquifyString(trialName, otherNames, 0);
        }
        String ext = trialName.substring(p2);
        String file = trialName.substring(0, p2);
        Vector<String> nameList = new Vector<String>();
        Enumeration e10 = otherNames.elements();
        while (e10.hasMoreElements()) {
            String name = e10.nextElement().toString();
            if (!name.endsWith(ext)) continue;
            nameList.add(name.substring(0, name.length() - ext.length()));
        }
        String unique = Descriptor.uniquifyString(file, nameList, 0);
        return unique + ext;
    }

    public static String createUniqueNameAmongst(String trialName, Vector otherNames) {
        return Descriptor.uniquifyString(trialName, otherNames, 0);
    }

    public static String createUniqueNameAmongstNamedDescriptors(String trialName, Set descriptors) {
        Vector<String> v2 = new Vector<String>();
        Iterator itr = descriptors.iterator();
        while (itr.hasNext()) {
            Descriptor next = (Descriptor)itr.next();
            v2.addElement(next.getName());
        }
        return Descriptor.createUniqueNameAmongst(trialName, v2);
    }

    public String toString() {
        String s2 = " name " + this.name;
        s2 = s2 + "\n description " + this.description;
        if (!"".equals(this.getSmallIconUri())) {
            s2 = s2 + "\n smallIconUri " + this.getSmallIconUri();
        }
        if (!"".equals(this.getLargeIconUri())) {
            s2 = s2 + "\n largeIconUri " + this.getLargeIconUri();
        }
        return s2;
    }
}

