/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.ArchiveException;
import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.FileContentsDescriptor;
import com.sun.enterprise.deployment.xml.ApplicationClientNode;
import com.sun.enterprise.deployment.xml.ApplicationClientRuntimeDescriptorNode;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ApplicationClientArchivist
extends Archivist {
    public static final String DEPLOYMENT_DESCRIPTOR_ENTRY = "META-INF/application-client.xml";
    private ApplicationClientDescriptor applicationClientDescriptor;
    public static final String RI_SPECIFIC_DESCRIPTOR_ENTRY = "META-INF/sun-j2ee-ri.xml";
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$deployment$ApplicationClientArchivist == null ? (class$com$sun$enterprise$deployment$ApplicationClientArchivist = ApplicationClientArchivist.class$("com.sun.enterprise.deployment.ApplicationClientArchivist")) : class$com$sun$enterprise$deployment$ApplicationClientArchivist);
    static /* synthetic */ Class class$com$sun$enterprise$deployment$ApplicationClientArchivist;

    public ApplicationClientArchivist(String archiveUri, ApplicationClientDescriptor applicationClientDescriptor) {
        this(true, archiveUri, applicationClientDescriptor, new HashSet());
    }

    public ApplicationClientArchivist(String archiveUri, ApplicationClientDescriptor applicationClientDescriptor, Set manifestClasspath) {
        this(true, archiveUri, applicationClientDescriptor, manifestClasspath);
    }

    public ApplicationClientArchivist(boolean hasArchiveFile, String archiveUri, ApplicationClientDescriptor applicationClientDescriptor, Set manifestClasspath) {
        super(archiveUri, hasArchiveFile);
        this.manifestClasspath = new HashSet(manifestClasspath);
        this.applicationClientDescriptor = applicationClientDescriptor;
        this.applicationClientDescriptor.setArchivist(this);
    }

    protected File getArchiveFile() throws IOException {
        if (!this.hasArchive()) {
            throw new IOException("No archive file for " + this);
        }
        File archiveFile = null;
        Application application = this.applicationClientDescriptor.getApplication();
        if (application != null) {
            ApplicationArchivist appArchivist = application.getApplicationArchivist();
            File applicationFile = appArchivist.getApplicationFile();
            archiveFile = Archivist.getApplicationClientTemp(Archivist.getDirectory(applicationFile));
            appArchivist.extractBundleToFile(this.applicationClientDescriptor, archiveFile);
            archiveFile.deleteOnExit();
        } else {
            archiveFile = this.getApplicationClientJarFile();
        }
        return archiveFile;
    }

    public File getApplicationClientJarFile() {
        return new File(this.getArchiveUri());
    }

    public Descriptor getDescriptor() {
        return this.applicationClientDescriptor;
    }

    public static boolean isApplicationClientJar(File jarFile) throws IOException {
        Archivist.checkExists(jarFile);
        JarFile jar = new JarFile(jarFile);
        ZipEntry ze = jar.getEntry(DEPLOYMENT_DESCRIPTOR_ENTRY);
        boolean isApplicationClientJar = ze != null;
        jar.close();
        return isApplicationClientJar;
    }

    public boolean isDeletable(String entryName) {
        boolean entryIsDeletable = true;
        if (entryName.equals("META-INF/MANIFEST.MF") || entryName.equals(DEPLOYMENT_DESCRIPTOR_ENTRY) || entryName.equals(RI_SPECIFIC_DESCRIPTOR_ENTRY)) {
            entryIsDeletable = false;
        }
        return entryIsDeletable;
    }

    public void updateFiles(Hashtable newFiles) throws IOException {
        super.updateFiles(newFiles);
        this.applicationClientDescriptor.changed();
    }

    public void removeEntries(Vector entriesToRemove) throws IOException {
        super.removeEntries(entriesToRemove);
        this.applicationClientDescriptor.changed();
    }

    public Hashtable createEntryNameMap(FileContentsDescriptor fcd) throws IOException {
        Hashtable entryNameMap = super.createEntryNameMap(fcd);
        entryNameMap.remove(DEPLOYMENT_DESCRIPTOR_ENTRY);
        entryNameMap.remove(RI_SPECIFIC_DESCRIPTOR_ENTRY);
        return entryNameMap;
    }

    public static void createPackage(FileContentsDescriptor fcd, String mainClassName, File descriptorFile, File destinationFile) throws IOException, ArchiveException {
        System.out.println(localStrings.getLocalString("enterprise.deployment.packageappclassesmainclassdescriptorinfileintodestfil", "Package app client classes {0} with main class {1} using descriptor in {2} into the file {3}", new Object[]{fcd, mainClassName, descriptorFile, destinationFile}));
        if (!descriptorFile.exists()) {
            throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptioncannotpackageappclient", "Cannot package Application Client: {0} does not exist.", new Object[]{descriptorFile}));
        }
        FileInputStream fis = new FileInputStream(descriptorFile);
        ApplicationClientDescriptor applicationClientDescriptor = null;
        ApplicationClientNode appClientNode = ApplicationClientNode.read(fis);
        fis.close();
        if (appClientNode != null) {
            applicationClientDescriptor = appClientNode.getDescriptor();
            ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(destinationFile));
            ApplicationClientArchivist archivist = new ApplicationClientArchivist(destinationFile.toString(), applicationClientDescriptor);
            boolean mainClassIncluded = false;
            Enumeration e10 = fcd.getFiles();
            while (e10.hasMoreElements()) {
                File nextRelativeFile = (File)e10.nextElement();
                String className = nextRelativeFile.toString().replace(File.separatorChar, '.');
                if (className.equals(mainClassName + ".class")) {
                    mainClassIncluded = true;
                }
                File actualFile = fcd.getFullFileFor(nextRelativeFile);
                String archiveName = nextRelativeFile.toString().replace(File.separatorChar, '/');
                ZipEntry entry = new ZipEntry(archiveName);
                entry.setTime(System.currentTimeMillis());
                fis = new FileInputStream(actualFile);
                zipOut.putNextEntry(entry);
                Archivist.copy(fis, zipOut);
                fis.close();
                zipOut.closeEntry();
            }
            archivist.writeDeploymentInfo(zipOut, true);
            if (!mainClassIncluded) {
                throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionincludeclassfileinpackcommand", "You must include the class file for {0} in the packaging command", new Object[]{mainClassName}));
            }
            Manifest manifest = ApplicationClientArchivist.createManifest(mainClassName, fcd.getClassLoader(), archivist);
            Archivist.writeManifest(manifest, zipOut);
            zipOut.close();
            System.out.println(localStrings.getLocalString("enterprise.deployment.createdappclientjar", "Created Application Client JAR {0}", new Object[]{destinationFile}));
        } else {
            System.out.println(localStrings.getLocalString("enterprise.deployment.nodeployinfofound", "There was no deployment information in {0}", new Object[]{descriptorFile}));
        }
    }

    private static Manifest createManifest(String mainClassName, Archivist archivist) {
        Manifest manifest = archivist.createManifest();
        manifest.getMainAttributes().put(Attributes.Name.MAIN_CLASS, mainClassName);
        return manifest;
    }

    private static Manifest createManifest(String mainClassName, ClassLoader cl2, Archivist archivist) throws IOException {
        try {
            cl2.loadClass(mainClassName);
            return ApplicationClientArchivist.createManifest(mainClassName, archivist);
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
            throw new IOException(cnfe.getMessage());
        }
    }

    public void writeDeploymentInfo(ZipOutputStream zos, boolean saveRuntimeInfo) throws IOException {
        this.writeDeploymentInfo(zos, saveRuntimeInfo, DEPLOYMENT_DESCRIPTOR_ENTRY, false);
    }

    public void writeDeploymentInfo(ZipOutputStream zos, boolean saveRuntimeInfo, String descriptorEntryName, boolean externalDescriptor) throws IOException {
        Archivist.writeDocumentToJar(ApplicationClientNode.getDocument(this.applicationClientDescriptor), descriptorEntryName, zos);
        if (saveRuntimeInfo && this.applicationClientDescriptor.hasRuntimeInformation()) {
            String rtDescriptorEntryName = RI_SPECIFIC_DESCRIPTOR_ENTRY;
            if (externalDescriptor) {
                rtDescriptorEntryName = ApplicationClientArchivist.getRuntimeEntryNameFrom(descriptorEntryName);
            }
            Archivist.writeDocumentToJar(ApplicationClientRuntimeDescriptorNode.getDocument(this.applicationClientDescriptor), rtDescriptorEntryName, zos);
        }
    }

    private static String getRuntimeEntryNameFrom(String name) {
        return RI_SPECIFIC_DESCRIPTOR_ENTRY + name;
    }

    public static ApplicationClientDescriptor open(File applicationClientJarFile) throws IOException, ArchiveException {
        if (!applicationClientJarFile.exists()) {
            throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionappclientjarinfodoesn'texist", "{0} does not exist", new Object[]{applicationClientJarFile}));
        }
        JarFile jar = new JarFile(applicationClientJarFile);
        ApplicationClientDescriptor descriptor = ApplicationClientArchivist.open(applicationClientJarFile, DEPLOYMENT_DESCRIPTOR_ENTRY, jar);
        jar.close();
        return descriptor;
    }

    static ApplicationClientDescriptor open(File applicationClientJarFile, String descriptorEntryName, JarFile jarContainingDescriptor) throws IOException, ArchiveException {
        if (!applicationClientJarFile.exists()) {
            throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionappclientjarinfodoesn'texist", "{0} does not exist", new Object[]{applicationClientJarFile}));
        }
        ZipEntry deploymentEntry = jarContainingDescriptor.getEntry(descriptorEntryName);
        if (deploymentEntry != null) {
            boolean externalDescriptor;
            InputStream is = jarContainingDescriptor.getInputStream(deploymentEntry);
            ApplicationClientNode node = ApplicationClientNode.read(is);
            is.close();
            ApplicationClientDescriptor applicationClientDescriptor = node.getDescriptor();
            ApplicationClientArchivist archivist = new ApplicationClientArchivist(applicationClientJarFile.toString(), applicationClientDescriptor);
            archivist.setManifestClasspaths(jarContainingDescriptor.getManifest());
            applicationClientDescriptor.setArchivist(archivist);
            boolean bl2 = externalDescriptor = !jarContainingDescriptor.getName().equals(applicationClientJarFile.toString());
            if (externalDescriptor) {
                JarFile acJarFile = new JarFile(applicationClientJarFile);
                Manifest manifest = acJarFile.getManifest();
                applicationClientDescriptor.setMainClassName(ApplicationClientArchivist.getMainClassNameFrom(manifest));
                acJarFile.close();
            } else {
                Manifest manifest = jarContainingDescriptor.getManifest();
                applicationClientDescriptor.setMainClassName(ApplicationClientArchivist.getMainClassNameFrom(manifest));
            }
            ZipEntry runtimeDescriptorEntry = null;
            runtimeDescriptorEntry = externalDescriptor ? jarContainingDescriptor.getEntry(ApplicationClientArchivist.getRuntimeEntryNameFrom(descriptorEntryName)) : jarContainingDescriptor.getEntry(RI_SPECIFIC_DESCRIPTOR_ENTRY);
            if (runtimeDescriptorEntry != null) {
                is = jarContainingDescriptor.getInputStream(runtimeDescriptorEntry);
                ApplicationClientRuntimeDescriptorNode rdn = ApplicationClientRuntimeDescriptorNode.read(is);
                is.close();
                rdn.updateRuntimeInformation(applicationClientDescriptor);
            }
            return applicationClientDescriptor;
        }
        throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionnodeployinfofoundatin", "No deployment info found at: {0} in {1}", new Object[]{descriptorEntryName, jarContainingDescriptor.getName()}));
    }

    private static String getMainClassNameFrom(Manifest manifest) throws IOException {
        Attributes attributes = manifest.getMainAttributes();
        if (attributes != null && attributes.get(Attributes.Name.MAIN_CLASS) != null) {
            return (String)attributes.get(Attributes.Name.MAIN_CLASS);
        }
        throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionincorrectmanifestformat", "Incorrect Manifest format"));
    }

    public void save(File destinationFile, boolean saveRuntimeInfo) throws IOException {
        this.save(destinationFile, saveRuntimeInfo, DEPLOYMENT_DESCRIPTOR_ENTRY, null);
    }

    void save(File destinationFile, boolean saveRuntimeInfo, String descriptorEntryName, ZipOutputStream descriptorOut) throws IOException {
        File tmpFile = Archivist.getApplicationClientTemp(Archivist.getDirectory(destinationFile));
        ZipOutputStream fileOut = new ZipOutputStream(new FileOutputStream(tmpFile));
        if (descriptorOut == null) {
            this.writeDeploymentInfo(fileOut, saveRuntimeInfo, descriptorEntryName, false);
        } else {
            this.writeDeploymentInfo(descriptorOut, saveRuntimeInfo, descriptorEntryName, true);
        }
        Manifest manifest = ApplicationClientArchivist.createManifest(this.applicationClientDescriptor.getMainClassName(), this);
        Archivist.writeManifest(manifest, fileOut);
        Vector<String> entryNamesToSkip = new Vector<String>();
        if (descriptorOut == null) {
            entryNamesToSkip.addElement(DEPLOYMENT_DESCRIPTOR_ENTRY);
            entryNamesToSkip.addElement(RI_SPECIFIC_DESCRIPTOR_ENTRY);
        }
        entryNamesToSkip.addElement("META-INF/MANIFEST.MF");
        this.writeEntriesToOutput(fileOut, entryNamesToSkip);
        fileOut.close();
        destinationFile.delete();
        boolean renamed = tmpFile.renameTo(destinationFile);
        if (!renamed) {
            throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionerrorsavingjar", "Error saving JAR"));
        }
        this.setHasArchive(true, destinationFile.toString());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

