/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.activation;

import com.sun.enterprise.activation.Activator;
import com.sun.enterprise.activation.Locator;
import com.sun.enterprise.activation.NoSuchEndPoint;
import com.sun.enterprise.activation.Repository;
import com.sun.enterprise.activation.Server;
import com.sun.enterprise.activation.ServerAlreadyActiveException;
import com.sun.enterprise.activation.ServerDef;
import com.sun.enterprise.activation.ServerHeldDownException;
import com.sun.enterprise.activation.ServerLocation;
import com.sun.enterprise.activation.ServerNotActiveException;
import com.sun.enterprise.activation.ServerNotRegisteredException;
import com.sun.enterprise.activation.ServerTableEntry;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.server.J2EEServer;
import com.sun.enterprise.util.ORBManager;
import com.sun.enterprise.util.Utility;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;

public class ServerManagerImpl
implements Activator,
Locator {
    public static final int J2EE_SERVER_ID = 0;
    private static final boolean debug = false;
    Hashtable serverTable;
    Repository repository;
    int initialPort;
    String dbDirName;
    J2EEServer j2eeServer;

    public ServerManagerImpl(Repository repository, String dbDirName, J2EEServer j2eeServer) {
        this.j2eeServer = j2eeServer;
        this.repository = repository;
        this.dbDirName = dbDirName;
        this.initialPort = ORBManager.getORBInitialPort();
        this.serverTable = new Hashtable(256);
    }

    public void activate(int serverId, boolean wait) throws RemoteException, ServerAlreadyActiveException, ServerNotRegisteredException, ServerHeldDownException {
        Integer key = new Integer(serverId);
        if (serverId == 0) {
            throw new ServerAlreadyActiveException();
        }
        ServerTableEntry entry = (ServerTableEntry)this.serverTable.get(key);
        if (entry != null && entry.isActive()) {
            throw new ServerAlreadyActiveException();
        }
        try {
            ServerLocation location = this.locateServer(serverId, 0, wait);
        }
        catch (NoSuchEndPoint ex2) {
            ex2.printStackTrace();
        }
    }

    public void active(Server server, int serverId) throws RemoteException, ServerNotRegisteredException {
        Integer key = new Integer(serverId);
        Hashtable hashtable = this.serverTable;
        synchronized (hashtable) {
            ServerTableEntry entry = (ServerTableEntry)this.serverTable.get(key);
            if (entry == null) {
                throw new INTERNAL(3003, CompletionStatus.COMPLETED_NO);
            }
            entry.register(server);
        }
    }

    public int[] getActiveServers() throws RemoteException {
        int[] list = null;
        int i2 = 0;
        Vector<ServerTableEntry> servers = new Vector<ServerTableEntry>();
        Hashtable hashtable = this.serverTable;
        synchronized (hashtable) {
            ServerTableEntry entry;
            Enumeration e10 = this.serverTable.elements();
            while (e10.hasMoreElements()) {
                entry = (ServerTableEntry)e10.nextElement();
                if (!entry.isValid() || !entry.isActive()) continue;
                servers.addElement(entry);
            }
            list = new int[servers.size() + 1];
            i2 = 0;
            while (i2 < servers.size()) {
                entry = (ServerTableEntry)servers.elementAt(i2);
                list[i2] = entry.getServerId();
                ++i2;
            }
        }
        list[i2] = 0;
        return list;
    }

    private void flushLogs() {
        if (System.out != null) {
            System.out.flush();
        }
        if (System.err != null) {
            System.err.flush();
        }
        if (Log.out != null) {
            Log.out.flush();
        }
        if (Log.err != null) {
            Log.err.flush();
        }
        if (Log.event != null) {
            Log.event.flush();
        }
    }

    public void shutdown(int serverId) throws RemoteException, ServerNotActiveException {
        Log.flushAll();
        if (serverId == 0) {
            this.j2eeServer.internalShutdown();
        } else {
            Integer key = new Integer(serverId);
            System.out.println("Shutting down server, id=" + serverId);
            ServerTableEntry entry = (ServerTableEntry)this.serverTable.remove(key);
            if (entry == null) {
                throw new ServerNotActiveException();
            }
            try {
                entry.destroy();
            }
            catch (Exception e10) {
                // empty catch block
            }
        }
    }

    private ServerLocation locateServer(int serverId, int endpointType, boolean block) throws RemoteException, NoSuchEndPoint, ServerNotRegisteredException, ServerHeldDownException {
        ServerTableEntry entry;
        Integer key = new Integer(serverId);
        boolean toActivate = false;
        ServerLocation location = null;
        if (serverId == 0) {
            return new ServerLocation(Utility.getLocalHost(), this.initialPort);
        }
        Hashtable hashtable = this.serverTable;
        synchronized (hashtable) {
            entry = (ServerTableEntry)this.serverTable.get(key);
            if (entry != null && !entry.isValid()) {
                this.serverTable.remove(key);
                entry = null;
            }
            if (entry == null) {
                ServerDef serverDef = this.repository.getServer(serverId);
                entry = new ServerTableEntry(serverId, serverDef, this.initialPort, this.dbDirName, false, true);
                this.serverTable.put(key, entry);
                toActivate = true;
            }
        }
        if (toActivate) {
            entry.activate();
        }
        if (block) {
            int port;
            try {
                port = entry.lookup();
            }
            catch (Exception ex2) {
                throw new ServerHeldDownException();
            }
            try {
                InetAddress addr = InetAddress.getLocalHost();
                String host = addr.getHostName();
                location = new ServerLocation(host, port);
            }
            catch (Exception c10) {
                c10.printStackTrace();
            }
        }
        return location;
    }

    public ServerLocation locateServer(int serverId, int endpointType) throws RemoteException, NoSuchEndPoint, ServerNotRegisteredException, ServerHeldDownException {
        return this.locateServer(serverId, endpointType, true);
    }

    public int getEndpoint(int endpointType) throws RemoteException, NoSuchEndPoint {
        return this.initialPort;
    }
}

