/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.persistence;

import com.sun.ejb.EJBUtils;
import com.sun.ejb.Partition;
import com.sun.ejb.PersistenceUtils;
import com.sun.ejb.PersistentInstance;
import com.sun.ejb.PersistentState;
import com.sun.ejb.persistence.PMSet;
import com.sun.ejb.persistence.PersistenceManagerImpl;
import com.sun.ejb.persistence.RelationshipManager;
import com.sun.enterprise.deployment.CMRFieldInfo;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.JoinObjectDescriptor;
import com.sun.enterprise.deployment.PersistenceDescriptor;
import com.sun.enterprise.deployment.PersistentFieldInfo;
import com.sun.enterprise.deployment.RelationRoleDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.EJBLocalObject;
import javax.ejb.EntityBean;
import javax.ejb.FinderException;
import javax.ejb.NoSuchEntityException;
import javax.ejb.ObjectNotFoundException;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;

public class PartitionImpl
implements Partition,
Synchronization {
    private static final boolean debug = false;
    private Transaction tx;
    private PersistenceManagerImpl pm;
    private RelationshipManager rm;
    private HashMap stateObjTable;
    private ArrayList collections;

    public PartitionImpl() {
    }

    public PartitionImpl(PersistenceManagerImpl pm, RelationshipManager rm, Transaction tx) {
        this.pm = pm;
        this.rm = rm;
        this.tx = tx;
        this.stateObjTable = new HashMap();
        this.collections = new ArrayList();
    }

    public Transaction getTransaction() {
        return this.tx;
    }

    public void cmpSet(PersistentInstance obj, String fieldName) {
        PersistentState stateObj = obj.__getPersistentState();
        if (stateObj == null) {
            stateObj = this.getPersistentState((EntityBean)((Object)obj));
            obj.__setPersistentState(stateObj);
        }
        if (stateObj.getStatus() == 3) {
            throw new IllegalStateException("Object has been deleted");
        }
    }

    public void pkeySet(PersistentInstance obj, String fieldName) {
        EjbCMPEntityDescriptor entd = (EjbCMPEntityDescriptor)obj.__getPersistenceDescriptor().getParentDescriptor();
        boolean afterEjbCreate = false;
        try {
            if (entd.isLocalInterfacesSupported()) {
                obj.__getEntityContext().getEJBLocalObject();
            } else {
                obj.__getEntityContext().getEJBObject();
            }
            afterEjbCreate = true;
        }
        catch (Exception ex2) {
            // empty catch block
        }
        if (afterEjbCreate) {
            throw new IllegalStateException("Primary key field must not be set after ejbCreate");
        }
        this.cmpSet(obj, fieldName);
    }

    public void cmpGet(PersistentInstance obj, String fieldName) {
        PersistentState stateObj = obj.__getPersistentState();
        if (stateObj == null) {
            stateObj = this.getPersistentState((EntityBean)((Object)obj));
            obj.__setPersistentState(stateObj);
        }
        if (stateObj.getStatus() == 3) {
            throw new IllegalStateException("Object has been deleted");
        }
    }

    public void cmrSet(PersistentInstance obj, int cmrFieldId, Object partner) {
        try {
            PersistentState stateObj = obj.__getPersistentState();
            if (stateObj == null) {
                stateObj = this.getPersistentState((EntityBean)((Object)obj));
                obj.__setPersistentState(stateObj);
            }
            if (stateObj.getStatus() == 3) {
                throw new IllegalStateException("Object has been deleted");
            }
            PersistenceDescriptor pers = obj.__getPersistenceDescriptor();
            CMRFieldInfo cmrFieldInfo = pers.getCMRFieldInfo()[cmrFieldId];
            this.rm.cmrSet(stateObj, pers, cmrFieldInfo, partner, this);
        }
        catch (Exception ex2) {
            EJBUtils.throwEJBException(ex2);
        }
    }

    public void cmrGet(PersistentInstance obj, int cmrFieldId) {
        try {
            PersistentState stateObj = obj.__getPersistentState();
            if (stateObj == null) {
                stateObj = this.getPersistentState((EntityBean)((Object)obj));
                obj.__setPersistentState(stateObj);
            }
            if (stateObj.getStatus() == 3) {
                throw new IllegalStateException("Object has been deleted");
            }
            PersistenceDescriptor pers = obj.__getPersistenceDescriptor();
            CMRFieldInfo cmrFieldInfo = pers.getCMRFieldInfo()[cmrFieldId];
            this.rm.cmrGet(stateObj, pers, cmrFieldInfo, this);
        }
        catch (Exception ex2) {
            EJBUtils.throwEJBException(ex2);
        }
    }

    PersistentState getOrCreateJoinObject(PersistentState source, RelationRoleDescriptor sourceRole, Object sink, JoinObjectDescriptor joinDesc, boolean shouldStore) throws Exception {
        PersistentState oldJoinObj;
        RelationRoleDescriptor sinkRole = sourceRole.getPartner();
        PersistenceDescriptor sinkPers = sinkRole.getPersistenceDescriptor();
        PersistentState sinkState = this.rm.getPersistentState(sink, sinkPers, this);
        if (sinkState != null && sinkState.getStatus() == 3) {
            throw new IllegalArgumentException("Object has been deleted");
        }
        PersistentState joinObj = null;
        PersistentKey joinKey = null;
        Object sinkPkey = null;
        if (!sourceRole.getIsMany()) {
            sinkPkey = this.pm.getPrimaryKey(sinkState);
            joinKey = new PersistentKey(joinDesc.getName(), sinkPkey);
            joinObj = (PersistentState)this.stateObjTable.get(joinKey);
            if (joinObj != null) {
                return joinObj;
            }
        } else if (!sinkRole.getIsMany()) {
            Object pkey = this.pm.getPrimaryKey(source);
            joinKey = new PersistentKey(joinDesc.getName(), pkey);
            joinObj = (PersistentState)this.stateObjTable.get(joinKey);
            if (joinObj != null) {
                return joinObj;
            }
        }
        PersistenceDescriptor joinPers = joinDesc.getPersistenceDescriptor();
        Class joinObjClass = joinPers.getPersistentClass();
        joinObj = (PersistentState)joinObjClass.newInstance();
        joinObj.__setPersistenceDescriptor(joinPers);
        joinObj.setStatus(0);
        PersistentFieldInfo[] joinFields = joinPers.getPersistentFieldInfo();
        int i2 = 0;
        while (i2 < joinFields.length) {
            Object value;
            PersistentFieldInfo joinField = joinFields[i2];
            if (joinField.relatedObj == sourceRole.getPersistenceDescriptor()) {
                Field sourceField = source.getClass().getField(joinField.relatedName);
                value = sourceField.get(source);
            } else {
                Field sinkField = sinkState.getClass().getField(joinField.relatedName);
                value = sinkField.get(sinkState);
            }
            joinField.field.set(joinObj, value);
            ++i2;
        }
        if (sourceRole.getIsMany() && sinkRole.getIsMany() && (oldJoinObj = (PersistentState)this.stateObjTable.get(joinKey = new PersistentKey(joinDesc.getName(), joinObj))) != null) {
            return oldJoinObj;
        }
        if (shouldStore) {
            this.stateObjTable.put(joinKey, joinObj);
        }
        return joinObj;
    }

    PersistentState getJoinObjForPkey(Object sourcePkey, RelationRoleDescriptor sourceRole) {
        JoinObjectDescriptor joinDesc = sourceRole.getRelationshipDescriptor().getJoinDescriptor();
        PersistentKey key = new PersistentKey(joinDesc.getName(), sourcePkey);
        return (PersistentState)this.stateObjTable.get(key);
    }

    PersistentState addJoinObject(PersistentState joinObj, JoinObjectDescriptor joinDesc, RelationRoleDescriptor sourceRole) throws Exception {
        PersistentKey joinKey;
        if (sourceRole.getIsMany()) {
            joinKey = new PersistentKey(joinDesc.getName(), joinObj);
        } else {
            Object sinkPkey = this.getJoinSinkPkey(joinObj, joinDesc, sourceRole);
            joinKey = new PersistentKey(joinDesc.getName(), sinkPkey);
        }
        PersistentState oldJoinObj = (PersistentState)this.stateObjTable.get(joinKey);
        if (oldJoinObj != null) {
            if (oldJoinObj.getStatus() == 3) {
                return null;
            }
            return oldJoinObj;
        }
        this.stateObjTable.put(joinKey, joinObj);
        return joinObj;
    }

    Object getJoinSink(Object joinObj, JoinObjectDescriptor joinDesc, RelationRoleDescriptor sourceRole) throws Exception {
        Object sinkPkey = this.getJoinSinkPkey(joinObj, joinDesc, sourceRole);
        RelationRoleDescriptor sinkRole = sourceRole.getPartner();
        EjbCMPEntityDescriptor sinkDesc = sinkRole.getOwner();
        EJBLocalObject sink = PersistenceUtils.getEJBLocalObject(sinkDesc, sinkPkey, null);
        return sink;
    }

    PersistentState getJoinSinkStateIfLoaded(Object joinObj, JoinObjectDescriptor joinDesc, RelationRoleDescriptor sourceRole) throws Exception {
        Object sinkPkey = this.getJoinSinkPkey(joinObj, joinDesc, sourceRole);
        PersistentKey key = new PersistentKey(sourceRole.getPartner().getOwner().getName(), sinkPkey);
        return (PersistentState)this.stateObjTable.get(key);
    }

    private Object getJoinSinkPkey(Object joinObj, JoinObjectDescriptor joinDesc, RelationRoleDescriptor sourceRole) throws Exception {
        Object sinkPkey = null;
        PersistenceDescriptor sourcePers = sourceRole.getPersistenceDescriptor();
        PersistenceDescriptor sinkPers = sourceRole.getPartner().getPersistenceDescriptor();
        PersistentFieldInfo[] joinFields = joinDesc.getPersistenceDescriptor().getPersistentFieldInfo();
        if (sinkPers == null || sinkPers.primaryKeyIsOneField()) {
            int i2 = 0;
            while (i2 < joinFields.length) {
                if (joinFields[i2].relatedObj != sourcePers) {
                    sinkPkey = joinFields[i2].field.get(joinObj);
                    break;
                }
                ++i2;
            }
        } else {
            Class pkeyClass = sinkPers.getPrimaryKeyClass();
            sinkPkey = pkeyClass.newInstance();
            int i3 = 0;
            while (i3 < joinFields.length) {
                if (joinFields[i3].relatedObj == sinkPers) {
                    Object value = joinFields[i3].field.get(joinObj);
                    Field sinkField = pkeyClass.getField(joinFields[i3].relatedName);
                    sinkField.set(sinkPkey, value);
                }
                ++i3;
            }
        }
        return sinkPkey;
    }

    PersistentState getOrLoadPersistentState(Object pkey, PersistenceDescriptor pers, PersistentInstance pi) {
        Descriptor desc = pers.getParentDescriptor();
        if (desc instanceof EjbCMPEntityDescriptor && !((EjbCMPEntityDescriptor)desc).isEJB20()) {
            return null;
        }
        PersistentKey key = new PersistentKey(desc.getName(), pkey);
        PersistentState stateObj = (PersistentState)this.stateObjTable.get(key);
        if (stateObj == null) {
            Class stateClass = pers.getStateClass();
            try {
                stateObj = (PersistentState)stateClass.newInstance();
            }
            catch (Exception ex2) {
                throw new EJBException(ex2);
            }
            stateObj.__setPersistenceDescriptor(pers);
            this.pm.loadRow(stateObj, pkey);
            stateObj.setStatus(1);
            this.stateObjTable.put(key, stateObj);
            if (desc instanceof JoinObjectDescriptor) {
                ((PersistentInstance)((Object)stateObj)).__setPrimaryKey(pkey);
            }
        } else {
            if (stateObj.getStatus() == 3) {
                throw new NoSuchEntityException("Entity object is already removed");
            }
            if (stateObj.getStatus() == 0) {
                this.pm.loadRow(stateObj, pkey);
                stateObj.setStatus(1);
            }
        }
        if (pi != null) {
            stateObj.setInstance(pi);
            pi.__setPersistentState(stateObj);
        }
        return stateObj;
    }

    private PersistentState createPersistentState(PersistentInstance pi) {
        PersistentState stateObj;
        PersistenceDescriptor pers = pi.__getPersistenceDescriptor();
        Descriptor desc = pers.getParentDescriptor();
        if (desc instanceof EjbCMPEntityDescriptor && !((EjbCMPEntityDescriptor)desc).isEJB20()) {
            return (PersistentState)((Object)pi);
        }
        Class stateClass = pers.getStateClass();
        try {
            stateObj = (PersistentState)stateClass.newInstance();
        }
        catch (Exception ex2) {
            throw new EJBException(ex2);
        }
        stateObj.__setPersistenceDescriptor(pers);
        stateObj.setInstance(pi);
        pi.__setPersistentState(stateObj);
        return stateObj;
    }

    private void addPersistentState(PersistentState stateObj, Object pkey, Descriptor desc) {
        if (desc instanceof EjbCMPEntityDescriptor) {
            EjbCMPEntityDescriptor ejbd = (EjbCMPEntityDescriptor)desc;
            if (ejbd.isEJB20()) {
                PersistentKey key = new PersistentKey(desc.getName(), pkey);
                this.stateObjTable.put(key, stateObj);
            }
        } else {
            PersistentKey key = new PersistentKey(desc.getName(), pkey);
            this.stateObjTable.put(key, stateObj);
        }
    }

    void addCollection(PMSet coll) {
        this.collections.add(coll);
    }

    public void ejbLoad(EntityBean ejb) {
        PersistentInstance pi = (PersistentInstance)((Object)ejb);
        Object pkey = pi.__getPrimaryKey();
        try {
            PersistenceDescriptor pers = pi.__getPersistenceDescriptor();
            Descriptor desc = pers.getParentDescriptor();
            if (((EjbCMPEntityDescriptor)desc).isEJB20()) {
                this.getOrLoadPersistentState(pkey, pers, pi);
            } else {
                PersistentState stateObj = (PersistentState)((Object)ejb);
                this.pm.loadRow(stateObj, pkey);
                stateObj.setStatus(1);
            }
        }
        catch (Exception ex2) {
            EJBUtils.throwEJBException(ex2);
        }
    }

    public void ejbStore(EntityBean ejb) {
        PersistentInstance pi = (PersistentInstance)((Object)ejb);
        PersistentState stateObj = pi.__getPersistentState();
        PersistenceDescriptor pers = pi.__getPersistenceDescriptor();
        if (!((EjbCMPEntityDescriptor)pers.getParentDescriptor()).isEJB20()) {
            this.pm.storeRow(stateObj, pi.__getPrimaryKey());
            stateObj.setStatus(1);
        } else {
            pi.__setPersistentState(null);
            if (stateObj != null) {
                stateObj.setInstance(null);
            }
        }
    }

    public PersistentState getPersistentState(EntityBean ejb) {
        PersistentInstance pi = (PersistentInstance)((Object)ejb);
        Object pkey = pi.__getPrimaryKey();
        try {
            PersistenceDescriptor pers = pi.__getPersistenceDescriptor();
            return this.getOrLoadPersistentState(pkey, pers, pi);
        }
        catch (Exception ex2) {
            EJBUtils.throwEJBException(ex2);
            return null;
        }
    }

    public void beforeEjbCreate(EntityBean ejb) {
        PersistentState stateObj = this.createPersistentState((PersistentInstance)((Object)ejb));
        this.pm.resetFields(stateObj);
    }

    public Object afterEjbCreate(EntityBean ejb) throws CreateException {
        Object pkey;
        PersistentInstance pi = (PersistentInstance)((Object)ejb);
        PersistentState stateObj = pi.__getPersistentState();
        PersistenceDescriptor pers = pi.__getPersistenceDescriptor();
        EjbCMPEntityDescriptor dd2 = (EjbCMPEntityDescriptor)pers.getParentDescriptor();
        if (!pers.primaryKeyIsSpecified()) {
            long pkeyValue = System.currentTimeMillis() + this.pm.getNextLong();
            pkey = new Long(pkeyValue);
            try {
                Field pkeyField = pers.getPkeyFieldInfo()[0].field;
                pkeyField.set(stateObj, pkey);
            }
            catch (IllegalAccessException ex2) {}
        } else {
            pkey = this.pm.getPrimaryKey(stateObj);
            if (pkey == null) {
                throw new CreateException("Primary key fields of bean not initialized.");
            }
            PersistentKey key = new PersistentKey(dd2.getName(), pkey);
            PersistentState oldObj = (PersistentState)this.stateObjTable.get(key);
            if (oldObj != null && oldObj.getStatus() != 0) {
                throw new DuplicateKeyException("Duplicate primary key");
            }
            if (this.pm.primaryKeyExists(pkey, pers)) {
                throw new DuplicateKeyException("Duplicate primary key");
            }
        }
        this.addPersistentState(stateObj, pkey, dd2);
        return pkey;
    }

    public void ejbPostCreate(EntityBean ejb) {
        ((PersistentInstance)((Object)ejb)).__getPersistentState().setStatus(2);
    }

    public void ejbRemove(EntityBean ejb) {
        PersistenceDescriptor pers;
        PersistentInstance pi = (PersistentInstance)((Object)ejb);
        PersistentState stateObj = pi.__getPersistentState();
        if (stateObj == null) {
            stateObj = this.getPersistentState(ejb);
            pi.__setPersistentState(stateObj);
        }
        if (!((EjbCMPEntityDescriptor)(pers = pi.__getPersistenceDescriptor()).getParentDescriptor()).isEJB20()) {
            if (stateObj.getStatus() != 2) {
                this.pm.removeRow(stateObj, pi.__getPrimaryKey());
            }
            stateObj.setStatus(1);
        } else {
            this.rm.nullifyAllRelationships(this, pi);
            if (stateObj.getStatus() == 2) {
                stateObj.setStatus(0);
            } else {
                stateObj.setStatus(3);
            }
            pi.__setPersistentState(null);
            stateObj.setInstance(null);
        }
    }

    public Object ejbFindByPrimaryKey(EntityBean ejb, Object pkey) throws FinderException {
        PersistentInstance pi = (PersistentInstance)((Object)ejb);
        PersistenceDescriptor pers = pi.__getPersistenceDescriptor();
        PersistentKey key = new PersistentKey(pers.getParentDescriptor().getName(), pkey);
        PersistentState ps = (PersistentState)this.stateObjTable.get(key);
        if (ps != null) {
            if (ps.getStatus() == 3 || ps.getStatus() == 0) {
                throw new ObjectNotFoundException();
            }
            return pkey;
        }
        if (!this.pm.primaryKeyExists(pkey, ((PersistentInstance)((Object)ejb)).__getPersistenceDescriptor())) {
            throw new ObjectNotFoundException("No database row for primary key");
        }
        return pkey;
    }

    public Object ejbFinder(EntityBean ejb, Method finder, Object[] params) throws FinderException {
        this.pm.beforeCompletion(this.tx, this.stateObjTable.values());
        PersistentInstance pi = (PersistentInstance)((Object)ejb);
        EjbCMPEntityDescriptor desc = (EjbCMPEntityDescriptor)pi.__getPersistenceDescriptor().getParentDescriptor();
        if (desc.isEJB20()) {
            return this.pm.getSQLEngine().ejb20Finder(ejb, finder, params, desc);
        }
        return this.pm.getSQLEngine().ejb11Finder(ejb, finder, params, desc);
    }

    public Object ejbSelector(PersistentInstance pi, Method selector, Object[] params) throws FinderException {
        this.pm.beforeCompletion(this.tx, this.stateObjTable.values());
        PersistenceDescriptor pers = pi.__getPersistenceDescriptor();
        return this.pm.getSQLEngine().ejbSelector(pi, selector, params, pers, this);
    }

    public void beforeCompletion() {
        this.pm.beforeCompletion(this.tx, this.stateObjTable.values());
    }

    public void afterCompletion(int status) {
        this.pm.releasePartition(this);
        this.stateObjTable = null;
        int i2 = 0;
        while (i2 < this.collections.size()) {
            PMSet coll = (PMSet)this.collections.get(i2);
            coll.invalidate();
            ++i2;
        }
        this.collections = null;
    }

    private class PersistentKey {
        String ddName;
        Object pkey;

        PersistentKey(String ddName, Object pkey) {
            this.ddName = ddName;
            this.pkey = pkey;
        }

        public final boolean equals(Object other) {
            if (!(other instanceof PersistentKey)) {
                return false;
            }
            PersistentKey otherKey = (PersistentKey)other;
            if (!this.ddName.equals(otherKey.ddName)) {
                return false;
            }
            return this.pkey.equals(otherKey.pkey);
        }

        public final int hashCode() {
            return this.pkey.hashCode();
        }

        public String toString() {
            return "Type: " + this.ddName + " Pkey: " + this.pkey;
        }
    }
}

