/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.persistence;

import com.sun.ejb.EJBUtils;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public final class JDBCUtils {
    private static final boolean debug = true;

    public static void copyObjToDB(PreparedStatement stmt, int param, Object obj, int type) throws SQLException {
        switch (type) {
            case 1: {
                if (obj == null) {
                    stmt.setNull(param, type);
                    break;
                }
                stmt.setString(param, ((Character)obj).toString());
                break;
            }
            case -7: 
            case -6: 
            case -5: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                if (obj == null) {
                    stmt.setNull(param, type);
                    break;
                }
                stmt.setObject(param, obj);
                break;
            }
            case -4: {
                if (obj == null) {
                    stmt.setNull(param, type);
                    break;
                }
                stmt.setBytes(param, (byte[])obj);
                break;
            }
            case 12: {
                if (obj == null) {
                    stmt.setNull(param, type);
                    break;
                }
                stmt.setString(param, (String)obj);
                break;
            }
            case 2: {
                if (obj == null) {
                    stmt.setNull(param, type);
                    break;
                }
                stmt.setBigDecimal(param, (BigDecimal)obj);
                break;
            }
            case 91: {
                if (obj == null) {
                    stmt.setNull(param, type);
                    break;
                }
                stmt.setDate(param, (Date)obj);
                break;
            }
            case 92: {
                if (obj == null) {
                    stmt.setNull(param, type);
                    break;
                }
                stmt.setTime(param, (Time)obj);
                break;
            }
            case 93: {
                if (obj == null) {
                    stmt.setNull(param, type);
                    break;
                }
                stmt.setTimestamp(param, (Timestamp)obj);
                break;
            }
            case 2000: {
                byte[] buf;
                if (obj == null) {
                    stmt.setNull(param, -4);
                    break;
                }
                try {
                    buf = EJBUtils.serializeObject(obj);
                }
                catch (Exception ex2) {
                    throw new RuntimeException("Unable to serialize container-managed field." + ex2);
                }
                stmt.setBytes(param, buf);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported JDBC type: " + type);
            }
        }
    }

    public static void copyFieldToDB(final PreparedStatement stmt, final int param, final Field field, final Object obj, final int type) throws SQLException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws SQLException {
                    JDBCUtils.copyFieldToDBInternal(stmt, param, field, obj, type);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e10) {
            throw (SQLException)e10.getException();
        }
    }

    private static void copyFieldToDBInternal(PreparedStatement stmt, int param, Field field, Object obj, int type) throws SQLException {
        Object value = null;
        try {
            switch (type) {
                case 1: {
                    value = field.get(obj);
                    if (value == null) {
                        stmt.setNull(param, type);
                        break;
                    }
                    stmt.setString(param, ((Character)value).toString());
                    break;
                }
                case -7: 
                case -6: 
                case -5: 
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    value = field.get(obj);
                    if (value == null) {
                        stmt.setNull(param, type);
                        break;
                    }
                    stmt.setObject(param, value);
                    break;
                }
                case -4: {
                    value = field.get(obj);
                    if (value == null) {
                        stmt.setNull(param, type);
                        break;
                    }
                    stmt.setBytes(param, (byte[])value);
                    break;
                }
                case 12: {
                    value = field.get(obj);
                    if (value == null) {
                        stmt.setNull(param, type);
                        break;
                    }
                    stmt.setString(param, (String)value);
                    break;
                }
                case 2: {
                    value = field.get(obj);
                    if (value == null) {
                        stmt.setNull(param, type);
                        break;
                    }
                    stmt.setBigDecimal(param, (BigDecimal)value);
                    break;
                }
                case 91: {
                    value = field.get(obj);
                    if (value == null) {
                        stmt.setNull(param, type);
                        break;
                    }
                    stmt.setDate(param, (Date)value);
                    break;
                }
                case 92: {
                    value = field.get(obj);
                    if (value == null) {
                        stmt.setNull(param, type);
                        break;
                    }
                    stmt.setTime(param, (Time)value);
                    break;
                }
                case 93: {
                    value = field.get(obj);
                    if (value == null) {
                        stmt.setNull(param, type);
                        break;
                    }
                    stmt.setTimestamp(param, (Timestamp)value);
                    break;
                }
                case 2000: {
                    byte[] buf;
                    value = field.get(obj);
                    if (value == null) {
                        stmt.setNull(param, -4);
                        break;
                    }
                    try {
                        buf = EJBUtils.serializeObject(value);
                    }
                    catch (Exception ex2) {
                        throw new RuntimeException("Unable to serialize container-managed field." + ex2);
                    }
                    stmt.setBytes(param, buf);
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported JDBC type: " + type);
                }
            }
        }
        catch (IllegalAccessException ex3) {
            throw new RuntimeException("Field not accessible: " + ex3);
        }
        catch (IllegalArgumentException ex4) {
            System.err.println("IllegalArgumentException: field=" + field + " obj=" + obj + " type=" + type);
            throw ex4;
        }
    }

    public static void copyFieldFromDB(final ResultSet result, final int param, final Field field, final Object obj, final int type) throws SQLException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws SQLException {
                    JDBCUtils.copyFieldFromDBInternal(result, param, field, obj, type);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e10) {
            throw (SQLException)e10.getException();
        }
    }

    private static void copyFieldFromDBInternal(ResultSet result, int param, Field field, Object obj, int type) throws SQLException {
        boolean isPrimitive = field.getType().isPrimitive();
        try {
            switch (type) {
                case 4: {
                    if (isPrimitive) {
                        field.setInt(obj, result.getInt(param));
                        break;
                    }
                    int i2 = result.getInt(param);
                    if (result.wasNull()) {
                        field.set(obj, null);
                        break;
                    }
                    field.set(obj, new Integer(i2));
                    break;
                }
                case -7: {
                    if (isPrimitive) {
                        field.setBoolean(obj, result.getBoolean(param));
                        break;
                    }
                    boolean b10 = result.getBoolean(param);
                    if (result.wasNull()) {
                        field.set(obj, null);
                        break;
                    }
                    field.set(obj, new Boolean(b10));
                    break;
                }
                case -6: {
                    if (isPrimitive) {
                        field.setByte(obj, result.getByte(param));
                        break;
                    }
                    byte b11 = result.getByte(param);
                    if (result.wasNull()) {
                        field.set(obj, null);
                        break;
                    }
                    field.set(obj, new Byte(b11));
                    break;
                }
                case 1: {
                    if (isPrimitive) {
                        field.setChar(obj, result.getString(param).charAt(0));
                        break;
                    }
                    String s2 = result.getString(param);
                    if (s2 == null) {
                        field.set(obj, null);
                        break;
                    }
                    field.set(obj, new Character(s2.charAt(0)));
                    break;
                }
                case 5: {
                    if (isPrimitive) {
                        field.setShort(obj, result.getShort(param));
                        break;
                    }
                    short s3 = result.getShort(param);
                    if (result.wasNull()) {
                        field.set(obj, null);
                        break;
                    }
                    field.set(obj, new Short(s3));
                    break;
                }
                case -5: {
                    if (isPrimitive) {
                        field.setLong(obj, result.getLong(param));
                        break;
                    }
                    long l2 = result.getLong(param);
                    if (result.wasNull()) {
                        field.set(obj, null);
                        break;
                    }
                    field.set(obj, new Long(l2));
                    break;
                }
                case 7: {
                    if (isPrimitive) {
                        field.setFloat(obj, result.getFloat(param));
                        break;
                    }
                    float f2 = result.getFloat(param);
                    if (result.wasNull()) {
                        field.set(obj, null);
                        break;
                    }
                    field.set(obj, new Float(f2));
                    break;
                }
                case 8: {
                    if (isPrimitive) {
                        field.setDouble(obj, result.getDouble(param));
                        break;
                    }
                    double d10 = result.getDouble(param);
                    if (result.wasNull()) {
                        field.set(obj, null);
                        break;
                    }
                    field.set(obj, new Double(d10));
                    break;
                }
                case -4: {
                    field.set(obj, result.getBytes(param));
                    break;
                }
                case 12: {
                    field.set(obj, result.getString(param));
                    break;
                }
                case 2: {
                    field.set(obj, result.getBigDecimal(param));
                    break;
                }
                case 91: {
                    field.set(obj, result.getDate(param));
                    break;
                }
                case 92: {
                    field.set(obj, result.getTime(param));
                    break;
                }
                case 93: {
                    field.set(obj, result.getTimestamp(param));
                    break;
                }
                case 2000: {
                    Object resultObj;
                    byte[] value = result.getBytes(param);
                    if (result.wasNull() || value.length == 0) {
                        resultObj = null;
                    } else {
                        try {
                            resultObj = EJBUtils.deserializeObject(value, field.getDeclaringClass().getClassLoader());
                        }
                        catch (Exception ex2) {
                            ex2.printStackTrace();
                            throw new RuntimeException("Unable to deserialize field: " + ex2);
                        }
                    }
                    field.set(obj, resultObj);
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported JDBC type: " + type);
                }
            }
        }
        catch (IllegalAccessException ex3) {
            throw new RuntimeException("Field not accessible: " + ex3);
        }
    }

    public static Object getObjFromDB(ResultSet result, int type, ClassLoader loader) throws SQLException {
        Object obj;
        switch (type) {
            case 4: {
                obj = new Integer(result.getInt(1));
                break;
            }
            case -7: {
                obj = new Boolean(result.getBoolean(1));
                break;
            }
            case -6: {
                obj = new Byte(result.getByte(1));
                break;
            }
            case 1: {
                obj = new Character(result.getString(1).charAt(0));
                break;
            }
            case 5: {
                obj = new Short(result.getShort(1));
                break;
            }
            case -5: {
                obj = new Long(result.getLong(1));
                break;
            }
            case 7: {
                obj = new Float(result.getFloat(1));
                break;
            }
            case 8: {
                obj = new Double(result.getDouble(1));
                break;
            }
            case -4: {
                obj = result.getBytes(1);
                break;
            }
            case 12: {
                obj = result.getString(1);
                break;
            }
            case 2: {
                obj = result.getBigDecimal(1);
                break;
            }
            case 91: {
                obj = result.getDate(1);
                break;
            }
            case 92: {
                obj = result.getTime(1);
                break;
            }
            case 93: {
                obj = result.getTimestamp(1);
                break;
            }
            case 2000: {
                try {
                    obj = EJBUtils.deserializeObject(result.getBytes(1), loader);
                    break;
                }
                catch (Exception ex2) {
                    throw new RuntimeException("Unable to deserialize object." + ex2);
                }
            }
            default: {
                throw new RuntimeException("Unsupported JDBC type: " + type);
            }
        }
        return result.wasNull() ? null : obj;
    }
}

