/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.ejbql.parser;

import com.sun.ejb.ejbql.parser.Token;

public class ParseException
extends Exception {
    protected boolean specialConstructor;
    public Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;
    protected String eol = System.getProperty("line.separator", "\n");

    public ParseException(Token currentTokenVal, int[][] expectedTokenSequencesVal, String[] tokenImageVal) {
        super("");
        this.specialConstructor = true;
        this.currentToken = currentTokenVal;
        this.expectedTokenSequences = expectedTokenSequencesVal;
        this.tokenImage = tokenImageVal;
    }

    public ParseException() {
        this.specialConstructor = false;
    }

    public ParseException(String message) {
        super(message);
        this.specialConstructor = false;
    }

    public String getMessage() {
        if (!this.specialConstructor) {
            return super.getMessage();
        }
        String expected = "";
        int maxSize = 0;
        int i2 = 0;
        while (i2 < this.expectedTokenSequences.length) {
            if (maxSize < this.expectedTokenSequences[i2].length) {
                maxSize = this.expectedTokenSequences[i2].length;
            }
            int j2 = 0;
            while (j2 < this.expectedTokenSequences[i2].length) {
                expected = expected + this.tokenImage[this.expectedTokenSequences[i2][j2]] + " ";
                ++j2;
            }
            if (this.expectedTokenSequences[i2][this.expectedTokenSequences[i2].length - 1] != 0) {
                expected = expected + "...";
            }
            expected = expected + this.eol + "    ";
            ++i2;
        }
        String retval = "Encountered \"";
        Token tok = this.currentToken.next;
        int i3 = 0;
        while (i3 < maxSize) {
            if (i3 != 0) {
                retval = retval + " ";
            }
            if (tok.kind == 0) {
                retval = retval + this.tokenImage[0];
                break;
            }
            retval = retval + this.add_escapes(tok.image);
            tok = tok.next;
            ++i3;
        }
        retval = retval + "\" at line " + this.currentToken.next.beginLine + ", column " + this.currentToken.next.beginColumn + "." + this.eol;
        retval = this.expectedTokenSequences.length == 1 ? retval + "Was expecting:" + this.eol + "    " : retval + "Was expecting one of:" + this.eol + "    ";
        retval = retval + expected;
        return retval;
    }

    protected String add_escapes(String str) {
        StringBuffer retval = new StringBuffer();
        int i2 = 0;
        while (i2 < str.length()) {
            switch (str.charAt(i2)) {
                case '\u0000': {
                    break;
                }
                case '\b': {
                    retval.append("\\b");
                    break;
                }
                case '\t': {
                    retval.append("\\t");
                    break;
                }
                case '\n': {
                    retval.append("\\n");
                    break;
                }
                case '\f': {
                    retval.append("\\f");
                    break;
                }
                case '\r': {
                    retval.append("\\r");
                    break;
                }
                case '\"': {
                    retval.append("\\\"");
                    break;
                }
                case '\'': {
                    retval.append("\\'");
                    break;
                }
                case '\\': {
                    retval.append("\\\\");
                    break;
                }
                default: {
                    char ch2 = str.charAt(i2);
                    if (ch2 < ' ' || ch2 > '~') {
                        String s2 = "0000" + Integer.toString(ch2, 16);
                        retval.append("\\u" + s2.substring(s2.length() - 4, s2.length()));
                        break;
                    }
                    retval.append(ch2);
                }
            }
            ++i2;
        }
        return retval.toString();
    }
}

