/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.ejbql;

import com.sun.ejb.ejbql.CmrField;
import com.sun.enterprise.deployment.CMRFieldInfo;
import com.sun.enterprise.deployment.JoinObjectDescriptor;
import com.sun.enterprise.deployment.PersistenceDescriptor;
import com.sun.enterprise.deployment.PersistentFieldInfo;
import com.sun.enterprise.deployment.RelationshipDescriptor;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;

public class RelationshipInfo {
    private CmrField cmrField_;
    private Vector sourceFields_;
    private Vector sinkFields_;
    private Vector joinSourceFields_;
    private Vector joinSinkFields_;

    public RelationshipInfo(CmrField cmrField) {
        this.cmrField_ = cmrField;
        this.sourceFields_ = new Vector();
        this.sinkFields_ = new Vector();
        this.joinSourceFields_ = new Vector();
        this.joinSinkFields_ = new Vector();
        this.init();
    }

    private void init() {
        if (this.cmrField_.hasJoinTable()) {
            RelationshipDescriptor relationshipDesc = this.cmrField_.getRelationshipDescriptor();
            PersistenceDescriptor joinTablePersistenceDesc = relationshipDesc.getJoinDescriptor().getPersistenceDescriptor();
            PersistentFieldInfo[] joinTableFields = joinTablePersistenceDesc.getPersistentFieldInfo();
            PersistenceDescriptor sourcePersistenceDesc = this.cmrField_.getSourcePersistenceDescriptor();
            PersistenceDescriptor sinkPersistenceDesc = this.cmrField_.getSinkPersistenceDescriptor();
            int i2 = 0;
            while (i2 < joinTableFields.length) {
                PersistentFieldInfo next = joinTableFields[i2];
                PersistenceDescriptor relatedObj = next.relatedObj;
                if (relatedObj != null) {
                    PersistentFieldInfo pkeyInfo = relatedObj.getPkeyFieldInfoByName(next.relatedName);
                    if (relatedObj.getTableName().equals(sourcePersistenceDesc.getTableName())) {
                        this.sourceFields_.add(pkeyInfo.columnName);
                        this.joinSourceFields_.add(next.columnName);
                    } else if (sinkPersistenceDesc != null && relatedObj.getTableName().equals(sinkPersistenceDesc.getTableName())) {
                        this.sinkFields_.add(pkeyInfo.columnName);
                        this.joinSinkFields_.add(next.columnName);
                    } else {
                        throw new IllegalArgumentException("Invalid join table field = " + joinTablePersistenceDesc.getTableName() + " : " + next.columnName);
                    }
                }
                ++i2;
            }
        } else {
            CMRFieldInfo cmrFieldInfo = this.cmrField_.getCMRFieldInfo();
            int i3 = 0;
            while (i3 < cmrFieldInfo.fkeyFields.length) {
                PersistentFieldInfo source = cmrFieldInfo.fkeyFields[i3];
                this.sourceFields_.add(source.columnName);
                PersistenceDescriptor sinkPersistenceDesc = this.cmrField_.getSinkPersistenceDescriptor();
                PersistentFieldInfo sink = sinkPersistenceDesc.getPkeyFieldInfoByName(source.relatedName);
                this.sinkFields_.add(sink.columnName);
                ++i3;
            }
        }
    }

    public Iterator getSourceFields() {
        return ((AbstractList)this.sourceFields_).iterator();
    }

    public Iterator getSinkFields() {
        return ((AbstractList)this.sinkFields_).iterator();
    }

    public boolean hasJoinTable() {
        return this.cmrField_.hasJoinTable();
    }

    public String getJoinTableName() {
        if (this.hasJoinTable()) {
            JoinObjectDescriptor joinDesc = this.cmrField_.getRelationshipDescriptor().getJoinDescriptor();
            return joinDesc.getPersistenceDescriptor().getTableName();
        }
        throw new IllegalArgumentException("no join table for " + this.cmrField_.getName());
    }

    public Iterator getJoinSourceFields() {
        return ((AbstractList)this.joinSourceFields_).iterator();
    }

    public Iterator getJoinSinkFields() {
        return ((AbstractList)this.joinSinkFields_).iterator();
    }
}

