/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.containers.MessageBeanContainer;
import com.sun.ejb.containers.MessageBeanHelper;
import com.sun.ejb.containers.ServerSessionImpl;
import com.sun.enterprise.ServerConfiguration;
import com.sun.enterprise.Switch;
import com.sun.enterprise.util.PoolBase;
import com.sun.jms.spi.ServerSession;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;

public class ServerSessionPoolImpl
implements ServerSessionPool {
    private static final boolean debug = false;
    private static final long DEFAULT_CLEANUP_INTERVAL = 600L;
    private static final String CLEANUP_INTERVAL_PROP = "messagebean.cleanup.interval";
    private MessageBeanHelper msgBeanHelper_;
    private MessageBeanContainer container_;
    private SessionPool pool_;
    private ServerSessionReaper reaper_;

    public ServerSessionPoolImpl(MessageBeanHelper msgBeanHelper, MessageBeanContainer container, int initialSize) throws Exception {
        this.msgBeanHelper_ = msgBeanHelper;
        this.container_ = container;
        this.pool_ = new SessionPool(initialSize);
        this.pool_.initialize();
        Timer timer = Switch.getSwitch().getTimer();
        this.reaper_ = new ServerSessionReaper();
        long cleanupInterval = this.getCleanupInterval() * 1000L;
        timer.scheduleAtFixedRate((TimerTask)this.reaper_, cleanupInterval, cleanupInterval);
    }

    private long getCleanupInterval() {
        long cleanupInterval = 600L;
        ServerConfiguration serverConfig = ServerConfiguration.getConfiguration();
        String cleanupIntervalProp = serverConfig.getProperty(CLEANUP_INTERVAL_PROP);
        if (cleanupIntervalProp != null) {
            long value = Long.parseLong(cleanupIntervalProp);
            if (value > 0L) {
                cleanupInterval = value;
            } else {
                System.err.println("Error -- invalid cleanup interval prop =" + value);
            }
        }
        return cleanupInterval;
    }

    public javax.jms.ServerSession getServerSession() throws JMSException {
        ServerSession serverSession = null;
        try {
            long initialTime = 0L;
            serverSession = (ServerSession)this.pool_.getItem();
        }
        catch (InterruptedException ie) {
            JMSException jmse = new JMSException("Couldn't get server session" + ie);
            jmse.setLinkedException(ie);
            throw jmse;
        }
        return serverSession;
    }

    public synchronized void close() {
        this.reaper_.cancel();
        this.pool_.close();
    }

    void release(ServerSession serverSession) {
        this.pool_.returnItem(serverSession);
    }

    private void reap() {
        this.pool_.reap();
    }

    private class ServerSessionReaper
    extends TimerTask {
        private ServerSessionReaper() {
        }

        public void run() {
            ServerSessionPoolImpl.this.reap();
        }
    }

    private class SessionPool
    extends PoolBase {
        int size_;
        private LinkedList initial_;
        private LinkedList ready_;
        private LinkedList inUse_;
        private LinkedList reaperList_;

        public SessionPool(int initialSize) {
            super(initialSize);
            this.size_ = initialSize;
            this.initial_ = new LinkedList();
            this.ready_ = new LinkedList();
            this.inUse_ = new LinkedList();
            this.reaperList_ = new LinkedList();
        }

        protected void doInitializeItems(int numItems) throws Exception {
            int itemIndex = 0;
            while (itemIndex < numItems) {
                ServerSessionImpl serverSession = new ServerSessionImpl(ServerSessionPoolImpl.this.msgBeanHelper_, ServerSessionPoolImpl.this.container_, ServerSessionPoolImpl.this);
                this.initial_.addLast(serverSession);
                ++itemIndex;
            }
        }

        protected synchronized Object doGet() {
            Object serverSession = !this.ready_.isEmpty() ? this.ready_.removeFirst() : (!this.reaperList_.isEmpty() ? this.reaperList_.removeFirst() : this.initial_.removeFirst());
            this.inUse_.add(serverSession);
            return serverSession;
        }

        protected synchronized boolean doReturn(Object object) {
            boolean allowReturn = false;
            if (this.inUse_.contains(object)) {
                this.inUse_.remove(object);
                this.ready_.addFirst(object);
                allowReturn = true;
            }
            return allowReturn;
        }

        protected synchronized void close() {
            Iterator iter = this.reaperList_.iterator();
            while (iter.hasNext()) {
                ServerSessionImpl serverSession = (ServerSessionImpl)iter.next();
                serverSession.cleanup();
            }
            Iterator iter2 = this.ready_.iterator();
            while (iter2.hasNext()) {
                ServerSessionImpl serverSession = (ServerSessionImpl)iter2.next();
                serverSession.cleanup();
            }
        }

        protected synchronized void reap() {
            Iterator iter = this.reaperList_.iterator();
            while (iter.hasNext()) {
                ServerSessionImpl next = (ServerSessionImpl)iter.next();
                next.cleanup();
            }
            this.initial_.addAll(this.reaperList_);
            this.reaperList_.clear();
            this.reaperList_.addAll(this.ready_);
            this.ready_.clear();
        }
    }
}

