/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.iiop;

import com.sun.corba.ee.internal.core.ClientResponse;
import com.sun.corba.ee.internal.core.IOR;
import com.sun.corba.ee.internal.core.ServiceContexts;
import com.sun.corba.ee.internal.iiop.IIOPInputStream;
import com.sun.corba.ee.internal.iiop.ORB;
import com.sun.corba.ee.internal.iiop.messages.ReplyMessage;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.InputStream;

class LocalClientResponseImpl
extends IIOPInputStream
implements ClientResponse {
    private ReplyMessage reply;
    private SystemException systemException;

    LocalClientResponseImpl(ORB oRB, byte[] byArray, ReplyMessage replyMessage) {
        super(oRB, byArray, replyMessage.getSize(), replyMessage.isLittleEndian(), replyMessage, null);
        this.reply = replyMessage;
        this.setIndex(12);
        this.reply.read((InputStream)this);
    }

    LocalClientResponseImpl(SystemException systemException) {
        this.systemException = systemException;
    }

    public boolean isSystemException() {
        if (this.reply != null) {
            return this.reply.getReplyStatus() == 2;
        }
        return this.systemException != null;
    }

    public boolean isUserException() {
        if (this.reply != null) {
            return this.reply.getReplyStatus() == 1;
        }
        return false;
    }

    public boolean isLocationForward() {
        if (this.reply != null) {
            return this.reply.getReplyStatus() == 3 || this.reply.getReplyStatus() == 4;
        }
        return false;
    }

    public boolean isDifferentAddrDispositionRequested() {
        if (this.reply != null) {
            return this.reply.getReplyStatus() == 5;
        }
        return false;
    }

    public short getAddrDisposition() {
        if (this.reply != null) {
            return this.reply.getAddrDisposition();
        }
        throw new INTERNAL("Null reply in getAddrDisposition", 1398079718, CompletionStatus.COMPLETED_MAYBE);
    }

    public IOR getForwardedIOR() {
        if (this.reply != null) {
            return this.reply.getIOR();
        }
        return null;
    }

    public int getRequestId() {
        if (this.reply != null) {
            return this.reply.getRequestId();
        }
        throw new INTERNAL("Error in getRequestId");
    }

    public ServiceContexts getServiceContexts() {
        if (this.reply != null) {
            return this.reply.getServiceContexts();
        }
        return null;
    }

    public SystemException getSystemException() {
        if (this.reply != null) {
            return this.reply.getSystemException();
        }
        return this.systemException;
    }

    public String peekUserExceptionId() {
        this.mark(Integer.MAX_VALUE);
        String string = this.read_string();
        this.reset();
        return string;
    }

    public boolean isLocal() {
        return true;
    }
}

