/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.Interceptors;

import com.sun.corba.ee.internal.Interceptors.PIORB;
import com.sun.corba.ee.internal.Interceptors.SlotTable;
import java.util.ArrayList;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;

public class SlotTableStack {
    private ArrayList tableContainer;
    private int currentIndex;
    private SlotTablePool tablePool;
    private PIORB piOrb;

    SlotTableStack(PIORB pIORB, SlotTable slotTable) {
        this.piOrb = pIORB;
        this.currentIndex = 0;
        this.tableContainer = new ArrayList();
        this.tablePool = new SlotTablePool();
        this.tableContainer.add(this.currentIndex, slotTable);
        ++this.currentIndex;
    }

    void pushSlotTable() {
        SlotTable slotTable = this.tablePool.getSlotTable();
        if (slotTable == null) {
            SlotTable slotTable2 = this.peekSlotTable();
            slotTable = new SlotTable(this.piOrb, slotTable2.getSize());
        }
        this.tableContainer.add(this.currentIndex, slotTable);
        ++this.currentIndex;
    }

    void popSlotTable() {
        if (this.currentIndex <= 1) {
            throw new INTERNAL("Cannot pop the only PICurrent in the stack", 1398080300, CompletionStatus.COMPLETED_NO);
        }
        --this.currentIndex;
        SlotTable slotTable = (SlotTable)this.tableContainer.get(this.currentIndex);
        slotTable.resetSlots();
        this.tablePool.putSlotTable(slotTable);
    }

    SlotTable peekSlotTable() {
        return (SlotTable)this.tableContainer.get(this.currentIndex - 1);
    }

    private class SlotTablePool {
        private SlotTable[] pool = new SlotTable[5];
        private final int HIGH_WATER_MARK = 5;
        private int currentIndex = 0;

        SlotTablePool() {
        }

        void putSlotTable(SlotTable slotTable) {
            if (this.currentIndex >= 5) {
                return;
            }
            this.pool[this.currentIndex] = slotTable;
            ++this.currentIndex;
        }

        SlotTable getSlotTable() {
            if (this.currentIndex == 0) {
                return null;
            }
            --this.currentIndex;
            return this.pool[this.currentIndex];
        }
    }
}

