/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.Activation;

import com.sun.corba.ee.ActivationIDL.BadServerDefinition;
import com.sun.corba.ee.ActivationIDL.RepositoryPackage.ServerDef;
import com.sun.corba.ee.ActivationIDL.ServerAlreadyInstalled;
import com.sun.corba.ee.ActivationIDL.ServerAlreadyRegistered;
import com.sun.corba.ee.ActivationIDL.ServerAlreadyUninstalled;
import com.sun.corba.ee.ActivationIDL.ServerNotRegistered;
import com.sun.corba.ee.ActivationIDL._RepositoryImplBase;
import com.sun.corba.ee.internal.Activation.ServerTableEntry;
import com.sun.corba.ee.internal.POA.POAORB;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.ORB;

public class RepositoryImpl
extends _RepositoryImplBase
implements Serializable {
    private static final long serialVersionUID = 8458417785209341858L;
    private transient boolean debug = false;
    static final int illegalServerId = -1;
    private transient RepositoryDB db = null;
    transient POAORB orb = null;

    RepositoryImpl(POAORB pOAORB, File file, boolean bl2) {
        this.debug = bl2;
        File file2 = new File(file, "servers.db");
        if (!file2.exists()) {
            this.db = new RepositoryDB(file2);
            this.db.flush();
        } else {
            try {
                FileInputStream fileInputStream = new FileInputStream(file2);
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                this.db = (RepositoryDB)objectInputStream.readObject();
                objectInputStream.close();
            }
            catch (Exception exception) {
                System.err.println(exception.toString());
                System.err.println("Unable to read IMR Database!");
                throw new INITIALIZE(1398079889, CompletionStatus.COMPLETED_NO);
            }
        }
        this.orb = pOAORB;
        pOAORB.connect(this);
    }

    private String printServerDef(ServerDef serverDef) {
        return "ServerDef[applicationName=" + serverDef.applicationName + " serverName=" + serverDef.serverName + " serverClassPath=" + serverDef.serverClassPath + " serverArgs=" + serverDef.serverArgs + " serverVmArgs=" + serverDef.serverVmArgs + "]";
    }

    public int registerServer(ServerDef serverDef, int n2) throws ServerAlreadyRegistered {
        DBServerDef dBServerDef = null;
        RepositoryDB repositoryDB = this.db;
        synchronized (repositoryDB) {
            Enumeration enumeration = this.db.serverTable.elements();
            while (enumeration.hasMoreElements()) {
                dBServerDef = (DBServerDef)enumeration.nextElement();
                if (!serverDef.applicationName.equals(dBServerDef.applicationName)) continue;
                if (this.debug) {
                    System.out.println("RepositoryImpl: registerServer called to register ServerDef " + this.printServerDef(serverDef) + " with " + (n2 == -1 ? "a new server Id" : "server Id " + n2) + " FAILED because it is already registered.");
                }
                throw new ServerAlreadyRegistered(dBServerDef.id);
            }
            int n3 = n2 == -1 ? this.db.incrementServerIdCounter() : n2;
            dBServerDef = new DBServerDef(serverDef, n3);
            this.db.serverTable.put(new Integer(n3), dBServerDef);
            this.db.flush();
            if (this.debug) {
                if (n2 == -1) {
                    System.out.println("RepositoryImpl: registerServer called to register ServerDef " + this.printServerDef(serverDef) + " with new serverId " + n3);
                } else {
                    System.out.println("RepositoryImpl: registerServer called to register ServerDef " + this.printServerDef(serverDef) + " with assigned serverId " + n3);
                }
            }
            int n4 = n3;
            return n4;
        }
    }

    public int registerServer(ServerDef serverDef) throws ServerAlreadyRegistered, BadServerDefinition {
        int n2 = this.orb.getServerGIOP().getBootstrapEndpoint(0).getPort();
        ServerTableEntry serverTableEntry = new ServerTableEntry(-1, serverDef, n2, "", true, this.debug);
        switch (serverTableEntry.verify()) {
            case 0: {
                break;
            }
            case 1: {
                throw new BadServerDefinition("main class not found.");
            }
            case 2: {
                throw new BadServerDefinition("no main method found.");
            }
            case 3: {
                throw new BadServerDefinition("server application error.");
            }
            default: {
                throw new BadServerDefinition("unknown Exception.");
            }
        }
        return this.registerServer(serverDef, -1);
    }

    public void unregisterServer(int n2) throws ServerNotRegistered {
        DBServerDef dBServerDef = null;
        Integer n3 = new Integer(n2);
        RepositoryDB repositoryDB = this.db;
        synchronized (repositoryDB) {
            dBServerDef = (DBServerDef)this.db.serverTable.get(n3);
            if (dBServerDef == null) {
                if (this.debug) {
                    System.out.println("RepositoryImpl: unregisterServer for serverId " + n2 + " called: server not registered");
                }
                throw new ServerNotRegistered();
            }
            this.db.serverTable.remove(n3);
            this.db.flush();
        }
        if (this.debug) {
            System.out.println("RepositoryImpl: unregisterServer for serverId " + n2 + " called");
        }
    }

    private DBServerDef getDBServerDef(int n2) throws ServerNotRegistered {
        Integer n3 = new Integer(n2);
        DBServerDef dBServerDef = (DBServerDef)this.db.serverTable.get(n3);
        if (dBServerDef == null) {
            throw new ServerNotRegistered(n2);
        }
        return dBServerDef;
    }

    public ServerDef getServer(int n2) throws ServerNotRegistered {
        DBServerDef dBServerDef = this.getDBServerDef(n2);
        ServerDef serverDef = new ServerDef(dBServerDef.applicationName, dBServerDef.name, dBServerDef.classPath, dBServerDef.args, dBServerDef.vmArgs);
        if (this.debug) {
            System.out.println("RepositoryImpl: getServer for serverId " + n2 + " returns " + this.printServerDef(serverDef));
        }
        return serverDef;
    }

    public boolean isInstalled(int n2) throws ServerNotRegistered {
        DBServerDef dBServerDef = this.getDBServerDef(n2);
        return dBServerDef.isInstalled;
    }

    public void install(int n2) throws ServerNotRegistered, ServerAlreadyInstalled {
        DBServerDef dBServerDef = this.getDBServerDef(n2);
        if (dBServerDef.isInstalled) {
            throw new ServerAlreadyInstalled(n2);
        }
        dBServerDef.isInstalled = true;
        this.db.flush();
    }

    public void uninstall(int n2) throws ServerNotRegistered, ServerAlreadyUninstalled {
        DBServerDef dBServerDef = this.getDBServerDef(n2);
        if (!dBServerDef.isInstalled) {
            throw new ServerAlreadyUninstalled(n2);
        }
        dBServerDef.isInstalled = false;
        this.db.flush();
    }

    public int[] listRegisteredServers() {
        RepositoryDB repositoryDB = this.db;
        synchronized (repositoryDB) {
            Object object;
            int n2 = 0;
            int[] nArray = new int[this.db.serverTable.size()];
            Enumeration enumeration = this.db.serverTable.elements();
            while (enumeration.hasMoreElements()) {
                object = (DBServerDef)enumeration.nextElement();
                nArray[n2++] = ((DBServerDef)object).id;
            }
            if (this.debug) {
                object = new StringBuffer();
                int n3 = 0;
                while (n3 < nArray.length) {
                    ((StringBuffer)object).append(' ');
                    ((StringBuffer)object).append(nArray[n3]);
                    ++n3;
                }
                System.out.println("RepositoryImpl: listRegisteredServers returns" + ((StringBuffer)object).toString());
            }
            object = nArray;
            return object;
        }
    }

    public int getServerID(String string) throws ServerNotRegistered {
        RepositoryDB repositoryDB = this.db;
        synchronized (repositoryDB) {
            int n2 = -1;
            Enumeration enumeration = this.db.serverTable.keys();
            while (enumeration.hasMoreElements()) {
                Integer n3 = (Integer)enumeration.nextElement();
                DBServerDef dBServerDef = (DBServerDef)this.db.serverTable.get(n3);
                if (!dBServerDef.applicationName.equals(string)) continue;
                n2 = n3;
                break;
            }
            if (this.debug) {
                System.out.println("RepositoryImpl: getServerID for " + string + " is " + n2);
            }
            if (n2 == -1) {
                throw new ServerNotRegistered();
            }
            int n4 = n2;
            return n4;
        }
    }

    public String[] getApplicationNames() {
        RepositoryDB repositoryDB = this.db;
        synchronized (repositoryDB) {
            String[] stringArray;
            Object object;
            Vector<String> vector = new Vector<String>();
            Enumeration enumeration = this.db.serverTable.keys();
            while (enumeration.hasMoreElements()) {
                object = (Integer)enumeration.nextElement();
                DBServerDef dBServerDef = (DBServerDef)this.db.serverTable.get(object);
                if (dBServerDef.applicationName.equals("")) continue;
                vector.addElement(dBServerDef.applicationName);
            }
            object = new String[vector.size()];
            int n2 = 0;
            while (n2 < vector.size()) {
                object[n2] = (String)vector.elementAt(n2);
                ++n2;
            }
            if (this.debug) {
                stringArray = new StringBuffer();
                int n3 = 0;
                while (n3 < ((String[])object).length) {
                    stringArray.append(' ');
                    stringArray.append(object[n3]);
                    ++n3;
                }
                System.out.println("RepositoryImpl: getApplicationNames returns " + stringArray.toString());
            }
            stringArray = object;
            return stringArray;
        }
    }

    public static void main(String[] stringArray) {
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].equals("-debug")) {
                bl2 = true;
            }
            ++n2;
        }
        try {
            Properties properties = new Properties();
            ((Hashtable)properties).put("org.omg.CORBA.ORBClass", "com.sun.corba.ee.internal.Interceptors.PIORB");
            POAORB pOAORB = (POAORB)ORB.init((String[])stringArray, (Properties)properties);
            String string = System.getProperty("com.sun.CORBA.activation.db", "db");
            RepositoryImpl repositoryImpl = new RepositoryImpl(pOAORB, new File(string), bl2);
            pOAORB.run();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    class DBServerDef
    implements Serializable {
        String applicationName;
        String name;
        String classPath;
        String args;
        String vmArgs;
        boolean isInstalled;
        int id;

        public String toString() {
            return "DBServerDef(applicationName=" + this.applicationName + ", name=" + this.name + ", classPath=" + this.classPath + ", args=" + this.args + ", vmArgs=" + this.vmArgs + ", id=" + this.id + ", isInstalled=" + this.isInstalled + ")";
        }

        DBServerDef(ServerDef serverDef, int n2) {
            this.applicationName = serverDef.applicationName;
            this.name = serverDef.serverName;
            this.classPath = serverDef.serverClassPath;
            this.args = serverDef.serverArgs;
            this.vmArgs = serverDef.serverVmArgs;
            this.id = n2;
            this.isInstalled = false;
        }
    }

    class RepositoryDB
    implements Serializable {
        File db;
        Hashtable serverTable;
        Integer serverIdCounter;

        RepositoryDB(File file) {
            this.db = file;
            this.serverTable = new Hashtable(255);
            this.serverIdCounter = new Integer(256);
        }

        int incrementServerIdCounter() {
            int n2 = this.serverIdCounter;
            this.serverIdCounter = new Integer(++n2);
            return n2;
        }

        void flush() {
            try {
                this.db.delete();
                FileOutputStream fileOutputStream = new FileOutputStream(this.db);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(this);
                objectOutputStream.flush();
                objectOutputStream.close();
            }
            catch (Exception exception) {
                System.err.println(exception.toString());
                System.err.println("Unable to write IMR Database!");
                throw new INTERNAL(1398079889, CompletionStatus.COMPLETED_NO);
            }
        }
    }
}

