/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.tp2.tpbenchlib;

import com.sap.sapdb.benchmark.tp2.common.Tp2Exception;
import com.sap.sapdb.benchmark.tp2.test.CaseEnv;
import com.sap.sapdb.benchmark.tp2.test.EasyTestDbInit;
import com.sap.sapdb.benchmark.tp2.test.EasyTpBenchmark;
import com.sap.sapdb.benchmark.tp2.test.TestEnv;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class OriginalTp2Init
extends EasyTestDbInit {
    private static final int BRANCH_FILLER_SIZE = 90;
    private static final int TELLER_FILLER_SIZE = 89;
    private static final int ACCOUNT_FILLER_SIZE = 83;
    public static final int HISTORY_FILLER_SIZE = 26;
    public static final int BRANCH_ENTRIES = 1000;
    public static final int TELLER_ENTRIES = 10000;
    public static final int NO_OF_ACCOUNTS = 100000;
    public static final int HISTORY_ENTRIES = 10000;
    private static final int BATCH_SIZE = 100;
    private static final int MAX_SCALE_FACTOR = 8;
    private static long branchKeySize;
    private static long tellerKeySize;
    private static long accountKeySize;
    private int sizeFactor = 1;

    public OriginalTp2Init(CaseEnv caseEnv, EasyTpBenchmark bench) throws Tp2Exception {
        super(caseEnv, bench);
    }

    protected void fillTables(Connection testDBConnection, int scaleFactor) throws Tp2Exception {
        try {
            this.createTestTables(testDBConnection);
            this.fillTableBranch(testDBConnection, scaleFactor);
            this.fillTableTeller(testDBConnection, scaleFactor);
            this.fillTableAccount(testDBConnection, scaleFactor);
            this.fillTableHistory(testDBConnection, scaleFactor);
        }
        catch (SQLException e) {
            throw new Tp2Exception("Problem when filling the tables", 3, e);
        }
    }

    private void createTestTables(Connection testDBConnection) throws SQLException, Tp2Exception {
        Statement stmt = testDBConnection.createStatement();
        try {
            stmt.executeUpdate("DROP TABLE branch");
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            stmt.executeUpdate("DROP TABLE teller");
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            stmt.executeUpdate("DROP TABLE account");
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            stmt.executeUpdate("DROP TABLE history");
        }
        catch (SQLException e) {
            // empty catch block
        }
        branchKeySize = Math.round(Math.log(1000 * this.sizeFactor) / Math.log(10.0) + 1.0);
        OriginalTp2Init.stdOut("BRANCH key: CHAR(" + branchKeySize + ")", 20);
        tellerKeySize = Math.round(Math.log(10000 * this.sizeFactor) / Math.log(10.0) + 1.0);
        OriginalTp2Init.stdOut("TELLER key: CHAR(" + tellerKeySize + ")", 20);
        accountKeySize = Math.round(Math.log(100000 * this.sizeFactor) / Math.log(10.0) + 5.0);
        OriginalTp2Init.stdOut("ACCOUNT/HISTORY key: CHAR(" + accountKeySize + ")", 20);
        stmt.executeUpdate("CREATE TABLE branch ( BRANCH_KEY\tCHAR(" + branchKeySize + ") KEY," + " BRANCH_VALUE\tFIXED(12)," + " BRANCH_FILLER\tCHAR(" + 90 + "))");
        stmt.executeUpdate("CREATE TABLE teller ( TELLER_KEY\tCHAR(" + tellerKeySize + ") KEY," + " TELLER_VALUE\tFIXED(12)," + " TELLER_FILLER\tCHAR(" + 89 + "))");
        stmt.executeUpdate("CREATE TABLE account ( ACCOUNT_KEY\t\tCHAR(" + accountKeySize + ") KEY," + " ACCOUNT_VALUE\t\tFIXED(12)," + " ACCOUNT_FILLER\tCHAR(" + 83 + "))");
        stmt.executeUpdate("CREATE TABLE history ( ACCOUNT_KEY\t\tCHAR(" + accountKeySize + ")," + " ACCOUNT_ADD\t\tFIXED(12)," + " BRANCH_KEY\t\tCHAR(3)," + " TELLER_KEY\t\tCHAR(4)," + " HISTORY_FILLER\tCHAR(" + 26 + "))");
        for (int tabNo = 0; tabNo < 8; ++tabNo) {
            stmt = testDBConnection.createStatement();
            try {
                stmt.executeUpdate("DROP TABLE branch_" + tabNo);
            }
            catch (SQLException e) {
                // empty catch block
            }
            try {
                stmt.executeUpdate("DROP TABLE teller_" + tabNo);
            }
            catch (SQLException e) {
                // empty catch block
            }
            try {
                stmt.executeUpdate("DROP TABLE account_" + tabNo);
            }
            catch (SQLException e) {
                // empty catch block
            }
            try {
                stmt.executeUpdate("DROP TABLE history_" + tabNo);
            }
            catch (SQLException e) {
                // empty catch block
            }
            branchKeySize = Math.round(Math.log(1000 * this.sizeFactor) / Math.log(10.0) + 1.0);
            OriginalTp2Init.stdOut("BRANCH_" + tabNo + " key: CHAR(" + branchKeySize + ")", 20);
            tellerKeySize = Math.round(Math.log(10000 * this.sizeFactor) / Math.log(10.0) + 1.0);
            OriginalTp2Init.stdOut("TELLER_" + tabNo + " key: CHAR(" + tellerKeySize + ")", 20);
            accountKeySize = Math.round(Math.log(100000 * this.sizeFactor) / Math.log(10.0) + 5.0);
            OriginalTp2Init.stdOut("ACCOUNT/HISTORY_" + tabNo + " key: CHAR(" + accountKeySize + ")", 20);
            stmt.executeUpdate("CREATE TABLE branch_" + tabNo + "(" + " BRANCH_KEY\tCHAR(" + branchKeySize + ") KEY," + " BRANCH_VALUE\tFIXED(12)," + " BRANCH_FILLER\tCHAR(" + 90 + "))");
            stmt.executeUpdate("CREATE TABLE teller_" + tabNo + "(" + " TELLER_KEY\tCHAR(" + tellerKeySize + ") KEY," + " TELLER_VALUE\tFIXED(12)," + " TELLER_FILLER\tCHAR(" + 89 + "))");
            stmt.executeUpdate("CREATE TABLE account_" + tabNo + "(" + " ACCOUNT_KEY\t\tCHAR(" + accountKeySize + ") KEY," + " ACCOUNT_VALUE\t\tFIXED(12)," + " ACCOUNT_FILLER\tCHAR(" + 83 + "))");
            stmt.executeUpdate("CREATE TABLE history_" + tabNo + "(" + " ACCOUNT_KEY\t\tCHAR(" + accountKeySize + ")," + " ACCOUNT_ADD\t\tFIXED(12)," + " BRANCH_KEY\t\tCHAR(3)," + " TELLER_KEY\t\tCHAR(4)," + " HISTORY_FILLER\tCHAR(" + 26 + "))");
        }
        stmt.close();
    }

    private void fillTableBranch(Connection testDBConnection, int scaleFactor) throws SQLException {
        OriginalTp2Init.stdOut("Filling table BRANCH with " + 1000 * this.sizeFactor + " entries ...");
        String filler = this.getFiller(90);
        PreparedStatement stmt = testDBConnection.prepareStatement("INSERT INTO branch VALUES (?,0,?)");
        for (int id = 0; id < 1000 * this.sizeFactor; ++id) {
            stmt.setInt(1, id);
            stmt.setString(2, filler);
            stmt.addBatch();
            if (id % 100 != 0) continue;
            stmt.executeBatch();
            stmt.clearBatch();
        }
        stmt.executeBatch();
        if (scaleFactor != -1) {
            for (int tabNo = 0; tabNo < 8; ++tabNo) {
                OriginalTp2Init.stdOut("Filling table BRANCH_" + tabNo + " with " + 1000 * this.sizeFactor + " entries ...");
                stmt = testDBConnection.prepareStatement("INSERT INTO branch_" + tabNo + " VALUES (?,0,?)");
                for (int id = 0; id < 1000 * this.sizeFactor; ++id) {
                    stmt.setInt(1, id);
                    stmt.setString(2, filler);
                    stmt.addBatch();
                    if (id % 100 != 0) continue;
                    stmt.executeBatch();
                    stmt.clearBatch();
                }
                stmt.executeBatch();
            }
        }
        stmt.close();
    }

    private void fillTableTeller(Connection testDBConnection, int scaleFactor) throws SQLException {
        OriginalTp2Init.stdOut("Filling table TELLER with " + 10000 * this.sizeFactor + " entries ...");
        String filler = this.getFiller(89);
        PreparedStatement stmt = testDBConnection.prepareStatement("INSERT INTO teller VALUES (?,0,?)");
        for (int id = 0; id < 10000 * this.sizeFactor; ++id) {
            stmt.setInt(1, id);
            stmt.setString(2, filler);
            stmt.addBatch();
            if (id % 100 != 0) continue;
            stmt.executeBatch();
            stmt.clearBatch();
        }
        stmt.executeBatch();
        if (scaleFactor != -1) {
            for (int tabNo = 0; tabNo < 8; ++tabNo) {
                OriginalTp2Init.stdOut("Filling table TELLER_" + tabNo + " with " + 10000 * this.sizeFactor + " entries ...");
                filler = this.getFiller(89);
                stmt = testDBConnection.prepareStatement("INSERT INTO teller_" + tabNo + " VALUES (?,0,?)");
                for (int id = 0; id < 10000 * this.sizeFactor; ++id) {
                    stmt.setInt(1, id);
                    stmt.setString(2, filler);
                    stmt.addBatch();
                    if (id % 100 != 0) continue;
                    stmt.executeBatch();
                    stmt.clearBatch();
                }
                stmt.executeBatch();
            }
        }
        stmt.close();
    }

    private void fillTableAccount(Connection testDBConnection, int scaleFactor) throws SQLException {
        OriginalTp2Init.stdOut("Filling table ACCOUNT with " + 100000 * this.sizeFactor + " entries ...");
        String filler = this.getFiller(83);
        int accountPerBranch = 100;
        PreparedStatement stmt = testDBConnection.prepareStatement("INSERT INTO account VALUES (?,0,?)");
        for (int i = 0; i < 1000 * this.sizeFactor; ++i) {
            for (int j = 0; j < accountPerBranch; ++j) {
                long accountKey = (long)(i * accountPerBranch) * 10000L + (long)j;
                stmt.setLong(1, accountKey);
                stmt.setString(2, filler);
                stmt.addBatch();
                if ((i * 1000 * this.sizeFactor + j) % 100 != 0) continue;
                stmt.executeBatch();
                stmt.clearBatch();
            }
        }
        stmt.executeBatch();
        if (scaleFactor != -1) {
            for (int tabNo = 0; tabNo < 8; ++tabNo) {
                OriginalTp2Init.stdOut("Filling table ACCOUNT_" + tabNo + " with " + 100000 * this.sizeFactor + " entries ...");
                filler = this.getFiller(83);
                accountPerBranch = 100;
                stmt = testDBConnection.prepareStatement("INSERT INTO account_" + tabNo + " VALUES (?,0,?)");
                for (int i = 0; i < 1000 * this.sizeFactor; ++i) {
                    for (int j = 0; j < accountPerBranch; ++j) {
                        long accountKey = (long)(i * accountPerBranch) * 10000L + (long)j;
                        stmt.setLong(1, accountKey);
                        stmt.setString(2, filler);
                        stmt.addBatch();
                        if ((i * 1000 * this.sizeFactor + j) % 100 != 0) continue;
                        stmt.executeBatch();
                        stmt.clearBatch();
                    }
                }
                stmt.executeBatch();
            }
        }
        stmt.close();
    }

    private void fillTableHistory(Connection testDBConnection, int scaleFactor) throws SQLException {
        OriginalTp2Init.stdOut("Filling table HISTORY with " + 10000 * this.sizeFactor + " entries ...");
        String filler = this.getFiller(26);
        PreparedStatement stmt = testDBConnection.prepareStatement("INSERT INTO history VALUES ('9999999999',0,'999','9999',?)");
        for (int id = 0; id < 10000 * this.sizeFactor; ++id) {
            stmt.setString(1, filler);
            stmt.addBatch();
            if (id % 100 != 0) continue;
            stmt.executeBatch();
            stmt.clearBatch();
        }
        stmt.executeBatch();
        if (scaleFactor != -1) {
            for (int tabNo = 0; tabNo < 8; ++tabNo) {
                OriginalTp2Init.stdOut("Filling table HISTORY_" + tabNo + " with " + 10000 * this.sizeFactor + " entries ...");
                stmt = testDBConnection.prepareStatement("INSERT INTO history_" + tabNo + " VALUES ('9999999999',0,'999','9999',?)");
                for (int id = 0; id < 10000 * this.sizeFactor; ++id) {
                    stmt.setString(1, filler);
                    stmt.addBatch();
                    if (id % 100 != 0) continue;
                    stmt.executeBatch();
                    stmt.clearBatch();
                }
                stmt.executeBatch();
            }
        }
        stmt.close();
    }

    private String getFiller(int fillerSize) {
        StringBuffer result = new StringBuffer("");
        for (int i = 0; i < fillerSize; ++i) {
            result.append('x');
        }
        return result.toString();
    }

    public void putTestTablesInCache(TestEnv testEnv, Connection testDBConn) throws Tp2Exception {
        try {
            Statement stmt = testDBConn.createStatement();
            ResultSet RS = stmt.executeQuery("SELECT * FROM account where account_filler = 'nase'");
            RS.next();
            RS.close();
            RS = stmt.executeQuery("SELECT * FROM branch where branch_filler = 'nase'");
            RS.next();
            RS.close();
            RS = stmt.executeQuery("SELECT * FROM teller  where teller_filler = 'nase'");
            RS.next();
            RS.close();
            RS = stmt.executeQuery("SELECT * FROM history  where history_filler = 'nase'");
            RS.next();
            RS.close();
            for (int tabNo = 0; tabNo < 8; ++tabNo) {
                RS = stmt.executeQuery("SELECT COUNT(*) FROM account_" + tabNo + " where account_filler = 'nase'");
                RS.next();
                RS.close();
                RS = stmt.executeQuery("SELECT COUNT(*) FROM branch_" + tabNo + " where branch_filler = 'nase'");
                RS.next();
                RS.close();
                RS = stmt.executeQuery("SELECT COUNT(*) FROM teller_" + tabNo + " where teller_filler = 'nase'");
                RS.next();
                RS.close();
                RS = stmt.executeQuery("SELECT COUNT(*) FROM history_" + tabNo + " where history_filler = 'nase'");
                RS.next();
                RS.close();
            }
            stmt.close();
            testDBConn.commit();
        }
        catch (SQLException e) {
            throw new Tp2Exception("Cannot put test tables in cache", 3, e);
        }
    }

    public static long getAccountKeySize() {
        return accountKeySize;
    }

    public static long getBranchKeySize() {
        return branchKeySize;
    }

    public static long getTellerKeySize() {
        return tellerKeySize;
    }
}

