/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.tp2.jsp;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;

public class WebSession {
    private static int nextId = 0;
    private boolean inEditorMode = false;
    private boolean inFilterMode = false;
    private boolean inParamComparMode = true;
    private int id = nextId++;
    private int ASGViewType = 0;
    private Hashtable graphContents = new Hashtable();
    private int nextSeqId = 0;

    public WebSession() {
        System.out.println("Created new WebSession[" + this.id + "]");
    }

    public boolean isInEditorMode() {
        return this.inEditorMode;
    }

    public void setInEditorMode(boolean inEditorMode) {
        this.inEditorMode = inEditorMode;
    }

    public boolean isInFilterMode() {
        return this.inFilterMode;
    }

    public void setInFilterMode(boolean inFilterMode) {
        this.inFilterMode = inFilterMode;
    }

    public void addGraph(String name, String description, String xList, String yList, String devList, String testCountList) {
        if (!this.graphContents.containsKey(name)) {
            this.graphContents.put(name, new TreeMap());
        }
        SeqContent seqC = new SeqContent(description, xList, yList, devList, testCountList, this.nextSeqId);
        SortedMap map = (SortedMap)this.graphContents.get(name);
        map.put(seqC.getDescription(), seqC);
        ++this.nextSeqId;
    }

    public void removeGraph(String name, String description) {
        if (this.graphContents.containsKey(name)) {
            SortedMap map = (SortedMap)this.graphContents.get(name);
            map.remove(description);
        }
    }

    public void removeGraphSet(String name) {
        if (this.graphContents.containsKey(name)) {
            this.graphContents.remove(name);
        }
    }

    public SortedMap getGraphContent(String name) {
        if (this.graphContents.containsKey(name)) {
            return (SortedMap)this.graphContents.get(name);
        }
        return new TreeMap();
    }

    public Iterator listGraphNames() {
        return this.graphContents.keySet().iterator();
    }

    public String getGraphNames() {
        StringBuffer res = null;
        Iterator it = this.listGraphNames();
        while (it.hasNext()) {
            if (res == null) {
                res = new StringBuffer("");
            } else {
                res.append(';');
            }
            res.append((String)it.next());
        }
        if (res == null) {
            return "";
        }
        return res.toString();
    }

    public int getASGViewType() {
        return this.ASGViewType;
    }

    public void setASGViewType(int aSGViewType) {
        this.ASGViewType = aSGViewType;
    }

    public boolean isInParamComparMode() {
        return this.inParamComparMode;
    }

    public void setInParamComparMode(boolean inParamComparMode) {
        this.inParamComparMode = inParamComparMode;
    }

    public static class SeqContent {
        private String xList = null;
        private String yList = null;
        private String devList = null;
        private String testCountList = null;
        private String description = null;
        private int colorId;

        private SeqContent(String description, String xList, String yList, String devList, String testCountList, int colorId) {
            this.xList = xList;
            this.yList = yList;
            this.devList = devList;
            this.testCountList = testCountList;
            this.description = description;
            this.colorId = colorId;
        }

        public String getXList() {
            return this.xList;
        }

        public String getYList() {
            return this.yList;
        }

        public String getDescription() {
            return this.description;
        }

        public int getColorId() {
            return this.colorId;
        }

        public String getDevList() {
            return this.devList;
        }

        public String getTestCountList() {
            return this.testCountList;
        }
    }
}

