/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.tp2.jsp;

import com.sap.sapdb.benchmark.common.MaxcpuWp;
import com.sap.sapdb.benchmark.common.ServerNode;
import com.sap.sapdb.benchmark.common.ShortBuild;
import com.sap.sapdb.benchmark.common.StorableObject;
import com.sap.sapdb.benchmark.common.Version;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class Report {
    public static final String REFERENCE_USER = "Reference";
    private PreparedStatement bestValuesForVersionMaxcpuAndHost = null;
    private PreparedStatement referenceHosts = null;
    private PreparedStatement referenceVersionsForHost = null;

    public Report() throws SQLException {
        this.initSQL(StorableObject.getConnection());
    }

    private void initSQL(Connection conn) throws SQLException {
        StringBuffer sessIdList = null;
        Statement stmt = conn.createStatement();
        ResultSet RS = stmt.executeQuery("SELECT sess.id FROM sessions sess,users WHERE users.name='Reference' AND users.id=sess.user_id");
        while (RS.next()) {
            if (sessIdList == null) {
                sessIdList = new StringBuffer("");
            } else {
                sessIdList.append(',');
            }
            sessIdList.append(RS.getInt("id"));
        }
        RS.close();
        stmt.close();
        this.bestValuesForVersionMaxcpuAndHost = conn.prepareStatement("SELECT " + ShortBuild.extractShortBuildField("dbdesc") + " AS short_build," + " MAX(res.tps) AS tps_max," + " AVG(res.tps) AS tps_avg," + " (STDDEV(res.tps)*100)/AVG(res.tps) AS tps_dev," + " COUNT(res.def_id) AS test_count" + " FROM tp2_definitions def, tp2_results res, tp2_sessions_results lnk, dbdescriptions dbdesc, servernodes  nodes" + " WHERE def.id = res.def_id " + " AND def.dbdescription_id = dbdesc.id" + " AND def.servernode_id = nodes.id" + " AND def.id=lnk.def_id" + " AND lnk.session_id IN (" + sessIdList.toString() + ")" + " AND " + ServerNode.getClassPreparedWherePart("nodes") + " AND " + Version.getClassPreparedWherePart("dbdesc") + " AND " + MaxcpuWp.getClassPreparedWherePart("dbdesc") + " GROUP BY " + ShortBuild.extractShortBuildField("dbdesc"));
        this.referenceHosts = conn.prepareStatement("SELECT nodes.id,nodes.host_name,nodes.os_name,nodes.os_version,nodes.memory_mb,nodes.processor_count,nodes.processor_mhz FROM servernodes nodes, tp2_sessions_results lnk, tp2_definitions def WHERE lnk.session_id IN (" + sessIdList.toString() + ")" + " AND lnk.def_id = def.id" + " AND def.servernode_id = nodes.id");
        this.referenceVersionsForHost = conn.prepareStatement("SELECT dbdesc.major,dbdesc.minor,dbdesc.correction_level FROM servernodes nodes, dbdescriptions dbdesc, tp2_sessions_results lnk, tp2_definitions def WHERE lnk.session_id IN (" + sessIdList.toString() + ")" + " AND lnk.def_id = def.id" + " AND def.dbdescription_id = dbdesc.id" + " AND def.servernode_id = ?");
    }

    public VersionPart getVersionPart(ServerNode serverNode, Version version) throws SQLException {
        VersionPart result = new VersionPart(version, serverNode);
        for (int maxcpu = 1; maxcpu < 4; ++maxcpu) {
            MaxcpuWp mWp = new MaxcpuWp(maxcpu);
            int index = serverNode.setPeparedStatementValues(this.bestValuesForVersionMaxcpuAndHost, 1);
            index = version.setPeparedStatementValues(this.bestValuesForVersionMaxcpuAndHost, index);
            mWp.setPeparedStatementValues(this.bestValuesForVersionMaxcpuAndHost, index);
            ResultSet RS = this.bestValuesForVersionMaxcpuAndHost.executeQuery();
            while (RS.next()) {
                result.addValue(RS.getString("short_build"), maxcpu, new Value(RS.getInt("tps_max"), RS.getInt("tps_avg"), RS.getFloat("tps_dev"), RS.getInt("test_count")));
            }
            RS.close();
        }
        return result;
    }

    public SortedSet getReferenceHosts() throws SQLException {
        TreeSet<ServerNode> res = new TreeSet<ServerNode>();
        ResultSet RS = this.referenceHosts.executeQuery();
        while (RS.next()) {
            ServerNode sn = new ServerNode(RS.getInt("id"), RS.getString("host_name"), RS.getString("os_name"), RS.getString("os_version"), RS.getInt("memory_mb"), RS.getInt("processor_count"), RS.getString("processor_mhz"));
            res.add(sn);
        }
        RS.close();
        return res;
    }

    public SortedSet getVersions(ServerNode serverNode) throws SQLException {
        TreeSet<Version> res = new TreeSet<Version>();
        this.referenceVersionsForHost.setInt(1, serverNode.getId());
        ResultSet RS = this.referenceVersionsForHost.executeQuery();
        while (RS.next()) {
            Version version = new Version(RS.getInt("major"), RS.getInt("minor"), RS.getInt("correction_level"));
            res.add(version);
        }
        RS.close();
        return res;
    }

    public static class Value {
        private int tpsMax;
        private int tpsAvg;
        private int testCount;
        private float tpsDev;

        public Value(int tpsMax, int tpsAvg, float tpsDev, int testCount) {
            this.tpsMax = tpsMax;
            this.tpsAvg = tpsAvg;
            this.tpsDev = tpsDev;
            this.testCount = testCount;
        }

        public int getTestCount() {
            return this.testCount;
        }

        public int getTpsAvg() {
            return this.tpsAvg;
        }

        public float getTpsDev() {
            return this.tpsDev;
        }

        public int getTpsMax() {
            return this.tpsMax;
        }
    }

    public static class VersionPart {
        private Version version = null;
        private ServerNode serverNode = null;
        private SortedSet shortBuilds = null;
        private SortedMap content = null;

        public VersionPart(Version version, ServerNode serverNode) {
            this.version = version;
            this.serverNode = serverNode;
            this.content = new TreeMap();
            this.shortBuilds = new TreeSet();
        }

        public void addValue(String shortBuild, int maxcpu, Value value) {
            MaxcpuWp mWp = new MaxcpuWp(maxcpu);
            if (!this.content.containsKey(mWp)) {
                this.content.put(mWp, new TreeMap());
            }
            ShortBuild sb = new ShortBuild(this.version, shortBuild);
            ((SortedMap)this.content.get(mWp)).put(sb, value);
            if (!this.shortBuilds.contains(sb)) {
                this.shortBuilds.add(sb);
            }
        }

        public Value getValue(int maxcpu, ShortBuild shortBuild) {
            MaxcpuWp mWp = new MaxcpuWp(maxcpu);
            if (!this.content.containsKey(mWp)) {
                return null;
            }
            SortedMap sm = (SortedMap)this.content.get(mWp);
            if (!sm.containsKey(shortBuild)) {
                return null;
            }
            return (Value)sm.get(shortBuild);
        }

        public SortedSet getShortBuilds() {
            return this.shortBuilds;
        }
    }
}

