/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.tp2.common;

import com.sap.sapdb.benchmark.common.ServerNode;
import com.sap.sapdb.benchmark.common.Session;
import com.sap.sapdb.benchmark.common.StorableObject;
import com.sap.sapdb.benchmark.common.User;
import com.sap.sapdb.benchmark.tp2.common.Tp2Exception;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;

public class Tp2Case
implements Comparable {
    public static final String INITIALIZED = "INITIALIZED";
    public static final String RUNNING = "RUNNING";
    public static final String FINISHED = "FINISHED";
    public static final String ABORTED = "ABORTED";
    private String state = null;
    private Date beginDate = null;
    private Date endDate = null;
    private Session session = null;
    private ServerNode serverNode = null;
    private String caseType = null;

    public static Tp2Case initCase(Session session, ServerNode serverNode, String caseType) throws SQLException, Tp2Exception {
        if (!StorableObject.isNonPersistent()) {
            Statement stmt = Tp2Case.getConnection().createStatement();
            ResultSet testRS = stmt.executeQuery("SELECT state,case_type,begin_date,end_date FROM tp2_sessions_servernodes WHERE session_id=" + session.getId() + " AND servernode_id=" + serverNode.getId());
            if (!testRS.next()) {
                stmt.executeUpdate("INSERT INTO tp2_sessions_servernodes SET session_id=" + session.getId() + "," + "servernode_id=" + serverNode.getId() + "," + "case_type='" + caseType + "'," + "state='" + INITIALIZED + "'");
            } else {
                testRS.close();
                stmt.executeUpdate("UPDATE tp2_sessions_servernodes SET  case_type='" + caseType + "'," + " begin_date=TIMESTAMP," + " end_date=NULL, " + " state='" + INITIALIZED + "'" + " WHERE session_id=" + session.getId() + " AND servernode_id=" + serverNode.getId());
            }
            Tp2Case.getConnection().commit();
            ResultSet RS = stmt.executeQuery("SELECT begin_date FROM tp2_sessions_servernodes WHERE session_id=" + session.getId() + " AND servernode_id=" + serverNode.getId());
            if (RS.next()) {
                Timestamp beginDate = RS.getTimestamp("begin_date");
                RS.close();
                testRS.close();
                stmt.close();
                Tp2Case.getConnection().commit();
                if (session.isClosed()) {
                    session.open();
                }
                return new Tp2Case(session, serverNode, caseType, beginDate, null, INITIALIZED);
            }
            RS.close();
            testRS.close();
            stmt.close();
            Tp2Case.getConnection().rollback();
            throw new Tp2Exception("Tp2Case was not properly created", 3);
        }
        return new Tp2Case(session, serverNode, caseType, new Date(), null, INITIALIZED);
    }

    public static void closeSessionIfAllCasesFinished(Session session) throws SQLException {
        if (!session.isGlobalSession()) {
            Statement stmt = Tp2Case.getConnection().createStatement();
            ResultSet RS = stmt.executeQuery("SELECT servernode_id,state FROM tp2_sessions_servernodes WHERE session_id=" + session.getId());
            boolean shouldClose = true;
            while (RS.next()) {
                if (RS.getString("state").equals(FINISHED)) continue;
                shouldClose = false;
                break;
            }
            RS.close();
            Tp2Case.getConnection().commit();
            if (shouldClose) {
                session.close();
            }
            RS.close();
            stmt.close();
            Tp2Case.getConnection().commit();
        }
    }

    private static Connection getConnection() throws SQLException {
        return StorableObject.getConnection();
    }

    public Tp2Case(Session session, ServerNode serverNode, String caseType, Date beginDate, Date endDate, String state) throws SQLException {
        this.session = session;
        this.serverNode = serverNode;
        this.beginDate = beginDate;
        this.endDate = endDate;
        this.caseType = caseType;
        this.state = state;
    }

    public boolean isFinished() throws Tp2Exception {
        if (this.state.equals(FINISHED) || this.state.equals(ABORTED)) {
            return true;
        }
        try {
            if (this.session.isClosed()) {
                this.abort();
                return true;
            }
            return false;
        }
        catch (SQLException e) {
            throw new Tp2Exception("Not able to determine the case state", 3);
        }
    }

    public void finish() throws SQLException {
        if (!StorableObject.isNonPersistent()) {
            try {
                Statement stmt = StorableObject.getConnection().createStatement();
                stmt.executeUpdate("UPDATE tp2_sessions_servernodes SET  state='FINISHED', end_date=TIMESTAMP WHERE session_id=" + this.session.getId() + " AND servernode_id=" + this.serverNode.getId());
                this.state = FINISHED;
                Tp2Case.getConnection().commit();
                stmt.close();
                Tp2Case.closeSessionIfAllCasesFinished(this.session);
            }
            catch (SQLException e) {
                Tp2Case.getConnection().rollback();
                throw e;
            }
        } else {
            this.state = FINISHED;
        }
    }

    public void abort() throws SQLException {
        if (!StorableObject.isNonPersistent()) {
            try {
                Statement stmt = StorableObject.getConnection().createStatement();
                stmt.executeUpdate("UPDATE tp2_sessions_servernodes SET  state='ABORTED', end_date=TIMESTAMP WHERE session_id=" + this.session.getId() + " AND servernode_id=" + this.serverNode.getId());
                this.state = ABORTED;
                stmt.close();
                Tp2Case.getConnection().commit();
            }
            catch (SQLException e) {
                Tp2Case.getConnection().rollback();
                throw e;
            }
        } else {
            this.state = ABORTED;
        }
    }

    public void startRunning() throws SQLException {
        if (!StorableObject.isNonPersistent()) {
            try {
                Statement stmt = StorableObject.getConnection().createStatement();
                stmt.executeUpdate("UPDATE tp2_sessions_servernodes SET  state='RUNNING' WHERE session_id=" + this.session.getId() + " AND servernode_id=" + this.serverNode.getId());
                this.state = RUNNING;
                stmt.close();
                Tp2Case.getConnection().commit();
            }
            catch (SQLException e) {
                Tp2Case.getConnection().rollback();
                throw e;
            }
        } else {
            this.state = RUNNING;
        }
    }

    public Session getSession() {
        return this.session;
    }

    public ServerNode getServerNode() {
        return this.serverNode;
    }

    public String getCaseType() {
        return this.caseType;
    }

    public String getCaseTypeWithId() {
        return this.getCaseType() + "[" + this.session.getId() + "]@" + this.serverNode.getShortHostName();
    }

    public String getState() {
        return this.state;
    }

    public User getUser() {
        return this.session.getUser();
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public String toString() {
        StringBuffer res = new StringBuffer("");
        res.append("Tp2Case[").append(this.session.getId()).append(", Description: ").append(this.session.getDescription()).append(", User: ").append(this.session.getUser().getName()).append("[").append(this.session.getUser().getId()).append("]");
        return res.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Tp2Case) {
            Tp2Case tp2Case = (Tp2Case)obj;
            return this.getSession().equals(tp2Case.getSession()) && this.getServerNode().equals(tp2Case.getServerNode()) && this.getCaseType().equals(tp2Case.getCaseType());
        }
        return false;
    }

    public int compareTo(Object obj) {
        if (obj instanceof Tp2Case) {
            Tp2Case tp2Case = (Tp2Case)obj;
            int sC = this.getSession().compareTo(tp2Case.getSession());
            if (sC == 0) {
                int snC = this.getServerNode().compareTo(tp2Case.getServerNode());
                if (snC == 0) {
                    return this.getCaseType().compareTo(tp2Case.getCaseType());
                }
                return snC;
            }
            return sC;
        }
        return this.toString().compareTo(obj.toString());
    }
}

