/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.tp2.cases;

import com.sap.sapdb.testframe.driver.TestDatabase;
import com.sap.sapdb.testframe.driver.TestDatabaseException;

class ParameterSet {
    private static String[] parameterNames = null;
    private int[] parameters = null;

    public static String getParameterNamesAsOutput() {
        StringBuffer res = new StringBuffer("");
        for (int i = 0; i < parameterNames.length; ++i) {
            if (i != 0) {
                res.append(", ");
            }
            res.append(parameterNames[i]);
        }
        return res.toString();
    }

    public static String[] getParameterNames() {
        return parameterNames;
    }

    public static void setParameterNames(String[] parameterNames) {
        ParameterSet.parameterNames = parameterNames;
    }

    public static int getParameterCount() {
        return parameterNames.length;
    }

    public ParameterSet(int[] parameters) {
        this.parameters = parameters;
    }

    public int[] getParameters() {
        return this.parameters;
    }

    public void putParameters(TestDatabase testDB) throws TestDatabaseException {
        for (int i = 0; i < this.parameters.length; ++i) {
            testDB.executeDBMcmd("param_directput " + parameterNames[i] + " " + this.parameters[i]);
        }
    }

    public double distance(ParameterSet paramSet) {
        double result = 0.0;
        int[] otherParams = paramSet.getParameters();
        for (int i = 0; i < this.parameters.length; ++i) {
            result += (double)(this.parameters[i] - otherParams[i]) * (double)(this.parameters[i] - otherParams[i]);
        }
        return Math.sqrt(result);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ParameterSet) {
            ParameterSet paramSet = (ParameterSet)obj;
            int[] otherParams = paramSet.getParameters();
            for (int i = 0; i < this.parameters.length; ++i) {
                if (this.parameters[i] == otherParams[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

