/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.SyncMan.MsgService;

import com.sap.sapdb.SyncMan.MsgService.MsgClient;
import com.sap.sapdb.testframe.testcase.TestCase;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.NamingException;

public abstract class MsgTopicClient
extends MsgClient {
    protected TopicConnection m_Connection = null;
    protected TopicSession m_PubSession = null;
    protected TopicSession m_SubSession = null;
    protected TopicPublisher m_Publisher = null;
    protected TopicSubscriber m_Subscriber = null;
    protected Topic m_Topic = null;

    public MsgTopicClient(TestCase testCase, int deliveryMode, String topicName, String user, String password, String selector, boolean durable, int pubAccMode, boolean pubTrans, int subAccMode, boolean subTrans, ThreadGroup group, String threadName) throws Exception {
        super(testCase, deliveryMode, user, password, group, threadName);
        TopicConnectionFactory conFactory = (TopicConnectionFactory)this.m_jndi.lookup("jms.TopicConnectionFactory");
        this.m_Connection = conFactory.createTopicConnection(user, password);
        this.m_PubSession = this.m_Connection.createTopicSession(pubTrans, pubAccMode);
        this.m_SubSession = this.m_Connection.createTopicSession(subTrans, subAccMode);
        this.m_Topic = (Topic)this.m_jndi.lookup("jms.topic." + topicName);
        this.m_Publisher = this.m_PubSession.createPublisher(this.m_Topic);
        this.m_Subscriber = durable ? this.m_SubSession.createDurableSubscriber(this.m_Topic, "Subscriber", selector, false) : this.m_SubSession.createSubscriber(this.m_Topic, selector, false);
    }

    public void close() throws JMSException {
        this.m_Connection.close();
    }

    public void closeSub() throws JMSException {
        this.m_Subscriber.close();
    }

    public void startSub() throws JMSException {
        this.m_Connection.stop();
        System.out.println("\u00b0\u00b0\u00b0\u00b0\u00b0 - Before setMessageListener ... DeliveryMode: " + this.m_DeliveryModeAsString);
        this.m_Subscriber = this.m_SubSession.createDurableSubscriber(this.m_Topic, "Subscriber");
        this.m_Subscriber.setMessageListener((MessageListener)this);
        System.out.println("\u00b0\u00b0\u00b0\u00b0\u00b0 - After setMessageListener ... DeliveryMode: " + this.m_DeliveryModeAsString);
        this.m_Connection.start();
    }

    protected void unSubscribeSub() throws JMSException, NamingException {
        this.closeSub();
        System.out.println("\u00b0\u00b0\u00b0\u00b0\u00b0 - Before unsubscribe ... DeliveryMode: " + this.m_DeliveryModeAsString);
        this.m_SubSession.unsubscribe("Subscriber");
        System.out.println("\u00b0\u00b0\u00b0\u00b0\u00b0 - After unsubscribe ... DeliveryMode: " + this.m_DeliveryModeAsString);
    }
}

