/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.lctest;

import com.sap.sapdb.lctest.SQLRecoverTest;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;

public class SQLRecoverTest2
extends SQLRecoverTest {
    public static void cleanUp() throws TestCaseException {
        SQLRecoverTest.cleanUp();
    }

    public static void prepare() throws TestCaseException {
        SQLRecoverTest.prepare();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean checksum = false;
        TestDatabaseSap sapdb = (TestDatabaseSap)SQLRecoverTest2.getDatabase();
        try {
            this.executeSQL(1, "drop table SQLRecoverTest2");
            this.executeSQL(1, "commit");
            this.executeDBMCmd("util_connect");
            this.executeDBMCmd("medium_put srt2 srt2 FILE DATA 0 8 YES NO");
            this.executeDBMCmd("util_release");
            SQLRecoverTest2.addGlobalMessage((String)"SQLRecoverTest2", (char)'I', (String)"--> Just created backup media (FILE c:/Temp/srt2)!");
            this.executeDBMCmd("util_connect");
            this.executeDBMCmd("backup_save srt2");
            this.executeDBMCmd("util_release");
            SQLRecoverTest2.addGlobalMessage((String)"SQLRecoverTest2", (char)'I', (String)"--> Just performed backup srt2!");
            this.executeSQL(1, "Create table SQLRecoverTest2 (k0 int, k1 char(10), primary key(k0, k1))");
            this.executeSQL(1, "commit");
            this.executeSQL(1, "Insert into SQLRecoverTest2 values (1, 'Key1')");
            this.executeSQL(1, "Insert into SQLRecoverTest2 values (2, 'Key2')");
            this.executeSQL(1, "Insert into SQLRecoverTest2 values (3, 'Key3')");
            this.executeSQL(1, "Insert into SQLRecoverTest2 values (4, 'Key4')");
            this.executeSQL(1, "Insert into SQLRecoverTest2 values (5, 'Key5')");
            this.executeSQL(1, "commit");
            this.executeSQL(1, "Insert into SQLRecoverTest2 values (6, 'Key6')");
            this.executeSQL(1, "Insert into SQLRecoverTest2 values (7, 'Key7')");
            this.executeSQL(1, "Insert into SQLRecoverTest2 values (8, 'Key8')");
            this.executeSQL(1, "Insert into SQLRecoverTest2 values (9, 'Key9')");
            this.executeSQL(1, "Insert into SQLRecoverTest2 values (10, 'Key10')");
            this.executeSQL(1, "commit");
            this.executeSQL(1, "Insert into SQLRecoverTest2 values (11, 'Key11')");
            this.executeSQL(1, "Insert into SQLRecoverTest2 values (12, 'Key12')");
            this.executeSQL(1, "Insert into SQLRecoverTest2 values (13, 'Key13')");
            this.executeSQL(1, "Insert into SQLRecoverTest2 values (14, 'Key14')");
            this.executeSQL(1, "Insert into SQLRecoverTest2 values (15, 'Key15')");
            this.checkChecksum("SQLRecoverTest2", 120);
            SQLRecoverTest2.addGlobalMessage((String)"SQLRecoverTest2", (char)'I', (String)"--> Inserted 5 Records but no explicit ROLLBACK executed!!!");
            this.executeDBMCmd("db_offline");
            SQLRecoverTest2.addGlobalMessage((String)"SQLRecoverTest2", (char)'I', (String)"--> Just performed db_offline!");
            this.executeDBMCmd("db_cold -" + sapdb.getKernelMode());
            SQLRecoverTest2.addGlobalMessage((String)"SQLRecoverTest2", (char)'I', (String)("--> Just performed db_cold -" + sapdb.getKernelMode() + "!"));
            this.executeDBMCmd("util_connect");
            this.executeDBMCmd("recover_start srt2 data");
            SQLRecoverTest2.addGlobalMessage((String)"SQLRecoverTest2", (char)'I', (String)"--> Just performed recovery!");
            this.executeDBMCmd("db_warm -" + sapdb.getKernelMode());
            SQLRecoverTest2.addGlobalMessage((String)"SQLRecoverTest2", (char)'I', (String)("--> Just performed db_warm -" + sapdb.getKernelMode() + "!"));
            SQLRecoverTest2.createConnections();
            this.executeSQL(1, "Insert into SQLRecoverTest2 values (11, 'Key11')");
            this.executeSQL(1, "commit");
            this.checkChecksum("SQLRecoverTest2", 66);
            this.executeSQL(1, "Insert into SQLRecoverTest2 values (5, 'Key5')");
            this.executeSQL(1, "commit");
            this.checkChecksum("SQLRecoverTest2", 66);
            this.executeDBMCmd("util_release");
            this.checkChecksum("SQLRecoverTest2", 66);
        }
        catch (Exception e) {
            SQLRecoverTest2.addGlobalMessage((String)"SQLRecoverTest2", (char)'E', (String)e.getMessage());
        }
        finally {
            try {
                this.executeDBMCmd("util_release");
                this.executeDBMCmd("sql_release");
            }
            catch (Exception exception) {}
        }
    }
}

