/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.lctest;

import com.sap.dbtech.jdbc.exceptions.DatabaseException;
import com.sap.dbtech.powertoys.DBM;
import com.sap.sapdb.lctest.LiveCacheConstants;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public abstract class SQLRecoverTest
extends TestCase
implements LiveCacheConstants {
    protected static final String sUser = "SQLUSER";
    protected static final String sPassword = "SQLUSER";
    protected static final int mNumberOfConnections = 3;
    protected static final int USER1 = 1;
    protected static final int USER2 = 2;
    protected static final int USER3 = 3;
    protected static final int NO_ERROR = 0;
    protected static final int DEFAULT_TIMEOUT = 10;
    protected static final int IGNORE_ALL_ERRORS = -999;
    private DBM mDBMan = null;
    public String mHost;
    public String mName;
    public int mPort;
    private String mDBMUser = "DBM";
    private String mDBMPassword = "DBM";
    private int mStatementCounter = 0;
    private static Connection[] mConnections;
    private static TestStatement[] mStatements;
    private int mNextKey = 0;
    private int mNextValue = 0;
    private Vector mValues = new Vector();
    private Vector mKeys = new Vector();

    public int checkChecksum(String pTableName, int pExpectedChecksum) {
        int sum = 0;
        String InfoString = "checkChecksum";
        try {
            ResultSet rs = mStatements[0].executeQuery("select * from " + pTableName);
            while (rs.next()) {
                sum += rs.getInt("k0");
            }
            if (pExpectedChecksum != sum) {
                SQLRecoverTest.addGlobalMessage((String)InfoString, (char)'E', (String)("SQLRecoverTest --> ERROR: Expected Checksum: " + pExpectedChecksum + ", Selected Checksum: " + sum));
                System.out.println("SQLRecoverTest --> ERROR: Expected Checksum: " + pExpectedChecksum + ", Selected Checksum: " + sum);
                return -1;
            }
            System.out.println("SQLRecoverTest --> Checksums are ok for table " + pTableName);
            System.out.println("SQLRecoverTest --> Expected checksum: " + pExpectedChecksum + ", Selected Checksum: " + sum);
            SQLRecoverTest.addGlobalMessage((String)InfoString, (char)'I', (String)("SQLRecoverTest --> Checksums are ok for table " + pTableName));
            SQLRecoverTest.addGlobalMessage((String)InfoString, (char)'I', (String)("SQLRecoverTest --> Expected checksum: " + pExpectedChecksum + ", Selected Checksum: " + sum));
            return sum;
        }
        catch (Exception e) {
            SQLRecoverTest.addGlobalMessage((String)InfoString, (char)'E', (String)("SQLRecoverTest --> ERROR: Select on table: " + pTableName + " failed!!! \nMessage:" + e.getMessage()));
            System.out.println("SQLRecoverTest --> ERROR: Select on table: " + pTableName + " failed!!! ");
            System.out.println("Message: " + e.getMessage());
            return -1;
        }
    }

    private void checkResultCode(String InfoString, String CallString, int pExpectedResultCode) throws TestCaseException {
        if (pExpectedResultCode != 0 && pExpectedResultCode != -999) {
            SQLRecoverTest.addGlobalMessage((String)InfoString, (char)'E', (String)("***** ERROR ****** " + CallString + " --> expecting result code " + pExpectedResultCode));
            throw new TestCaseException(CallString + " --> expecting result code " + pExpectedResultCode);
        }
    }

    private void checkResultCode(String InfoString, String CallString, int pExpectedResultCode, SQLException e) throws TestCaseException {
        if (pExpectedResultCode == -999) {
            return;
        }
        if (e.getErrorCode() != pExpectedResultCode) {
            SQLRecoverTest.addGlobalMessage((String)InfoString, (char)'E', (String)("***** ERROR ****** " + CallString + " --> " + e.getMessage()));
            throw new TestCaseException(CallString + " --> " + e.getMessage());
        }
        SQLRecoverTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " - Expected error: " + e.getMessage() + " --> OK"));
    }

    public static void cleanUp() throws TestCaseException {
        if (mStatements == null || mConnections == null) {
            return;
        }
        try {
            for (int i = 0; i < 3; ++i) {
                if (mStatements[i] != null) {
                    mStatements[i].close();
                }
                if (mConnections[i] == null) continue;
                mConnections[i].close();
            }
        }
        catch (Exception e) {
            SQLRecoverTest.addGlobalMessage((String)"cleanup", (char)'E', (String)("Error during connection closure: " + e.getMessage()));
            throw new TestCaseException("Error during connection closure: " + e.getMessage());
        }
    }

    public static boolean createConnections() {
        try {
            mConnections = new Connection[3];
            mStatements = new TestStatement[3];
            for (int i = 0; i < 3; ++i) {
                SQLRecoverTest.mConnections[i] = SQLRecoverTest.getDatabase().connect("SQLUSER", "SQLUSER");
                mConnections[i].setAutoCommit(false);
                SQLRecoverTest.mStatements[i] = new TestStatement(null, mConnections[i]);
            }
        }
        catch (Exception e) {
            SQLRecoverTest.addGlobalMessage((String)"createConnections", (char)'E', (String)("Error during connection creation: " + e.getMessage()));
            return false;
        }
        return true;
    }

    public String executeDBMCmd(String pCmd) throws TestDatabaseException {
        String logon = "";
        try {
            this.mHost = SQLRecoverTest.getDatabase().getHost();
            this.mName = SQLRecoverTest.getDatabase().getName();
            this.mPort = SQLRecoverTest.getDatabase().getPort();
            if (this.mDBMan == null) {
                this.mDBMan = DBM.dbDBM((String)(this.mHost + ":" + this.mPort), (String)this.mName);
                logon = "USER_LOGON " + this.mDBMUser + ',' + this.mDBMPassword;
                this.mDBMan.cmd(logon);
            }
            return this.mDBMan.cmd(pCmd);
        }
        catch (Exception e) {
            throw new TestDatabaseException(e, " DBM command: " + pCmd + ", logon String: " + logon);
        }
    }

    public void executeSQL(int pUser, String pCommand) {
        mStatements[pUser - 1].executeUpdateIgnoreErrors(pCommand);
    }

    public void executeSQL(String pCommand) {
        mStatements[0].executeUpdateIgnoreErrors(pCommand);
    }

    protected Connection getConnection(int UserId) throws TestCaseException {
        if (UserId < 1 || UserId > 3) {
            throw new TestCaseException(" UserId " + UserId + " is out of range[1," + 3 + "]");
        }
        return mConnections[UserId - 1];
    }

    private String getInfoString(String pMethodName, int pCounter, int pUser) {
        return "<" + pMethodName + "(), Statement " + pCounter + ", User " + pUser + ">";
    }

    public int getNextKey() {
        return this.mNextKey++;
    }

    public int getNextValue() {
        return this.mNextValue++;
    }

    protected TestStatement getStatement(int UserId) throws TestCaseException {
        if (UserId < 1 || UserId > 3) {
            throw new TestCaseException(" UserId " + UserId + " is out of range[1," + 3 + "]");
        }
        return mStatements[UserId - 1];
    }

    protected void prCheckSubtrans(int pUserId, int pKey) throws TestCaseException {
        this.prCheckSubtrans(pUserId, pKey, 10, 0);
    }

    protected void prCheckSubtrans(int pUserId, int pKey, int pRequestTimeout, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prCheckSubtrans", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            CallString = "CALL CHECK_SUBTRANS ( Key=" + pKey + ", Counter=" + this.mStatementCounter + ", Timeout=" + pRequestTimeout + ")";
            CallableStatement stmt = con.prepareCall("CALL CHECK_SUBTRANS (" + pKey + ", " + this.mStatementCounter + ", " + pRequestTimeout + ")");
            stmt.execute();
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return;
        }
        SQLRecoverTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
    }

    protected boolean prCheckValue(int pUserId, int pKey, int pExpectedValue) throws TestCaseException {
        return this.prCheckValue(pUserId, pKey, pExpectedValue, 0);
    }

    protected boolean prCheckValue(int pUserId, int pKey, int pExpectedValue, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        boolean ResultKey = false;
        int ResultValue = 0;
        String CallString = "";
        String ResultString = "";
        String InfoString = this.getInfoString("prCheckValue", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            CallString = "Call of GET_OBJECT_VALUE ( Key=" + pKey + ", Counter=" + this.mStatementCounter + " )";
            CallableStatement stmt = con.prepareCall("CALL GET_OBJECT_VALUE ( " + pKey + ", " + this.mStatementCounter + ", ?)");
            stmt.registerOutParameter(1, 4);
            stmt.execute();
            ResultValue = stmt.getInt(1);
            ResultString = CallString + " returned: ( Value=" + ResultValue + " )";
            if (ResultValue != pExpectedValue) {
                SQLRecoverTest.addGlobalMessage((String)InfoString, (char)'E', (String)("***** ERROR ****** " + ResultString + " --> expecting value " + pExpectedValue));
                throw new TestCaseException(ResultString + " --> expecting value " + pExpectedValue);
            }
            this.checkResultCode(InfoString, ResultString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, ResultString, pExpectedResultCode, e);
            return true;
        }
        SQLRecoverTest.addGlobalMessage((String)InfoString, (char)'I', (String)(ResultString + " --> OK"));
        return true;
    }

    protected void prCommit(int pUserId) throws TestCaseException {
        ++this.mStatementCounter;
        String InfoString = this.getInfoString("prCommit", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            con.commit();
            SQLRecoverTest.addGlobalMessage((String)InfoString, (char)'I', (String)"Commit --> OK");
        }
        catch (Exception e) {
            SQLRecoverTest.addGlobalMessage((String)InfoString, (char)'E', (String)("***** ERROR ****** Could not commit: " + e.getMessage()));
            throw new TestCaseException("Error in Primary test");
        }
    }

    public static void prepare() throws TestCaseException {
        Connection mSQLConnection = null;
        TestStatement mSQLStatement = null;
        try {
            block13: {
                try {
                    mSQLConnection = SQLRecoverTest.getDatabase().connect(SQLRecoverTest.getDatabase().getDBAUser(), SQLRecoverTest.getDatabase().getDBAPassword());
                }
                catch (Exception e) {
                    SQLRecoverTest.addGlobalMessage((String)"Login failure", (char)'E', (String)("DBAUser: " + SQLRecoverTest.getDatabase().getDBAUser() + ", Password: " + SQLRecoverTest.getDatabase().getDBAPassword()));
                    throw e;
                }
                mSQLStatement = new TestStatement(null, mSQLConnection);
                mSQLStatement.executeUpdateIgnoreErrors("drop user SQLUSER");
                try {
                    mSQLStatement.executeUpdate("Create user SQLUSER password SQLUSER dba not exclusive");
                }
                catch (DatabaseException e) {
                    if (e.getErrorCode() == -6006) break block13;
                    SQLRecoverTest.addGlobalMessage((String)"Init failure", (char)'E', (String)"Creation of user : SQLUSER not possible");
                    throw e;
                }
            }
            SQLRecoverTest.createConnections();
        }
        catch (Exception e) {
            throw (TestCaseException)((Object)e);
        }
        finally {
            try {
                mSQLStatement.close();
                mSQLConnection.close();
            }
            catch (Exception e) {}
        }
    }

    protected void printTestError(SQLRecoverTest pCallerClass) {
    }

    protected void printTestHeader(SQLRecoverTest pCallerClass) {
    }

    protected void printTestTrailer(SQLRecoverTest pCallerClass) {
    }

    protected void prReconnect(int pUserId) throws TestCaseException {
        String InfoString = this.getInfoString("prReconnect", this.mStatementCounter++, pUserId);
        try {
            if (pUserId < 1 || pUserId > 3) {
                throw new TestCaseException("Illegal user number: " + pUserId);
            }
            mConnections[--pUserId].close();
            mStatements[pUserId].close();
            SQLRecoverTest.mConnections[pUserId] = SQLRecoverTest.getDatabase().connect("SQLUSER", "SQLUSER");
            mConnections[pUserId].setAutoCommit(false);
            SQLRecoverTest.mStatements[pUserId] = new TestStatement(null, mConnections[pUserId]);
        }
        catch (Exception e) {
            SQLRecoverTest.addGlobalMessage((String)InfoString, (char)'E', (String)("***** ERROR ****** Reconnect for user " + pUserId + " failed: " + e.getMessage()));
            throw new TestCaseException("Error in Primary test");
        }
    }

    protected void prRollback(int pUserId) throws TestCaseException {
        ++this.mStatementCounter;
        String InfoString = this.getInfoString("prRollback", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            con.rollback();
            SQLRecoverTest.addGlobalMessage((String)InfoString, (char)'I', (String)"Rollback --> OK");
        }
        catch (Exception e) {
            SQLRecoverTest.addGlobalMessage((String)InfoString, (char)'E', (String)("Could not rollback: " + e.getMessage()));
            throw new TestCaseException("Error in Primary test");
        }
    }

    public int querySQL(String pCommand) {
        int sum = 0;
        try {
            ResultSet rs = mStatements[0].executeQuery(pCommand);
            while (rs.next()) {
                sum += rs.getInt("k1");
            }
            return sum;
        }
        catch (Exception e) {
            return -1;
        }
    }

    private static void readParameters() throws TestCaseException {
    }

    public void run() {
    }
}

