/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.lctest;

import com.sap.dbtech.jdbc.exceptions.DatabaseException;
import com.sap.dbtech.powertoys.DBM;
import com.sap.dbtech.rte.comm.RTEException;
import com.sap.sapdb.testframe.driver.TestDatabase;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.StringTokenizer;
import java.util.Vector;

public class MultiUserRandomShadow
extends TestCase {
    private static final String mExUser = "SHADOW";
    private static final String mExPassword = "SHADOW";
    private static Connection[] mConnections;
    private static TestStatement[] mStatements;
    private String mKernelMode = "FAST";
    private static int mTraceLevel;
    private DBM mDBManShadow = null;
    private DBM mDBManMaster = null;
    private static String mMasterDBName;
    private String[] mMasterLogSegmentsToRecover = new String[1000];
    private long mShadowRedoPage = -1L;
    private Vector mAlreadyRecoveredLogSegments = new Vector(1000);
    private Vector mLogSegmentsNOTToRecover = new Vector(200);
    private int mFilecounter = 0;
    private String mLastRecoveredLogSegment = "";
    private boolean mRecoverCancelShouldBeUsed = false;
    private static final String RECOVER_START = "recover_start";
    private static final String RECOVER_REPLACE = "recover_replace";
    private String mNextAction = "recover_start";
    protected static final int mNumberOfConnections = 1;
    protected static final int DBERR_DUPLICATE_NAME = -6006;

    public static void prepare() throws TestCaseException {
        Connection lConnection = null;
        TestStatement lTstmt = null;
        mMasterDBName = MultiUserRandomShadow.getParameterString((String)"MasterDBName", (String)"MURAND");
        try {
            block13: {
                TestCase.setInfoMessageFilter((boolean)false);
                try {
                    lConnection = MultiUserRandomShadow.getDatabase().connect(MultiUserRandomShadow.getDatabase().getDBAUser(), MultiUserRandomShadow.getDatabase().getDBAPassword());
                }
                catch (Exception e) {
                    MultiUserRandomShadow.addGlobalMessage((String)"Login failure", (char)'E', (String)("DBAUser: " + MultiUserRandomShadow.getDatabase().getDBAUser() + ", Password: " + MultiUserRandomShadow.getDatabase().getDBAPassword()));
                    throw e;
                }
                lTstmt = new TestStatement(null, lConnection);
                lTstmt.enableExceptions(false);
                lTstmt.executeUpdate("drop user SHADOW");
                lTstmt.enableExceptions(true);
                try {
                    lTstmt.executeUpdate("Create user SHADOW password SHADOW dba not exclusive");
                }
                catch (DatabaseException e) {
                    if (e.getErrorCode() == -6006) break block13;
                    MultiUserRandomShadow.addGlobalMessage((String)"Init failure", (char)'E', (String)"Creation of user : SHADOW not possible");
                    throw e;
                }
            }
            MultiUserRandomShadow.createConnections();
        }
        catch (Exception e) {
            throw (TestCaseException)e;
        }
        finally {
            try {
                lTstmt.close();
                lConnection.close();
            }
            catch (Exception e) {}
        }
    }

    public void run() {
        try {
            this.setStatus("createBackupMedia");
            this.executeShadowDBMCmd("util_connect");
            this.executeShadowDBMCmd("backup_media_put MURLOG " + this.getDataOutputPath() + System.getProperty("file.separator") + ".." + System.getProperty("file.separator") + "MultiUserRandom" + System.getProperty("file.separator") + "autosave FILE LOG 0 0 NO NO \"\" NONE");
            this.executeShadowDBMCmd("backup_media_put MURDAT " + this.getDataOutputPath() + System.getProperty("file.separator") + ".." + System.getProperty("file.separator") + "MultiUserRandom" + System.getProperty("file.separator") + "DAT_RESET.dat " + "FILE DATA 0 8 YES NO ");
            this.executeShadowDBMCmd("util_release");
            this.setStatus("Restart Database");
            MultiUserRandomShadow.addGlobalMessage((String)MultiUserRandomShadow.getTestClassId(), (char)'I', (String)"Restart with init-config and backup_restore");
            this.executeShadowDBMCmd("autosave_off");
            this.executeShadowDBMCmd("db_offline");
            this.executeShadowDBMCmd("db_cold -" + this.mKernelMode);
            this.executeShadowDBMCmd("util_connect");
            MultiUserRandomShadow.addGlobalMessage((String)MultiUserRandomShadow.getTestClassId(), (char)'I', (String)"db_activate RECOVER MURDAT DATA");
            TestDatabase mTestDatabase = MultiUserRandomShadow.getDatabase();
            TestDatabaseSap sapdb = null;
            if (mTestDatabase.isSap()) {
                sapdb = (TestDatabaseSap)mTestDatabase;
            }
            String cmd = "";
            if (TestDriver.compareRelease((String)(sapdb.getKernelVersion() + "." + sapdb.getKernelBuild().substring(0, 3)), (String)">=", (String)"7.4.4.1")) {
                cmd = "db_activate RECOVER MURDAT DATA";
                this.executeShadowDBMCmd(cmd);
            } else {
                cmd = "util_execute INIT CONFIG";
                this.executeShadowDBMCmd(cmd);
                cmd = "backup_restore MURDAT DATA";
                this.executeShadowDBMCmd(cmd);
            }
            MultiUserRandomShadow.addGlobalMessage((String)MultiUserRandomShadow.getTestClassId(), (char)'I', (String)"Get first shadow redo page using db_restartinfo");
            if (mTraceLevel > 0) {
                System.out.println("Get restart info: \n" + this.executeShadowDBMCmd("db_restartinfo"));
            }
            this.mShadowRedoPage = this.getShadowRedoPage();
            MultiUserRandomShadow.addGlobalMessage((String)MultiUserRandomShadow.getTestClassId(), (char)'I', (String)("mShadowRedoPage : " + this.mShadowRedoPage));
            MultiUserRandomShadow.addGlobalMessage((String)MultiUserRandomShadow.getTestClassId(), (char)'I', (String)"Get backup history list of master database");
            if (mTraceLevel > 0) {
                System.out.println("Get backup history list of master database: \n" + this.executeMasterDBMCmd("backup_history_list -Inverted -c LABEL,RC,FIRSTLOG,LASTLOG,KEY,ACTION", mMasterDBName));
            }
            this.mMasterLogSegmentsToRecover = this.getLogSegmentsToRecoverFromMaster();
            this.mAlreadyRecoveredLogSegments = this.addSmallerLogSegments(this.mMasterLogSegmentsToRecover[0]);
            this.executeShadowDBMCmd("db_offline");
            this.executeShadowDBMCmd("db_admin -" + this.mKernelMode);
            if (mTraceLevel > 0) {
                System.out.println("First log segment to recover is        : " + this.mMasterLogSegmentsToRecover[0]);
                System.out.println("Total number of log segments to recover: " + this.mMasterLogSegmentsToRecover.length);
            }
            MultiUserRandomShadow.addGlobalMessage((String)MultiUserRandomShadow.getTestClassId(), (char)'I', (String)("   First log segment to recover is        : " + this.mMasterLogSegmentsToRecover[0] + "\n   Total number of log segments to recover: " + this.mMasterLogSegmentsToRecover.length));
            this.executeShadowDBMCmd("util_connect");
            for (int i = 0; i < this.mMasterLogSegmentsToRecover.length; ++i) {
                if (i == 0) {
                    this.executeShadowDBMCmd("recover_start MURLOG " + this.mMasterLogSegmentsToRecover[i]);
                    this.mAlreadyRecoveredLogSegments.add(this.mMasterLogSegmentsToRecover[i]);
                    this.mLastRecoveredLogSegment = this.mMasterLogSegmentsToRecover[i];
                    ++this.mFilecounter;
                    continue;
                }
                if (this.mMasterLogSegmentsToRecover[i] == null || !this.checkDirectoryForLogsegment(this.mMasterLogSegmentsToRecover[i])) continue;
                this.executeShadowDBMCmd("recover_replace MURLOG " + this.getDataOutputPath() + System.getProperty("file.separator") + ".." + System.getProperty("file.separator") + "MultiUserRandom" + System.getProperty("file.separator") + "autosave " + this.mMasterLogSegmentsToRecover[i]);
                this.mLastRecoveredLogSegment = this.mMasterLogSegmentsToRecover[i];
                this.mAlreadyRecoveredLogSegments.add(this.mMasterLogSegmentsToRecover[i]);
                ++this.mFilecounter;
            }
            this.executeShadowDBMCmd("recover_cancel");
            this.executeShadowDBMCmd("util_release");
            this.sleepForSoManySeconds(30);
            boolean keepRunning = true;
            int soManyLoopsNothingDidHappen = 0;
            do {
                this.executeShadowDBMCmd("db_admin -" + this.mKernelMode);
                MultiUserRandomShadow.addGlobalMessage((String)MultiUserRandomShadow.getTestClassId(), (char)'I', (String)"Get first shadow redo page using db_restartinfo");
                if (mTraceLevel > 0) {
                    System.out.println("Get restart info: \n" + this.executeShadowDBMCmd("db_restartinfo"));
                }
                this.mShadowRedoPage = this.getShadowRedoPage();
                MultiUserRandomShadow.addGlobalMessage((String)MultiUserRandomShadow.getTestClassId(), (char)'I', (String)("mShadowRedoPage : " + this.mShadowRedoPage));
                this.mMasterLogSegmentsToRecover = null;
                this.mMasterLogSegmentsToRecover = this.getLogSegmentsToRecoverFromMaster();
                this.mAlreadyRecoveredLogSegments = this.addSmallerLogSegments(this.mMasterLogSegmentsToRecover[0]);
                this.sleepForSoManySeconds(30);
                System.out.println("\n");
                if (mTraceLevel > 0) {
                    System.out.println("First log segment to recover is        : " + this.mMasterLogSegmentsToRecover[0]);
                    System.out.println("Total number of log segments to recover: " + this.mMasterLogSegmentsToRecover.length);
                }
                MultiUserRandomShadow.addGlobalMessage((String)MultiUserRandomShadow.getTestClassId(), (char)'I', (String)("   First log segment to recover is        : " + this.mMasterLogSegmentsToRecover[0] + "\n   Total number of log segments to recover: " + this.mMasterLogSegmentsToRecover.length));
                this.executeShadowDBMCmd("util_connect");
                for (int i = 0; i < this.mMasterLogSegmentsToRecover.length; ++i) {
                    if (soManyLoopsNothingDidHappen < 10) {
                        if (i == 0) {
                            this.executeShadowDBMCmd("recover_start MURLOG " + this.mMasterLogSegmentsToRecover[i]);
                            this.mAlreadyRecoveredLogSegments.add(this.mMasterLogSegmentsToRecover[i]);
                            if (this.mLastRecoveredLogSegment.equals(this.mMasterLogSegmentsToRecover[i])) {
                                ++soManyLoopsNothingDidHappen;
                            }
                            ++this.mFilecounter;
                        } else if (this.mMasterLogSegmentsToRecover[i] != null && this.checkDirectoryForLogsegment(this.mMasterLogSegmentsToRecover[i])) {
                            this.executeShadowDBMCmd("recover_replace MURLOG " + this.getDataOutputPath() + System.getProperty("file.separator") + ".." + System.getProperty("file.separator") + "MultiUserRandom" + System.getProperty("file.separator") + "autosave " + this.mMasterLogSegmentsToRecover[i]);
                            this.mLastRecoveredLogSegment = this.mMasterLogSegmentsToRecover[i];
                            this.mAlreadyRecoveredLogSegments.add(this.mMasterLogSegmentsToRecover[i]);
                            ++this.mFilecounter;
                            soManyLoopsNothingDidHappen = 0;
                        }
                        System.out.println("######################## soManyLoopsNothingDidHappen =" + soManyLoopsNothingDidHappen);
                        continue;
                    }
                    keepRunning = false;
                    System.out.println("######################## soManyLoopsNothingDidHappen =" + soManyLoopsNothingDidHappen + "\n keepRunnin was set to FALSE!!!");
                }
                this.executeShadowDBMCmd("recover_cancel");
                this.executeShadowDBMCmd("util_release");
                this.sleepForSoManySeconds(60);
                System.out.println("\n");
            } while (keepRunning);
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    public static void cleanUp() throws TestCaseException {
    }

    public static long getTimeout() {
        return 0L;
    }

    public void sleepForSoManySeconds(int lSeconds) {
        try {
            for (int i = 0; i < lSeconds; ++i) {
                System.out.print("z ");
                Thread.sleep(1000L);
                System.out.print("Z ");
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public String findNextLogSementToRecover() {
        String lReturnLogSegToRecover = "";
        try {
            String backuphistory = this.executeMasterDBMCmd("backup_history_list -Inverted -c LABEL,RC,FIRSTLOG,LASTLOG,KEY,ACTION", mMasterDBName);
            backuphistory = backuphistory.replaceAll("\n", "|");
            StringTokenizer bhstring = new StringTokenizer(backuphistory, "|");
            int i = 0;
            while (bhstring.hasMoreTokens()) {
                String currentToken = bhstring.nextToken().trim();
                if (currentToken.startsWith("LOG_")) {
                    lReturnLogSegToRecover = currentToken.substring(10, 13);
                    ++i;
                    Integer returnCodeObj = new Integer(bhstring.nextToken().trim());
                    int returnCode = returnCodeObj;
                    if (returnCode != 0) break;
                    Integer firstLogObj = new Integer(bhstring.nextToken().trim());
                    int firstLog = firstLogObj;
                    Integer lastLogObj = new Integer(bhstring.nextToken().trim());
                    int lastLog = lastLogObj;
                    if (this.mShadowRedoPage >= (long)firstLog && this.mShadowRedoPage <= (long)lastLog) break;
                }
                if (currentToken.compareTo("HISTLOST") != 0) continue;
                break;
            }
            System.out.println("lReturnLogSegToRecover      : " + lReturnLogSegToRecover);
            System.out.println("lReturnLogSegsToRecover    : " + lReturnLogSegToRecover);
            return lReturnLogSegToRecover;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (TestDatabaseException e) {
            e.printStackTrace();
        }
        return lReturnLogSegToRecover;
    }

    public void recoverStart(String lMasterLogSegmentToBeUsed) {
        String outString = "";
        try {
            this.executeShadowDBMCmd("util_connect");
            outString = this.executeShadowDBMCmd("recover_start MURLOG " + lMasterLogSegmentToBeUsed);
        }
        catch (Exception e) {
            System.out.println("recoverStart failed! outString: \n" + outString);
        }
    }

    public void recoverReplace(String lMasterLogSegmentToBeUsed) {
        String outString = "";
        try {
            outString = this.executeShadowDBMCmd("recover_replace MURLOG " + this.getDataOutputPath() + System.getProperty("file.separator") + ".." + System.getProperty("file.separator") + "MultiUserRandom" + System.getProperty("file.separator") + "autosave " + lMasterLogSegmentToBeUsed);
        }
        catch (Exception e) {
            System.out.println("recoverStart failed! outString: \n" + outString);
        }
    }

    private static boolean createConnections() {
        try {
            mConnections = new Connection[1];
            mStatements = new TestStatement[1];
            for (int i = 0; i < 1; ++i) {
                MultiUserRandomShadow.mConnections[i] = MultiUserRandomShadow.getDatabase().connect("SHADOW", "SHADOW");
                mConnections[i].setAutoCommit(false);
                MultiUserRandomShadow.mStatements[i] = new TestStatement(null, mConnections[i]);
            }
        }
        catch (Exception e) {
            MultiUserRandomShadow.addGlobalMessage((String)"createConnections", (char)'E', (String)("Error during connection creation: " + e.getMessage()));
            return false;
        }
        return true;
    }

    protected Connection getConnection(int UserId) throws TestCaseException {
        if (UserId < 1 || UserId > 1) {
            throw new TestCaseException(" UserId " + UserId + " is out of range[1," + 1 + "]");
        }
        return mConnections[UserId - 1];
    }

    protected TestStatement getStatement(int UserId) throws TestCaseException {
        if (UserId < 1 || UserId > 1) {
            throw new TestCaseException(" UserId " + UserId + " is out of range[1," + 1 + "]");
        }
        return mStatements[UserId - 1];
    }

    public String executeShadowDBMCmd(String pCmd) throws TestDatabaseException {
        String logon = "";
        String mHost = "";
        String mName = "";
        MultiUserRandomShadow.printInfo(5, MultiUserRandomShadow.getTestClassId(), "executeShadowDBMCmd: " + pCmd);
        try {
            mHost = MultiUserRandomShadow.getDatabase().getHost();
            mName = MultiUserRandomShadow.getDatabase().getName();
            int mPort = MultiUserRandomShadow.getDatabase().getPort();
            if (this.mDBManShadow == null) {
                this.mDBManShadow = DBM.dbDBM((String)(mHost + ":" + mPort), (String)mName);
                logon = "USER_LOGON DBM,DBM";
                this.mDBManShadow.cmd(logon);
            }
            return this.mDBManShadow.cmd(pCmd);
        }
        catch (Exception e) {
            if (this.mDBManShadow != null) {
                try {
                    this.mDBManShadow.release();
                }
                catch (RTEException rte) {
                    // empty catch block
                }
                this.mDBManShadow = null;
            }
            throw new TestDatabaseException(e, " DBM command: " + pCmd + ", logon String: " + logon);
        }
    }

    public String executeMasterDBMCmd(String pCmd, String pMasterDBName) throws TestDatabaseException {
        String logon = "";
        String mHost = "";
        String mName = "";
        MultiUserRandomShadow.printInfo(5, MultiUserRandomShadow.getTestClassId(), "executeMasterDBMCmd: " + pCmd);
        try {
            mHost = MultiUserRandomShadow.getDatabase().getHost();
            mName = pMasterDBName;
            int mPort = MultiUserRandomShadow.getDatabase().getPort();
            if (this.mDBManMaster == null) {
                this.mDBManMaster = DBM.dbDBM((String)(mHost + ":" + mPort), (String)mName);
                logon = "USER_LOGON DBM,DBM";
                this.mDBManMaster.cmd(logon);
                MultiUserRandomShadow.printInfo(5, MultiUserRandomShadow.getTestClassId(), "executeMasterDBMCmd LOGON: " + logon);
            }
            return this.mDBManMaster.cmd(pCmd);
        }
        catch (Exception e) {
            if (this.mDBManMaster != null) {
                try {
                    this.mDBManMaster.release();
                }
                catch (RTEException rte) {
                    // empty catch block
                }
                this.mDBManMaster = null;
            }
            throw new TestDatabaseException(e, " DBM command: " + pCmd + ", logon String: " + logon);
        }
    }

    private static void printInfo(int Level2, String pComponent, String pInfoText) {
        if (Level2 <= mTraceLevel) {
            System.out.println(pComponent + " --> " + pInfoText);
        }
        if (Level2 < 7) {
            MultiUserRandomShadow.addGlobalMessage((String)pComponent, (char)'I', (String)pInfoText);
        } else if (mTraceLevel >= 9) {
            MultiUserRandomShadow.addGlobalMessage((String)pComponent, (char)'I', (String)pInfoText);
        }
    }

    public int getShadowRedoPage() {
        int usedLogPage = 0;
        String tmp = "";
        try {
            boolean loop = true;
            do {
                try {
                    tmp = this.executeShadowDBMCmd("db_restartinfo");
                    loop = false;
                }
                catch (TestDatabaseException e) {
                    if (mTraceLevel > 0) {
                        System.out.println("*** UsedLogPage ERROR: " + e.toString());
                    }
                    if (e.toString().indexOf("-104") != -1) continue;
                    loop = false;
                }
            } while (loop);
            int index = tmp.indexOf("First");
            Integer usedLogPageObj = new Integer(tmp.substring(index - 6, index - 1).trim());
            usedLogPage = usedLogPageObj;
            if (mTraceLevel > 0) {
                System.out.println("UsedLogPage: " + usedLogPage);
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return usedLogPage;
    }

    public String[] getLogSegmentsToRecoverFromMaster() {
        String[] lTempLogSegsToRecover = new String[1000];
        String[] lReturnLogSegsToRecover = null;
        try {
            for (int i = 0; i < lTempLogSegsToRecover.length; ++i) {
                lTempLogSegsToRecover[i] = "nixdrinne";
            }
            this.mDBManMaster = null;
            String backuphistory = this.executeMasterDBMCmd("backup_history_list -Inverted -c LABEL,RC,FIRSTLOG,LASTLOG,KEY,ACTION", mMasterDBName);
            System.out.println("-----------------------------------\n" + this.executeMasterDBMCmd("backup_history_list -Inverted -c LABEL,RC,FIRSTLOG,LASTLOG,KEY,ACTION", mMasterDBName));
            backuphistory = backuphistory.replaceAll("\n", "|");
            StringTokenizer bhstring = new StringTokenizer(backuphistory, "|");
            int i = 0;
            while (bhstring.hasMoreTokens()) {
                String currentToken = bhstring.nextToken().trim();
                if (currentToken.startsWith("LOG_")) {
                    lTempLogSegsToRecover[i] = currentToken.substring(10, 13);
                    ++i;
                    Integer returnCodeObj = new Integer(bhstring.nextToken().trim());
                    int returnCode = returnCodeObj;
                    if (returnCode != 0) break;
                    Integer firstLogObj = new Integer(bhstring.nextToken().trim());
                    int firstLog = firstLogObj;
                    Integer lastLogObj = new Integer(bhstring.nextToken().trim());
                    int lastLog = lastLogObj;
                    if (this.mShadowRedoPage >= (long)firstLog && this.mShadowRedoPage <= (long)lastLog) break;
                }
                if (currentToken.compareTo("HISTLOST") != 0) continue;
                break;
            }
            lReturnLogSegsToRecover = new String[i];
            int idx = 0;
            for (int j = lTempLogSegsToRecover.length - 1; j >= 0; --j) {
                if (lTempLogSegsToRecover[j].equalsIgnoreCase("nixdrinne")) continue;
                lReturnLogSegsToRecover[idx] = lTempLogSegsToRecover[j];
                ++idx;
            }
            System.out.println("These many log segments are to be recovered (lReturnLogSegsToRecover.length)    : " + lReturnLogSegsToRecover.length);
            return lReturnLogSegsToRecover;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (TestDatabaseException e) {
            e.printStackTrace();
        }
        return lReturnLogSegsToRecover;
    }

    public boolean checkDirectoryForLogsegment(String lLogSegmentNumber) {
        boolean logSegmentExists = false;
        MultiUserRandomShadow.addGlobalMessage((String)MultiUserRandomShadow.getTestClassId(), (char)'I', (String)("Check, if log segement with number " + lLogSegmentNumber + " arrived from MultiUserRandom test!"));
        System.out.println("Check, if log segement with number " + lLogSegmentNumber + " arrived from MultiUserRandom test!");
        File FileDir = null;
        FileDir = new File(this.getDataOutputPath() + System.getProperty("file.separator") + ".." + System.getProperty("file.separator") + "MultiUserRandom" + System.getProperty("file.separator"));
        if (FileDir == null) {
            MultiUserRandomShadow.addGlobalMessage((String)"run()", (char)'I', (String)"No recovery of new autosave files possible: can't read MY DATAOUTPUTPATH; getting: null");
            return logSegmentExists;
        }
        if (FileDir.isDirectory()) {
            String[] FileList = FileDir.list();
            for (int i = 0; i < FileList.length && this.mFilecounter < 1000; ++i) {
                File file = new File(FileDir, FileList[i]);
                String fileName = file.getName();
                String logSegNumber = fileName.substring(fileName.indexOf(".") + 1);
                if (!fileName.startsWith("autosave.") || !logSegNumber.equals(lLogSegmentNumber)) continue;
                MultiUserRandomShadow.addGlobalMessage((String)"checkDirectoryAgainAndAgain()", (char)'I', (String)("Will recover " + fileName + "!"));
                if (this.doesCopyLockfileExist()) continue;
                logSegmentExists = true;
            }
        }
        return logSegmentExists;
    }

    public boolean checkDirectoryAgainAndAgain() {
        boolean didSomeRecovery = false;
        MultiUserRandomShadow.addGlobalMessage((String)MultiUserRandomShadow.getTestClassId(), (char)'I', (String)"Check, if new autosave files arrived from MultiUserRandom test!");
        System.out.println("Recursively check, if new autosave files arrived from MultiUserRandom test!");
        File FileDir = null;
        System.out.println("getDataOutputPath(): " + this.getDataOutputPath() + System.getProperty("file.separator") + ".." + System.getProperty("file.separator") + "MultiUserRandom" + System.getProperty("file.separator"));
        FileDir = new File(this.getDataOutputPath() + System.getProperty("file.separator") + ".." + System.getProperty("file.separator") + "MultiUserRandom" + System.getProperty("file.separator"));
        if (FileDir == null) {
            MultiUserRandomShadow.addGlobalMessage((String)"run()", (char)'I', (String)"No recovery of new autosave files possible: can't read MY DATAOUTPUTPATH; getting: null");
            return didSomeRecovery;
        }
        if (this.mRecoverCancelShouldBeUsed && this.mAlreadyRecoveredLogSegments.contains(this.mLastRecoveredLogSegment)) {
            this.mAlreadyRecoveredLogSegments.remove(this.mLastRecoveredLogSegment);
        }
        if (FileDir.isDirectory()) {
            String[] FileList = FileDir.list();
            for (int i = 0; i < FileList.length && this.mFilecounter < 1000; ++i) {
                File file = new File(FileDir, FileList[i]);
                String fileName = file.getName();
                String logSegNumber = fileName.substring(fileName.indexOf(".") + 1);
                if (!fileName.startsWith("autosave.") || this.mAlreadyRecoveredLogSegments.contains(logSegNumber) || this.mLogSegmentsNOTToRecover.contains(logSegNumber)) continue;
                System.out.println(fileName);
                MultiUserRandomShadow.addGlobalMessage((String)"checkDirectoryAgainAndAgain()", (char)'I', (String)("Will recover " + fileName + "!"));
                if (this.doesCopyLockfileExist()) continue;
                this.recoverCancelMissingLogfiles(fileName, this.mNextAction);
                if (this.mNextAction.equals(RECOVER_START)) {
                    this.mNextAction = RECOVER_REPLACE;
                } else if (this.mNextAction.equals(RECOVER_REPLACE)) {
                    this.mNextAction = RECOVER_START;
                }
                didSomeRecovery = true;
            }
        }
        return didSomeRecovery;
    }

    public boolean doesCopyLockfileExist() {
        boolean lFileIsThere;
        File copyLockfile = new File(this.getDataOutputPath() + File.separator + ".." + File.separator + "copyLockfile");
        if (copyLockfile.exists()) {
            System.out.println("copyLockfile is still there - have to wait until copying is finished!");
            lFileIsThere = true;
        } else {
            System.out.println("copyLockfile is gone - recovery can be done with this autosave file!");
            lFileIsThere = false;
        }
        return lFileIsThere;
    }

    private void recoverCancelMissingLogfiles(String lFileName, String lNextAction) {
        String logSegmentToRecover = lFileName.substring(lFileName.indexOf(".") + 1);
        System.out.println("logSegmentToRecover : " + logSegmentToRecover);
        try {
            if (lNextAction.equals(RECOVER_START)) {
                this.executeShadowDBMCmd("db_cold -" + this.mKernelMode);
                this.mShadowRedoPage = this.getShadowRedoPage();
                this.mMasterLogSegmentsToRecover = this.getLogSegmentsToRecoverFromMaster();
            }
            String outString = "";
            String outCancelString = "";
            if (lNextAction.equals(RECOVER_START)) {
                outString = this.executeShadowDBMCmd("recover_start MURLOG " + logSegmentToRecover);
            } else if (lNextAction.equals(RECOVER_REPLACE)) {
                outString = this.executeShadowDBMCmd("recover_replace MURLOG " + this.getDataOutputPath() + System.getProperty("file.separator") + ".." + System.getProperty("file.separator") + "MultiUserRandom" + System.getProperty("file.separator") + "autosave " + logSegmentToRecover);
                outCancelString = this.executeShadowDBMCmd("recover_cancel");
            }
            this.mAlreadyRecoveredLogSegments.add(logSegmentToRecover);
            this.mLastRecoveredLogSegment = logSegmentToRecover;
            ++this.mFilecounter;
        }
        catch (TestDatabaseException tde) {
            // empty catch block
        }
    }

    public boolean isDevelopmentInstallation() {
        String itprop = System.getProperty("db.insttype");
        return itprop == null || itprop.equalsIgnoreCase("develop") || itprop.equalsIgnoreCase("developer") || itprop.equalsIgnoreCase("development");
    }

    public Vector addSmallerLogSegments(String lMasterLogSegmentToBeUsed) {
        Vector<String> lAlreadyRecoveredLogSegments = new Vector<String>(1000);
        if (lMasterLogSegmentToBeUsed.equals("009")) {
            lAlreadyRecoveredLogSegments.add("008");
            lAlreadyRecoveredLogSegments.add("007");
            lAlreadyRecoveredLogSegments.add("006");
            lAlreadyRecoveredLogSegments.add("005");
            lAlreadyRecoveredLogSegments.add("004");
            lAlreadyRecoveredLogSegments.add("003");
            lAlreadyRecoveredLogSegments.add("002");
            lAlreadyRecoveredLogSegments.add("001");
        }
        if (lMasterLogSegmentToBeUsed.equals("008")) {
            lAlreadyRecoveredLogSegments.add("007");
            lAlreadyRecoveredLogSegments.add("006");
            lAlreadyRecoveredLogSegments.add("005");
            lAlreadyRecoveredLogSegments.add("004");
            lAlreadyRecoveredLogSegments.add("003");
            lAlreadyRecoveredLogSegments.add("002");
            lAlreadyRecoveredLogSegments.add("001");
        }
        if (lMasterLogSegmentToBeUsed.equals("007")) {
            lAlreadyRecoveredLogSegments.add("006");
            lAlreadyRecoveredLogSegments.add("005");
            lAlreadyRecoveredLogSegments.add("004");
            lAlreadyRecoveredLogSegments.add("003");
            lAlreadyRecoveredLogSegments.add("002");
            lAlreadyRecoveredLogSegments.add("001");
        }
        if (lMasterLogSegmentToBeUsed.equals("006")) {
            lAlreadyRecoveredLogSegments.add("005");
            lAlreadyRecoveredLogSegments.add("004");
            lAlreadyRecoveredLogSegments.add("003");
            lAlreadyRecoveredLogSegments.add("002");
            lAlreadyRecoveredLogSegments.add("001");
        }
        if (lMasterLogSegmentToBeUsed.equals("005")) {
            lAlreadyRecoveredLogSegments.add("004");
            lAlreadyRecoveredLogSegments.add("003");
            lAlreadyRecoveredLogSegments.add("002");
            lAlreadyRecoveredLogSegments.add("001");
        }
        if (lMasterLogSegmentToBeUsed.equals("004")) {
            lAlreadyRecoveredLogSegments.add("003");
            lAlreadyRecoveredLogSegments.add("002");
            lAlreadyRecoveredLogSegments.add("001");
        }
        if (lMasterLogSegmentToBeUsed.equals("003")) {
            lAlreadyRecoveredLogSegments.add("002");
            lAlreadyRecoveredLogSegments.add("001");
        }
        if (lMasterLogSegmentToBeUsed.equals("002")) {
            lAlreadyRecoveredLogSegments.add("001");
        }
        return lAlreadyRecoveredLogSegments;
    }

    static {
        mTraceLevel = 9;
        mMasterDBName = "";
    }
}

