/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.lctest;

import com.sap.sapdb.lctest.DataConsistencyException;
import com.sap.sapdb.lctest.ListDescriptor;
import com.sap.sapdb.lctest.LiveCacheActor;
import com.sap.sapdb.lctest.LiveCacheMaster;
import com.sap.sapdb.lctest.Oid;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCase;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.Date;

public class LiveCacheWriter
extends LiveCacheActor {
    private int mObjectIndex;
    private int mNewObjectValue;
    private int mNumberOfLists = 0;
    private int mMaxListLength = 0;
    private int mObjPercentage = 0;
    private int mKeyedPercentage = 0;
    private int mVarPercentage = 0;
    private int mVarMaxLength = 0;
    private int mSubtransactionPercentage = 0;
    private int mSubtransCommitPercentage = 0;
    private int mInsertPercentage = 0;
    private int mUpdatePercentage = 0;
    private int mDeletePercentage = 0;
    private boolean mTwoPhaseCommit = false;

    public LiveCacheWriter() {
        this.mTitle = "Writer";
    }

    public void check() throws DataConsistencyException {
    }

    public int getActorType() {
        return 1;
    }

    protected int nextAction() {
        switch (this.mAction) {
            case 0: 
            case 6: 
            case 7: {
                if (LiveCacheWriter.randomInteger(0, 100) <= this.mInsertPercentage) {
                    this.mAction = 9;
                    break;
                }
                this.mAction = 4;
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                this.mAction = 6;
                break;
            }
            case 4: {
                this.mAction = LiveCacheWriter.randomInteger(0, this.mUpdatePercentage + this.mDeletePercentage) <= this.mUpdatePercentage ? 11 : 10;
            }
        }
        if (this.mAction == 6 && Math.random() > 0.5) {
            this.mAction = 7;
        }
        return this.mAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block50: {
            int CurrentCycle = 0;
            int ListIndex = -1;
            int CurrentLoop = 0;
            boolean KeepRunning = true;
            boolean ExpectingOutOfDate = false;
            boolean inException = false;
            ListDescriptor mList = null;
            ListDescriptor OldList = null;
            this.mRunning = true;
            Boolean SyncObject = new Boolean(true);
            try {
                while (KeepRunning) {
                    this.mAction = this.nextAction();
                    if (CurrentLoop % LiveCacheMaster.mTraceLoops == 0) {
                        LiveCacheMaster.printInfo(this.mTitle, "Starting cycle " + CurrentLoop);
                    }
                    ++CurrentLoop;
                    switch (this.mAction) {
                        case 4: {
                            CallableStatement stm;
                            ListIndex = LiveCacheWriter.randomInteger(0, this.mNumberOfLists - 1);
                            mList = this.mMaster.getList(ListIndex);
                            if (mList == null) {
                                if (this.mTraceOn) {
                                    LiveCacheMaster.printTrace(this.mTitle + ": List <" + ListIndex + "> not existent yet");
                                }
                                this.mAction = 6;
                                break;
                            }
                            OldList = (ListDescriptor)mList.clone();
                            SyncObject = this.mMaster.getSyncObject(ListIndex);
                            try {
                                if (this.mTraceOn) {
                                    LiveCacheMaster.printTrace(this.mTitle + ": Trying to lock list no <" + ListIndex + "> with OID " + mList.getRootOid().toString());
                                }
                                stm = this.mConnection.prepareCall("CALL LIST_LOCK(?)");
                                stm.setBytes(1, mList.getRootOid().getOmsOid());
                                Boolean bl = SyncObject;
                                synchronized (bl) {
                                    stm.execute();
                                    if (this.mMaster.isListLocked(ListIndex)) {
                                        LiveCacheMaster.printTrace(this.mTitle + ": ** ERROR ** List <" + ListIndex + "> should be locked, but is accessible");
                                        this.setStatus(-1, "List <" + ListIndex + "> should be locked, but is accessible");
                                        KeepRunning = false;
                                    } else {
                                        this.mMaster.setListLocked(ListIndex, true);
                                    }
                                }
                                LiveCacheMaster.printTrace(this.mTitle + ": Lock end");
                                break;
                            }
                            catch (SQLException e) {
                                if (e.getErrorCode() == -51 || e.getErrorCode() == -28007 || e.getErrorCode() == -28814 || e.getErrorCode() == -28802 || e.getErrorCode() == -28804) {
                                    if (this.mTraceOn) {
                                        LiveCacheMaster.printTrace(this.mTitle + ": List <" + ListIndex + "> cannot be locked - committing");
                                    }
                                    this.mConnection.commit();
                                    this.mAction = 6;
                                    break;
                                }
                                throw e;
                            }
                        }
                        case 9: {
                            ListIndex = LiveCacheWriter.randomInteger(0, this.mNumberOfLists - 1);
                            mList = this.mMaster.createList(ListIndex);
                            if (mList == null) {
                                if (this.mTraceOn) {
                                    LiveCacheMaster.printTrace(this.mTitle + ": List <" + ListIndex + "> still exists and could not be created");
                                }
                                this.mAction = 6;
                                break;
                            }
                            if (this.mTraceOn) {
                                LiveCacheMaster.printTrace(this.mTitle + ": Creating new list <" + ListIndex + "> with <" + mList.getNumberOfObjects() + "> entries.");
                            }
                            OldList = (ListDescriptor)mList.clone();
                            mList.setValid(true);
                            mList.setNumberOfObjects(LiveCacheWriter.randomInteger(0, this.mMaxListLength - 1));
                            CallableStatement stm = this.mConnection.prepareCall("CALL LIST_CREATE( " + this.mSubtransactionPercentage + ", " + this.mSubtransCommitPercentage + ", " + mList.getNumberOfObjects() + ", " + this.mObjPercentage + ", " + this.mKeyedPercentage + ", " + this.mVarPercentage + ", " + this.mVarMaxLength + ", ?, ?)");
                            stm.registerOutParameter(1, 4);
                            stm.registerOutParameter(2, -2);
                            stm.execute();
                            mList.setChecksum(stm.getInt(1));
                            mList.setRootOid(new Oid(stm.getBytes(2)));
                            mList.setValid(true);
                            if (!this.mTraceOn) break;
                            LiveCacheMaster.printTrace(this.mTitle + ": New List <" + ListIndex + "> : " + mList.toString());
                            break;
                        }
                        case 10: {
                            if (this.mTraceOn) {
                                LiveCacheMaster.printTrace(this.mTitle + ": Removing list <" + ListIndex + ">");
                            }
                            CallableStatement stm = this.mConnection.prepareCall("CALL LIST_REMOVE(?)");
                            stm.setBytes(1, mList.getRootOid().getOmsOid());
                            stm.execute();
                            mList.setRootOid(null);
                            mList.setValid(false);
                            break;
                        }
                        case 11: {
                            int NextUpdateAction = LiveCacheWriter.randomInteger(0, 100);
                            String DBProcedureName = NextUpdateAction < 33 ? "LIST_INSERT" : (NextUpdateAction < 67 ? "LIST_UPDATE" : "LIST_DELETE");
                            if (this.mTraceOn) {
                                LiveCacheMaster.printTrace(this.mTitle + ": Calling " + DBProcedureName + " for list <" + ListIndex + ">");
                            }
                            CallableStatement stm = this.mConnection.prepareCall("CALL " + DBProcedureName + "( ?, 50, ?, ? )");
                            stm.setBytes(1, mList.getRootOid().getOmsOid());
                            stm.registerOutParameter(2, 4);
                            stm.registerOutParameter(3, 4);
                            stm.execute();
                            mList.setNumberOfObjects(stm.getInt(2));
                            mList.setChecksum(stm.getInt(3));
                            if (!this.mTraceOn) break;
                            LiveCacheMaster.printTrace(this.mTitle + ": List <" + ListIndex + "> has now : " + mList.toString());
                            break;
                        }
                        case 6: {
                            if (this.mTraceOn) {
                                LiveCacheMaster.printTrace(this.mTitle + ": Committing list <" + ListIndex + "> to : " + mList.toString());
                            }
                            mList.setLocked(false);
                            Boolean bl = SyncObject;
                            synchronized (bl) {
                                this.mConnection.commit();
                                this.mMaster.setListInProgress(ListIndex, false);
                                this.mMaster.setList(ListIndex, mList);
                            }
                            if (this.mTraceOn) {
                                LiveCacheMaster.printTrace(this.mTitle + ": Committing finished");
                            }
                            ++CurrentCycle;
                            break;
                        }
                        case 7: {
                            if (this.mTraceOn) {
                                LiveCacheMaster.printTrace(this.mTitle + ": Rolling back list <" + ListIndex + ">");
                            }
                            Boolean bl = SyncObject;
                            synchronized (bl) {
                                this.mConnection.rollback();
                                this.mMaster.setListLocked(ListIndex, false);
                                this.mMaster.setListInProgress(ListIndex, false);
                            }
                            if (this.mTraceOn) {
                                LiveCacheMaster.printTrace(this.mTitle + ": Rollback finished");
                            }
                            ++CurrentCycle;
                        }
                    }
                    LiveCacheWriter.sleep(25L);
                    if (this.mCycleNumber != -1 && CurrentCycle > this.mCycleNumber) {
                        LiveCacheMaster.printTrace(this.mTitle + ": Finished <" + (CurrentCycle - 1) + "> cycles");
                        KeepRunning = false;
                        this.setStatus(1);
                    }
                    if (!this.mShouldStop) continue;
                    LiveCacheMaster.printTrace(this.mTitle + ": Soft interrupted at " + (CurrentCycle - 1) + " cycles");
                    KeepRunning = false;
                    this.setStatus(2, "Interrupted by master thread at " + (CurrentCycle - 1) + " cycles");
                }
                Object var17_23 = null;
                super.cleanup();
                if (!inException || this.mTwoPhaseCommit || this.mAction != 6 || mList == null || !mList.isLocked() || ListIndex == -1) break block50;
                this.mMaster.mLists_Fallback[ListIndex] = mList;
                this.mMaster.mLists_Fallback[ListIndex].setValid(true);
            }
            catch (Throwable throwable) {
                Object var17_27 = null;
                super.cleanup();
                if (inException && !this.mTwoPhaseCommit && this.mAction == 6 && mList != null && mList.isLocked() && ListIndex != -1) {
                    this.mMaster.mLists_Fallback[ListIndex] = mList;
                    this.mMaster.mLists_Fallback[ListIndex].setValid(true);
                    LiveCacheMaster.printTrace(this.mTitle + ": Use fallback-list for list <" + ListIndex + "> with : " + mList.toString());
                }
                throw throwable;
            }
            LiveCacheMaster.printTrace(this.mTitle + ": Use fallback-list for list <" + ListIndex + "> with : " + mList.toString());
            {
                break block50;
                catch (SQLException e) {
                    if (this.mShouldStop && (e.getErrorCode() == -708 || e.getErrorCode() == -700 || e.getErrorCode() == -904 || e.getErrorCode() == -907)) {
                        LiveCacheMaster.printTrace(this.mTitle + ": Exception but soft interrupted by master thread at " + (CurrentCycle - 1) + " cycles");
                        KeepRunning = false;
                        this.setStatus(2, "Interrupted by master thread at " + (CurrentCycle - 1) + " cycles (in exception)");
                    } else {
                        LiveCacheMaster.printTrace(this.mTitle + ": ** ERROR ** Raising exception " + e.getLocalizedMessage());
                        this.setStatus(-2, "SQLException: " + e.getLocalizedMessage());
                        StringWriter sw = new StringWriter();
                        e.printStackTrace(new PrintWriter(sw));
                        System.err.println("last action of " + this.mTitle + ": " + this.mAction + " on " + mDateFormat.format(new Date()));
                        System.err.println("sql-error-trace:\n" + sw.toString());
                    }
                    inException = true;
                    Object var17_24 = null;
                    super.cleanup();
                    if (inException && !this.mTwoPhaseCommit && this.mAction == 6 && mList != null && mList.isLocked() && ListIndex != -1) {
                        this.mMaster.mLists_Fallback[ListIndex] = mList;
                        this.mMaster.mLists_Fallback[ListIndex].setValid(true);
                        LiveCacheMaster.printTrace(this.mTitle + ": Use fallback-list for list <" + ListIndex + "> with : " + mList.toString());
                    }
                    break block50;
                }
                catch (InterruptedException e) {
                    LiveCacheMaster.printTrace(this.mTitle + ": Hard interrupted");
                    this.setStatus(2);
                    inException = true;
                    Object var17_25 = null;
                    super.cleanup();
                    if (inException && !this.mTwoPhaseCommit && this.mAction == 6 && mList != null && mList.isLocked() && ListIndex != -1) {
                        this.mMaster.mLists_Fallback[ListIndex] = mList;
                        this.mMaster.mLists_Fallback[ListIndex].setValid(true);
                        LiveCacheMaster.printTrace(this.mTitle + ": Use fallback-list for list <" + ListIndex + "> with : " + mList.toString());
                    }
                    break block50;
                }
                catch (Exception e) {
                    LiveCacheMaster.printTrace(this.mTitle + ": ** ERROR **  General exception: " + e.getMessage());
                    this.setStatus(-3, "Exception: " + e.getMessage());
                    inException = true;
                    Object var17_26 = null;
                    super.cleanup();
                    if (inException && !this.mTwoPhaseCommit && this.mAction == 6 && mList != null && mList.isLocked() && ListIndex != -1) {
                        this.mMaster.mLists_Fallback[ListIndex] = mList;
                        this.mMaster.mLists_Fallback[ListIndex].setValid(true);
                        LiveCacheMaster.printTrace(this.mTitle + ": Use fallback-list for list <" + ListIndex + "> with : " + mList.toString());
                    }
                }
            }
        }
        this.mRunning = false;
        LiveCacheMaster.printTrace(this.mTitle + ": Terminating");
    }

    public void setMaster(LiveCacheMaster newMaster) throws TestDatabaseException, SQLException {
        super.setMaster(newMaster);
        this.mNumberOfLists = TestCase.getParameterInt((String)"NumberOfLists", (int)1);
        this.mMaxListLength = TestCase.getParameterInt((String)"MaxListLength", (int)33);
        this.mObjPercentage = TestCase.getParameterInt((String)"ObjPercentage", (int)33);
        this.mKeyedPercentage = TestCase.getParameterInt((String)"KeyedPercentage", (int)33);
        this.mVarPercentage = TestCase.getParameterInt((String)"VarPercentage", (int)33);
        this.mVarMaxLength = TestCase.getParameterInt((String)"VarMaxLength", (int)1000);
        this.mInsertPercentage = TestCase.getParameterInt((String)"InsertPercentage", (int)33);
        this.mDeletePercentage = TestCase.getParameterInt((String)"DeletePercentage", (int)33);
        this.mUpdatePercentage = TestCase.getParameterInt((String)"UpdatePercentage", (int)33);
        this.mSubtransactionPercentage = TestCase.getParameterInt((String)"SubtransactionPercentage", (int)50);
        this.mSubtransCommitPercentage = TestCase.getParameterInt((String)"SubtransCommitPercentage", (int)75);
        this.mTwoPhaseCommit = TestCase.getParameterBoolean((String)"TwoPhaseCommit", (boolean)false);
    }
}

