/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.lctest;

import com.sap.dbtech.jdbc.exceptions.DatabaseException;
import com.sap.sapdb.lctest.DBProcedure;
import com.sap.sapdb.lctest.LiveCacheConstants;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.sql.Connection;
import java.sql.SQLException;

public class HeapTest
extends TestCase
implements LiveCacheConstants {
    protected static final String sUser = "UHEAP";
    protected static final String sPassword = "UHEAP";
    protected static Connection[] mConnections;
    protected static TestStatement[] mStatements;
    protected static int m_heapLimit;
    protected static int m_heapSizePerTask;
    protected static final int mNumberOfConnections = 3;
    protected static final int USER1 = 1;
    protected static final int USER2 = 2;
    protected static final int USER3 = 3;

    public static void prepare() throws TestCaseException {
        Connection lDefConnection = null;
        TestStatement lDefTstmt = null;
        try {
            block16: {
                TestCase.setInfoMessageFilter((boolean)false);
                try {
                    lDefConnection = HeapTest.getDatabase().connect(HeapTest.getDatabase().getDBAUser(), HeapTest.getDatabase().getDBAPassword());
                }
                catch (Exception e) {
                    HeapTest.addGlobalMessage((String)"Login failure", (char)'E', (String)("DBAUser: " + HeapTest.getDatabase().getDBAUser() + ", Password: " + HeapTest.getDatabase().getDBAPassword()));
                    throw e;
                }
                lDefTstmt = new TestStatement(null, lDefConnection);
                lDefTstmt.enableExceptions(false);
                try {
                    if (((TestDatabaseSap)TestCase.getDatabase()).getKernelVersion().startsWith("7.2")) {
                        lDefTstmt.executeUpdate("enable write transaction");
                    }
                }
                catch (TestDatabaseException e) {
                    throw new TestDatabaseException((Exception)((Object)e), "Could not retrieve kernel version");
                }
                lDefTstmt.executeUpdate("enable write transaction");
                lDefTstmt.executeUpdate("drop user UHEAP");
                lDefTstmt.enableExceptions(true);
                try {
                    lDefTstmt.executeUpdate("Create user UHEAP password UHEAP dba not exclusive");
                }
                catch (DatabaseException e) {
                    if (e.getErrorCode() == -6006) break block16;
                    HeapTest.addGlobalMessage((String)"Init failure", (char)'E', (String)"Creation of user : UHEAP not possible");
                    throw e;
                }
            }
            HeapTest.readParameters();
            HeapTest.createDBProcedures();
            HeapTest.createConnections();
        }
        catch (Exception e) {
            throw (TestCaseException)e;
        }
        finally {
            try {
                lDefTstmt.close();
                lDefConnection.close();
            }
            catch (Exception e) {}
        }
    }

    public void run() {
    }

    public static void cleanUp() throws TestCaseException {
        if (mStatements == null || mConnections == null) {
            return;
        }
        try {
            if (mStatements[0] != null) {
                mStatements[0].execute("CALL DROP_CURRENT_SCHEMA('testteam')");
            }
        }
        catch (Exception e) {
            HeapTest.addGlobalMessage((String)"cleanup", (char)'E', (String)("Error while dropping schema: " + e.getMessage()));
            throw new TestCaseException("Error while dropping schema: " + e.getMessage());
        }
        try {
            for (int i = 0; i < 3; ++i) {
                if (mStatements[i] != null) {
                    mStatements[i].close();
                }
                if (mConnections[i] != null) {
                    mConnections[i].commit();
                }
                mConnections[i].close();
            }
        }
        catch (Exception e) {
            HeapTest.addGlobalMessage((String)"cleanup", (char)'E', (String)("Error during connection closure: " + e.getMessage()));
            throw new TestCaseException("Error during connection closure: " + e.getMessage());
        }
    }

    private static void readParameters() throws TestCaseException {
        m_heapLimit = HeapTest.getParameterInt((String)"OMS_HEAP_LIMIT", (int)0);
        m_heapSizePerTask = HeapTest.getParameterInt((String)"TASK_HEAP_SIZE", (int)300000);
    }

    private static boolean createConnections() {
        try {
            mConnections = new Connection[3];
            mStatements = new TestStatement[3];
            for (int i = 0; i < 3; ++i) {
                HeapTest.mConnections[i] = HeapTest.getDatabase().connect("UHEAP", "UHEAP");
                mConnections[i].setAutoCommit(false);
                HeapTest.mStatements[i] = new TestStatement(null, mConnections[i]);
                mStatements[i].execute("CALL SET_CURRENT_SCHEMA('testteam')");
                mConnections[i].commit();
            }
        }
        catch (Exception e) {
            HeapTest.addGlobalMessage((String)"createConnections", (char)'E', (String)("Error during connection creation: " + e.getMessage()));
            return false;
        }
        return true;
    }

    private static void createDBProcedures() throws TestCaseException {
        Connection con = null;
        TestStatement stmt = null;
        try {
            con = HeapTest.getDatabase().connect("UHEAP", "UHEAP");
            stmt = new TestStatement(null, con);
            int ExecMode = 1;
            try {
                if (TestDriver.compareRelease((String)((TestDatabaseSap)TestCase.getDatabase()).getKernelVersion(), (String)">=", (String)"7.4.4")) {
                    DBProcedure.createPackageWithFile(stmt, "ttlcbasics", "ttlcbasics");
                    DBProcedure.createPackageWithFile(stmt, "consistent", "consistent");
                    DBProcedure.createPackageWithFile(stmt, "LVCTIMEOUTTEST", "lctest");
                } else {
                    DBProcedure.createPackage(stmt, "ttlcbasics", "liveCache.ttlcbasics.TT");
                    DBProcedure.createPackage(stmt, "consistent", "liveCache.consistent.TEST");
                    DBProcedure.createPackage(stmt, "LVCTIMEOUTTEST", "liveCache.lctest.TEST");
                }
            }
            catch (TestDatabaseException e) {
                throw new TestDatabaseException((Exception)((Object)e), "Could not retrieve kernel version for creation of packages ");
            }
            DBProcedure.create(stmt, "HEAP_ALLOC1", "ttlcbasics", ExecMode);
            DBProcedure.create(stmt, "HEAP_ALLOC2", "ttlcbasics", ExecMode);
            DBProcedure.create(stmt, "HEAP_ALLOC3", "ttlcbasics", ExecMode);
            DBProcedure.create(stmt, "CREATE_CURRENT_SCHEMA", "consistent", ExecMode);
            DBProcedure.create(stmt, "SET_CURRENT_SCHEMA", "consistent", ExecMode);
            DBProcedure.create(stmt, "DROP_CURRENT_SCHEMA", "consistent", ExecMode);
            DBProcedure.create(stmt, "CLASS_REGISTER", "consistent", ExecMode);
            stmt.enableExceptions(false);
            stmt.execute("CALL DROP_CURRENT_SCHEMA('testteam')");
            stmt.enableExceptions(true);
            stmt.execute("CALL CREATE_CURRENT_SCHEMA('testteam')");
            stmt.execute("CALL CLASS_REGISTER");
            stmt.enableExceptions(false);
            stmt.execute("CALL DELETE_ALL_OBJECTS(0)");
            stmt.enableExceptions(true);
            con.commit();
        }
        catch (Exception e) {
            HeapTest.addGlobalMessage((String)"DPProc registration", (char)'E', (String)("SQL Error while registering DBProcedures: " + e.getMessage()));
            throw new TestCaseException("PrimaryTest.createDBProcedures() failed");
        }
        finally {
            try {
                stmt.close();
                con.close();
            }
            catch (Exception e) {}
        }
    }

    protected Connection getConnection(int UserId) throws TestCaseException {
        if (UserId < 1 || UserId > 3) {
            throw new TestCaseException(" UserId " + UserId + " is out of range[1," + 3 + "]");
        }
        return mConnections[UserId - 1];
    }
}

