/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.util;

import com.sap.sdb.msgServer.util.ReceiveStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;

public class ReceiveRetryStream
extends ReceiveStream {
    boolean m_isRetry = false;
    boolean m_currBoolean;
    byte m_currByte;
    short m_currShort;
    char m_currChar;
    int m_currType;
    int m_currInt;
    float m_currFloat;
    long m_currLong;
    double m_currDouble;
    String m_currString;
    byte[] m_currByteArray;

    public ReceiveRetryStream(InputStream in) throws IOException {
        super(in);
    }

    private String getCurrTypeName() {
        switch (this.m_currType) {
            case 0: {
                return "null";
            }
            case 1: {
                return "Object";
            }
            case 2: {
                return "boolean";
            }
            case 3: {
                return "byte";
            }
            case 4: {
                return "char";
            }
            case 5: {
                return "double";
            }
            case 6: {
                return "float";
            }
            case 7: {
                return "int";
            }
            case 8: {
                return "long";
            }
            case 9: {
                return "short";
            }
            case 10: {
                return "String";
            }
            case 11: {
                return "byte[]";
            }
        }
        return "unknown type";
    }

    private JMSException getJMSException(IOException e) {
        if (e instanceof EOFException) {
            return new MessageEOFException(e.getMessage());
        }
        JMSException jmsException = new JMSException(e.getMessage());
        jmsException.setLinkedException((Exception)e);
        return jmsException;
    }

    public boolean readBooleanType() throws JMSException {
        this.readElement();
        switch (this.m_currType) {
            case 0: {
                return Boolean.getBoolean(null);
            }
            case 2: {
                return this.m_currBoolean;
            }
            case 10: {
                return Boolean.getBoolean(this.m_currString);
            }
        }
        this.m_isRetry = true;
        throw new MessageFormatException("cannot convert " + this.getCurrTypeName() + " into boolean");
    }

    public byte[] readByteArrayType() throws JMSException {
        this.readElement();
        switch (this.m_currType) {
            case 0: {
                return null;
            }
            case 11: {
                return this.m_currByteArray;
            }
        }
        this.m_isRetry = true;
        throw new MessageFormatException("cannot convert " + this.getCurrTypeName() + " into byte[]");
    }

    public int readByteArrayType(byte[] byteArray, int off, int len) throws JMSException {
        if (off < 0 || len < 0 || off + len > byteArray.length) {
            throw new MessageFormatException("index out of bounds");
        }
        try {
            if (!this.m_isRetry) {
                this.m_currType = this.readByte();
            }
            if (this.m_currType == 0) {
                this.m_isRetry = false;
                return 0;
            }
            if (this.m_currType != 11) {
                if (!this.m_isRetry) {
                    this.m_isRetry = true;
                    this.readElementIntoMember();
                }
                throw new MessageFormatException("cannot convert " + this.getCurrTypeName() + " into byte[]");
            }
            if (this.m_isRetry) {
                if (this.m_currByteArray.length > len) {
                    throw new MessageFormatException("input array too large");
                }
                this.m_isRetry = false;
                System.arraycopy(this.m_currByteArray, 0, byteArray, off, this.m_currByteArray.length);
                return this.m_currByteArray.length;
            }
            int lengthInputArray = this.readInt();
            if (lengthInputArray == -1) {
                return 0;
            }
            if (lengthInputArray > len) {
                this.m_isRetry = true;
                this.m_currByteArray = new byte[lengthInputArray];
                this.readFully(this.m_currByteArray, 0, lengthInputArray);
                throw new MessageFormatException("input array too large");
            }
            this.readFully(byteArray, off, lengthInputArray);
            return lengthInputArray;
        }
        catch (IOException e) {
            throw this.getJMSException(e);
        }
    }

    public byte readByteType() throws JMSException, NumberFormatException {
        this.readElement();
        try {
            switch (this.m_currType) {
                case 0: {
                    throw new NumberFormatException("null");
                }
                case 3: {
                    return this.m_currByte;
                }
                case 10: {
                    return Byte.decode(this.m_currString);
                }
            }
            this.m_isRetry = true;
            throw new MessageFormatException("cannot convert " + this.getCurrTypeName() + " into byte");
        }
        catch (NumberFormatException e) {
            this.m_isRetry = true;
            throw e;
        }
    }

    public char readCharType() throws JMSException, NullPointerException {
        this.readElement();
        switch (this.m_currType) {
            case 0: {
                this.m_isRetry = true;
                throw new NullPointerException();
            }
            case 4: {
                return this.m_currChar;
            }
        }
        this.m_isRetry = true;
        throw new MessageFormatException("cannot convert " + this.getCurrTypeName() + " into char");
    }

    public double readDoubleType() throws JMSException, NumberFormatException {
        this.readElement();
        try {
            switch (this.m_currType) {
                case 0: {
                    throw new NumberFormatException("null");
                }
                case 5: {
                    return this.m_currDouble;
                }
                case 6: {
                    return this.m_currFloat;
                }
                case 10: {
                    return Double.parseDouble(this.m_currString);
                }
            }
            this.m_isRetry = true;
            throw new MessageFormatException("cannot convert " + this.getCurrTypeName() + " into double");
        }
        catch (NumberFormatException e) {
            this.m_isRetry = true;
            throw e;
        }
    }

    private void readElement() throws JMSException {
        if (this.m_isRetry) {
            this.m_isRetry = false;
            return;
        }
        try {
            this.m_currType = this.readByte();
            this.readElementIntoMember();
        }
        catch (IOException e) {
            throw this.getJMSException(e);
        }
    }

    private void readElementIntoMember() throws IOException {
        switch (this.m_currType) {
            case 0: {
                return;
            }
            case 2: {
                this.m_currBoolean = this.readBoolean();
                return;
            }
            case 3: {
                this.m_currByte = this.readByte();
                return;
            }
            case 4: {
                this.m_currChar = this.readChar();
                return;
            }
            case 5: {
                this.m_currDouble = this.readDouble();
                return;
            }
            case 6: {
                this.m_currFloat = this.readFloat();
                return;
            }
            case 7: {
                this.m_currInt = this.readInt();
                return;
            }
            case 8: {
                this.m_currLong = this.readLong();
                return;
            }
            case 9: {
                this.m_currShort = this.readShort();
                return;
            }
            case 10: {
                this.m_currString = this.readUTF();
                return;
            }
            case 11: {
                this.m_currByteArray = this.readByteArray();
                return;
            }
        }
        throw new StreamCorruptedException("unknown object type: " + this.m_currType);
    }

    public float readFloatType() throws JMSException, NumberFormatException {
        this.readElement();
        try {
            switch (this.m_currType) {
                case 0: {
                    throw new NumberFormatException("null");
                }
                case 6: {
                    return this.m_currFloat;
                }
                case 10: {
                    return Float.parseFloat(this.m_currString);
                }
            }
            this.m_isRetry = true;
            throw new MessageFormatException("cannot convert " + this.getCurrTypeName() + " into float");
        }
        catch (NumberFormatException e) {
            this.m_isRetry = true;
            throw e;
        }
    }

    public int readIntType() throws JMSException, NumberFormatException {
        this.readElement();
        try {
            switch (this.m_currType) {
                case 0: {
                    throw new NumberFormatException("null");
                }
                case 3: {
                    return this.m_currByte;
                }
                case 7: {
                    return this.m_currInt;
                }
                case 9: {
                    return this.m_currShort;
                }
                case 10: {
                    return Integer.parseInt(this.m_currString);
                }
            }
            this.m_isRetry = true;
            throw new MessageFormatException("cannot convert " + this.getCurrTypeName() + " into integer");
        }
        catch (NumberFormatException e) {
            this.m_isRetry = true;
            throw e;
        }
    }

    public long readLongType() throws JMSException, NumberFormatException {
        this.readElement();
        try {
            switch (this.m_currType) {
                case 0: {
                    throw new NumberFormatException("null");
                }
                case 3: {
                    return this.m_currByte;
                }
                case 7: {
                    return this.m_currInt;
                }
                case 8: {
                    return this.m_currLong;
                }
                case 9: {
                    return this.m_currShort;
                }
                case 10: {
                    return Long.parseLong(this.m_currString);
                }
            }
            this.m_isRetry = true;
            throw new MessageFormatException("cannot convert " + this.getCurrTypeName() + " into long");
        }
        catch (NumberFormatException e) {
            this.m_isRetry = true;
            throw e;
        }
    }

    public Object readObjectType() throws JMSException {
        this.readElement();
        switch (this.m_currType) {
            case 0: {
                return null;
            }
            case 2: {
                return new Boolean(this.m_currBoolean);
            }
            case 3: {
                return new Byte(this.m_currByte);
            }
            case 4: {
                return new Character(this.m_currChar);
            }
            case 5: {
                return new Double(this.m_currDouble);
            }
            case 6: {
                return new Float(this.m_currFloat);
            }
            case 7: {
                return new Integer(this.m_currInt);
            }
            case 8: {
                return new Long(this.m_currLong);
            }
            case 9: {
                return new Short(this.m_currShort);
            }
            case 10: {
                return this.m_currString;
            }
            case 11: {
                return this.m_currByteArray;
            }
        }
        throw new MessageFormatException("invalid object");
    }

    public short readShortType() throws JMSException, NumberFormatException {
        this.readElement();
        try {
            switch (this.m_currType) {
                case 0: {
                    throw new NumberFormatException("null");
                }
                case 3: {
                    return this.m_currByte;
                }
                case 9: {
                    return this.m_currShort;
                }
                case 10: {
                    return Short.parseShort(this.m_currString);
                }
            }
            this.m_isRetry = true;
            throw new MessageFormatException("cannot convert " + this.getCurrTypeName() + " into short");
        }
        catch (NumberFormatException e) {
            this.m_isRetry = true;
            throw e;
        }
    }

    public String readStringType() throws JMSException {
        this.readElement();
        switch (this.m_currType) {
            case 0: {
                return null;
            }
            case 2: {
                return String.valueOf(this.m_currBoolean);
            }
            case 3: {
                return String.valueOf(this.m_currByte);
            }
            case 4: {
                return String.valueOf(this.m_currChar);
            }
            case 5: {
                return String.valueOf(this.m_currDouble);
            }
            case 6: {
                return String.valueOf(this.m_currFloat);
            }
            case 7: {
                return String.valueOf(this.m_currInt);
            }
            case 8: {
                return String.valueOf(this.m_currLong);
            }
            case 9: {
                return String.valueOf(this.m_currShort);
            }
            case 10: {
                return this.m_currString;
            }
        }
        this.m_isRetry = true;
        throw new MessageFormatException("cannot convert " + this.getCurrTypeName() + " into String");
    }
}

