/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.util;

import com.sap.sdb.msgServer.client.MessageImpl;
import com.sap.sdb.msgServer.util.MessageConsumerInfo;
import com.sap.sdb.msgServer.util.Notification;
import com.sap.sdb.msgServer.util.ReceiveStream;
import com.sap.sdb.msgServer.util.SendStream;
import java.io.IOException;

public class MessageNotification
extends Notification {
    private MessageConsumerInfo myMessageConsumerInfo;
    private MessageImpl myMessage;
    private boolean myRedelivered;
    private long myTransactionID;
    private int myPort;
    public static final transient int SEND_TRANSACTED = 0;
    public static final transient int SEND_COMMIT = 1;
    public static final transient int PUBLISH_TRANSACTED = 2;
    public static final transient int PUBLISH_COMMIT = 3;

    protected MessageNotification() {
        this.myTransactionID = 0L;
        this.myMessageConsumerInfo = new MessageConsumerInfo();
        this.myMessage = null;
        this.myRedelivered = false;
        this.myPort = 0;
    }

    public MessageNotification(int type, MessageImpl message, long transactionID) {
        super(type, "rec");
        this.myTransactionID = transactionID;
        this.myMessageConsumerInfo = new MessageConsumerInfo();
        this.setMessage(message);
        this.myRedelivered = false;
        this.myPort = 0;
    }

    public MessageConsumerInfo getMessageConsumerInfo() {
        return this.myMessageConsumerInfo;
    }

    public void setMessageConsumerInfo(MessageConsumerInfo info) {
        this.myMessageConsumerInfo = info;
    }

    public MessageImpl getMessage() {
        return this.myMessage;
    }

    public long getTransactionID() {
        return this.myTransactionID;
    }

    public void setMessage(MessageImpl message) {
        this.myMessage = message == null ? new MessageImpl() : message;
    }

    public void setNullMessage() {
        this.myMessage = null;
    }

    public void setRedelivered(boolean redelivered) {
        this.myRedelivered = redelivered;
    }

    public void setTransactionID(long transactionID) {
        this.myTransactionID = transactionID;
    }

    public void setPort(int port) {
        this.myPort = port;
    }

    public int getPort() {
        return this.myPort;
    }

    public String toString() {
        return "MessageNotification: " + super.toString();
    }

    void receiveFromClient(ReceiveStream in) throws IOException {
        this.deserializeWithoutMessage(in);
        this.myMessage = in.isNullObject() ? null : MessageImpl.receiveFromClient(in);
    }

    void receiveFromServer(ReceiveStream in) throws IOException {
        this.deserializeWithoutMessage(in);
        this.myMessage = in.isNullObject() ? null : MessageImpl.receiveFromServer(in);
    }

    public void sendToClient(SendStream out) throws IOException {
        int length = this.myMessage == null ? 1 : 1 + this.myMessage.getWriteToClientLength();
        this.serializeWithoutMessage(out, length);
        if (out.isWriteObject(this.myMessage)) {
            this.myMessage.sendToClient(out, this.myRedelivered);
        }
        super.endSerialize(out);
    }

    public void sendToServer(SendStream out) throws IOException {
        int length = this.myMessage == null ? 1 : 1 + this.myMessage.initSendToServer();
        this.serializeWithoutMessage(out, length);
        if (out.isWriteObject(this.myMessage)) {
            this.myMessage.sendToServer(out);
        }
        super.endSerialize(out);
    }

    private void deserializeWithoutMessage(ReceiveStream in) throws IOException {
        super.deserialize(in);
        if (in.isNullObject()) {
            this.myMessageConsumerInfo = null;
        } else {
            this.myMessageConsumerInfo = new MessageConsumerInfo();
            this.myMessageConsumerInfo.deserialize(in);
        }
        this.myTransactionID = in.readLong();
        this.myPort = in.readInt();
    }

    void serializeWithoutMessage(SendStream out, int messageSendLength) throws IOException {
        int length = 9 + messageSendLength;
        if (this.myMessageConsumerInfo != null) {
            length += this.myMessageConsumerInfo.getSerializationLength();
        }
        super.serialize(out, 12, length);
        if (out.isWriteObject(this.myMessageConsumerInfo)) {
            this.myMessageConsumerInfo.serialize(out);
        }
        out.writeLong(this.myTransactionID);
        out.writeInt(this.myPort);
    }
}

