/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.util;

import com.sap.sdb.msgServer.util.ReceiveStream;
import com.sap.sdb.msgServer.util.SendStream;
import com.sap.sdb.msgServer.util.StreamString;
import java.io.IOException;

public class ClientSessionAddress {
    private StreamString myClientID = null;
    private StreamString myQueueID = null;
    private int myPort = 0;
    private StreamString myAddressAsStringStream = null;
    private String myAddressAsString = null;

    public StreamString getClientID() {
        return this.myClientID;
    }

    public int getClientPort() {
        return this.myPort;
    }

    private String getClientIDString() {
        return StreamString.getString(this.myClientID);
    }

    public String getQueueID() {
        return StreamString.getString(this.myQueueID);
    }

    public void setAddress(ClientSessionAddress other) {
        this.myClientID = other.myClientID;
        this.myQueueID = other.myQueueID;
        this.myAddressAsString = this.getClientIDString() + "/" + this.getQueueID();
        this.myAddressAsStringStream = new StreamString(this.myAddressAsString);
        this.myPort = this.getPortFromClientAdress();
    }

    public void setAddress(StreamString clientID, String queueID) {
        this.myClientID = clientID;
        this.myQueueID = StreamString.create(queueID);
        this.myAddressAsString = this.getClientIDString() + "/" + this.getQueueID();
        this.myAddressAsStringStream = new StreamString(this.myAddressAsString);
        this.myPort = this.getPortFromClientAdress();
    }

    private int getPortFromClientAdress() {
        String aClientID = this.myClientID.getString();
        String port = aClientID.substring(aClientID.indexOf(":") + 1);
        return new Integer(port);
    }

    public boolean isValid() {
        return this.myClientID != null && this.myQueueID != null;
    }

    public static String createClientSessionAddressString(String clientID, String clientQueueID) {
        return clientID + "/" + clientQueueID;
    }

    public String toString() {
        if (this.myAddressAsString == null) {
            return this.getClientIDString() + "/" + this.getQueueID();
        }
        return this.myAddressAsString;
    }

    public StreamString toStreamString() {
        if (this.myAddressAsStringStream == null) {
            return new StreamString(this.getClientIDString() + "/" + this.getQueueID());
        }
        return this.myAddressAsStringStream;
    }

    void deserialize(ReceiveStream in) throws IOException {
        this.myClientID = in.readStreamString();
        if (this.myClientID != null) {
            this.myClientID.setHashCode(in.readInt());
        }
        this.myQueueID = in.readStreamString();
    }

    int getSerializationLength() {
        return SendStream.getStreamStringLength(this.myClientID) + 4 + SendStream.getStreamStringLength(this.myQueueID);
    }

    void serialize(SendStream out) throws IOException {
        out.writeStreamString(this.myClientID);
        out.writeInt(this.myClientID == null ? 0 : this.myClientID.hashCode());
        out.writeStreamString(this.myQueueID);
    }
}

