/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.util;

import com.sap.sdb.msgServer.Server;
import com.sap.sdb.msgServer.agents.ConnectionManager;
import com.sap.sdb.msgServer.agents.JmsThread;
import com.sap.sdb.msgServer.service.Service;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import javax.net.ssl.SSLException;

public class ClientConnection {
    private final ConnectionManager myConnectionManager;
    private final Socket myClientSocket;
    private final Service myService;
    private final ClientConnection myThisClient;
    private Thread myThread;
    private String myConnectionName;
    public static final String PORT_SEPARATOR = ":";

    public ClientConnection(ConnectionManager manager, Socket client, Service service) {
        this.myConnectionManager = manager;
        this.myClientSocket = client;
        this.myService = service;
        this.myThisClient = this;
        this.myConnectionName = this.myClientSocket.getInetAddress().getHostAddress() + PORT_SEPARATOR + this.myClientSocket.getPort();
        this.myThread = new JmsThread("ClientConnection:" + this.myConnectionName){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ClientConnection.this.printConnectedMsg();
                this.registerThisThread();
                try {
                    try {
                        InputStream in = ClientConnection.this.getClient().getInputStream();
                        OutputStream out = ClientConnection.this.getClient().getOutputStream();
                        ClientConnection.this.getService().enableService();
                        ClientConnection.this.getService().serve(in, out);
                    }
                    catch (SSLException ssl) {
                        Server.log(ssl.toString());
                    }
                    catch (IOException e) {
                        Server.log(e);
                    }
                    try {
                        ClientConnection.this.myConnectionManager.removeConnection(ClientConnection.this.myThisClient);
                        ClientConnection.this.endCommunication();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                finally {
                    this.unregisterThisThread();
                    ClientConnection.this.printMsgConnectionClosed();
                }
            }
        };
    }

    public ConnectionManager getManager() {
        return this.myConnectionManager;
    }

    public Socket getClient() {
        return this.myClientSocket;
    }

    public Service getService() {
        return this.myService;
    }

    public void startCommunication() {
        this.myThread.start();
    }

    public synchronized void endCommunication() {
        try {
            this.myClientSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void printMsgConnectionClosed() {
        Server.log("Connection " + this.myConnectionName + " closed.");
    }

    private void printConnectedMsg() {
        Server.log("Connected to " + this.getConnectionInfo());
    }

    public synchronized String getConnectionInfo() {
        return this.myConnectionName + " on port " + this.myClientSocket.getLocalPort() + " for service " + this.myService.getClass().getName();
    }
}

