/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.util;

import com.sap.sdb.msgServer.util.AdminNotification;
import com.sap.sdb.msgServer.util.ReceiveStream;
import com.sap.sdb.msgServer.util.SendStream;
import com.sap.sdb.msgServer.util.StreamString;
import java.io.IOException;

public class ActivateAdminNotification
extends AdminNotification {
    private StreamString myDestinationName;
    private StreamString mySubscriptionName;
    private StreamString myClientID;
    private StreamString mySessionQueueID;
    private StreamString myMsgSelector;
    private Integer mySessionListenerID;
    private long myConsumerID;
    private boolean myIsQueue;
    private boolean myIsDurable;
    private boolean myIsActive;
    private boolean myNoLocal;

    ActivateAdminNotification() {
        this.myDestinationName = null;
        this.mySubscriptionName = null;
        this.myClientID = null;
        this.mySessionQueueID = null;
        this.myMsgSelector = null;
        this.mySessionListenerID = null;
        this.myConsumerID = 0L;
        this.myIsQueue = false;
        this.myIsDurable = false;
        this.myIsActive = false;
        this.myNoLocal = false;
    }

    public ActivateAdminNotification(String destinationName, String subscriptionName, StreamString clientID, String sessionQueueID, Integer sessionListenerID, boolean isQueue, boolean isDurable, long consumerID, String msgSelector, boolean isActive, boolean bNoLocal) {
        super(-1);
        this.myDestinationName = StreamString.create(destinationName);
        this.mySubscriptionName = StreamString.create(subscriptionName);
        this.myClientID = clientID;
        this.mySessionQueueID = StreamString.create(sessionQueueID);
        this.mySessionListenerID = sessionListenerID;
        this.myIsQueue = isQueue;
        this.myIsDurable = isDurable;
        this.myConsumerID = consumerID;
        this.myMsgSelector = StreamString.create(msgSelector);
        this.myIsActive = isActive;
        this.myNoLocal = bNoLocal;
    }

    public boolean getIsDurable() {
        return this.myIsDurable;
    }

    public boolean getNoLocal() {
        return this.myNoLocal;
    }

    public boolean getIsQueue() {
        return this.myIsQueue;
    }

    public String getDestinationName() {
        return StreamString.getString(this.myDestinationName);
    }

    public String getSubscriptionName() {
        return StreamString.getString(this.mySubscriptionName);
    }

    public StreamString getClientID() {
        return this.myClientID;
    }

    public String getSessionQueueID() {
        return StreamString.getString(this.mySessionQueueID);
    }

    public Integer getSessionListenerID() {
        return this.mySessionListenerID;
    }

    public long getConsumerID() {
        return this.myConsumerID;
    }

    public String getMessageSelector() {
        return StreamString.getString(this.myMsgSelector);
    }

    public String toString() {
        return "ActivateAdminNotification: " + super.toString();
    }

    public boolean getIsActive() {
        return this.myIsActive;
    }

    void readFromStream(ReceiveStream in) throws IOException {
        super.deserialize(in);
        this.myDestinationName = in.readStreamString();
        this.mySubscriptionName = in.readStreamString();
        this.myClientID = in.readStreamString();
        this.mySessionQueueID = in.readStreamString();
        this.myMsgSelector = in.readStreamString();
        this.mySessionListenerID = in.readInteger();
        this.myConsumerID = in.readLong();
        this.myIsQueue = in.readBoolean();
        this.myIsDurable = in.readBoolean();
        this.myIsActive = in.readBoolean();
        this.myNoLocal = in.readBoolean();
    }

    void writeToStream(SendStream out) throws IOException {
        super.serialize(out, 4, SendStream.getStreamStringLength(this.myDestinationName) + SendStream.getStreamStringLength(this.mySubscriptionName) + SendStream.getStreamStringLength(this.myClientID) + SendStream.getStreamStringLength(this.mySessionQueueID) + SendStream.getStreamStringLength(this.myMsgSelector) + SendStream.getIntegerLength(this.mySessionListenerID) + 8 + 4);
        out.writeStreamString(this.myDestinationName);
        out.writeStreamString(this.mySubscriptionName);
        out.writeStreamString(this.myClientID);
        out.writeStreamString(this.mySessionQueueID);
        out.writeStreamString(this.myMsgSelector);
        out.writeInteger(this.mySessionListenerID);
        out.writeLong(this.myConsumerID);
        out.writeBoolean(this.myIsQueue);
        out.writeBoolean(this.myIsDurable);
        out.writeBoolean(this.myIsActive);
        out.writeBoolean(this.myNoLocal);
    }
}

