/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.transientStorage;

import com.sap.sdb.minDB.common.DatabaseRow;
import com.sap.sdb.minDB.common.PreparedStatementDummy;
import com.sap.sdb.minDB.dataAccess.ConnectionImpl;
import com.sap.sdb.minDB.dataAccess.PrimaryCharKey;
import com.sap.sdb.minDB.dataAccess.PrimaryNumKey;
import com.sap.sdb.minDB.dataAccess.PrimaryNumNumKey;
import com.sap.sdb.minDB.dataAccess.ResultSetImpl;
import com.sap.sdb.minDB.dataAccess.Table;
import com.sap.sdb.minDB.dataAccess.TableRow;
import com.sap.sdb.minDB.dataAccessInterface.DatabaseKey;
import com.sap.sdb.minDB.dataAccessInterface.DatabaseTableRow;
import com.sap.sdb.minDB.util.ErrorMsg;
import com.sap.sdb.msgServer.database.SqlCmd;
import com.sap.sdb.msgServer.transientStorage.DatabaseTables;
import com.sap.sdb.msgServer.transientStorage.ResultSetDestOrder;
import com.sap.sdb.msgServer.transientStorage.ResultSetTransSelect;
import com.sap.sdb.msgServer.transientStorage.TableRowWithIndex;
import com.sap.sdb.msgServer.transientStorage.TableWithIndex;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;

public class TransientStatement
extends PreparedStatementDummy {
    private int m_stmtIndex;
    private int m_fetchSize = Integer.MAX_VALUE;
    private Table m_table = null;
    private TableRow m_newRow = null;
    private boolean[] m_isNullParam = null;
    private long[] m_numericParam = null;
    private String[] m_charParam = null;
    private Object[] m_objectParam = null;
    private ResultSetImpl m_currResult = null;
    private ConnectionImpl m_connection;
    private static final int MAX_PARAM_NO = 20;

    TransientStatement(ConnectionImpl connection, int stmtIndex) throws SQLException {
        this.m_connection = connection;
        this.m_stmtIndex = stmtIndex;
        if (stmtIndex >= 4 && stmtIndex <= 16) {
            this.m_table = DatabaseTables.getConsumerTable();
            if (stmtIndex == 4) {
                this.m_newRow = this.m_table.getNewRow();
                return;
            }
            this.initNumericAndCharParam();
            return;
        }
        if (stmtIndex >= 26 && stmtIndex <= 32) {
            this.m_table = DatabaseTables.getMessageTable();
            if (stmtIndex == 26) {
                this.m_newRow = this.m_table.getNewRow();
                return;
            }
            this.initParam();
            return;
        }
        if (stmtIndex >= 39 && stmtIndex <= 67) {
            this.m_table = DatabaseTables.getSendorderTable();
            if (stmtIndex == 39) {
                this.m_newRow = this.m_table.getNewRow();
                return;
            }
            this.initNumericParam();
            return;
        }
        if (stmtIndex >= 68 && stmtIndex <= 71) {
            this.m_table = DatabaseTables.getTransactionTable();
            if (stmtIndex == 68) {
                this.m_newRow = this.m_table.getNewRow();
                return;
            }
            this.initNumericParam();
            return;
        }
        if (stmtIndex >= 0 && stmtIndex <= 3) {
            this.m_table = DatabaseTables.getLookupTable();
            if (stmtIndex == 0) {
                this.m_newRow = this.m_table.getNewRow();
                return;
            }
            this.initParam();
            return;
        }
        if (stmtIndex >= 17 && stmtIndex <= 25) {
            this.m_table = DatabaseTables.getDestinationTable();
            if (stmtIndex == 17) {
                this.m_newRow = this.m_table.getNewRow();
                return;
            }
            this.initParam();
            return;
        }
        throw ErrorMsg.notSupported("msg server statement (index = " + stmtIndex + ")");
    }

    public void addBatch() throws SQLException {
        throw ErrorMsg.notSupported("TransientStatement.addBatch");
    }

    public void clearParameters() throws SQLException {
        if (this.m_newRow != null) {
            this.m_newRow.clear();
            return;
        }
        Arrays.fill(this.m_isNullParam, true);
    }

    public void clearReferences() {
        this.close();
        this.m_connection = null;
    }

    public void close() {
        this.m_table = null;
        this.m_newRow = null;
        this.m_isNullParam = null;
        this.m_numericParam = null;
        this.m_charParam = null;
        this.m_objectParam = null;
    }

    public void closeResultSet() throws SQLException {
        if (this.m_currResult != null) {
            this.m_currResult.clearReferences();
            this.m_currResult = null;
        }
    }

    public boolean execute() throws SQLException {
        throw ErrorMsg.notSupported("PreparedStatement.execute");
    }

    public ResultSet executeQuery() throws SQLException {
        if (this.m_currResult != null) {
            this.m_currResult.clearReferences();
            this.m_currResult = null;
        }
        switch (this.m_stmtIndex) {
            case 11: {
                this.m_currResult = this.queryConsumerSelect();
                break;
            }
            case 12: {
                this.m_currResult = this.queryConsumerSelectAll();
                break;
            }
            case 13: {
                this.m_currResult = this.querySelectCount();
                break;
            }
            case 14: {
                this.m_currResult = this.queryConsumerSelectId();
                break;
            }
            case 15: {
                this.m_currResult = this.queryConsumerSelectWhereSubscr();
                break;
            }
            case 16: {
                this.m_currResult = this.queryConsumerSelectWhereDest();
                break;
            }
            case 21: {
                this.m_currResult = this.queryDestinSelect();
                break;
            }
            case 22: {
                this.m_currResult = this.queryDestinSelectAll();
                break;
            }
            case 2: {
                this.m_currResult = this.queryLookupSelect();
                break;
            }
            case 30: {
                this.m_currResult = this.queryMessageSelect();
                break;
            }
            case 31: {
                this.m_currResult = this.querySelectCount();
                break;
            }
            case 60: {
                this.m_currResult = this.querySelectCount();
                break;
            }
            case 61: {
                this.m_currResult = this.querySendorderSelectMaxMsgsequence();
                break;
            }
            case 62: {
                this.m_currResult = this.querySendorderSelectMaxTrans();
                break;
            }
            case 63: {
                this.m_currResult = this.querySendorderSelectOrders();
                break;
            }
            case 64: {
                this.m_currResult = this.querySendorderSelectOrdersWithDest();
                break;
            }
            case 65: {
                this.m_currResult = this.querySendorderSelectOrderByPrio(true);
                break;
            }
            case 66: {
                this.m_currResult = this.querySendorderSelectOrderByPrio(false);
                break;
            }
            case 67: {
                this.m_currResult = this.querySendorderSelectCountByDest();
                break;
            }
            case 71: {
                this.m_currResult = this.queryTransSelect();
                break;
            }
            default: {
                throw ErrorMsg.notSupported("executeQuery (statement " + this.m_stmtIndex + "): " + SqlCmd.getCmd(this.m_stmtIndex));
            }
        }
        this.m_currResult.setStatement(this);
        return this.m_currResult;
    }

    public int executeUpdate() throws SQLException {
        switch (this.m_stmtIndex) {
            case 5: {
                return this.updDelNumKey();
            }
            case 6: {
                return this.updDelAll();
            }
            case 7: {
                return this.updConsumerDelWhereType();
            }
            case 4: {
                return this.performInsert();
            }
            case 8: {
                return this.updConsumerUpd();
            }
            case 9: {
                return this.updConsumerUpdSetState();
            }
            case 10: {
                return this.updConsumerUpdSetStateWhereType();
            }
            case 18: {
                return this.updDelNumKey();
            }
            case 19: {
                return this.updDelAll();
            }
            case 20: {
                return this.updDestinDelWhereName();
            }
            case 17: {
                return this.performInsert();
            }
            case 3: {
                return this.updLookupDelete();
            }
            case 0: {
                return this.performInsert();
            }
            case 1: {
                return this.updLookupUpd();
            }
            case 27: {
                return this.updMessageDelId();
            }
            case 28: {
                return this.updMessageDelIdReceived();
            }
            case 29: {
                return this.updMessageDelUnused();
            }
            case 26: {
                return this.updMessageIns();
            }
            case 40: {
                return this.updSendorderDelExpired();
            }
            case 41: {
                return this.updSendorderDelReceived();
            }
            case 42: {
                return this.updSendorderDelTopicWhereConsumer();
            }
            case 43: {
                return this.updSendorderDelTopicWhereConsumerExists();
            }
            case 44: {
                return this.updSendorderDelTopicWhereConsumerNotExists();
            }
            case 45: {
                return this.updSendorderDelTopicWhereMessage();
            }
            case 46: {
                return this.updSendorderDelWhereDest();
            }
            case 39: {
                return this.updSendorderIns();
            }
            case 48: {
                return this.updSendorderUpdActive(true);
            }
            case 47: {
                return this.updSendorderUpdActive(false);
            }
            case 49: {
                return this.updSendorderUpdDelivered();
            }
            case 50: {
                return this.updSendorderUpdInprocessAndDelivered();
            }
            case 51: {
                return this.updSendorderUpdMarkNext();
            }
            case 52: {
                return this.updSendorderUpdReceivedQueueRollback();
            }
            case 53: {
                return this.updSendorderUpdReceivedTopicRollback();
            }
            case 54: {
                return this.updSendorderUpdRecoverQueue();
            }
            case 55: {
                return this.updSendorderUpdRecoverTopic();
            }
            case 56: {
                return this.updSendorderUpdResetQueueWhereConsumer();
            }
            case 57: {
                return this.updSendorderUpdResetQueueWhereMessageAndConsumer();
            }
            case 58: {
                return this.updSendorderUpdResetTopicWhereConsumer();
            }
            case 59: {
                return this.updSendorderUpdResetTopicWhereMessageAndConsumer();
            }
            case 69: {
                return this.updTransDel();
            }
            case 70: {
                return this.updDelAll();
            }
            case 68: {
                return this.performInsert();
            }
        }
        throw ErrorMsg.notSupported("executeUpdate (statement " + this.m_stmtIndex + "): " + SqlCmd.getCmd(this.m_stmtIndex));
    }

    public Connection getConnection() {
        return this.m_connection;
    }

    public int getQueryTimeout() throws SQLException {
        throw ErrorMsg.notSupported("Statement.getQueryTimeout");
    }

    public ResultSet getResultSet() throws SQLException {
        throw ErrorMsg.notSupported("Statement.getQueryTimeout");
    }

    public int getUpdateCount() throws SQLException {
        throw ErrorMsg.notSupported("Statement.getUpdateCount");
    }

    private void initNumericAndCharParam() {
        this.initNumericParam();
        this.m_charParam = new String[20];
    }

    private void initNumericParam() {
        this.m_isNullParam = new boolean[20];
        this.m_numericParam = new long[20];
        Arrays.fill(this.m_isNullParam, true);
    }

    private void initParam() {
        this.initNumericAndCharParam();
        this.m_objectParam = new Object[20];
    }

    private int performInsert() throws SQLException {
        this.m_table.insertRowWithLogging(this.m_connection, this.m_newRow);
        this.m_newRow = this.m_table.getNewRow();
        return 1;
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        if (this.m_newRow != null) {
            this.m_newRow.setBinaryCol(parameterIndex, x);
            return;
        }
        this.m_isNullParam[parameterIndex] = false;
        this.m_objectParam[parameterIndex] = x;
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        if (this.m_newRow != null) {
            this.m_newRow.setDoubleCol(parameterIndex, x);
            return;
        }
        this.m_isNullParam[parameterIndex] = false;
        this.m_objectParam[parameterIndex] = new Double(x);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        if (this.m_newRow != null) {
            this.m_newRow.setNumericCol(parameterIndex, x);
            return;
        }
        this.m_isNullParam[parameterIndex] = false;
        this.m_numericParam[parameterIndex] = x;
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (this.m_newRow != null) {
            this.m_newRow.setObjectCol(parameterIndex, x);
            return;
        }
        this.m_isNullParam[parameterIndex] = false;
        this.m_objectParam[parameterIndex] = x;
    }

    public void setMaxRows(int rows) {
        if (rows > 0) {
            this.m_fetchSize = rows;
        }
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        if (this.m_newRow != null) {
            this.m_newRow.setNull(parameterIndex);
            return;
        }
        this.m_isNullParam[parameterIndex] = true;
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        if (this.m_newRow != null) {
            this.m_newRow.setCharCol(parameterIndex, x);
            return;
        }
        this.m_isNullParam[parameterIndex] = false;
        this.m_charParam[parameterIndex] = x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSetImpl queryConsumerSelect() throws SQLException {
        ResultSetImpl result = new ResultSetImpl(7, 6, null, null, null, null);
        Table table = this.m_table;
        synchronized (table) {
            DatabaseTableRow tabRow = this.findRow(this.m_table, this.m_numericParam[1]);
            if (tabRow != null && !tabRow.isLockCollision(this.m_connection)) {
                DatabaseRow resultRow = result.getNewResultRow();
                resultRow.copyCol(1, tabRow, 2);
                resultRow.copyCol(2, tabRow, 3);
                resultRow.copyCol(3, tabRow, 4);
                resultRow.copyCol(4, tabRow, 5);
                resultRow.copyCol(5, tabRow, 6);
                resultRow.copyCol(6, tabRow, 7);
                resultRow.copyCol(7, tabRow, 8);
                result.addRow(resultRow);
            }
        }
        result.resultCreated();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSetImpl queryConsumerSelectAll() throws SQLException {
        ResultSetImpl result = new ResultSetImpl(5, 7, null, null, null, null);
        Table table = this.m_table;
        synchronized (table) {
            TableRow currRow;
            Iterator iter = this.m_table.getIterator();
            while (iter.hasNext() && ((currRow = (TableRow)iter.next()).isLockCollision(this.m_connection) || result.addRow(currRow.getNewRowCopy()) < this.m_fetchSize)) {
            }
        }
        result.resultCreated();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSetImpl queryConsumerSelectId() throws SQLException {
        ResultSetImpl result = new ResultSetImpl(1, 0, null, null, null, null);
        long destination = this.m_numericParam[1];
        Table table = this.m_table;
        synchronized (table) {
            Iterator iter = this.m_table.getIterator();
            while (iter.hasNext()) {
                long consumerState;
                TableRow currRow = (TableRow)iter.next();
                if (currRow.getNumericCol(3) != destination || (consumerState = currRow.getNumericCol(5)) != 1L && consumerState != 2L || currRow.isLockCollision(this.m_connection)) continue;
                DatabaseRow resultRow = result.getNewResultRow();
                resultRow.copyCol(1, currRow, 1);
                if (result.addRow(resultRow) < this.m_fetchSize) continue;
                break;
            }
        }
        result.resultCreated();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSetImpl queryConsumerSelectWhereDest() throws SQLException {
        ResultSetImpl result = new ResultSetImpl(7, 6, null, null, null, null);
        long destination = this.m_numericParam[2];
        Table table = this.m_table;
        synchronized (table) {
            Iterator iter = this.m_table.getIterator();
            while (iter.hasNext()) {
                TableRow currRow = (TableRow)iter.next();
                if (currRow.getNumericCol(3) != destination || currRow.isLockCollision(this.m_connection)) continue;
                DatabaseRow resultRow = result.getNewResultRow();
                resultRow.copyCol(1, currRow, 1);
                resultRow.copyCol(2, currRow, 2);
                resultRow.copyCol(3, currRow, 4);
                resultRow.copyCol(4, currRow, 5);
                resultRow.copyCol(5, currRow, 7);
                resultRow.copyCol(6, currRow, 6);
                resultRow.copyCol(7, currRow, 8);
                if (result.addRow(resultRow) < this.m_fetchSize) continue;
                break;
            }
        }
        result.resultCreated();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSetImpl queryConsumerSelectWhereSubscr() throws SQLException {
        ResultSetImpl result = new ResultSetImpl(6, 5, null, null, null, null);
        String subscription = this.m_charParam[1];
        long destination = this.m_numericParam[2];
        Table table = this.m_table;
        synchronized (table) {
            Iterator iter = this.m_table.getIterator();
            while (iter.hasNext()) {
                TableRow currRow = (TableRow)iter.next();
                if (currRow.getNumericCol(3) != destination || !subscription.equals(currRow.getCharCol(6)) || currRow.isLockCollision(this.m_connection)) continue;
                DatabaseRow resultRow = result.getNewResultRow();
                resultRow.copyCol(1, currRow, 1);
                resultRow.copyCol(2, currRow, 2);
                resultRow.copyCol(3, currRow, 4);
                resultRow.copyCol(4, currRow, 5);
                resultRow.copyCol(5, currRow, 7);
                resultRow.copyCol(6, currRow, 8);
                if (result.addRow(resultRow) < this.m_fetchSize) continue;
                break;
            }
        }
        result.resultCreated();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSetImpl queryDestinSelect() throws SQLException {
        ResultSetImpl result = new ResultSetImpl(1, 0, null, null, null, null);
        String name = this.m_charParam[1];
        long isQueue = this.m_numericParam[2];
        Table table = this.m_table;
        synchronized (table) {
            Iterator iter = this.m_table.getIterator();
            while (iter.hasNext()) {
                TableRow row = (TableRow)iter.next();
                if (row.getNumericCol(3) != isQueue || !name.equals(row.getCharCol(2)) || row.isLockCollision(this.m_connection)) continue;
                DatabaseRow resultRow = result.getNewResultRow();
                resultRow.copyCol(1, row, 1);
                if (result.addRow(resultRow) < this.m_fetchSize) continue;
                break;
            }
        }
        result.resultCreated();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSetImpl queryDestinSelectAll() throws SQLException {
        ResultSetImpl result = new ResultSetImpl(3, 2, null, null, null, null);
        Table table = this.m_table;
        synchronized (table) {
            TableRow currRow;
            Iterator iter = this.m_table.getIterator();
            while (iter.hasNext() && ((currRow = (TableRow)iter.next()).isLockCollision(this.m_connection) || result.addRow(currRow.getNewRowCopy()) < this.m_fetchSize)) {
            }
        }
        result.resultCreated();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSetImpl queryLookupSelect() throws SQLException {
        ResultSetImpl result = new ResultSetImpl(0, 2, null, null, null, null);
        PrimaryCharKey key = new PrimaryCharKey(this.m_charParam[1]);
        Table table = this.m_table;
        synchronized (table) {
            DatabaseTableRow row = this.m_table.findRow(key);
            if (row != null && !row.isLockCollision(this.m_connection)) {
                result.addRow(row.getNewRowCopy());
            }
        }
        result.resultCreated();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSetImpl queryMessageSelect() throws SQLException {
        ResultSetImpl result = new ResultSetImpl(17, 13, null, null, null, null);
        Table table = this.m_table;
        synchronized (table) {
            DatabaseTableRow row = this.findRow(this.m_table, this.m_numericParam[1]);
            if (row != null && !row.isLockCollision(this.m_connection)) {
                result.addRow(row.getNewRowCopy());
            }
        }
        result.resultCreated();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSetImpl querySelectCount() throws SQLException {
        ResultSetImpl result = new ResultSetImpl(3, 0, null, null, null, null);
        DatabaseRow row = result.getNewResultRow();
        Table table = this.m_table;
        synchronized (table) {
            row.setNumericCol(1, this.m_table.getRowCount());
            if (this.m_stmtIndex == 31) {
                row.setNumericCol(2, DatabaseTables.getUsedMessageSpace());
                row.setNumericCol(3, DatabaseTables.getMaxMessageSpace());
            }
        }
        if (this.m_stmtIndex == 60) {
            row.setNumericCol(2, DatabaseTables.getMaxSendOrders());
        }
        result.addRow(row);
        result.resultCreated();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSetImpl querySendorderSelectCountByDest() throws SQLException {
        int rowCount = 0;
        long destination = this.m_numericParam[1];
        long isInProcess = this.m_numericParam[2];
        long isDelivered = this.m_numericParam[3];
        Table table = this.m_table;
        synchronized (table) {
            Iterator iter = this.m_table.getIterator();
            while (iter.hasNext()) {
                TableRow row = (TableRow)iter.next();
                if (row.getNumericCol(4) != destination || row.getNumericCol(8) != isInProcess || row.getNumericCol(9) != isDelivered) continue;
                ++rowCount;
            }
        }
        ResultSetImpl result = new ResultSetImpl(1, 0, null, null, null, null);
        DatabaseRow row = result.getNewResultRow();
        row.setNumericCol(1, rowCount);
        result.addRow(row);
        result.resultCreated();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSetImpl querySendorderSelectMaxMsgsequence() throws SQLException {
        ResultSetImpl result = new ResultSetImpl(1, 0, null, null, null, null);
        long maxSequence = -1L;
        long destination = this.m_numericParam[1];
        DatabaseRow resultRow = result.getNewResultRow();
        Table table = this.m_table;
        synchronized (table) {
            Iterator iter = this.m_table.getIterator();
            while (iter.hasNext()) {
                long currSequence;
                TableRow row = (TableRow)iter.next();
                if (row.getNumericCol(4) != destination || (currSequence = row.getNumericCol(6)) <= maxSequence) continue;
                maxSequence = currSequence;
            }
        }
        resultRow.setNumericCol(1, maxSequence);
        result.addRow(resultRow);
        result.resultCreated();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSetImpl querySendorderSelectMaxTrans() throws SQLException {
        ResultSetImpl result = new ResultSetImpl(1, 0, null, null, null, null);
        long maxSequence = -1L;
        DatabaseRow resultRow = result.getNewResultRow();
        Table table = this.m_table;
        synchronized (table) {
            Iterator iter = this.m_table.getIterator();
            while (iter.hasNext()) {
                TableRow row = (TableRow)iter.next();
                long currSequence = row.getNumericCol(5);
                if (currSequence <= maxSequence) continue;
                maxSequence = currSequence;
            }
        }
        resultRow.setNumericCol(1, maxSequence);
        result.addRow(resultRow);
        result.resultCreated();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSetImpl querySendorderSelectOrders() throws SQLException {
        ResultSetImpl result = new ResultSetImpl(8, 0, null, null, null, null);
        Table table = this.m_table;
        synchronized (table) {
            Iterator iter = ((TableWithIndex)this.m_table).getIndexIterator();
            while (iter.hasNext()) {
                TableRow row = (TableRow)iter.next();
                if (row.getNumericCol(8) != 0L || row.getNumericCol(13) != 1L || row.isLockCollision(this.m_connection)) continue;
                DatabaseRow resultRow = result.getNewResultRow();
                resultRow.copyCol(1, row, 11);
                resultRow.copyCol(2, row, 5);
                resultRow.copyCol(3, row, 6);
                resultRow.copyCol(4, row, 1);
                resultRow.copyCol(5, row, 3);
                resultRow.copyCol(6, row, 7);
                resultRow.copyCol(7, row, 4);
                resultRow.copyCol(8, row, 9);
                if (result.addRow(resultRow) < this.m_fetchSize) continue;
                break;
            }
        }
        result.resultCreated();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSetImpl querySendorderSelectOrdersWithDest() throws SQLException {
        ResultSetImpl result = new ResultSetImpl(5, 0, null, null, null, null);
        long isQueueOrder = this.m_numericParam[1];
        long destination = this.m_numericParam[2];
        long consumer = this.m_numericParam[3];
        Table table = this.m_table;
        synchronized (table) {
            Iterator iter = ((TableWithIndex)this.m_table).getIndexIterator();
            while (iter.hasNext()) {
                TableRow row = (TableRow)iter.next();
                if (row.getNumericCol(8) != 0L || row.getNumericCol(7) != isQueueOrder || row.getNumericCol(4) != destination || row.getNumericCol(3) != consumer || row.isLockCollision(this.m_connection)) continue;
                DatabaseRow resultRow = result.getNewResultRow();
                resultRow.copyCol(1, row, 11);
                resultRow.copyCol(2, row, 5);
                resultRow.copyCol(3, row, 6);
                resultRow.copyCol(4, row, 1);
                resultRow.copyCol(5, row, 9);
                if (result.addRow(resultRow) < this.m_fetchSize) continue;
                break;
            }
        }
        result.resultCreated();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSetImpl querySendorderSelectOrderByPrio(boolean queueOrder) throws SQLException {
        ResultSetDestOrder result = new ResultSetDestOrder(4, 1, false, 2, true, 3, true, 4, true);
        long destination = this.m_numericParam[1];
        long messageId = this.m_numericParam[2];
        int isQueueOrder = queueOrder ? 1 : 0;
        Table table = this.m_table;
        synchronized (table) {
            Iterator iter = this.m_table.getIteratorGreaterEqual(new PrimaryNumKey(messageId));
            while (iter.hasNext()) {
                TableRow currRow = (TableRow)iter.next();
                if (currRow.getNumericCol(4) != destination || currRow.getNumericCol(1) <= messageId || currRow.getNumericCol(7) != (long)isQueueOrder || currRow.getNumericCol(8) != 0L || currRow.isLockCollision(this.m_connection)) continue;
                DatabaseRow resultRow = result.getNewResultRow();
                resultRow.copyCol(1, currRow, 11);
                resultRow.copyCol(2, currRow, 5);
                resultRow.copyCol(3, currRow, 6);
                resultRow.copyCol(4, currRow, 1);
                if (((ResultSetImpl)result).addRow(resultRow) < this.m_fetchSize) continue;
                break;
            }
        }
        ((ResultSetImpl)result).resultCreated();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSetImpl queryTransSelect() throws SQLException {
        ResultSetTransSelect result = new ResultSetTransSelect(7, 3);
        long trans = this.m_numericParam[1];
        Table table = this.m_table;
        synchronized (table) {
            Iterator iter = this.m_table.getIterator();
            while (iter.hasNext()) {
                TableRow currRow = (TableRow)iter.next();
                if (currRow.getNumericCol(5) != trans || currRow.isLockCollision(this.m_connection)) continue;
                DatabaseRow resultRow = result.getNewResultRow();
                resultRow.copyCol(1, currRow, 1);
                resultRow.copyCol(2, currRow, 2);
                resultRow.copyCol(3, currRow, 3);
                resultRow.copyCol(4, currRow, 4);
                resultRow.copyCol(5, currRow, 5);
                resultRow.copyCol(6, currRow, 6);
                resultRow.copyCol(7, currRow, 7);
                if (((ResultSetImpl)result).addRow(resultRow) < this.m_fetchSize) continue;
                break;
            }
        }
        ((ResultSetImpl)result).resultCreated();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updConsumerDelWhereType() throws SQLException {
        int rowCount = 0;
        Table table = this.m_table;
        synchronized (table) {
            Iterator iter = this.m_table.getIterator();
            while (iter.hasNext()) {
                TableRow row = (TableRow)iter.next();
                if (row.getNumericCol(4) == 2L || row.isLockCollision(this.m_connection)) continue;
                iter.remove();
                ++rowCount;
            }
        }
        return rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updConsumerUpd() {
        Table table = this.m_table;
        synchronized (table) {
            DatabaseTableRow row = this.findUpdateRow(this.m_numericParam[8]);
            if (row == null) {
                return 0;
            }
            int colNo = 2;
            for (int paramNo = 1; paramNo <= 7; ++paramNo) {
                if (this.m_isNullParam[paramNo]) {
                    row.setNull(colNo);
                } else if (paramNo == 5 || paramNo == 6) {
                    row.setCharCol(colNo, this.m_charParam[paramNo]);
                } else {
                    row.setNumericCol(colNo, this.m_numericParam[paramNo]);
                }
                ++colNo;
            }
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updConsumerUpdSetState() {
        Table table = this.m_table;
        synchronized (table) {
            DatabaseTableRow row = this.findUpdateRow(this.m_numericParam[2]);
            if (row == null) {
                return 0;
            }
            row.setNumericCol(5, this.m_numericParam[1]);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updConsumerUpdSetStateWhereType() throws SQLException {
        int rowCount = 0;
        Table table = this.m_table;
        synchronized (table) {
            Iterator iter = this.m_table.getIterator();
            while (iter.hasNext()) {
                DatabaseTableRow updRow;
                TableRow row = (TableRow)iter.next();
                if (row.getNumericCol(4) != 2L || (updRow = this.getUpdateRow(row)) == null) continue;
                updRow.setNumericCol(5, 1L);
                ++rowCount;
            }
        }
        return rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updDelAll() {
        int rowCount = 0;
        Table table = this.m_table;
        synchronized (table) {
            rowCount = this.m_table.getRowCount();
            this.m_table.removeAll();
        }
        return rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updDelNumKey() {
        PrimaryNumKey key = new PrimaryNumKey(this.m_numericParam[1]);
        Table table = this.m_table;
        synchronized (table) {
            DatabaseTableRow row = this.m_table.findRow(key);
            if (row == null) {
                return 0;
            }
            if (row.isLockCollision(this.m_connection)) {
                return 0;
            }
            this.m_table.removeRow(key);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updDestinDelWhereName() throws SQLException {
        int rowCount = 0;
        String name = this.m_charParam[1];
        long isQueue = this.m_numericParam[2];
        Table table = this.m_table;
        synchronized (table) {
            Iterator iter = this.m_table.getIterator();
            while (iter.hasNext()) {
                TableRow row = (TableRow)iter.next();
                if (row.getNumericCol(3) != isQueue || !name.equals(row.getCharCol(2)) || row.isLockCollision(this.m_connection)) continue;
                iter.remove();
                ++rowCount;
            }
        }
        return rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updLookupDelete() {
        PrimaryCharKey key = new PrimaryCharKey(this.m_charParam[1]);
        Table table = this.m_table;
        synchronized (table) {
            DatabaseTableRow row = this.m_table.findRow(key);
            if (row == null) {
                return 0;
            }
            if (row.isLockCollision(this.m_connection)) {
                return 0;
            }
            this.m_table.removeRow(key);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updLookupUpd() {
        PrimaryCharKey key = new PrimaryCharKey(this.m_charParam[2]);
        Table table = this.m_table;
        synchronized (table) {
            DatabaseTableRow row = this.getUpdateRow(this.m_table.findRow(key));
            if (row == null) {
                return 0;
            }
            row.setBinaryCol(2, (byte[])this.m_objectParam[1]);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updMessageDelId() throws SQLException {
        PrimaryNumKey key = new PrimaryNumKey(this.m_numericParam[1]);
        Table table = this.m_table;
        synchronized (table) {
            DatabaseTableRow row = this.m_table.findRow(key);
            if (row == null) {
                return 0;
            }
            if (row.isLockCollision(this.m_connection)) {
                return 0;
            }
            DatabaseTables.decreaseUsedMessageSpace(row.getNumericCol(3));
            this.m_table.removeRow(key);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updMessageDelIdReceived() throws SQLException {
        PrimaryNumKey key = new PrimaryNumKey(this.m_numericParam[1]);
        Table messageTab = DatabaseTables.getMessageTable();
        TableWithIndex sendorderTab = DatabaseTables.getSendorderTable();
        Table table = messageTab;
        synchronized (table) {
            TableWithIndex tableWithIndex = sendorderTab;
            synchronized (tableWithIndex) {
                TableRow row = (TableRow)messageTab.findRow(key);
                if (row == null) {
                    return 0;
                }
                if (row.isLockCollision(this.m_connection)) {
                    return 0;
                }
                if (this.existsFirstKeyValue(sendorderTab, this.m_numericParam[2])) {
                    return 0;
                }
                DatabaseTables.decreaseUsedMessageSpace(row.getNumericCol(3));
                messageTab.removeRow(key);
            }
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updMessageDelUnused() throws SQLException {
        int rowCount = 0;
        long paramMessageId = this.m_numericParam[1];
        Table messageTab = DatabaseTables.getMessageTable();
        TableWithIndex sendorderTab = DatabaseTables.getSendorderTable();
        Table transTab = DatabaseTables.getTransactionTable();
        Table table = messageTab;
        synchronized (table) {
            TableWithIndex tableWithIndex = sendorderTab;
            synchronized (tableWithIndex) {
                Table table2 = transTab;
                synchronized (table2) {
                    TableRow row;
                    long messageId;
                    Iterator iter = messageTab.getIterator();
                    while (iter.hasNext() && (messageId = (row = (TableRow)iter.next()).getNumericCol(1)) < paramMessageId) {
                        if (row.isLockCollision(this.m_connection) || this.existsFirstKeyValue(sendorderTab, messageId) || this.existsFirstKeyValue(transTab, messageId)) continue;
                        DatabaseTables.decreaseUsedMessageSpace(row.getNumericCol(3));
                        iter.remove();
                        ++rowCount;
                    }
                }
            }
        }
        return rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updMessageIns() throws SQLException {
        long usedBytes = this.m_newRow.getNumericCol(3);
        if (usedBytes > 0L) {
            Table table = this.m_table;
            synchronized (table) {
                DatabaseTables.increaseUsedMessageSpace(usedBytes);
            }
        }
        try {
            return this.performInsert();
        }
        catch (SQLException e) {
            if (usedBytes > 0L) {
                Table table = this.m_table;
                synchronized (table) {
                    DatabaseTables.decreaseUsedMessageSpace(usedBytes);
                }
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updSendorderDelExpired() throws SQLException {
        int rowCount = 0;
        long expiresParam = this.m_numericParam[1];
        long messageId = this.m_numericParam[2];
        Table table = this.m_table;
        synchronized (table) {
            TableRowWithIndex row;
            Iterator iter = this.m_table.getIterator();
            while (iter.hasNext() && (row = (TableRowWithIndex)iter.next()).getNumericCol(1) < messageId) {
                long expires;
                if (row.getNumericCol(8) != 0L || (expires = row.getNumericCol(12)) <= 0L || expires >= expiresParam || row.isLockCollision(this.m_connection)) continue;
                ((TableWithIndex)this.m_table).removeIndexRow(row.getIndexKey());
                iter.remove();
                ++rowCount;
            }
        }
        return rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updSendorderDelReceived() throws SQLException {
        PrimaryNumNumKey key = new PrimaryNumNumKey(this.m_numericParam[1], this.m_numericParam[2]);
        Table table = this.m_table;
        synchronized (table) {
            boolean clause2;
            DatabaseTableRow row = this.m_table.findRow(key);
            if (row == null) {
                return 0;
            }
            if (row.getNumericCol(9) != 1L) {
                return 0;
            }
            boolean clause1 = row.getNumericCol(3) == this.m_numericParam[3] && row.getNumericCol(8) != 0L;
            boolean bl = clause2 = row.getNumericCol(3) == 0L && row.getNumericCol(7) == 1L && row.getNumericCol(8) == 0L;
            if (!clause1 && !clause2) {
                return 0;
            }
            if (row.isLockCollision(this.m_connection)) {
                return 0;
            }
            this.m_table.removeRow(key);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updSendorderDelTopicWhereConsumer() throws SQLException {
        int rowCount = 0;
        long consumer = this.m_numericParam[1];
        Table table = this.m_table;
        synchronized (table) {
            Iterator iter = this.m_table.getIterator();
            while (iter.hasNext()) {
                TableRowWithIndex row = (TableRowWithIndex)iter.next();
                if (row.getNumericCol(7) != 0L || row.getNumericCol(3) != consumer || row.isLockCollision(this.m_connection)) continue;
                ((TableWithIndex)this.m_table).removeIndexRow(row.getIndexKey());
                iter.remove();
                ++rowCount;
            }
        }
        return rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updSendorderDelTopicWhereConsumerExists() throws SQLException {
        int rowCount = 0;
        long messageId = this.m_numericParam[1];
        Table consumerTab = DatabaseTables.getConsumerTable();
        TableWithIndex sendorderTab = DatabaseTables.getSendorderTable();
        Table table = consumerTab;
        synchronized (table) {
            TableWithIndex tableWithIndex = sendorderTab;
            synchronized (tableWithIndex) {
                TableRowWithIndex row;
                Iterator iter = sendorderTab.getIterator();
                while (iter.hasNext() && (row = (TableRowWithIndex)iter.next()).getNumericCol(1) < messageId) {
                    long consumerId;
                    if (row.getNumericCol(7) != 0L || row.isLockCollision(this.m_connection) || !this.existsConsumer(consumerTab, consumerId = row.getNumericCol(3), 0L)) continue;
                    sendorderTab.removeIndexRow(row.getIndexKey());
                    iter.remove();
                    ++rowCount;
                }
            }
        }
        return rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updSendorderDelTopicWhereConsumerNotExists() throws SQLException {
        int rowCount = 0;
        long messageId = this.m_numericParam[1];
        Table consumerTab = DatabaseTables.getConsumerTable();
        TableWithIndex sendorderTab = DatabaseTables.getSendorderTable();
        Table table = consumerTab;
        synchronized (table) {
            TableWithIndex tableWithIndex = sendorderTab;
            synchronized (tableWithIndex) {
                TableRowWithIndex row;
                Iterator iter = sendorderTab.getIterator();
                while (iter.hasNext() && (row = (TableRowWithIndex)iter.next()).getNumericCol(1) < messageId) {
                    long consumerId;
                    if (row.getNumericCol(7) != 0L || row.isLockCollision(this.m_connection) || this.existsConsumer(consumerTab, consumerId = row.getNumericCol(3))) continue;
                    sendorderTab.removeIndexRow(row.getIndexKey());
                    iter.remove();
                    ++rowCount;
                }
            }
        }
        return rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updSendorderDelTopicWhereMessage() throws SQLException {
        Table table = this.m_table;
        synchronized (table) {
            PrimaryNumNumKey key = new PrimaryNumNumKey(this.m_numericParam[1], this.m_numericParam[2]);
            DatabaseTableRow row = this.m_table.findRow(key);
            if (row == null) {
                return 0;
            }
            if (row.getNumericCol(7) != 0L) {
                return 0;
            }
            if (row.isLockCollision(this.m_connection)) {
                return 0;
            }
            this.m_table.removeRow(key);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updSendorderDelWhereDest() throws SQLException {
        int rowCount = 0;
        long destination = this.m_numericParam[1];
        Table table = this.m_table;
        synchronized (table) {
            Iterator iter = this.m_table.getIterator();
            while (iter.hasNext()) {
                TableRowWithIndex row = (TableRowWithIndex)iter.next();
                if (row.getNumericCol(4) != destination || row.isLockCollision(this.m_connection)) continue;
                ((TableWithIndex)this.m_table).removeIndexRow(row.getIndexKey());
                iter.remove();
                ++rowCount;
            }
        }
        return rowCount;
    }

    private int updSendorderIns() throws SQLException {
        DatabaseTables.checkSendOrderLimit();
        return this.performInsert();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updSendorderUpdActive(boolean queueWanted) throws SQLException {
        int destinOrConsumer;
        long isQueueOrder;
        int rowCount = 0;
        if (queueWanted) {
            isQueueOrder = 1L;
            destinOrConsumer = 4;
        } else {
            isQueueOrder = 0L;
            destinOrConsumer = 3;
        }
        Table table = this.m_table;
        synchronized (table) {
            Iterator iter = this.m_table.getIterator();
            while (iter.hasNext()) {
                TableRow row = (TableRow)iter.next();
                if (row.getNumericCol(7) != isQueueOrder || row.getNumericCol(destinOrConsumer) != this.m_numericParam[2] || row.getNumericCol(13) != this.m_numericParam[3]) continue;
                row.setNumericCol(13, this.m_numericParam[1]);
                ++rowCount;
            }
        }
        return rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updSendorderUpdDelivered() throws SQLException {
        Table table = this.m_table;
        synchronized (table) {
            DatabaseTableRow row = this.findUpdateRow(this.m_numericParam[1], this.m_numericParam[2]);
            if (row == null) {
                return 0;
            }
            if (row.getNumericCol(8) != this.m_numericParam[3]) {
                return 0;
            }
            row.setNumericCol(9, 1L);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updSendorderUpdInprocessAndDelivered() throws SQLException {
        long inProcess = this.m_numericParam[1];
        long newConsumerId = this.m_numericParam[2];
        long messageId = this.m_numericParam[3];
        long topicConsumerId = this.m_numericParam[4];
        Table table = this.m_table;
        synchronized (table) {
            DatabaseTableRow row = this.findUpdateRow(messageId, topicConsumerId);
            if (row == null) {
                return 0;
            }
            if (row.getNumericCol(8) != 0L) {
                return 0;
            }
            row.setNumericCol(8, inProcess);
            row.setNumericCol(3, newConsumerId);
            row.setNumericCol(9, 1L);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updSendorderUpdMarkNext() throws SQLException {
        long inProcess = this.m_numericParam[1];
        long newConsumerId = this.m_numericParam[2];
        long messageId = this.m_numericParam[3];
        long topicConsumerId = this.m_numericParam[4];
        Table table = this.m_table;
        synchronized (table) {
            DatabaseTableRow row = this.findUpdateRow(messageId, topicConsumerId);
            if (row == null) {
                return 0;
            }
            if (row.getNumericCol(8) != 0L) {
                return 0;
            }
            row.setNumericCol(8, inProcess);
            row.setNumericCol(3, newConsumerId);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updSendorderUpdReceivedQueueRollback() throws SQLException {
        Table table = this.m_table;
        synchronized (table) {
            DatabaseTableRow row = this.findUpdateRow(this.m_numericParam[1], 0L);
            if (row == null) {
                return 0;
            }
            if (row.getNumericCol(3) != this.m_numericParam[2] || row.getNumericCol(7) != 1L || row.getNumericCol(9) != 1L || row.getNumericCol(8) == 0L) {
                return 0;
            }
            row.setNumericCol(3, 0L);
            row.setNumericCol(8, 0L);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updSendorderUpdReceivedTopicRollback() throws SQLException {
        Table table = this.m_table;
        synchronized (table) {
            DatabaseTableRow row = this.findUpdateRow(this.m_numericParam[1], this.m_numericParam[2]);
            if (row == null) {
                return 0;
            }
            if (row.getNumericCol(3) != this.m_numericParam[3] || row.getNumericCol(7) != 0L || row.getNumericCol(9) != 1L || row.getNumericCol(8) == 0L) {
                return 0;
            }
            row.setNumericCol(8, 0L);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updSendorderUpdRecoverQueue() throws SQLException {
        int rowCount = 0;
        Table table = this.m_table;
        synchronized (table) {
            Iterator iter = this.m_table.getIterator();
            while (iter.hasNext()) {
                DatabaseTableRow updRow;
                TableRow row = (TableRow)iter.next();
                if (row.getNumericCol(7) != 1L || (updRow = this.getUpdateRow(row)) == null) continue;
                updRow.setNumericCol(8, 0L);
                updRow.setNumericCol(3, 0L);
                updRow.setNumericCol(13, 0L);
                ++rowCount;
            }
        }
        return rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updSendorderUpdRecoverTopic() throws SQLException {
        int rowCount = 0;
        Table table = this.m_table;
        synchronized (table) {
            Iterator iter = this.m_table.getIterator();
            while (iter.hasNext()) {
                DatabaseTableRow updRow;
                TableRow row = (TableRow)iter.next();
                if (row.getNumericCol(7) != 0L || (updRow = this.getUpdateRow(row)) == null) continue;
                updRow.setNumericCol(8, 0L);
                updRow.setNumericCol(13, 0L);
                ++rowCount;
            }
        }
        return rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updSendorderUpdResetQueueWhereConsumer() throws SQLException {
        int rowCount = 0;
        long consumerId = this.m_numericParam[1];
        Table table = this.m_table;
        synchronized (table) {
            Iterator iter = this.m_table.getIterator();
            while (iter.hasNext()) {
                DatabaseTableRow updRow;
                TableRow row = (TableRow)iter.next();
                if (row.getNumericCol(7) != 1L || row.getNumericCol(3) != consumerId || row.getNumericCol(8) == 0L || (updRow = this.getUpdateRow(row)) == null) continue;
                updRow.setNumericCol(8, 0L);
                updRow.setNumericCol(3, 0L);
                ++rowCount;
            }
        }
        return rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updSendorderUpdResetQueueWhereMessageAndConsumer() throws SQLException {
        long messageId = this.m_numericParam[1];
        long consumerId = this.m_numericParam[2];
        Table table = this.m_table;
        synchronized (table) {
            DatabaseTableRow row = this.findRow(messageId, 0L);
            if (row == null) {
                return 0;
            }
            if (row.getNumericCol(7) != 1L || row.getNumericCol(3) != consumerId || row.getNumericCol(8) == 0L) {
                return 0;
            }
            if (row.isLockCollision(this.m_connection)) {
                return 0;
            }
            row.setNumericCol(8, 0L);
            row.setNumericCol(3, 0L);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updSendorderUpdResetTopicWhereConsumer() throws SQLException {
        int rowCount = 0;
        long consumerId = this.m_numericParam[1];
        Table table = this.m_table;
        synchronized (table) {
            Iterator iter = this.m_table.getIterator();
            while (iter.hasNext()) {
                DatabaseTableRow updRow;
                TableRow row = (TableRow)iter.next();
                if (row.getNumericCol(7) != 0L || row.getNumericCol(3) != consumerId || row.getNumericCol(8) == 0L || (updRow = this.getUpdateRow(row)) == null) continue;
                updRow.setNumericCol(8, 0L);
                ++rowCount;
            }
        }
        return rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updSendorderUpdResetTopicWhereMessageAndConsumer() throws SQLException {
        Table table = this.m_table;
        synchronized (table) {
            DatabaseTableRow row = this.findRow(this.m_numericParam[1], this.m_numericParam[2]);
            if (row == null) {
                return 0;
            }
            if (row.getNumericCol(7) != 0L || row.getNumericCol(8) == 0L) {
                return 0;
            }
            if (row.isLockCollision(this.m_connection)) {
                return 0;
            }
            row.setNumericCol(8, 0L);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updTransDel() throws SQLException {
        int rowCount = 0;
        long transId = this.m_numericParam[1];
        Table table = this.m_table;
        synchronized (table) {
            Iterator iter = this.m_table.getIterator();
            while (iter.hasNext()) {
                TableRow row = (TableRow)iter.next();
                if (row.getNumericCol(5) != transId || row.isLockCollision(this.m_connection)) continue;
                iter.remove();
                ++rowCount;
            }
        }
        return rowCount;
    }

    private boolean existsConsumer(Table consumerTab, long id) {
        DatabaseTableRow consumerRow = this.findRow(consumerTab, id);
        return consumerRow != null;
    }

    private boolean existsConsumer(Table consumerTab, long id, long state) throws SQLException {
        DatabaseTableRow consumerRow = this.findRow(consumerTab, id);
        if (consumerRow == null) {
            return false;
        }
        if (consumerRow.isLockCollision(this.m_connection)) {
            return false;
        }
        return consumerRow.getNumericCol(5) == state;
    }

    private boolean existsFirstKeyValue(Table tab, long keyValue1) throws SQLException {
        DatabaseKey startKey = tab.getNewKey();
        startKey.addCol(1, keyValue1);
        Iterator iter = tab.getIteratorGreaterEqual(startKey);
        while (iter.hasNext()) {
            TableRow row = (TableRow)iter.next();
            long col1Value = row.getNumericCol(1);
            if (col1Value < keyValue1) continue;
            return col1Value == keyValue1;
        }
        return false;
    }

    private DatabaseTableRow findRow(Table tab, long keyValue) {
        return tab.findRow(new PrimaryNumKey(keyValue));
    }

    private DatabaseTableRow findRow(long keyValue1, long keyValue2) {
        return this.m_table.findRow(new PrimaryNumNumKey(keyValue1, keyValue2));
    }

    private DatabaseTableRow findUpdateRow(long keyValue) {
        return this.getUpdateRow(this.m_table.findRow(new PrimaryNumKey(keyValue)));
    }

    private DatabaseTableRow findUpdateRow(long keyValue1, long keyValue2) {
        return this.getUpdateRow(this.m_table.findRow(new PrimaryNumNumKey(keyValue1, keyValue2)));
    }

    private DatabaseTableRow getUpdateRow(DatabaseTableRow row) {
        if (!row.lock(this.m_connection) || row.isDeleted()) {
            return null;
        }
        this.m_table.updateLogging(this.m_connection, row);
        return row;
    }
}

