/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.service;

import com.sap.sdb.msgServer.Server;
import com.sap.sdb.msgServer.service.ServiceException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public abstract class Service {
    protected Server myServer;
    private String myName;
    private boolean myStopFlag;

    public Service(Server server, String name) throws ServiceException {
        if (server == null || name == null) {
            if (name == null) {
                throw new ServiceException("???", "Service-Constructor failed due to null parameters");
            }
            throw new ServiceException(name, "Service-Constructor failed due to null server parameter");
        }
        this.myServer = server;
        this.myName = name;
    }

    public Server getServer() {
        return this.myServer;
    }

    public String getName() {
        return this.myName;
    }

    public boolean isStopped() {
        return this.myStopFlag;
    }

    public void enableService() {
        this.myStopFlag = false;
    }

    public void stopService() {
        this.myStopFlag = true;
    }

    public abstract void serve(InputStream var1, OutputStream var2) throws IOException;

    public abstract void open(Hashtable var1) throws ServiceException;

    public abstract void close() throws ServiceException;

    protected String[] tokenize(String command) {
        StringTokenizer st = new StringTokenizer(command);
        int count = st.countTokens();
        String[] tokens = new String[count];
        for (int i = 0; i < count; ++i) {
            tokens[i] = st.nextToken();
        }
        return tokens;
    }

    protected String nextToken(StringTokenizer st, String errorMsg) throws ServiceException {
        if (st.hasMoreTokens()) {
            return st.nextToken();
        }
        throw new ServiceException(this, errorMsg);
    }

    protected String nextString(StringTokenizer st, String errorMsg) throws ServiceException {
        String result = null;
        try {
            st.nextToken("\"");
            if (!st.hasMoreTokens()) {
                throw new ServiceException(this, errorMsg);
            }
            result = st.nextToken();
        }
        catch (NoSuchElementException ex) {
            throw new ServiceException(this, errorMsg);
        }
        try {
            st.nextToken(" ");
        }
        catch (Exception ex) {
            // empty catch block
        }
        return result;
    }
}

