/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.service;

import com.sap.sdb.msgServer.Server;
import com.sap.sdb.msgServer.agents.AcknowledgeAgent;
import com.sap.sdb.msgServer.agents.AdminAgent;
import com.sap.sdb.msgServer.agents.AdminException;
import com.sap.sdb.msgServer.agents.Agent;
import com.sap.sdb.msgServer.agents.DestinationAlreadyExistsException;
import com.sap.sdb.msgServer.agents.FreeLists;
import com.sap.sdb.msgServer.agents.GarbageCollector;
import com.sap.sdb.msgServer.agents.JmsOutputManager;
import com.sap.sdb.msgServer.agents.JmsThread;
import com.sap.sdb.msgServer.agents.MessageBuilder;
import com.sap.sdb.msgServer.agents.ReceivingAgent;
import com.sap.sdb.msgServer.agents.SendOrderPolling;
import com.sap.sdb.msgServer.agents.SocketWriter;
import com.sap.sdb.msgServer.agents.SyncReceiveHandler;
import com.sap.sdb.msgServer.client.QueueConnectionFactoryImpl;
import com.sap.sdb.msgServer.client.TopicConnectionFactoryImpl;
import com.sap.sdb.msgServer.config.CreateMsgServerTables;
import com.sap.sdb.msgServer.database.ConsumerList;
import com.sap.sdb.msgServer.database.DBConnectionPool;
import com.sap.sdb.msgServer.database.DataBaseTime;
import com.sap.sdb.msgServer.database.DeliveryPreparedStmt;
import com.sap.sdb.msgServer.database.DeliveryResultSet;
import com.sap.sdb.msgServer.database.DestinationList;
import com.sap.sdb.msgServer.database.MessageCache;
import com.sap.sdb.msgServer.database.MessageTable;
import com.sap.sdb.msgServer.database.SendOrderTable;
import com.sap.sdb.msgServer.database.UserConnection;
import com.sap.sdb.msgServer.jndi.JndiService;
import com.sap.sdb.msgServer.msgselector.MsgSelector;
import com.sap.sdb.msgServer.service.Service;
import com.sap.sdb.msgServer.service.ServiceException;
import com.sap.sdb.msgServer.util.AdminNotification;
import com.sap.sdb.msgServer.util.ConnectionTransfer;
import com.sap.sdb.msgServer.util.DeactivateAdminNotification;
import com.sap.sdb.msgServer.util.DestinationAdminNotification;
import com.sap.sdb.msgServer.util.DestinationAuth;
import com.sap.sdb.msgServer.util.ErrorNotification;
import com.sap.sdb.msgServer.util.ListDestAdminNotification;
import com.sap.sdb.msgServer.util.ListNotificationQueue;
import com.sap.sdb.msgServer.util.Notification;
import com.sap.sdb.msgServer.util.NotificationChannel;
import com.sap.sdb.msgServer.util.NotificationQueue;
import com.sap.sdb.msgServer.util.ReceiveStream;
import com.sap.sdb.msgServer.util.ResetAdminNotification;
import com.sap.sdb.msgServer.util.SendStream;
import com.sap.sdb.msgServer.util.SendingNotificationCounter;
import com.sap.sdb.msgServer.util.SendingNotificationQueue;
import com.sap.sdb.msgServer.util.ServerConfig;
import com.sap.sdb.msgServer.util.StreamString;
import com.sap.sdb.msgServer.util.VectorNotification;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.SocketException;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.jms.InvalidSelectorException;
import javax.naming.NamingException;

public class JmsService
extends Service {
    private ThreadGroup mThreadGroup;
    private Hashtable mNotificationQueues;
    private Vector mThreads;
    private static long mDatabaseTimeStamp;
    private static long mInitialTimeStamp;
    private int mMaxSendOrderQueueSize;
    private Hashtable mBrowserSelectors;
    private GarbageCollector mGarbageCollector;
    private SendOrderPolling mSendOrderPollingPersistent = null;
    private SendOrderPolling mSendOrderPollingTransient = null;
    private NotificationQueue mAcknowledgeQueue;
    private NotificationQueue mReceivingQueue;
    private NotificationQueue mAdminQueue;
    private SendingNotificationQueue mSendingQueue;
    private SendingNotificationCounter mSendingCounter;
    private DebugOutputThread mDebugOutputThread = null;
    private static boolean s_verboseAdmin;
    private static boolean s_verboseConsumer;
    private static boolean s_verboseException;
    private static boolean s_verboseMessageBuilder;
    private static boolean s_verboseSendingQueues;
    private static boolean s_verboseSendOrderStat;
    private static boolean s_verboseSendReceive;
    private static boolean s_verboseSQLConnection;
    private static boolean s_verboseTraceback;
    private static boolean s_verboseWait;
    public static final String ACKNOWLEDGE_QUEUE = "ack";
    public static final String RECEIVING_QUEUE = "rec";
    public static final String SENDING_QUEUE = "send";
    public static final String ADMIN_QUEUE = "adm";
    public static final String PERSIST_QUEUE = "persist";
    public static final String SOCKET_QUEUE = "socket";
    private static final String TRANSIENT_PACKAGE_PREFIX = "com.sap.sdb.msgServer.transientStorage";
    private long mDisplayTime = 0L;

    public JmsService(Server server) throws ServiceException {
        super(server, "MsgServer");
        this.mThreadGroup = server.createSubThreadGroup("MsgService");
        this.mNotificationQueues = new Hashtable(100);
        this.mThreads = new Vector(100, 10);
        this.mBrowserSelectors = new Hashtable(100);
    }

    public ThreadGroup getThreadGroup() {
        return this.mThreadGroup;
    }

    public SendingNotificationQueue getSendingQueue() {
        return this.mSendingQueue;
    }

    public NotificationQueue getReceivingQueue() {
        return this.mReceivingQueue;
    }

    public void addNotificationQueue(NotificationQueue queue) {
        this.mNotificationQueues.put(queue.getID(), queue);
    }

    public NotificationQueue removeNotificationQueue(String queueID) {
        return (NotificationQueue)this.mNotificationQueues.remove(queueID);
    }

    public void addBrowserSelector(Long id, MsgSelector aSelector) {
        this.mBrowserSelectors.put(id, aSelector);
    }

    public void removeBrowserSelector(Long id) {
        this.mBrowserSelectors.remove(id);
    }

    public MsgSelector getBrowserSelector(Long id) {
        return (MsgSelector)this.mBrowserSelectors.get(id);
    }

    public void addJmsThread(JmsThread newThread) {
        this.mThreads.add(newThread);
    }

    private Agent getAgent(String queueName) {
        Agent agent = null;
        for (int i = 0; i < this.mThreads.size(); ++i) {
            if (!(this.mThreads.elementAt(i) instanceof Agent) || !((Agent)this.mThreads.elementAt(i)).getNotificationQueue().getID().equals(queueName)) continue;
            agent = (Agent)this.mThreads.elementAt(i);
            break;
        }
        return agent;
    }

    public void open(Hashtable global_commandline_options) throws ServiceException {
        ServerConfig aServerConfig = this.myServer.getServerConfig();
        this.mMaxSendOrderQueueSize = aServerConfig.getLengthSendOrderQueue();
        s_verboseAdmin = aServerConfig.getVerboseAdmin();
        s_verboseConsumer = aServerConfig.getVerboseConsumer();
        s_verboseException = aServerConfig.getVerboseException();
        s_verboseMessageBuilder = aServerConfig.getVerboseMessageBuilder();
        s_verboseSendingQueues = aServerConfig.getVerboseSendingQueues();
        s_verboseSendOrderStat = aServerConfig.getVerboseSendOrderStat();
        s_verboseSendReceive = aServerConfig.getVerboseSendReceive();
        s_verboseSQLConnection = aServerConfig.getVerboseSQLConnection();
        s_verboseTraceback = aServerConfig.getVerboseTraceBack();
        s_verboseWait = aServerConfig.getVerboseWait();
        UserConnection dbConnection = null;
        try {
            String url = aServerConfig.getDatabaseURL();
            String jdbcDriver = aServerConfig.getJDBCDriver();
            String user = aServerConfig.getUser();
            String password = aServerConfig.getPassword();
            DBConnectionPool.createInstance(url, jdbcDriver, user, password, aServerConfig.getTransientDatabaseURL(), aServerConfig.getTransientJDBCDriver(), aServerConfig.getTransientUser(), aServerConfig.getTransientPassword(), aServerConfig.getTransientMaxSendOrders(), aServerConfig.getTransientMaxMessageSpace(), aServerConfig.getInitialDBConnections());
            if (aServerConfig.getCreateMsgSvrTables()) {
                String transientURL;
                String persistentURL = aServerConfig.getDatabaseURL();
                CreateMsgServerTables msgTables = new CreateMsgServerTables();
                if (persistentURL != null) {
                    msgTables.createTables(jdbcDriver, url, user, password, aServerConfig.getSchema());
                }
                if ((transientURL = aServerConfig.getTransientDatabaseURL()) != null && !transientURL.startsWith(TRANSIENT_PACKAGE_PREFIX)) {
                    msgTables = new CreateMsgServerTables();
                    msgTables.createTables(aServerConfig.getTransientJDBCDriver(), transientURL, aServerConfig.getTransientUser(), aServerConfig.getTransientPassword(), aServerConfig.getSchema());
                }
                if (transientURL == null && persistentURL == null) {
                    throw new Exception("Database URL not specified");
                }
            }
            MessageCache.createInstance(aServerConfig.getMessageCacheSize());
            FreeLists.createInstance(this.mMaxSendOrderQueueSize + 10);
            SyncReceiveHandler.createInstance(this);
            dbConnection = DBConnectionPool.useConnection();
            this.checkMsgServerTablesVersion(dbConnection);
            ConsumerList.createInstance(dbConnection);
            ConsumerList.setVerbose(JmsService.getVerboseConsumer());
            DestinationList.createInstance(dbConnection);
            this.initTimeStamps();
        }
        catch (Exception ex) {
            try {
                if (JmsService.getVerboseTraceback()) {
                    JmsService.logException(ex);
                }
                throw new ServiceException(this, ex.toString());
            }
            catch (Throwable throwable) {
                DBConnectionPool.returnConnection(dbConnection);
                throw throwable;
            }
        }
        DBConnectionPool.returnConnection(dbConnection);
        this.recover();
        this.startWorkingThreads(aServerConfig);
        this.createObjects(aServerConfig);
        this.mDisplayTime = aServerConfig.getDisplayServerTime();
        this.setDisplayTime(this.mDisplayTime);
    }

    private void checkMsgServerTablesVersion(UserConnection dbConnection) throws Exception {
        if (DBConnectionPool.connectedToSAPDB(2)) {
            DeliveryPreparedStmt stmt = dbConnection.getPersistentPreparedStmt(76);
            DeliveryResultSet result = stmt.executeQuery();
            while (result.next()) {
                String tabName = result.getString(1);
                String version = result.getString(2);
                if (version.equalsIgnoreCase(Server.getVersion())) continue;
                result.close();
                throw new Exception("Wrong version of message server table: " + tabName);
            }
            result.close();
        }
    }

    public void close() throws ServiceException {
        if (this.mDebugOutputThread != null) {
            this.mDebugOutputThread.pleaseStop();
        }
        this.stopAgentsAndThreads();
        try {
            while (this.isOneOfMyThreadsAlive()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {}
            }
            Server.log("destroy JmsOutputManager");
            JmsOutputManager.destroyInstance();
            Server.log("destroy ConsumerList");
            ConsumerList.destroyInstance();
            Server.log("destroy FreeLists");
            FreeLists.destroyInstance();
            Server.log("destroy DestinationList");
            DestinationList.destroyInstance();
            Server.log("destroy SyncReceiveHandler");
            SyncReceiveHandler.destroyInstance();
            Server.log("destroy DBConnectionPool");
            DBConnectionPool.destroyInstance();
        }
        catch (SQLException ex) {
            Server.log(ex, JmsService.getVerboseTraceback());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serve(InputStream in, OutputStream out) throws IOException {
        ReceiveStream fromClient = new ReceiveStream(in, 2048);
        ConnectionTransfer connect = new ConnectionTransfer(fromClient);
        StreamString clientID = new StreamString(connect.getClientID());
        SendStream toClient = connect.getSendStream(out);
        JmsOutputManager.addNotificationChannel(clientID, new NotificationChannel(toClient, clientID, connect.getUser(), connect.getPassword(), this.mSendingQueue, this.mSendingCounter));
        connect = null;
        try {
            boolean doReceive = true;
            while (doReceive) {
                try {
                    Notification notification = Notification.getFromClient(fromClient);
                    Object queue = null;
                    ErrorNotification answer = null;
                    String serverQueue = notification.getServerQueue();
                    queue = serverQueue.equals(ADMIN_QUEUE) ? this.mAdminQueue : (serverQueue.equals(ACKNOWLEDGE_QUEUE) ? this.mAcknowledgeQueue : (serverQueue.equals(RECEIVING_QUEUE) ? this.mReceivingQueue : (serverQueue.equals(PERSIST_QUEUE) ? null : (NotificationQueue)this.mNotificationQueues.get(serverQueue))));
                    if (queue != null) {
                        ((NotificationQueue)queue).push(notification);
                        continue;
                    }
                    answer = new ErrorNotification("No server queue <" + notification.getServerQueue() + "> available!");
                    answer.setClientSessionAddress(notification.getClientSessionAddress());
                    JmsOutputManager.send(answer);
                }
                catch (Exception ex) {
                    if (!(ex instanceof EOFException)) {
                        Server.log("Terminating Message service for client " + clientID + " reason: " + ex);
                    }
                    if (JmsService.getVerboseSendReceive() || !(ex instanceof EOFException) && !(ex instanceof SocketException)) {
                        JmsService.logException(ex);
                    }
                    ConsumerList.tryUnregisterActiveConsumers(clientID, this);
                    doReceive = false;
                }
            }
        }
        finally {
            JmsOutputManager.removeNotificationChannel(clientID);
        }
        try {
            fromClient.close();
            toClient.close();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public Notification doAdminCommand(AdminNotification command) throws ServiceException {
        Agent admin = this.getAgent(ADMIN_QUEUE);
        if (admin == null) {
            throw new ServiceException(this, "No AdminAgent available");
        }
        Notification answer = null;
        try {
            answer = admin.doCommand(command);
        }
        catch (Exception ex) {
            throw new ServiceException(this, ex.toString());
        }
        return answer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String doCommand(String aServiceCommand) throws ServiceException {
        Notification answer = new ErrorNotification("No valid command:" + aServiceCommand);
        boolean isQueue = false;
        int type = -1;
        String name = null;
        String[] tokens = new String[20];
        StringTokenizer st = new StringTokenizer(aServiceCommand);
        String command = this.nextToken(st, "Empty command!");
        Server.log("Handle Service Command: " + aServiceCommand);
        if (command.equalsIgnoreCase("help")) {
            return "Message Server:" + Server.lineSep + "\tset garbage collector <time>  //in seconds" + Server.lineSep + "\tset " + "DisplayServerStateInSec".toUpperCase() + " <time> //in seconds" + Server.lineSep + "Destination Handling:" + Server.lineSep + "\tlist|ls  topics|queues | <name>|%" + Server.lineSep + "\tcreate|drop  topic|queue     <name>  [[<read password>] [,<write password>] ...] " + Server.lineSep + "\tsendordercount  topic|queue  <name>" + Server.lineSep + "\tlist|ls subscription topic|queue  <name>" + Server.lineSep + "\tregister consumer <DestinationName> <clientID> <queueID> <listenerID> <subscription> <(non)durable>" + Server.lineSep + "\tunregister consumer <consumerID> <(non)durable>" + Server.lineSep + "\tunsusbscribe consumer <consumerID>" + Server.lineSep + "\tresetsendorder <messageID> <consumerID> <isqueue true|false> <isdurable true|false>" + Server.lineSep + "Debug Options:" + Server.lineSep + "\tset verbose level " + Server.lineSep + "\t\t" + "VerboseAdmin".toUpperCase() + "" + Server.lineSep + "\t\t" + "VerboseConsumer".toUpperCase() + "" + Server.lineSep + "\t\t" + "VerboseException".toUpperCase() + "" + Server.lineSep + "\t\t" + "VerboseMessageBuilder".toUpperCase() + "" + Server.lineSep + "\t\t" + "VerboseSendingQueues".toUpperCase() + "" + Server.lineSep + "\t\t" + "VerboseSendOrderStat".toUpperCase() + "" + Server.lineSep + "\t\t" + "VerboseSendReceive".toUpperCase() + "" + Server.lineSep + "\t\t" + "VerboseSQLConnection".toUpperCase() + "" + Server.lineSep + "\t\t" + "VerboseTraceBack".toUpperCase() + "" + Server.lineSep + "\t\t" + "VerboseWait".toUpperCase() + "" + Server.lineSep + "\t\t<0|1>" + Server.lineSep + "\tget debug options" + Server.lineSep;
        }
        if (command.equalsIgnoreCase("status")) {
            boolean debugState = false;
            String tmpState = this.getStatus();
            Vector<String> tV = new Vector<String>();
            if (st.hasMoreTokens()) {
                String tmpToken = st.nextToken();
                if (!tmpToken.toLowerCase().endsWith("debug")) throw new ServiceException(this, "Unknown argument <" + tmpToken + "> for <" + command + ">");
                debugState = true;
            }
            if (debugState) {
                String logBuffer = "================================ D E B U G - O U T P U T ================================" + Server.lineSep;
                logBuffer = logBuffer + "--------------- Sendorder ---------------------------------------" + Server.lineSep;
                VectorNotification not = null;
                AdminAgent admin = (AdminAgent)this.getAgent(ADMIN_QUEUE);
                if (admin != null) {
                    try {
                        int i;
                        Vector dests = DestinationList.listDestinations(false, "%");
                        for (i = 0; i < dests.size(); ++i) {
                            not = admin.getSendorderCount(dests.get(i).toString(), false);
                            logBuffer = logBuffer + "Sendorder Count for TOPIC: " + dests.get(i).toString() + Server.lineSep;
                            logBuffer = logBuffer + not.toString() + Server.lineSep;
                        }
                        dests = DestinationList.listDestinations(true, "%");
                        for (i = 0; i < dests.size(); ++i) {
                            not = admin.getSendorderCount(dests.get(i).toString(), true);
                            logBuffer = logBuffer + "Sendorder Count for QUEUE: " + dests.get(i).toString() + Server.lineSep;
                            logBuffer = logBuffer + not.toString() + Server.lineSep;
                        }
                    }
                    catch (AdminException e) {
                        throw new ServiceException(this, e.toString());
                    }
                }
                logBuffer = logBuffer + "--------------- Server Status ---------------------------------------" + Server.lineSep;
                logBuffer = logBuffer + tmpState + Server.lineSep;
                logBuffer = logBuffer + "================================ D E B U G - E N D ================================" + Server.lineSep;
                Server.log(logBuffer);
                tV.add(logBuffer);
            } else {
                tV.add(tmpState);
            }
            answer = new VectorNotification(tV);
            return answer.toString();
        }
        if (command.equalsIgnoreCase("get")) {
            String which = this.nextToken(st, "Missing argument for <" + command + ">");
            if (!which.toLowerCase().endsWith("debug")) return answer.toString();
            String tmp = this.nextToken(st, "Missing keyword 'options'");
            if (!tmp.equalsIgnoreCase("options")) {
                throw new ServiceException(this, "Unknown argument <" + tmp + "> for <" + command + ">");
            }
            Vector opts = this.getDebugOptions();
            answer = new VectorNotification(opts);
            return answer.toString();
        } else if (command.equalsIgnoreCase("set")) {
            type = -1;
            String which = this.nextToken(st, "Missing argument for <" + command + ">");
            if (which.toLowerCase().endsWith("verbose")) {
                String tmp = this.nextToken(st, "Missing keyword 'level'");
                if (!tmp.equalsIgnoreCase("level")) {
                    throw new ServiceException(this, "Unknown argument <" + tmp + "> for <" + command + ">");
                }
                tokens[0] = this.nextToken(st, "Missing " + which + " level");
                try {
                    tokens[1] = this.nextToken(st, "Missing 1. argument (destination) behind <" + command + " " + which + ">");
                    boolean verboseLevelValue = false;
                    if (tokens[1].equalsIgnoreCase("1")) {
                        verboseLevelValue = true;
                    }
                    this.setVerboseLevel(tokens[0], verboseLevelValue);
                    answer = FreeLists.getOkNotification();
                    return answer.toString();
                }
                catch (AdminException ex) {
                    throw new ServiceException(this, ex.toString());
                }
            } else if (which.toLowerCase().endsWith("DisplayServerStateInSec".toLowerCase())) {
                try {
                    tokens[1] = this.nextToken(st, "Missing 1. argument behind <" + command + " " + which + ">");
                    long value = Long.parseLong(tokens[1]);
                    this.setDisplayTime(value * 1000L);
                    answer = FreeLists.getOkNotification();
                    return answer.toString();
                }
                catch (Exception ex) {
                    throw new ServiceException(this, ex.toString());
                }
            } else {
                if (!which.toLowerCase().endsWith("garbage")) throw new ServiceException(this, "Unknown argument <" + which + "> for <" + command + ">");
                String tmp = this.nextToken(st, "Missing keyword 'collector'");
                if (!tmp.equalsIgnoreCase("collector")) {
                    throw new ServiceException(this, "Unknown argument <" + tmp + "> for <" + command + ">");
                }
                tokens[0] = this.nextToken(st, "Missing " + which + " collector");
                try {
                    long value = Long.parseLong(tokens[0]);
                    this.setGarbageCollector(value);
                    answer = FreeLists.getOkNotification();
                    return answer.toString();
                }
                catch (Exception ex) {
                    throw new ServiceException(this, ex.toString());
                }
            }
        } else if (command.equalsIgnoreCase("ls") || command.equalsIgnoreCase("list")) {
            type = -1;
            String which = this.nextToken(st, "Missing argument for <" + command + ">");
            if (which.toLowerCase().endsWith("topics")) {
                type = 0;
                name = st.hasMoreTokens() ? this.nextToken(st, "") : "%";
                isQueue = false;
            } else if (which.toLowerCase().endsWith("queues")) {
                type = 0;
                name = st.hasMoreTokens() ? this.nextToken(st, "") : "%";
                isQueue = true;
            } else {
                if (!which.toLowerCase().endsWith("subscription")) throw new ServiceException(this, "Unknown argument <" + which + "> for <" + command + ">");
                type = 1;
                String tmp = this.nextToken(st, "Missing " + which + " queue/topic");
                if (tmp.equalsIgnoreCase("queue")) {
                    isQueue = true;
                } else {
                    if (!tmp.equalsIgnoreCase("topic")) throw new ServiceException(this, "Unknown argument <" + tmp + "> for <" + command + ">");
                    isQueue = false;
                }
                name = this.nextToken(st, "Missing " + which + " name");
            }
            ListDestAdminNotification aCommand = new ListDestAdminNotification(type, isQueue, name);
            answer = this.doAdminCommand(aCommand);
            return answer.toString();
        } else if (command.equalsIgnoreCase("sendordercount")) {
            String which = this.nextToken(st, "Missing argument for <" + command + ">");
            if (which.toLowerCase().endsWith("topic")) {
                name = this.nextToken(st, "Missing " + which + " name");
                isQueue = false;
            } else {
                if (!which.toLowerCase().endsWith("queue")) throw new ServiceException(this, "Unknown argument <" + which + "> for <" + command + ">");
                name = this.nextToken(st, "Missing " + which + " name");
                isQueue = true;
            }
            type = 2;
            DestinationAdminNotification aCommand = new DestinationAdminNotification(type, isQueue, false, name);
            answer = this.doAdminCommand(aCommand);
            return answer.toString();
        } else if (command.equalsIgnoreCase("create") || command.equalsIgnoreCase("drop")) {
            String which = this.nextToken(st, "Missing argument for <" + command + ">");
            if (which.toLowerCase().endsWith("topic")) {
                name = this.nextToken(st, "Missing " + which + " name");
                isQueue = false;
            } else {
                if (!which.toLowerCase().endsWith("queue")) throw new ServiceException(this, "Unknown argument <" + which + "> for <" + command + ">");
                name = this.nextToken(st, "Missing " + which + " name");
                isQueue = true;
            }
            if (command.equalsIgnoreCase("create")) {
                type = 0;
            }
            if (command.equalsIgnoreCase("drop")) {
                type = 1;
            }
            DestinationAdminNotification aCommand = new DestinationAdminNotification(type, isQueue, false, name);
            String passwords = "";
            if (st.hasMoreTokens()) {
                passwords = this.nextToken(st, "Missing password for " + command);
                StringTokenizer stAuth = new StringTokenizer(passwords, ",");
                while (stAuth.hasMoreTokens()) {
                    aCommand.setDestinationAuth(new DestinationAuth("", stAuth.nextToken(), true));
                    if (!stAuth.hasMoreTokens()) continue;
                    aCommand.setDestinationAuth(new DestinationAuth("", stAuth.nextToken(), false));
                }
            }
            answer = this.doAdminCommand(aCommand);
            return answer.toString();
        } else {
            if (command.equalsIgnoreCase("register")) {
                String which = this.nextToken(st, "Missing argument for <" + command + ">");
                if (!which.toLowerCase().endsWith("topicsubscriber") && !which.toLowerCase().endsWith("queuereceiver")) throw new ServiceException(this, "Unknown argument <" + which + "> for <" + command + ">");
                tokens[2] = this.nextToken(st, "Missing 1. argument (destination) behind <" + command + " " + which + ">");
                tokens[3] = this.nextToken(st, "Missing 2. argument (clientID) behind <" + command + " " + which + ">");
                tokens[4] = this.nextToken(st, "Missing 3. argument (queueID) behind <" + command + " " + which + ">");
                tokens[5] = this.nextToken(st, "Missing 4. argument (listenerID) behind <" + command + " " + which + ">");
                tokens[6] = this.nextToken(st, "Missing 5. argument (non/durable:subscription) behind <" + command + " " + which + ">");
                if (!st.hasMoreTokens()) return answer.toString();
                tokens[7] = this.nextToken(st, "");
                throw new ServiceException(this, "Unknown argument <" + tokens[7] + "> for <" + command + ">");
            }
            if (command.equalsIgnoreCase("unregister")) {
                long consumerID = -1L;
                String which = this.nextToken(st, "Missing argument for <" + command + ">");
                if (!which.toLowerCase().endsWith("consumer") && !which.toLowerCase().endsWith("queuereceiver")) throw new ServiceException(this, "Unknown argument <" + which + "> for <" + command + ">");
                tokens[2] = this.nextToken(st, "Missing 1. argument <consumerID> behind <" + command + " " + which + ">");
                consumerID = Long.parseLong(tokens[2].toString());
                tokens[3] = this.nextToken(st, "Missing 2. argument (non/durable) behind <" + command + " " + which + ">");
                if (st.hasMoreTokens()) {
                    tokens[4] = this.nextToken(st, "");
                    throw new ServiceException(this, "Unknown argument <" + tokens[3] + "> for <" + command + ">");
                }
                boolean remove = false;
                if (tokens[3].equalsIgnoreCase("nondurable")) {
                    remove = true;
                }
                DeactivateAdminNotification aCommand = new DeactivateAdminNotification(0, "", remove, consumerID);
                answer = this.doAdminCommand(aCommand);
                return answer.toString();
            } else if (command.equalsIgnoreCase("unsubscribe")) {
                long consumerID = -1L;
                String which = this.nextToken(st, "Missing argument for <" + command + ">");
                if (!which.toLowerCase().endsWith("consumer") && !which.toLowerCase().endsWith("queuereceiver")) throw new ServiceException(this, "Unknown argument <" + which + "> for <" + command + ">");
                tokens[2] = this.nextToken(st, "Missing 1. argument <consumerID> behind <" + command + " " + which + ">");
                consumerID = Long.parseLong(tokens[2].toString());
                if (st.hasMoreTokens()) {
                    tokens[3] = this.nextToken(st, "");
                    throw new ServiceException(this, "Unknown argument <" + tokens[3] + "> for <" + command + ">");
                }
                DeactivateAdminNotification aCommand = new DeactivateAdminNotification(1, "", true, consumerID);
                answer = this.doAdminCommand(aCommand);
                return answer.toString();
            } else {
                if (!command.equalsIgnoreCase("resetsendorder")) throw new ServiceException(this, "Unknown command <" + command + ">");
                String messageID = this.nextToken(st, "Missing MessageID argument for <resetsendorder>");
                String consumerID = this.nextToken(st, "Missing ConsumerID argument for <resetsendorder>");
                String isQueueOrder = this.nextToken(st, "Missing isQueueOrder argument for <resetsendorder>");
                String isDurable = this.nextToken(st, "Missing isDurable argument for <resetsendorder>");
                ResetAdminNotification aCommand = new ResetAdminNotification(Long.parseLong(messageID), Long.parseLong(consumerID), Boolean.valueOf(isQueueOrder), Boolean.valueOf(isDurable));
                answer = this.doAdminCommand(aCommand);
            }
        }
        return answer.toString();
    }

    private void writeStatusToLog() {
        Server.log(this.getStatus());
    }

    private String getStatus() {
        String status = "";
        if (this.mSendOrderPollingPersistent != null || this.mSendOrderPollingTransient != null) {
            System.gc();
            status = "- Server status ----------------------------------------" + Server.lineSep;
            Runtime runTimeRef = Runtime.getRuntime();
            long usedBytes = runTimeRef.totalMemory() - runTimeRef.freeMemory();
            long usedKB = usedBytes / 1024L;
            long usedMB = usedKB / 1024L;
            status = status + "    Memory:             " + usedMB + " MB  (" + usedKB + " KB, " + usedBytes + " bytes)" + Server.lineSep;
            if (this.mSendOrderPollingPersistent != null) {
                status = status + "    SendOrderPolling:   persistent = " + this.mSendOrderPollingPersistent.getPreviousNumberOfOrdersSent() + Server.lineSep;
            }
            if (this.mSendOrderPollingTransient != null) {
                status = status + "    SendOrderPolling:   transient  = " + this.mSendOrderPollingTransient.getPreviousNumberOfOrdersSent() + Server.lineSep;
            }
            status = status + "    AcknowledgeQueue:   size = " + this.mAcknowledgeQueue.getQueueSize() + Server.lineSep;
            status = status + "    ReceivingQueue:     size = " + this.mReceivingQueue.getQueueSize() + Server.lineSep;
            status = status + "    SendingQueue:       size = " + this.mSendingCounter.used() + "/" + this.mMaxSendOrderQueueSize + Server.lineSep;
            status = status + "    Message to build:   size = " + this.mSendingQueue.getMessagesToBuild() + Server.lineSep;
            status = status + "    Message to send:    size = " + this.mSendingQueue.getMessagesToSend() + Server.lineSep;
            status = status + "    AdminQueue:         size = " + this.mAdminQueue.getQueueSize() + Server.lineSep;
            status = status + "    Active Consumers:   size = " + ConsumerList.getNumberOfActiveConsumers() + Server.lineSep;
            status = status + "    Inactive Consumers: size = " + ConsumerList.getNumberOfInActiveConsumers() + Server.lineSep;
            status = status + MessageCache.printStatistics();
            status = status + MessageTable.printMemoryUsedSpace();
            status = status + "--------------- Threads ---------------------------------------" + Server.lineSep;
            status = status + this.getStatusForAllThreads();
            status = status + "--------------------------------------------------------------------------";
        }
        return status;
    }

    private String getStatusForAllThreads() {
        String status = "";
        for (int i = 0; i < this.mThreads.size(); ++i) {
            JmsThread currThread = (JmsThread)this.mThreads.elementAt(i);
            status = status + this.getThreadStatus(currThread) + Server.lineSep;
        }
        JmsThread[] tempThreads = JmsThread.getTemporaryThreads();
        for (int i = 0; i < tempThreads.length; ++i) {
            status = status + this.getThreadStatus(tempThreads[i]) + Server.lineSep;
        }
        return status;
    }

    private String getThreadStatus(JmsThread thread) {
        long waitCount = thread.getWaitCount();
        long processedNotifications = thread.getNotificationCount();
        String msg = "    " + thread.getName() + ": ";
        if (processedNotifications > 0L) {
            msg = msg + processedNotifications + " notifications; ";
        }
        if (waitCount > 0L) {
            msg = msg + (waitCount == 1L ? "1 wait call; " : waitCount + " wait calls; ");
        }
        return msg + thread.getAction();
    }

    private void startWorkingThreads(ServerConfig aConfig) throws ServiceException {
        int i;
        int i2;
        Agent agent = null;
        JmsOutputManager.createInstance();
        this.mAdminQueue = new ListNotificationQueue(ADMIN_QUEUE);
        agent = new AdminAgent(this, this.mAdminQueue);
        agent.start();
        this.mThreads.add(agent);
        int agentCount = aConfig.getAgents();
        if (agentCount < 1) {
            agentCount = 1;
        }
        this.mAcknowledgeQueue = new ListNotificationQueue(ACKNOWLEDGE_QUEUE);
        for (i2 = 0; i2 < agentCount; ++i2) {
            agent = new AcknowledgeAgent(this, this.mAcknowledgeQueue);
            agent.start();
            this.mThreads.add(agent);
        }
        this.mReceivingQueue = new ListNotificationQueue(RECEIVING_QUEUE);
        for (i2 = 0; i2 < agentCount; ++i2) {
            agent = new ReceivingAgent(this, this.mReceivingQueue);
            agent.start();
            this.mThreads.add(agent);
        }
        int sendQueueInsertLimit = this.mMaxSendOrderQueueSize / 2;
        int pollingFetchSize = this.mMaxSendOrderQueueSize / 2;
        this.mSendingQueue = new SendingNotificationQueue();
        this.mSendingCounter = new SendingNotificationCounter(sendQueueInsertLimit);
        this.mSendingQueue.setVerbose(JmsService.getVerboseSendingQueues());
        for (i = 0; i < 2 * agentCount; ++i) {
            MessageBuilder msgBuilder = new MessageBuilder(this);
            msgBuilder.start();
            this.mThreads.add(msgBuilder);
        }
        for (i = 0; i < agentCount; ++i) {
            SocketWriter aSW = new SocketWriter(this);
            aSW.start();
            this.mThreads.add(aSW);
        }
        if (DBConnectionPool.existsPersistentConnection()) {
            this.mSendOrderPollingPersistent = new SendOrderPolling(this, this.mSendingQueue, this.mSendingCounter, 2, aConfig.getSendOrderPollingInMilliSec(), pollingFetchSize, aConfig.getPushSizeForSendOrderQueue(), aConfig.getClientTimeOutInSec());
            this.mSendOrderPollingPersistent.start();
            this.mThreads.add(this.mSendOrderPollingPersistent);
        }
        if (DBConnectionPool.existsTransientConnection()) {
            int pushSize = aConfig.getTransientPushSizeForSendOrderQueue();
            if (pushSize <= 0) {
                pushSize = aConfig.getPushSizeForSendOrderQueue();
            }
            this.mSendOrderPollingTransient = new SendOrderPolling(this, this.mSendingQueue, this.mSendingCounter, 1, aConfig.getSendOrderPollingInMilliSec(), pollingFetchSize, pushSize, aConfig.getClientTimeOutInSec());
            this.mSendOrderPollingTransient.start();
            this.mThreads.add(this.mSendOrderPollingTransient);
        }
        this.setGarbageCollector(aConfig.getGarbageCollectingTimeInSec());
    }

    private void stopAgentsAndThreads() throws ServiceException {
        for (int i = 0; i < this.mThreads.size(); ++i) {
            ((JmsThread)this.mThreads.elementAt(i)).pleaseStop();
        }
    }

    private boolean isOneOfMyThreadsAlive() throws ServiceException {
        for (int i = 0; i < this.mThreads.size(); ++i) {
            if (!((JmsThread)this.mThreads.elementAt(i)).isAlive()) continue;
            return true;
        }
        return false;
    }

    private void createObjects(ServerConfig aConfig) throws ServiceException {
        try {
            Serializable object = new TopicConnectionFactoryImpl();
            JndiService.rebind("jms.TopicConnectionFactory", object);
            object = new QueueConnectionFactoryImpl();
            JndiService.rebind("jms.QueueConnectionFactory", object);
            String topicName = null;
            topicName = aConfig.getFirstTopicName();
            String passWords = "";
            while (topicName != null && topicName.length() > 0) {
                passWords = "";
                StringTokenizer st = new StringTokenizer(topicName, " ");
                if (st.hasMoreTokens()) {
                    topicName = st.nextToken();
                }
                while (st.hasMoreTokens()) {
                    passWords = passWords + st.nextToken();
                }
                DestinationAdminNotification aCommand = new DestinationAdminNotification(0, false, false, topicName);
                StringTokenizer stAuth = new StringTokenizer(passWords, ",");
                while (stAuth.hasMoreTokens()) {
                    aCommand.setDestinationAuth(new DestinationAuth("", stAuth.nextToken(), true));
                    if (!stAuth.hasMoreTokens()) continue;
                    aCommand.setDestinationAuth(new DestinationAuth("", stAuth.nextToken(), false));
                }
                Notification answer = this.doAdminCommand(aCommand);
                if (answer instanceof ErrorNotification && !(((ErrorNotification)answer).getException() instanceof DestinationAlreadyExistsException)) {
                    throw new ServiceException(this, ((ErrorNotification)answer).getErrorMessage());
                }
                topicName = aConfig.getNextTopicName();
            }
            String queueName = null;
            queueName = aConfig.getFirstQueueName();
            while (queueName != null && queueName.length() > 0) {
                passWords = "";
                StringTokenizer st = new StringTokenizer(queueName, " ");
                if (st.hasMoreTokens()) {
                    queueName = st.nextToken();
                }
                while (st.hasMoreTokens()) {
                    passWords = passWords + st.nextToken();
                }
                DestinationAdminNotification aCommand = new DestinationAdminNotification(0, true, false, queueName);
                StringTokenizer stAuth = new StringTokenizer(passWords, ",");
                while (stAuth.hasMoreTokens()) {
                    aCommand.setDestinationAuth(new DestinationAuth("", stAuth.nextToken(), true));
                    if (!stAuth.hasMoreTokens()) continue;
                    aCommand.setDestinationAuth(new DestinationAuth("", stAuth.nextToken(), false));
                }
                Notification answer = this.doAdminCommand(aCommand);
                if (answer instanceof ErrorNotification && !(((ErrorNotification)answer).getException() instanceof DestinationAlreadyExistsException)) {
                    throw new ServiceException(this, ((ErrorNotification)answer).getErrorMessage());
                }
                queueName = aConfig.getNextQueueName();
            }
        }
        catch (NamingException ex) {
            throw new ServiceException(this, ex.toString());
        }
    }

    private void recover() throws ServiceException {
        UserConnection dbConnection = null;
        try {
            dbConnection = DBConnectionPool.useConnection();
            Server.log("JMS Service: recover consumer list ...");
            ConsumerList.recover(dbConnection);
            Server.log("JMS Service: recover send orders ...");
            SendOrderTable.recover(dbConnection, 2);
            SendOrderTable.recover(dbConnection, 1);
            Server.log("JMS Service: delete messages without send orders ...");
            MessageTable.deleteAllMessagesWithoutSendOrder(dbConnection);
            dbConnection.commit();
        }
        catch (SQLException ex) {
            throw new ServiceException(this, "Error during recovery: " + ex);
        }
        catch (InvalidSelectorException ex) {
            throw new ServiceException(this, "Error during recovery: " + (Object)((Object)ex));
        }
        finally {
            DBConnectionPool.returnConnection(dbConnection);
        }
    }

    public static long getTimeStamp() {
        return mDatabaseTimeStamp + System.currentTimeMillis() - mInitialTimeStamp;
    }

    public Vector getDebugOptions() {
        Vector<String> tmp = new Vector<String>();
        tmp.add("VerboseAdmin=" + s_verboseAdmin);
        tmp.add("VerboseConsumer=" + s_verboseConsumer);
        tmp.add("VerboseException=" + s_verboseException);
        tmp.add("VerboseMessageBuilder=" + s_verboseMessageBuilder);
        tmp.add("VerboseSendingQueues=" + s_verboseSendingQueues);
        tmp.add("VerboseSendOrderStat=" + s_verboseSendOrderStat);
        tmp.add("VerboseSendReceive=" + s_verboseSendReceive);
        tmp.add("VerboseSQLConnection=" + s_verboseSQLConnection);
        tmp.add("VerboseTraceBack=" + s_verboseTraceback);
        tmp.add("VerboseWait=" + s_verboseWait);
        tmp.add("DisplayServerStateInSec=" + this.mDisplayTime / 1000L);
        return tmp;
    }

    public void setDisplayTime(long displayTime) {
        this.mDisplayTime = displayTime;
        if (this.mDisplayTime < 1L) {
            if (this.mDebugOutputThread != null) {
                this.mDebugOutputThread.pleaseStop();
                this.mDebugOutputThread = null;
            }
        } else if (this.mDebugOutputThread == null) {
            this.mDebugOutputThread = new DebugOutputThread("DebugOutputThread");
            this.mDebugOutputThread.start();
        } else {
            this.mDebugOutputThread.interrupt();
        }
    }

    public void setVerboseLevel(String verboseLevelType, boolean verboseLevelValue) throws AdminException {
        if (verboseLevelType.equalsIgnoreCase("VerboseAdmin")) {
            s_verboseAdmin = verboseLevelValue;
        } else if (verboseLevelType.equalsIgnoreCase("VerboseConsumer")) {
            s_verboseConsumer = verboseLevelValue;
        } else if (verboseLevelType.equalsIgnoreCase("VerboseException")) {
            s_verboseException = verboseLevelValue;
        } else if (verboseLevelType.equalsIgnoreCase("VerboseMessageBuilder")) {
            s_verboseMessageBuilder = verboseLevelValue;
        } else if (verboseLevelType.equalsIgnoreCase("VerboseSendingQueues")) {
            s_verboseSendingQueues = verboseLevelValue;
            this.mSendingQueue.setVerbose(s_verboseSendingQueues);
        } else if (verboseLevelType.equalsIgnoreCase("VerboseSendOrderStat")) {
            s_verboseSendOrderStat = verboseLevelValue;
        } else if (verboseLevelType.equalsIgnoreCase("VerboseSendReceive")) {
            s_verboseSendReceive = verboseLevelValue;
        } else if (verboseLevelType.equalsIgnoreCase("VerboseSQLConnection")) {
            s_verboseSQLConnection = verboseLevelValue;
        } else if (verboseLevelType.equalsIgnoreCase("VerboseTraceBack")) {
            s_verboseTraceback = verboseLevelValue;
        } else if (verboseLevelType.equalsIgnoreCase("VerboseWait")) {
            s_verboseWait = verboseLevelValue;
        } else {
            throw new AdminException("Unknown level:" + verboseLevelType);
        }
    }

    public static boolean getVerboseAdmin() {
        return s_verboseAdmin;
    }

    public static boolean getVerboseSendReceive() {
        return s_verboseSendReceive;
    }

    public static boolean getVerboseConsumer() {
        return s_verboseConsumer;
    }

    public static boolean getVerboseSendingQueues() {
        return s_verboseSendingQueues;
    }

    public static boolean getVerboseMessageBuilder() {
        return s_verboseMessageBuilder;
    }

    public static boolean getVerboseSendOrderStat() {
        return s_verboseSendOrderStat;
    }

    public static boolean getVerboseSQLConnection() {
        return s_verboseSQLConnection;
    }

    public static boolean getVerboseException() {
        return s_verboseException;
    }

    public static boolean getVerboseTraceback() {
        return s_verboseTraceback;
    }

    public static boolean getVerboseWait() {
        return s_verboseWait;
    }

    public static void logException(Exception ex) {
        if (JmsService.getVerboseException()) {
            Server.log(ex, JmsService.getVerboseTraceback());
        }
    }

    private void initTimeStamps() throws SQLException {
        UserConnection connection = DBConnectionPool.useConnection();
        mInitialTimeStamp = System.currentTimeMillis();
        mDatabaseTimeStamp = DataBaseTime.getTimeStamp(connection);
        DBConnectionPool.returnConnection(connection);
    }

    private void setGarbageCollector(long garbageTime) throws ServiceException {
        if (garbageTime < 1L && this.mGarbageCollector != null) {
            this.mGarbageCollector.pleaseStop();
            this.mGarbageCollector = null;
        }
        if (garbageTime > 0L) {
            if (this.mGarbageCollector == null) {
                this.mGarbageCollector = new GarbageCollector(this, garbageTime);
                this.mGarbageCollector.start();
                this.mThreads.add(this.mGarbageCollector);
            } else {
                this.mGarbageCollector.setGarbageCollectingTime(garbageTime);
            }
        }
    }

    static {
        s_verboseAdmin = false;
        s_verboseConsumer = false;
        s_verboseException = false;
        s_verboseMessageBuilder = false;
        s_verboseSendingQueues = false;
        s_verboseSendOrderStat = false;
        s_verboseSendReceive = false;
        s_verboseSQLConnection = false;
        s_verboseTraceback = false;
        s_verboseWait = false;
    }

    private class DebugOutputThread
    extends Thread {
        boolean mStopFlag;

        public DebugOutputThread(String name) {
            super(name);
            this.mStopFlag = false;
            this.mStopFlag = false;
        }

        public void pleaseStop() {
            this.mStopFlag = true;
            this.interrupt();
        }

        public void run() {
            while (!this.mStopFlag) {
                JmsService.this.writeStatusToLog();
                try {
                    Thread.sleep(JmsService.this.mDisplayTime);
                }
                catch (Exception ex) {
                    Server.log("DebugOutputThread: " + ex.toString());
                }
            }
        }
    }
}

