/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.msgselector.parsing.builtinoperators;

import com.sap.sdb.msgServer.msgselector.parsing.AbstractTreeNode;
import com.sap.sdb.msgServer.msgselector.parsing.OperatorInfo;
import com.sap.sdb.msgServer.msgselector.parsing.Set;
import com.sap.sdb.msgServer.msgselector.parsing.Token;

public abstract class GeneralLikeOperatorTreeNode
extends AbstractTreeNode {
    protected static final char WILDCARD_ONE = '_';
    protected static final char WILDCARD_ANY = '%';
    protected static final int INT_WILDCARD_ONE = -2;
    protected static final int INT_WILDCARD_ANY = -3;
    protected int[] m_preprocessed_pattern = null;

    public GeneralLikeOperatorTreeNode(Token t) {
        super(t);
    }

    public abstract OperatorInfo getOperatorInfo();

    public int getEvaluationType(Set globCtx, boolean have_supplier) {
        return 8193;
    }

    public boolean canEvaluateForArgumentTypes(int[] argTypes, boolean parsetime) throws Exception {
        if (parsetime) {
            if (argTypes[0] == 8194) {
                throw new Exception("String literal not allowed as first operand.");
            }
            if ((argTypes[0] == -1 || argTypes[0] == 4096) && argTypes[1] == -1) {
                throw new Exception("String literal required as second operand.");
            }
            return argTypes.length == 2 && (argTypes[0] == -1 || argTypes[0] == 4096) && argTypes[1] == 8194;
        }
        return argTypes.length == 2;
    }

    protected abstract boolean invert(boolean var1);

    protected Object evaluateThisNode(Set globCtx, boolean have_supplier, boolean parsetime) throws Exception {
        Boolean retval = null;
        AbstractTreeNode op0 = this.getChildAt(0);
        if (op0 != null && op0.getEvaluationType(globCtx, have_supplier) != -1) {
            Object obj_value0 = op0.evaluate(globCtx, have_supplier, parsetime);
            if (!(obj_value0 instanceof String)) {
                retval = Boolean.FALSE;
            } else {
                AbstractTreeNode op1 = this.getChildAt(1);
                String value1 = (String)op1.evaluate(globCtx, have_supplier, parsetime);
                if ((String)obj_value0 != null) {
                    retval = new Boolean(this.invert(this.match_pattern((String)obj_value0, value1, null)));
                }
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean match_pattern(String matchee, String pattern, String escapechar) {
        boolean retval = false;
        int mlen = matchee.length();
        char[] mcbuf = new char[mlen];
        matchee.getChars(0, mlen, mcbuf, 0);
        GeneralLikeOperatorTreeNode generalLikeOperatorTreeNode = this;
        synchronized (generalLikeOperatorTreeNode) {
            if (this.m_preprocessed_pattern == null) {
                this.m_preprocessed_pattern = escapechar == null ? GeneralLikeOperatorTreeNode.preprocess_pattern(pattern) : GeneralLikeOperatorTreeNode.preprocess_pattern(pattern, escapechar.charAt(0));
            }
        }
        retval = GeneralLikeOperatorTreeNode.match_pattern_aux(mcbuf, this.m_preprocessed_pattern, 0, 0);
        return retval;
    }

    private static final int[] preprocess_pattern(String pattern) {
        int collapse = 0;
        int pclen = pattern.length();
        char[] pcbuf = new char[pclen];
        pattern.getChars(0, pclen, pcbuf, 0);
        for (int i = 0; i < pclen; ++i) {
            int k;
            if (pcbuf[i] != '%') continue;
            for (k = i + 1; k < pclen && pcbuf[k] == '%'; ++k) {
            }
            collapse += k - i - 1;
            i = k - 1;
        }
        int plen = pclen - collapse;
        int[] retval = new int[plen];
        int j = 0;
        for (int i = 0; i < pclen; ++i) {
            if (pcbuf[i] == '%') {
                int k;
                for (k = i + 1; k < pclen && pcbuf[k] == '%'; ++k) {
                }
                i = k - 1;
            }
            retval[j] = pcbuf[i] == '%' ? -3 : (pcbuf[i] == '_' ? -2 : pcbuf[i]);
            ++j;
        }
        return retval;
    }

    private static final int[] preprocess_pattern(String pattern, char escape) {
        int collapse = 0;
        int pclen = pattern.length();
        char[] pcbuf = new char[pclen];
        pattern.getChars(0, pclen, pcbuf, 0);
        for (int i = 0; i < pclen; ++i) {
            if (pcbuf[i] != escape || i + 1 == pclen) {
                int k;
                if (pcbuf[i] != '%') continue;
                for (k = i + 1; k < pclen && pcbuf[k] == '%'; ++k) {
                }
                collapse += k - i - 1;
                i = k - 1;
                continue;
            }
            if (pcbuf[i + 1] != '%' && pcbuf[i + 1] != '_') continue;
            ++i;
            ++collapse;
        }
        int plen = pclen - collapse;
        int[] retval = new int[plen];
        int j = 0;
        for (int i = 0; i < pclen; ++i) {
            if (pcbuf[i] != escape || i + 1 == pclen) {
                if (pcbuf[i] == '%') {
                    int k;
                    for (k = i + 1; k < pclen && pcbuf[k] == '%'; ++k) {
                    }
                    i = k - 1;
                }
                retval[j] = pcbuf[i] == '%' ? -3 : (pcbuf[i] == '_' ? -2 : pcbuf[i]);
                ++j;
                continue;
            }
            retval[j++] = pcbuf[i + 1] == '%' || pcbuf[i + 1] == '_' ? pcbuf[++i] : pcbuf[i];
        }
        return retval;
    }

    protected static final boolean match_pattern_aux(char[] matchee, int[] pattern, int midx, int pidx) {
        block3: {
            int p;
            do {
                if (pidx >= pattern.length) {
                    return midx >= matchee.length;
                }
                if ((p = pattern[pidx++]) == -3) {
                    return pidx >= pattern.length || GeneralLikeOperatorTreeNode.match_pattern_aux(matchee, pattern, midx, pidx) ? true : (midx < matchee.length ? GeneralLikeOperatorTreeNode.match_pattern_aux(matchee, pattern, ++midx, pidx - 1) : false);
                }
                if (midx >= matchee.length) break block3;
            } while (p == matchee[midx++] || p == -2);
            return false;
        }
        return false;
    }
}

