/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.msgselector.parsing.builtinoperators;

import com.sap.sdb.msgServer.msgselector.parsing.AbstractOperator;
import com.sap.sdb.msgServer.msgselector.parsing.AbstractTreeNode;
import com.sap.sdb.msgServer.msgselector.parsing.ContextProvidingTreeNode;
import com.sap.sdb.msgServer.msgselector.parsing.Iterator;
import com.sap.sdb.msgServer.msgselector.parsing.LanguageDefinition;
import com.sap.sdb.msgServer.msgselector.parsing.OperatorInfo;
import com.sap.sdb.msgServer.msgselector.parsing.Set;
import com.sap.sdb.msgServer.msgselector.parsing.Token;

public class Attribute
extends AbstractOperator {
    private String m_name = null;
    private OperatorInfo m_operatorInfo = null;
    private Iterator m_supplier = null;

    public Attribute(String name) {
        this.m_name = name;
        this.m_operatorInfo = new OperatorInfo(name, 0, 0, -1, true);
    }

    public OperatorInfo getOperatorInfo() {
        return this.m_operatorInfo;
    }

    public AbstractTreeNode getTreeNodeInstance(Token t) {
        return new AttributeOperatorTreeNode(t);
    }

    public class AttributeOperatorTreeNode
    extends AbstractTreeNode
    implements LanguageDefinition {
        public AttributeOperatorTreeNode(Token t) {
            super(t);
        }

        public int getEvaluationType(Set globCtx, boolean have_supplier) {
            if (have_supplier) {
                return globCtx.getDatatype().getAttributeType(Attribute.this.m_name);
            }
            if (Attribute.this.m_supplier == null) {
                Attribute.this.m_supplier = this.getSupplier();
            }
            return Attribute.this.m_supplier.getSet().getDatatype().getAttributeType(Attribute.this.m_name);
        }

        public boolean canEvaluateForArgumentTypes(int[] argTypes, boolean parsetime) {
            return argTypes.length == 0;
        }

        protected Object evaluateThisNode(Set globCtx, boolean have_supplier, boolean parsetime) throws Exception {
            Iterator supplier;
            if (have_supplier) {
                supplier = globCtx.getIterator();
                supplier.next();
            } else {
                if (Attribute.this.m_supplier == null) {
                    Attribute.this.m_supplier = this.getSupplier();
                }
                supplier = Attribute.this.m_supplier;
            }
            return supplier.getDataobject().getAttributeAsObject(Attribute.this.m_name);
        }

        private Iterator getSupplier() {
            for (AbstractTreeNode walk = this.getParent(); walk != null; walk = walk.getParent()) {
                Iterator it;
                if (!walk.isContext() || !(it = ((ContextProvidingTreeNode)walk).getContextIterator()).getSet().getDatatype().hasAttribute(Attribute.this.m_name)) continue;
                return it;
            }
            throw new RuntimeException("Unknown attribute '" + Attribute.this.m_name + "'");
        }

        public String toString() {
            return "[" + Attribute.this.m_name + "]";
        }
    }
}

