/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.msgselector.parsing;

import com.sap.sdb.msgServer.msgselector.parsing.TokenException;

public final class SQLTokenizer {
    public static final int SQLTT_NOTHING = -4;
    public static final int SQLTT_EOF = -1;
    public static final int SQLTT_FNUMBER = -2;
    public static final int SQLTT_INUMBER = -3;
    public static final int SQLTT_WORD = -5;
    public static final int SQLTT_STRLIT = -6;
    private static final int SQLTT_NUMERIC = -10;
    public double fnval;
    public long inval;
    public String sval;
    public int ttype;
    public int pos;
    private static final char SQL_CHR_QUOTE = '\'';
    private static final char SQL_CHR_LESSTHAN = '<';
    private static final char SQL_CHR_GREATERTHAN = '>';
    private static final char SQL_CHR_EQUAL = '=';
    private static final char SQL_CHR_OPENPAREN = '(';
    private static final char SQL_CHR_CLOSEPAREN = ')';
    private static final char SQL_CHR_COMMA = ',';
    private static final char SQL_CHR_PLUS = '+';
    private static final char SQL_CHR_MINUS = '-';
    private static final char SQL_CHR_TIMES = '*';
    private static final char SQL_CHR_DIV = '/';
    private static final char SQL_CHR_DECPT = '.';
    private static final char SQL_CHR_UEXP = 'E';
    private static final char SQL_CHR_LEXP = 'e';
    private static final char SQL_CHR_DIGIT_1 = '1';
    private static final char SQL_CHR_DIGIT_2 = '2';
    private static final char SQL_CHR_DIGIT_3 = '3';
    private static final char SQL_CHR_DIGIT_4 = '4';
    private static final char SQL_CHR_DIGIT_5 = '5';
    private static final char SQL_CHR_DIGIT_6 = '6';
    private static final char SQL_CHR_DIGIT_7 = '7';
    private static final char SQL_CHR_DIGIT_8 = '8';
    private static final char SQL_CHR_DIGIT_9 = '9';
    private static final char SQL_CHR_DIGIT_a = 'a';
    private static final char SQL_CHR_DIGIT_b = 'b';
    private static final char SQL_CHR_DIGIT_c = 'c';
    private static final char SQL_CHR_DIGIT_d = 'd';
    private static final char SQL_CHR_DIGIT_e = 'e';
    private static final char SQL_CHR_DIGIT_f = 'f';
    private static final char SQL_CHR_DIGIT_A = 'A';
    private static final char SQL_CHR_DIGIT_B = 'B';
    private static final char SQL_CHR_DIGIT_C = 'C';
    private static final char SQL_CHR_DIGIT_D = 'D';
    private static final char SQL_CHR_DIGIT_E = 'E';
    private static final char SQL_CHR_DIGIT_F = 'F';
    private static final char SQL_CHR_DIGIT_0 = '0';
    private static final char SQL_CHR_LFLOAT = 'f';
    private static final char SQL_CHR_UFLOAT = 'F';
    private static final char SQL_CHR_LDOUB = 'd';
    private static final char SQL_CHR_UDOUB = 'D';
    private static final char SQL_CHR_LLONG = 'l';
    private static final char SQL_CHR_ULONG = 'L';
    private static final char SQL_CHR_LEX = 'x';
    private static final char SQL_CHR_UEX = 'X';
    private static final String SQL_STR_DECPT = ".";
    private static final String SQL_STR_LFLOAT = "f";
    private static final String SQL_STR_UFLOAT = "F";
    private static final String SQL_STR_LDOUB = "d";
    private static final String SQL_STR_UDOUB = "D";
    private static final String SQL_STR_LLONG = "l";
    private static final String SQL_STR_ULONG = "L";
    private static final String SQL_STR_OCT = "0";
    private static final String SQL_STR_LHEX = "0x";
    private static final String SQL_STR_UHEX = "0X";
    private int m_len;
    private char[] m_buf;
    private int m_nextpos;

    private SQLTokenizer() {
    }

    public SQLTokenizer(char[] buf) {
        this.m_len = buf.length;
        this.m_buf = buf;
        this.m_nextpos = 0;
        this.fnval = 0.0;
        this.inval = 0L;
        this.sval = null;
        this.ttype = -4;
        this.pos = 0;
    }

    public int nextToken() throws SQLTokenizerException {
        int retval = -4;
        boolean identifier_start = true;
        boolean inside_hex_numeric = false;
        int state = -4;
        boolean string_literal_complete = false;
        StringBuffer tok = new StringBuffer("");
        this.fnval = 0.0;
        this.inval = 0L;
        this.sval = null;
        if (this.m_nextpos < this.m_len && Character.isWhitespace(this.m_buf[this.m_nextpos])) {
            ++this.m_nextpos;
            while (this.m_nextpos < this.m_len && Character.isWhitespace(this.m_buf[this.m_nextpos])) {
                ++this.m_nextpos;
            }
        }
        this.pos = this.m_nextpos + 1;
        if (this.m_nextpos >= this.m_len) {
            state = -1;
        } else {
            while (this.m_nextpos < this.m_len) {
                if (this.m_buf[this.m_nextpos] == '\'' && state == -4) {
                    state = -6;
                } else if (this.m_buf[this.m_nextpos] == '\'' && this.m_nextpos + 1 < this.m_len && state == -6 && this.m_buf[this.m_nextpos + 1] == '\'') {
                    ++this.m_nextpos;
                    tok.append('\'');
                } else {
                    if (this.m_buf[this.m_nextpos] == '\'' && state == -6) {
                        string_literal_complete = true;
                        ++this.m_nextpos;
                        break;
                    }
                    if (state == -6) {
                        tok.append(this.m_buf[this.m_nextpos]);
                    } else {
                        if (state == -5 && (Character.isWhitespace(this.m_buf[this.m_nextpos]) || this.m_buf[this.m_nextpos] == '\'' || this.m_buf[this.m_nextpos] == '<' || this.m_buf[this.m_nextpos] == '>' || this.m_buf[this.m_nextpos] == '=' || this.m_buf[this.m_nextpos] == '(' || this.m_buf[this.m_nextpos] == ')' || this.m_buf[this.m_nextpos] == '.' || this.m_buf[this.m_nextpos] == '+' || this.m_buf[this.m_nextpos] == '-' || this.m_buf[this.m_nextpos] == '*' || this.m_buf[this.m_nextpos] == '/') || state == -10 && this.m_buf[this.m_nextpos] != '1' && this.m_buf[this.m_nextpos] != '2' && this.m_buf[this.m_nextpos] != '3' && this.m_buf[this.m_nextpos] != '4' && this.m_buf[this.m_nextpos] != '5' && this.m_buf[this.m_nextpos] != '6' && this.m_buf[this.m_nextpos] != '7' && this.m_buf[this.m_nextpos] != '8' && this.m_buf[this.m_nextpos] != '9' && (this.m_buf[this.m_nextpos] != 'a' && this.m_buf[this.m_nextpos] != 'b' && this.m_buf[this.m_nextpos] != 'c' && this.m_buf[this.m_nextpos] != 'd' && this.m_buf[this.m_nextpos] != 'e' && this.m_buf[this.m_nextpos] != 'f' && this.m_buf[this.m_nextpos] != 'A' && this.m_buf[this.m_nextpos] != 'B' && this.m_buf[this.m_nextpos] != 'C' && this.m_buf[this.m_nextpos] != 'D' && this.m_buf[this.m_nextpos] != 'E' && this.m_buf[this.m_nextpos] != 'F' || !inside_hex_numeric) && this.m_buf[this.m_nextpos] != '0' && (this.m_buf[this.m_nextpos] != '+' && this.m_buf[this.m_nextpos] != '-' || this.m_buf[this.m_nextpos - 1] != 'e' && this.m_buf[this.m_nextpos - 1] != 'E') && this.m_buf[this.m_nextpos] != '.' && this.m_buf[this.m_nextpos] != 'e' && this.m_buf[this.m_nextpos] != 'E' && this.m_buf[this.m_nextpos] != 'f' && this.m_buf[this.m_nextpos] != 'F' && this.m_buf[this.m_nextpos] != 'd' && this.m_buf[this.m_nextpos] != 'D' && this.m_buf[this.m_nextpos] != 'l' && this.m_buf[this.m_nextpos] != 'L' && this.m_buf[this.m_nextpos] != 'x' && this.m_buf[this.m_nextpos] != 'X') break;
                        if (this.m_buf[this.m_nextpos] == '(' || this.m_buf[this.m_nextpos] == ')' || this.m_buf[this.m_nextpos] == ',') {
                            tok.append(this.m_buf[this.m_nextpos]);
                            state = this.m_buf[this.m_nextpos++];
                            break;
                        }
                        if (state == -4 && (this.m_buf[this.m_nextpos] == '=' || this.m_buf[this.m_nextpos] == '+' || this.m_buf[this.m_nextpos] == '-' || this.m_buf[this.m_nextpos] == '*' || this.m_buf[this.m_nextpos] == '/')) {
                            tok.append(this.m_buf[this.m_nextpos++]);
                            state = -5;
                            break;
                        }
                        if (this.m_buf[this.m_nextpos] == '<') {
                            tok.append(this.m_buf[this.m_nextpos]);
                            if (this.m_nextpos + 1 < this.m_len && (this.m_buf[this.m_nextpos + 1] == '=' || this.m_buf[this.m_nextpos + 1] == '>')) {
                                tok.append(this.m_buf[++this.m_nextpos]);
                            }
                            ++this.m_nextpos;
                            state = -5;
                            break;
                        }
                        if (this.m_buf[this.m_nextpos] == '>') {
                            tok.append(this.m_buf[this.m_nextpos]);
                            if (this.m_nextpos + 1 < this.m_len && this.m_buf[this.m_nextpos + 1] == '=') {
                                tok.append(this.m_buf[++this.m_nextpos]);
                            }
                            ++this.m_nextpos;
                            state = -5;
                            break;
                        }
                        if ((this.m_buf[this.m_nextpos] == '.' || this.m_buf[this.m_nextpos] == '0' || this.m_buf[this.m_nextpos] == '1' || this.m_buf[this.m_nextpos] == '2' || this.m_buf[this.m_nextpos] == '3' || this.m_buf[this.m_nextpos] == '4' || this.m_buf[this.m_nextpos] == '5' || this.m_buf[this.m_nextpos] == '6' || this.m_buf[this.m_nextpos] == '7' || this.m_buf[this.m_nextpos] == '8' || this.m_buf[this.m_nextpos] == '9') && state == -4) {
                            tok.append(this.m_buf[this.m_nextpos]);
                            state = -10;
                        } else if (state == -10) {
                            inside_hex_numeric = inside_hex_numeric || this.m_buf[this.m_nextpos] == 'x' || this.m_buf[this.m_nextpos] == 'X';
                            tok.append(this.m_buf[this.m_nextpos]);
                        } else {
                            if (!(identifier_start && Character.isJavaIdentifierStart(this.m_buf[this.m_nextpos]) || !identifier_start && Character.isJavaIdentifierPart(this.m_buf[this.m_nextpos]))) {
                                throw new SQLTokenizerException("Illegal character in identifier.", this.m_nextpos + 1);
                            }
                            tok.append(this.m_buf[this.m_nextpos]);
                            identifier_start = false;
                            state = -5;
                        }
                    }
                }
                ++this.m_nextpos;
            }
            if (this.m_nextpos == this.m_len && state == -6 && !string_literal_complete) {
                throw new SQLTokenizerException("String literal not delimited.", this.m_nextpos + 1);
            }
        }
        if (state != -4 && state != -1) {
            this.sval = tok.toString();
            if (state == -10) {
                try {
                    String trimmed = null;
                    if (this.sval.startsWith(SQL_STR_LHEX) || this.sval.startsWith(SQL_STR_UHEX)) {
                        trimmed = this.sval.endsWith(SQL_STR_LLONG) || this.sval.endsWith(SQL_STR_ULONG) ? this.sval.substring(2, this.sval.length() - 1) : this.sval.substring(2);
                        this.inval = Long.parseLong(trimmed, 16);
                        state = -3;
                    } else if (this.sval.indexOf(SQL_STR_DECPT) >= 0 || this.sval.indexOf(101) >= 0 || this.sval.indexOf(69) >= 0) {
                        trimmed = this.sval.endsWith(SQL_STR_LFLOAT) || this.sval.endsWith(SQL_STR_UFLOAT) || this.sval.endsWith(SQL_STR_LDOUB) || this.sval.endsWith(SQL_STR_UDOUB) ? this.sval.substring(0, this.sval.length() - 1) : this.sval;
                        if (this.sval.endsWith(SQL_STR_LFLOAT) || this.sval.endsWith(SQL_STR_UFLOAT)) {
                            Float.parseFloat(trimmed);
                        }
                        this.fnval = Double.parseDouble(trimmed);
                        state = -2;
                    } else if (this.sval.startsWith(SQL_STR_OCT) && this.sval.length() > 1) {
                        trimmed = this.sval.endsWith(SQL_STR_LLONG) || this.sval.endsWith(SQL_STR_ULONG) ? this.sval.substring(0, this.sval.length() - 1) : this.sval;
                        this.inval = Long.parseLong(trimmed, 8);
                        state = -3;
                    } else {
                        trimmed = this.sval.endsWith(SQL_STR_LLONG) || this.sval.endsWith(SQL_STR_ULONG) ? this.sval.substring(0, this.sval.length() - 1) : this.sval;
                        this.inval = Long.parseLong(trimmed);
                        state = -3;
                    }
                }
                catch (Exception e) {
                    this.fnval = 0.0;
                    this.inval = 0L;
                    this.sval = null;
                    throw new SQLTokenizerException("Illegal numeric format.", this.pos);
                }
            }
        }
        retval = state;
        this.ttype = state;
        return retval;
    }

    public static class SQLTokenizerException
    extends TokenException {
        public SQLTokenizerException(String msg, int pos) {
            super(msg, pos);
        }
    }
}

