/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.msgselector.parsing;

import com.sap.sdb.msgServer.msgselector.parsing.ContextProvidingTreeNode;
import com.sap.sdb.msgServer.msgselector.parsing.LanguageDefinition;
import com.sap.sdb.msgServer.msgselector.parsing.OperatorInfo;
import com.sap.sdb.msgServer.msgselector.parsing.Set;
import com.sap.sdb.msgServer.msgselector.parsing.Token;
import com.sap.sdb.msgServer.msgselector.parsing.TokenException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public abstract class AbstractTreeNode
implements LanguageDefinition {
    protected Vector m_vecChildren = new Vector();
    protected Token m_token = null;
    protected AbstractTreeNode m_parent = null;
    protected int[] m_childrenEvalCosts = null;

    public AbstractTreeNode() {
    }

    public AbstractTreeNode(Token t) {
        this.m_token = t;
    }

    public OperatorInfo getOperatorInfo() {
        return null;
    }

    public String toString() {
        return this.getOperatorInfo().getWord();
    }

    public int getEvaluationType() {
        return this.getEvaluationType(null, false);
    }

    public int getEvaluationType(Set globCtx) {
        return this.getEvaluationType(globCtx, true);
    }

    public abstract int getEvaluationType(Set var1, boolean var2);

    public abstract boolean canEvaluateForArgumentTypes(int[] var1, boolean var2) throws Exception;

    protected final Object evaluateThisNode() throws Exception {
        return this.evaluateThisNode(null, false, false);
    }

    protected final Object evaluateThisNode(Set globCtx) throws Exception {
        return this.evaluateThisNode(globCtx, true, false);
    }

    protected abstract Object evaluateThisNode(Set var1, boolean var2, boolean var3) throws Exception;

    public int getThisNodeCosts() {
        return 0;
    }

    public final int getCosts() {
        int len = this.getChildrenCount();
        int r = this.getThisNodeCosts();
        for (int i = 0; i < len; ++i) {
            r += this.getChildAt(i).getCosts();
        }
        return r;
    }

    protected final void prepare() {
        this.prepare(null, false, false);
    }

    protected void prepare(Set globCtx) {
        this.prepare(globCtx, true, false);
    }

    private void prepare(Set globCtx, boolean have_supplier, boolean parsetime) {
        boolean canEvaluate;
        int childrenCount = this.getChildrenCount();
        int[] argTypes = new int[childrenCount];
        for (int i = 0; i < argTypes.length; ++i) {
            argTypes[i] = this.getChildAt(i).getEvaluationType(globCtx, have_supplier);
        }
        String msg = parsetime ? "Parse time type Mismatch." : "Evaluation type mismatch.";
        try {
            canEvaluate = this.canEvaluateForArgumentTypes(argTypes, parsetime);
        }
        catch (Exception e) {
            throw new ExpressionEvaluationException(this, e.getMessage());
        }
        if (!canEvaluate) {
            throw new ExpressionEvaluationException(this, msg);
        }
        this.m_childrenEvalCosts = new int[childrenCount];
        for (int i = 0; i < childrenCount; ++i) {
            this.m_childrenEvalCosts[i] = this.getChildAt(i).getCosts();
        }
    }

    public final Object evaluate() throws Exception {
        return this.evaluate(null, false);
    }

    public Object evaluate(Set globCtx, boolean parsetime) throws Exception {
        return this.evaluate(globCtx, true, parsetime);
    }

    public Object evaluate(Set globCtx, boolean have_supplier, boolean parsetime) throws Exception {
        this.prepare(globCtx, have_supplier, parsetime);
        return this.evaluateThisNode(globCtx, have_supplier, parsetime);
    }

    public int getArgEvaluationCosts(int index) throws Exception {
        return this.m_childrenEvalCosts[index];
    }

    public void addChild(AbstractTreeNode n) {
        n.setParent(this);
        this.m_vecChildren.add(n);
    }

    public void addChildren(Collection c) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.addChild((AbstractTreeNode)it.next());
        }
    }

    public boolean isContext() {
        return false;
    }

    public ContextProvidingTreeNode getContext() {
        for (AbstractTreeNode walk = this.getParent(); walk != null; walk = walk.getParent()) {
            if (!walk.isContext()) continue;
            return (ContextProvidingTreeNode)walk;
        }
        return null;
    }

    public int getChildrenCount() {
        return this.m_vecChildren.size();
    }

    public AbstractTreeNode getChildAt(int index) {
        return (AbstractTreeNode)this.m_vecChildren.elementAt(index);
    }

    public Token getToken() {
        return this.m_token;
    }

    public void setParent(AbstractTreeNode n) {
        this.m_parent = n;
    }

    public AbstractTreeNode getParent() {
        return this.m_parent;
    }

    public static class ExpressionEvaluationException
    extends TokenException {
        private AbstractTreeNode m_node = null;

        public ExpressionEvaluationException(AbstractTreeNode node, String msg) {
            super(msg, node.getToken().getPositionOfToken());
            this.m_node = node;
        }

        public AbstractTreeNode getNode() {
            return this.m_node;
        }

        public boolean hasTokenWithNumber(int n) {
            return this.m_node.getToken().getNumberOfToken() == n;
        }
    }
}

